/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.led.signals;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import java.io.IOException;
import java.util.Arrays;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.led.signals.AbstractBcServerSignal;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

abstract class AbstractBcServerRejectSignal
extends AbstractBcServerSignal {
    private static final Class THIS_CLASS = AbstractBcServerRejectSignal.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    static final int ELIB_CONST_HWU_MAX_ERROR_DESCRIPTION_STRINGLENGTH = 110;
    private int errorCode;
    private String rejectCause;

    public AbstractBcServerRejectSignal(int sigNoIn) {
        super(sigNoIn);
    }

    public AbstractBcServerRejectSignal(int sigNoIn, int errorCodeIn, String rejectCauseIn) {
        super(sigNoIn);
        this.errorCode = errorCodeIn;
        this.rejectCause = rejectCauseIn;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getRejectCause() {
        return this.rejectCause;
    }

    protected void readErrorCodeAndRejectCause(SignalInputStream sis) throws IOException {
        logger.traceEnter(THIS_CLASS, "readErrorCodeAndRejectCause");
        this.errorCode = sis.readU16();
        sis.readU16();
        this.setRejectCause(sis.readU8Array(110));
        sis.readU16();
        logger.traceReturn(THIS_CLASS, "readErrorCodeAndRejectCause " + this.errorCode + ", " + this.rejectCause);
    }

    protected void writeErrorCodeAndRejectCause(SignalOutputStream sos) throws IOException {
        logger.traceEnter(THIS_CLASS, "writeErrorCodeAndRejectCause() " + this.errorCode + ", " + this.rejectCause);
        sos.writeU16(this.errorCode);
        sos.writeU16(65535);
        sos.writeU8Array(this.convertRejectCauseToIntArray());
        sos.writeU16(65535);
        logger.traceReturn(THIS_CLASS, "writeErrorCodeAndRejectCause()");
    }

    private void setRejectCause(int[] rawErrorDescr) {
        char[] tmpCharArray = new char[rawErrorDescr.length];
        for (int i = 0; i < rawErrorDescr.length; ++i) {
            if (rawErrorDescr[i] == 0) {
                this.rejectCause = new String(tmpCharArray, 0, i);
                break;
            }
            tmpCharArray[i] = (char)rawErrorDescr[i];
        }
    }

    private int[] convertRejectCauseToIntArray() {
        int[] intArray = new int[110];
        Arrays.fill(intArray, 0);
        for (int i = 0; i < this.rejectCause.length(); ++i) {
            intArray[i] = this.rejectCause.charAt(i);
        }
        return intArray;
    }
}

