/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ric.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class RicInfoParser
extends DefaultHandler {
    private static final Class THIS_CLASS = RicInfoParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private String ric = "";
    private boolean ricInfoPresent = false;

    public String getRic() {
        return this.ric;
    }

    public boolean isRicInfoPresent() {
        return this.ricInfoPresent;
    }

    public void parse(String xmlString) throws IOException {
        logger.traceEnter(THIS_CLASS, "parse(xmlString)");
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
            InputSource input = new InputSource(bais);
            saxParser.parse(input, (DefaultHandler)this);
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.toString());
        }
        logger.traceReturn(THIS_CLASS, "parse(xmlString)");
    }

    public void startDocument() throws SAXException {
        this.ric = "";
        this.ricInfoPresent = false;
    }

    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        logger.traceEnter(THIS_CLASS, "startElement(" + qName + ")");
        if ("RicInfo".equals(qName)) {
            this.ricInfoPresent = true;
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.ric = attributes.getValue("ric");
            }
        }
        logger.traceReturn(THIS_CLASS, "startElement(" + qName + ")");
    }
}

