/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.rollback;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.sync.SynchronizationMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.xml.XmlPack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.AbstractRollbackStackAttributeItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.DeleteRollbackStackItem;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class ActionRollbackStackItem
extends AbstractRollbackStackAttributeItem {
    private static final Class THIS_CLASS = DeleteRollbackStackItem.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String actionName;

    public ActionRollbackStackItem(String inLdn, String inActionName, String[] inAttributeNames, Object[] inAttributeValues) {
        super(inLdn, inAttributeNames, inAttributeValues);
        this.actionName = inActionName;
    }

    protected void packItem(Element topElement, XmlPack xmlpack, Document document) {
        Element typeElement = ActionRollbackStackItem.createTypeElement("action", this.getLdn(), this.actionName, document);
        boolean invalidAttrElement = false;
        String[] attributeNames = this.getAttributeNames();
        Object[] attributeValues = this.getAttributeValues();
        for (int i = 0; i < attributeNames.length; ++i) {
            Element attrElement = ActionRollbackStackItem.createAttrElement(xmlpack, attributeNames[i], attributeValues[i], document);
            if (attrElement == null) {
                invalidAttrElement = true;
                break;
            }
            typeElement.appendChild(attrElement);
        }
        if (!invalidAttrElement) {
            topElement.appendChild(typeElement);
        }
    }

    public String getActionName() {
        return this.actionName;
    }

    public boolean doRollback(MoRepositoryWrapper moRepositoryWrapper, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "doRollback()");
        boolean result2 = true;
        String ldn = null;
        try {
            ldn = this.getLdn();
            ManagedObject mo = moRepositoryWrapper.lookup(ldn);
            if (this.actionName.equals("actionDeleteNtpPrimary")) {
                ((ManagedElementDataMo)mo).actionDeleteNtpPrimary(coordinator);
            } else if (this.actionName.equals("actionDeleteNtpSecondary")) {
                ((ManagedElementDataMo)mo).actionDeleteNtpSecondary(coordinator);
            } else if (this.actionName.equals("actionDeleteNtpThird")) {
                ((ManagedElementDataMo)mo).actionDeleteNtpThird(coordinator);
            } else if (this.actionName.equals("actionRemoveSyncRefResource")) {
                this.executeActionRemoveSyncRefResource(coordinator, mo);
            } else {
                logger.traceError(THIS_CLASS, "An unexpected type of action was encountered.");
                result2 = false;
            }
        }
        catch (MoAccessException mae) {
            result2 = false;
            String errorMsg = "Exception when trying to perform action " + this.actionName + " on " + ldn + ". " + mae.getMessage();
            logger.traceError(THIS_CLASS, errorMsg, (Throwable)mae);
        }
        logger.traceReturn(THIS_CLASS, "doRollback()");
        return result2;
    }

    private void executeActionRemoveSyncRefResource(Coordinator coordinator, ManagedObject mo) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "executeActionRemoveSyncRefResource()");
        String[] attributeNames = this.getAttributeNames();
        Object[] attributeValues = this.getAttributeValues();
        for (int i = 0; i < attributeNames.length; ++i) {
            if (!attributeNames[i].equals("syncReference")) continue;
            ManagedObject syncRefMo = (ManagedObject)attributeValues[i];
            ((SynchronizationMo)mo).actionRemoveSyncRefResource(syncRefMo, coordinator);
            break;
        }
        logger.traceReturn(THIS_CLASS, "executeActionRemoveSyncRefResource()");
    }

    public String getItemInfo() {
        return "Action " + this.actionName + " on MO " + this.getLdn() + " with attributes " + this.getAttributeNames() + " and attribute values " + this.getAttributeValues();
    }
}

