/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.rollback;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.AbstractRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.RollbackStack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.RollbackStackImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class RollbackHandler {
    private final MoRepositoryWrapper moRepositoryWrapper;
    private static final Class THIS_CLASS = RollbackHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private RollbackStack rollbackStack = null;

    public RollbackHandler(RbsConfigurationMao inRbsConfigurationMao, MoRepositoryWrapper inMoRepositoryWrapper) {
        this.rollbackStack = RollbackStackImpl.getInstance(inRbsConfigurationMao, inMoRepositoryWrapper);
        this.moRepositoryWrapper = inMoRepositoryWrapper;
    }

    public void doRollback() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "doRollback()");
        if (this.rollbackStack.isEmpty()) {
            logger.traceError(THIS_CLASS, "The rollback stack is empty and the rollback could not be performed.");
        } else {
            while (!this.rollbackStack.isEmpty()) {
                TransactionHandler.run(new RollbackTp());
            }
        }
        logger.traceReturn(THIS_CLASS, "doRollback()");
    }

    protected void setRollbackStack(RollbackStack inRollbackStack) {
        this.rollbackStack = inRollbackStack;
    }

    private class RollbackTp
    implements TransactionPackage {
        private RollbackTp() {
        }

        public void execute(Coordinator coordinator) throws MoAccessException {
            boolean itemResult = true;
            AbstractRollbackStackItem item = RollbackHandler.this.rollbackStack.popNextRollbackItem(coordinator);
            itemResult = item.doRollback(RollbackHandler.this.moRepositoryWrapper, coordinator);
            if (!itemResult) {
                throw new RbsConfigurationFailedException("Rollback failed!", "Could not rollback rollback item: " + item.getItemInfo());
            }
        }

        public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
            throw new RbsConfigurationFailedException("Rollback", "Unable to perform rollback", exception);
        }

        public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
            throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
        }
    }
}

