/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.rollback;

import java.util.Enumeration;
import java.util.Stack;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.AbstractRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.RollbackStackImpl;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class RollbackResource
extends Stack
implements Resource {
    private static final Class THIS_CLASS = RollbackResource.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final RollbackStackImpl rollbackStack;
    private final int transactionId;
    private final boolean pushRollbackStackItem;

    public RollbackResource(RollbackStackImpl inRollbackStack, int inTransactionId, boolean inPushRollbackStackItem) {
        this.rollbackStack = inRollbackStack;
        this.transactionId = inTransactionId;
        this.pushRollbackStackItem = inPushRollbackStackItem;
    }

    public void commit() {
        logger.traceEnter(THIS_CLASS, "commit()");
        if (this.pushRollbackStackItem) {
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                this.rollbackStack.pushRollbackStackItem((AbstractRollbackStackItem)enumeration.nextElement());
            }
        }
        this.rollbackStack.commit(this.transactionId);
        this.clear();
        logger.traceReturn(THIS_CLASS, "commit()");
    }

    public boolean prepare() {
        return true;
    }

    public void rollback() {
        if (!this.pushRollbackStackItem) {
            while (!this.isEmpty()) {
                this.rollbackStack.pushRollbackStackItem((AbstractRollbackStackItem)this.pop());
            }
        }
        this.clear();
    }
}

