/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.rollback;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.xml.XmlPack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.AbstractRollbackStackAttributeItem;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SetRollbackStackItem
extends AbstractRollbackStackAttributeItem {
    private static final Class THIS_CLASS = SetRollbackStackItem.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public SetRollbackStackItem(String inLdn, String[] inAttributeNames, Object[] inAttributeValues) {
        super(inLdn, inAttributeNames, inAttributeValues);
    }

    protected void packItem(Element topElement, XmlPack xmlpack, Document document) {
        Element typeElement = SetRollbackStackItem.createTypeElement("set", this.getLdn(), document);
        boolean invalidAttrElement = false;
        String[] attributeNames = this.getAttributeNames();
        Object[] attributeValues = this.getAttributeValues();
        for (int i = 0; i < attributeNames.length; ++i) {
            Element attrElement = SetRollbackStackItem.createAttrElement(xmlpack, attributeNames[i], attributeValues[i], document);
            if (attrElement == null) {
                invalidAttrElement = true;
                break;
            }
            typeElement.appendChild(attrElement);
        }
        typeElement.toString();
        if (!invalidAttrElement) {
            topElement.appendChild(typeElement);
        }
    }

    public boolean doRollback(MoRepositoryWrapper moRepositoryWrapper, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "doRollback()");
        boolean result2 = true;
        String attributeName = null;
        Object attributeValue = null;
        String ldn = this.getLdn();
        ManagedObject mo = moRepositoryWrapper.lookup(ldn);
        if (mo == null) {
            result2 = false;
            String errorMsg = "Could not set attribute " + attributeName + " to value " + attributeValue + " on MO " + ldn + ". MO not found.";
            logger.traceError(THIS_CLASS, errorMsg);
        } else {
            try {
                String[] attributeNames = this.getAttributeNames();
                Object[] attributeValues = this.getAttributeValues();
                if (attributeNames.length == attributeValues.length) {
                    for (int i = 0; i < attributeNames.length; ++i) {
                        attributeName = attributeNames[i];
                        attributeValue = attributeValues[i];
                        if (attributeName.equals("accessControlListRef")) {
                            attributeValue = moRepositoryWrapper.lookup((String)attributeValue);
                        }
                        mo.setAttribute(attributeName, attributeValue, coordinator);
                    }
                } else {
                    result2 = false;
                }
            }
            catch (MoAccessException mae) {
                result2 = false;
                String errorMsg = "Exception when trying to set attribute " + attributeName + " to value " + attributeValue + ". " + mae.getMessage();
                logger.traceError(THIS_CLASS, errorMsg, (Throwable)mae);
            }
        }
        logger.traceReturn(THIS_CLASS, "doRollback()");
        return result2;
    }

    public String getItemInfo() {
        return "Set on MO " + this.getLdn() + " of attributes " + this.getAttributeNames() + " with attribute values " + this.getAttributeValues();
    }
}

