/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.security;

import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationSmrsHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.SensitiveDataHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.NodeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.AbstractIpSecThread;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.security.cppsec.esa.CertInfo;
import se.ericsson.security.cppsec.esa.EsaMessageHandler;
import se.ericsson.security.cppsec.esa.IpSecInstallation;
import se.ericsson.security.cppsec.esa.IpSecInstallationException;
import se.ericsson.security.cppsec.esa.IpSecInstallationFactory;
import se.ericsson.security.cppsec.esa.IpSecInstallationInputException;
import se.ericsson.security.cppsec.esa.IpSecReturnVal;

public class IpSecThreadImpl
extends AbstractIpSecThread {
    protected static final String GENERAL_EXCEPTION_MSG = "Fetched an unexpected exception from ipSecInstallation.install: ";
    private static final Class THIS_CLASS = IpSecThreadImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String THREAD_NAME = "CRBS_lmCatOamLmU_RbsConfiguration_prepareIpSecConfiguration";
    private static final String IP_SEC_FAULT = "Fault when activating IP Sec.";
    private final RbsConfigurationContext rbsConfigurationContext;
    private final RbsConfigurationMao rbsConfigurationMao;
    private final MoRepositoryWrapper moRepository;
    private final ProgressReporter progressReporter = new ProgressReporter();
    protected IpSecInstallation ipSecInstallation;
    private int refetchNumber = 0;
    private boolean successful = true;
    private final RbsConfigurationHelper helper;

    public IpSecThreadImpl(RbsConfigurationMao inRbsConfigurationMao) {
        super(THREAD_NAME);
        this.rbsConfigurationMao = inRbsConfigurationMao;
        this.rbsConfigurationContext = this.rbsConfigurationMao.getRbsConfigurationContext();
        this.moRepository = this.rbsConfigurationContext.getGenericMaoContext().getMoRepositoryWrapper();
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        this.ipSecInstallation = IpSecInstallationFactory.createIpSecInstallation((EsaMessageHandler)this.progressReporter);
    }

    public boolean isIpSecSuccessful() {
        return this.successful;
    }

    public void run() {
        logger.traceEnter(THIS_CLASS, "run()");
        this.updateProgressReportInformation(2100, 3, "Installing IPSec certificates.", true);
        this.successful = false;
        try {
            this.prepareIpSecConfiguration();
            this.updateProgressReportInformation(2100, 5, "Finished installing IPSec certificates", true);
        }
        catch (RbsConfigurationFailedException rcfe) {
            this.logIpSecException((Exception)((Object)rcfe));
        }
        logger.traceReturn(THIS_CLASS, "run()");
    }

    private void logIpSecException(Exception e) {
        logger.traceAbnormal(THIS_CLASS, e.getMessage());
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SECURITY_CONFIGURATION_FAULT, IP_SEC_FAULT, e.getMessage());
        this.updateProgressReportInformation(2100, 4, e.getMessage(), true);
    }

    protected void prepareIpSecConfiguration() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "prepareIpSecConfiguration()");
        IpSecMo ipSecMo = this.getIpSecMo();
        SensitiveDataHelper sensitiveDataHelper = (SensitiveDataHelper)this.rbsConfigurationContext.getHelper(SensitiveDataHelper.class);
        String userName = sensitiveDataHelper.retrieveSmrsUserName();
        String rbsIntegrationCode = sensitiveDataHelper.retrieveRbsIntegrationCode();
        String logicalName = NodeParameters.instance(this.rbsConfigurationMao).getLogicalName();
        IpSecReturnVal ipSecReturnVal = null;
        boolean keepTrying = true;
        while (keepTrying) {
            try {
                String iscfFilePath = SecurityParameters.instance(this.rbsConfigurationMao).getLocalInitialSecurityConfigurationFile();
                ipSecReturnVal = this.ipSecInstallation.install(iscfFilePath, rbsIntegrationCode, userName, logicalName, ipSecMo.getLocalDistinguishedName());
                keepTrying = false;
            }
            catch (IpSecInstallationException isie) {
                keepTrying = this.handleIpSecException((Exception)((Object)isie));
            }
            catch (IpSecInstallationInputException isiie) {
                keepTrying = this.handleIpSecException((Exception)((Object)isiie));
            }
            catch (Exception e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SECURITY_CONFIGURATION_FAULT, "Security preparation failure!", ExceptionHelper.appendReason((String)"Failed at IpSec install. Caught an unexpected Exception: ", (Throwable)e));
                String errorMsg = GENERAL_EXCEPTION_MSG + ExceptionHelper.convertToString((Throwable)e);
                logger.traceError(THIS_CLASS, errorMsg);
                this.updateProgressReportInformation(2100, 0, "Security preparation failure! " + errorMsg, true);
                keepTrying = false;
            }
        }
        if (ipSecReturnVal != null) {
            this.successful = true;
            try {
                Integer wantedIpSecLevel = new Integer(ipSecReturnVal.getWantedIPSecLevel());
                logger.traceDebug(THIS_CLASS, "wantedIpSecLevel: " + wantedIpSecLevel);
                CertInfo[] ipSecCusCertInfo = ipSecReturnVal.getIPSecCUSCertInfo();
                String ipSecFingerPrint = ipSecCusCertInfo[0].getCertificateFingerprint();
                String ipSecSerialNumber = ipSecCusCertInfo[0].getSerialNumber();
                logger.traceDebug(THIS_CLASS, "ipSecReturnVal = " + ipSecReturnVal);
                logger.traceDebug(THIS_CLASS, "ipSecFingerPrint = " + ipSecFingerPrint);
                logger.traceDebug(THIS_CLASS, "ipSecSerialNumber = " + ipSecSerialNumber);
                this.rbsConfigurationMao.storePersistently("wantedIpSecLevel", wantedIpSecLevel);
                this.rbsConfigurationMao.storePersistently("IpSecFingerPrint", ipSecFingerPrint);
                this.rbsConfigurationMao.storePersistently("IpSecSerialNumber", ipSecSerialNumber);
            }
            catch (MoAccessException mae) {
                throw new RbsConfigurationFailedException(IP_SEC_FAULT, mae.getReasonTag(), (Exception)((Object)mae));
            }
        }
        logger.traceReturn(THIS_CLASS, "prepareIpSecConfiguration()");
    }

    private IpSecMo getIpSecMo() throws RbsConfigurationFailedException {
        IpSecMo ipSecMo = (IpSecMo)this.moRepository.lookup("ManagedElement=1,IpSystem=1,IpSec=1");
        if (ipSecMo == null) {
            String errorMessage = "Unable to find IpSec Mo.";
            throw new RbsConfigurationFailedException(IP_SEC_FAULT, "Unable to find IpSec Mo.");
        }
        return ipSecMo;
    }

    private boolean handleIpSecException(Exception e) throws RbsConfigurationFailedException {
        boolean keepTrying = true;
        String errorMessage = "Security preparation failure! Will retry...";
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SECURITY_CONFIGURATION_FAULT, "Security preparation failure! Will retry...", e.getMessage());
        logger.traceError(THIS_CLASS, ExceptionHelper.appendReason((String)"Security preparation failure! Will retry...", (Throwable)e));
        this.updateProgressReportInformation(2100, 4, ExceptionHelper.appendReason((String)"Security preparation failure! Will retry...", (Throwable)e), true);
        try {
            RbsConfigurationSmrsHelper smrsHelper = (RbsConfigurationSmrsHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationSmrsHelper.class);
            ++this.refetchNumber;
            smrsHelper.reFetchInitialSecurityContainerFile(this.refetchNumber);
        }
        catch (RbsConfigurationFailedException rcfe) {
            keepTrying = false;
            throw new RbsConfigurationFailedException(IP_SEC_FAULT, "Failed to re-fetch ISCF!", (Exception)((Object)rcfe));
        }
        return keepTrying;
    }

    protected void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport) {
        ProgressReportHandler.getInstance().updateProgressReportInformation(integrationStepNumber, status, detailedInformation, updateProgressReport);
    }

    final class ProgressReporter
    implements EsaMessageHandler {
        ProgressReporter() {
        }

        public void reportProgress(String information) {
            logger.traceGeneral(THIS_CLASS, information);
        }
    }
}

