/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.security;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class SensitiveDataStore
implements Serializable {
    private static final Class THIS_CLASS = SensitiveDataStore.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String SENSITIVE_FAILURE_SLOGAN = "Sensitive data storage failure";
    private String smrsUserName = "";
    private String smrsPassword = "";
    private String rbsIntegrationCode = "";
    private String sftpUserName = "";
    private String sftpPassword = "";

    public String getSmrsUserName() {
        return this.smrsUserName;
    }

    public void setSmrsUserName(String inputSmrsUserName) {
        this.smrsUserName = inputSmrsUserName;
    }

    public String getSmrsPassword() {
        return this.smrsPassword;
    }

    public void setSmrsPassword(String inputSmrsPassword) {
        this.smrsPassword = inputSmrsPassword;
    }

    public String getRbsIntegrationCode() {
        return this.rbsIntegrationCode;
    }

    public void setRbsIntegrationCode(String inputRbsIntegrationCode) {
        this.rbsIntegrationCode = inputRbsIntegrationCode;
    }

    public void storeToDisc(String filePath) throws RbsConfigurationFailedException {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(filePath);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this.smrsUserName);
            oos.writeObject(this.smrsPassword);
            oos.writeObject(this.rbsIntegrationCode);
            oos.writeObject(this.sftpUserName);
            oos.writeObject(this.sftpPassword);
        }
        catch (Exception e) {
            throw new RbsConfigurationFailedException(SENSITIVE_FAILURE_SLOGAN, ExceptionHelper.appendReason((String)"Failed to store sensitive data to disc", (Throwable)e), e);
        }
        finally {
            try {
                oos.close();
                fos.close();
            }
            catch (Exception ioe) {
                logger.traceAbnormal(THIS_CLASS, "Unable to close outpustream. " + ioe);
            }
        }
    }

    public static SensitiveDataStore restoreFromDisc(String filePath) throws RbsConfigurationFailedException {
        SensitiveDataStore sensitiveDataStore = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(filePath);
            ois = new ObjectInputStream(fis);
            Object readObject = ois.readObject();
            if (readObject instanceof String) {
                try {
                    sensitiveDataStore = new SensitiveDataStore();
                    sensitiveDataStore.setSmrsUserName((String)readObject);
                    sensitiveDataStore.setSmrsPassword((String)ois.readObject());
                    sensitiveDataStore.setRbsIntegrationCode((String)ois.readObject());
                    sensitiveDataStore.setSftpUserName((String)ois.readObject());
                    sensitiveDataStore.setSftpPassword((String)ois.readObject());
                }
                catch (EOFException f) {
                    logger.traceDebug(THIS_CLASS, "EOF reached. restoreFromDisc() new way is not complete: " + f.getMessage());
                }
            } else {
                sensitiveDataStore = (SensitiveDataStore)readObject;
            }
        }
        catch (Exception e) {
            throw new RbsConfigurationFailedException(SENSITIVE_FAILURE_SLOGAN, ExceptionHelper.appendReason((String)"Failed to restore sensitive data from disc", (Throwable)e), e);
        }
        finally {
            try {
                ois.close();
                fis.close();
            }
            catch (Exception ioe) {
                logger.traceAbnormal(THIS_CLASS, "Unable to close outputstream. " + ioe);
            }
        }
        return sensitiveDataStore;
    }

    public void setSftpUserName(String inputSftpUserName) {
        this.sftpUserName = inputSftpUserName;
    }

    public void setSftpPassword(String inputSftpPassword) {
        this.sftpPassword = inputSftpPassword;
    }

    public String getSftpUserName() {
        return this.sftpUserName;
    }

    public String getSftpPassword() {
        return this.sftpPassword;
    }
}

