/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.helpers.AttributesImpl;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationIpHelperImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.DtdAttributesHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AccessControlListData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.DnsResolverData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.ENodeBFunctionData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.GpsOutSyncLinkData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.GpsSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.HptsiSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpAccessHostEtData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpInterfaceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSecData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSystemData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.Ipv6Data;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.Ipv6InterfaceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.ManagedElementDataData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.RbsConfigurationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.SiteBasicData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.SynchronizationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.TimingUnitData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.TuSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.VpnInterfaceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.WantedPositionData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class DtdSiteBasicDataConverter {
    private static final String SECONDARY_NTP_SERVICE_ACTIVE = "secondaryNtpServiceActive";
    private static final String PRIMARY_NTP_SERVICE_ACTIVE = "primaryNtpServiceActive";
    private static final String LOCAL_TIME_ZONE = "localTimeZone";
    private static final String SYNC_IP_ADDRESS = "syncIpAddress";
    private static final String SECONDARY_NTP_SERVER_IP_ADDRESS = "secondaryNtpServerIpAddress";
    private static final String PRIMARY_NTP_SERVER_IP_ADDRESS = "primaryNtpServerIpAddress";
    private static final String DOC_LIB_USER_DEFINED = "docLibUserDefined";
    private static final String DOCUMENT_SERVER_WEB_ADDRESS = "documentServerWebAddress";
    private static final String DU_ = "DU-";
    private static final String SYNC_IP_SLOT = "syncIpSlot";
    private static final String SYNC_VID = "syncVid";
    private static final String SYNC_SUBNET_MASK = "syncSubnetMask";
    private static final String NTP_SERVER_ADDRESS = "ntpServerAddress";
    private static final Class THIS_CLASS = DtdSiteBasicDataConverter.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    private DtdSiteBasicDataConverter() {
    }

    public static SiteBasicData convertOamAccessConfiguration(XMLElement oamAccessConfigurationElement, MoRepositoryWrapper aMoRepository) throws IOException, NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "convertOamAccessConfiguration()");
        List oamAccessConfigurationChildren = oamAccessConfigurationElement.getChildren();
        Iterator oamAccessConfigurationChildrenIter = oamAccessConfigurationChildren.iterator();
        AttributesImpl attributes = oamAccessConfigurationElement.getAttributes();
        XMLElement ipOverGigabitEthernetElement = null;
        XMLElement serversElement = null;
        XMLElement[] networkSyncElements = new XMLElement[1];
        String upIpAccessHostRef = "1";
        RbsConfigurationData rbsConfigurationData = null;
        int networkSyncCounter = 0;
        while (oamAccessConfigurationChildrenIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)oamAccessConfigurationChildrenIter.next();
            if ("NetworkSync".equalsIgnoreCase(xmlChild.getType())) {
                networkSyncElements[networkSyncCounter] = xmlChild;
                ++networkSyncCounter;
                continue;
            }
            if ("Servers".equalsIgnoreCase(xmlChild.getType())) {
                serversElement = xmlChild;
                continue;
            }
            if (!"IPoverGigabitEthernet".equalsIgnoreCase(xmlChild.getType())) continue;
            ipOverGigabitEthernetElement = xmlChild;
        }
        WantedPositionData wantedPositionData = new WantedPositionData("-", "-", "-", new Integer(50));
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (!"ossCorbaNameServer".equalsIgnoreCase(attributes.getQName(index))) continue;
            rbsConfigurationData = new RbsConfigurationData(attributes.getValue(index), "FDN", "", wantedPositionData);
        }
        Map networkSyncMap = DtdAttributesHandler.createHashMapFromNetworkSync(networkSyncElements, ipOverGigabitEthernetElement);
        SynchronizationData synchronizationData = new SynchronizationData(networkSyncMap, null);
        ENodeBFunctionData eNodeBFunctionData = new ENodeBFunctionData("1", rbsConfigurationData);
        ManagedElementDataData managedElementDataData = DtdSiteBasicDataConverter.createManagedElementData(serversElement);
        TuSyncRefData[] tuSyncRefData = DtdSiteBasicDataConverter.createTuSyncRefData(networkSyncMap);
        String ipInterFaceId = DtdAttributesHandler.handleIpInterfaceId(aMoRepository, ipOverGigabitEthernetElement);
        IpInterfaceData[] ipInterfaceData = new IpInterfaceData[]{DtdSiteBasicDataConverter.createIpInterfaceData(ipOverGigabitEthernetElement, ipInterFaceId)};
        IpSystemData ipSystemData = DtdSiteBasicDataConverter.createIpSystemData(ipOverGigabitEthernetElement, ipInterfaceData[0]);
        IpData ipData = null;
        TimingUnitData timingUnitData = null;
        GpsSyncRefData[] gpsSyncRefData = new GpsSyncRefData[]{};
        GpsOutSyncLinkData[] gpsOutSyncLinkData = new GpsOutSyncLinkData[]{};
        HptsiSyncRefData[] hptsiSyncRefData = new HptsiSyncRefData[]{};
        SiteBasicData siteBasicData = new SiteBasicData(null, ipData, eNodeBFunctionData, managedElementDataData, ipSystemData, ipInterfaceData, timingUnitData, tuSyncRefData, gpsSyncRefData, gpsOutSyncLinkData, hptsiSyncRefData, synchronizationData);
        logger.traceReturn(THIS_CLASS, "convertOamAccessConfiguration()");
        return siteBasicData;
    }

    private static IpSystemData createIpSystemData(XMLElement ipOverGigabitEthernetElement, IpInterfaceData ipInterfaceData) throws IOException {
        logger.traceEnter(THIS_CLASS, "createIpSystemData()");
        IpAccessHostEtData[] ipAccessHostEtData = new IpAccessHostEtData[]{DtdSiteBasicDataConverter.createIpAccessHostEtData(ipOverGigabitEthernetElement, ipInterfaceData)};
        VpnInterfaceData[] vpnInterfaceData = null;
        IpSecData ipsecData = null;
        AccessControlListData[] accessControlListData = null;
        Ipv6Data[] ipv6Data = null;
        Ipv6InterfaceData[] ipv6InterfaceData = null;
        DnsResolverData[] dnsResolverData = null;
        IpSystemData ipSystemData = new IpSystemData(ipAccessHostEtData, vpnInterfaceData, ipsecData, accessControlListData, ipv6Data, ipv6InterfaceData, dnsResolverData);
        logger.traceReturn(THIS_CLASS, "createIpSystemData()");
        return ipSystemData;
    }

    private static IpAccessHostEtData createIpAccessHostEtData(XMLElement ipOverGigabitEthernetElement, IpInterfaceData ipInterfaceData) throws IOException {
        logger.traceEnter(THIS_CLASS, "createIpAccessHostEtData()");
        Map attrNameValueMap = ParserHelper.createAttrNameValueMap(ipOverGigabitEthernetElement.getAttributes());
        Map xmlTypeElementMap = ParserHelper.createXmlTypeElementMap(ipOverGigabitEthernetElement.getChildren());
        String ipAccessHostEtId = "1";
        String ipAddress = (String)attrNameValueMap.get(SYNC_IP_ADDRESS.toLowerCase(Locale.getDefault()));
        String ipInterfaceMoRef = DtdAttributesHandler.handleIpInterFaceMoRef(ipInterfaceData);
        String userLabel = null;
        IpSyncRefData[] ipSyncRefData = DtdSiteBasicDataConverter.createIpSyncRefData(xmlTypeElementMap);
        ParserHelper.checkMandatoryAttribute((String)"ipAddress", (String)ipAddress);
        IpAccessHostEtData IpAccessHostEtData2 = new IpAccessHostEtData("1", ipAddress, ipInterfaceMoRef, userLabel, ipSyncRefData);
        logger.traceReturn(THIS_CLASS, "createIpAccessHostEtData()");
        return IpAccessHostEtData2;
    }

    private static IpSyncRefData[] createIpSyncRefData(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createIpSyncRefData()");
        int ipSyncRefCounter = 0;
        IpSyncRefData[] ipSyncRefDataArr = new IpSyncRefData[7];
        String xmlTag = "IpSyncRef".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                IpSyncRefData ipSyncRefData;
                XMLElement xmlElement = (XMLElement)iter.next();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                String ipSyncRefId = (String)attrNameValueMap.get("IpSyncRefId".toLowerCase(Locale.getDefault()));
                String ntpServerIpAddress = (String)attrNameValueMap.get(NTP_SERVER_ADDRESS.toLowerCase(Locale.getDefault()));
                String userLabel = (String)attrNameValueMap.get("userLabel".toLowerCase(Locale.getDefault()));
                ParserHelper.checkMandatoryAttribute((String)"IpSyncRefId", (String)ipSyncRefId);
                ParserHelper.checkMandatoryAttribute((String)NTP_SERVER_ADDRESS, (String)ntpServerIpAddress);
                ipSyncRefDataArr[ipSyncRefCounter] = ipSyncRefData = new IpSyncRefData(ipSyncRefId, ntpServerIpAddress, userLabel);
                ++ipSyncRefCounter;
            }
        }
        logger.traceReturn(THIS_CLASS, "createIpSyncRefData()");
        return ipSyncRefDataArr;
    }

    private static IpInterfaceData createIpInterfaceData(XMLElement ipOverGigabitEthernetElement, String ipInterfaceId) throws IOException {
        logger.traceEnter(THIS_CLASS, "createIpInterfaceData()");
        Map attrNameValueMap = ParserHelper.createAttrNameValueMap(ipOverGigabitEthernetElement.getAttributes());
        String accessControlListRef = null;
        Integer networkPrefixLength = null;
        String subnetMask = (String)attrNameValueMap.get(SYNC_SUBNET_MASK.toLowerCase(Locale.getDefault()));
        if (subnetMask != null) {
            try {
                networkPrefixLength = RbsConfigurationIpHelperImpl.calculateNetworkPrefixLength(subnetMask);
            }
            catch (Exception e) {
                throw new IOException("Invalid input for networkPrefixLength make sure you used a valid netmask.");
            }
        }
        String defaultRouter0 = (String)attrNameValueMap.get("defaultRouter0".toLowerCase(Locale.getDefault()));
        String vid = (String)attrNameValueMap.get(SYNC_VID.toLowerCase(Locale.getDefault()));
        String ipInterFaceSlot = (String)attrNameValueMap.get(SYNC_IP_SLOT.toLowerCase(Locale.getDefault()));
        String inConfigurationMode = (String)attrNameValueMap.get("configurationMode".toLowerCase(Locale.getDefault()));
        String userLabel = (String)attrNameValueMap.get("userLabel".toLowerCase(Locale.getDefault()));
        String dhcpClientIdentifierType = (String)attrNameValueMap.get("dhcpClientIdentifierType".toLowerCase(Locale.getDefault()));
        String dhcpClientIdentifier = (String)attrNameValueMap.get("dhcpClientIdentifier".toLowerCase(Locale.getDefault()));
        ParserHelper.checkMandatoryAttribute((String)"defaultRouter0", (String)defaultRouter0);
        ParserHelper.checkMandatoryAttribute((String)SYNC_VID, (String)vid);
        ParserHelper.checkMandatoryAttribute((String)SYNC_IP_SLOT, (String)ipInterFaceSlot);
        IpInterfaceData ipInterfaceData = new IpInterfaceData(accessControlListRef, ipInterfaceId, networkPrefixLength.toString(), defaultRouter0, vid, ipInterFaceSlot, inConfigurationMode, userLabel, dhcpClientIdentifierType, dhcpClientIdentifier);
        logger.traceReturn(THIS_CLASS, "createIpInterfaceData()");
        return ipInterfaceData;
    }

    private static TuSyncRefData[] createTuSyncRefData(Map networkSyncMap) {
        logger.traceEnter(THIS_CLASS, "createTuSyncRefData()");
        int tuSyncRefId = 1;
        String syncSlot = null;
        TuSyncRefData[] tuSyncRefData = new TuSyncRefData[1];
        for (int index = 0; index < 7; ++index) {
            String mapOutPut = (String)networkSyncMap.get(new Integer(index + 1));
            if (mapOutPut == null || !(syncSlot = mapOutPut.substring(0, 4)).startsWith(DU_)) continue;
            tuSyncRefData[tuSyncRefId - 1] = new TuSyncRefData(Integer.toString(tuSyncRefId), syncSlot);
            ++tuSyncRefId;
        }
        logger.traceReturn(THIS_CLASS, "createTuSyncRefData()");
        return tuSyncRefData;
    }

    private static ManagedElementDataData createManagedElementData(XMLElement serversElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "createManagedElementData()");
        Map attrNameValueMap = ParserHelper.createAttrNameValueMap(serversElement.getAttributes());
        ManagedElementDataData managedElementDataData = new ManagedElementDataData((String)attrNameValueMap.get(DOCUMENT_SERVER_WEB_ADDRESS.toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get(PRIMARY_NTP_SERVER_IP_ADDRESS.toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get(PRIMARY_NTP_SERVICE_ACTIVE.toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get(SECONDARY_NTP_SERVER_IP_ADDRESS.toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get(SECONDARY_NTP_SERVICE_ACTIVE.toLowerCase(Locale.getDefault())), null, null, (String)attrNameValueMap.get(LOCAL_TIME_ZONE.toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("daylightSavingTime".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("swServerUrlList".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get(DOC_LIB_USER_DEFINED.toLowerCase(Locale.getDefault())));
        logger.traceReturn(THIS_CLASS, "createManagedElementData()");
        return managedElementDataData;
    }
}

