/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic;

import java.io.IOException;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.ipsec.mom.VpnInterface;
import se.ericsson.cello.iptransport.AccessControlListMo;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationIpHelperImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.IpRollbackStack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.IpRollbackStackImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.RbsConfigurationSiteBasicHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AclEntriesData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.OaMAlternativeAccessSourceData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class OaMAlternativeAccessHelper {
    private static final Class THIS_CLASS = OaMAlternativeAccessHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private MoRepositoryWrapper moRepository;
    private MoFactoryMgrWrapper moFactoryMgr;
    private static final String OAM_ALTERNATIVE_ACCESS = "O&M Alternative Access";
    private RbsConfigurationSiteBasicHelper rbsConfigurationSiteBasicHelper;
    private IpRollbackStack ipRollbackStack = IpRollbackStackImpl.getInstance();

    public void activateOaMAlternativeAccess(IpData ipData, RbsConfigurationSiteBasicHelper inRbsConfigurationSiteBasicHelper, MoRepositoryWrapper inMoRepository, MoFactoryMgrWrapper inFactoryMgr, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "activateOaMAlternativeAccess()");
        this.rbsConfigurationSiteBasicHelper = inRbsConfigurationSiteBasicHelper;
        this.moRepository = inMoRepository;
        this.moFactoryMgr = inFactoryMgr;
        IpSecForOamConfig ipSecForOamConfig = this.getOaMIpSecConfig(ipData, coordinator);
        this.configureAcl(ipData.getOaMAlternativeAccessSourceData(), ipSecForOamConfig, coordinator);
        this.linkIpAndIpAccessHostEt(ipSecForOamConfig, coordinator);
        logger.traceReturn(THIS_CLASS, "activateOaMAlternativeAccess()");
    }

    public void deactivateOaMAlternativeAccess() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "deactivateOaMAlternativeAccess()");
        String errorSlogan = "Failed to deactivate alternative access.";
        IpOamConfigurationService ipOamConfigurationService = IpOamConfigurationServiceImpl.getInstance();
        if (ipOamConfigurationService == null) {
            throw new RbsConfigurationFailedException("Failed to deactivate alternative access.", "IpOamConfigurationService has not been instantiated.");
        }
        String ipMoLdn = "ManagedElement=1,IpOam=1,Ip=1";
        String attributeName = "ipAccessHostEtRef";
        try {
            ManagedObject referencedMo = (ManagedObject)ipOamConfigurationService.getAttribute("ManagedElement=1,IpOam=1,Ip=1", "ipAccessHostEtRef");
            if (referencedMo == null) {
                logger.traceDebug(THIS_CLASS, "Alternative access is not activated. Skipping the deactivation.");
                logger.traceReturn(THIS_CLASS, "deactivateOaMAlternativeAccess()");
                return;
            }
            StringReplacingManagedObject oldAttributeValue = new StringReplacingManagedObject(referencedMo.getLocalDistinguishedName());
            ipOamConfigurationService.setAttribute("ManagedElement=1,IpOam=1,Ip=1", "ipAccessHostEtRef", null);
            this.ipRollbackStack.pushSet("ManagedElement=1,IpOam=1,Ip=1", new String[]{"ipAccessHostEtRef"}, new Object[]{oldAttributeValue});
        }
        catch (MoAccessException e) {
            throw new RbsConfigurationFailedException("Failed to deactivate alternative access.", "Exception thrown when changing the attribute ipAccessHostEtRef on ManagedElement=1,IpOam=1,Ip=1.", (Exception)((Object)e));
        }
        logger.traceDebug(THIS_CLASS, "Alternative access has successfully been deactivated.");
        logger.traceReturn(THIS_CLASS, "deactivateOaMAlternativeAccess()");
    }

    private void configureAcl(OaMAlternativeAccessSourceData[] alternativeAccessSourceData, IpSecForOamConfig inIpSecForOamConfig, Coordinator coordinator) throws RbsConfigurationFailedException {
        if (inIpSecForOamConfig.accessControlList == null) {
            this.createAndSetDefaultAcl(alternativeAccessSourceData, inIpSecForOamConfig, coordinator);
        } else {
            this.modifyCurrentAcl(alternativeAccessSourceData, inIpSecForOamConfig, coordinator);
        }
    }

    private IpSecForOamConfig getOaMIpSecConfig(IpData ipData, Coordinator coordinator) throws RbsConfigurationFailedException {
        IpSecForOamConfig ipSecForOamConfig;
        block7: {
            try {
                if (ipData.getIpHostLinkData() == null) {
                    throw new RbsConfigurationFailedException(OAM_ALTERNATIVE_ACCESS, "Inconsistent configuration - OaMAlternativeAccess requires configuration of IpSec for OaM.");
                }
                String ipHostLinkLdn = "ManagedElement=1,IpOam=1,Ip=1,IpHostLink=" + ipData.getIpHostLinkData().getIpHostLinkId();
                IpHostLinkMo ipHostLinkMo = (IpHostLinkMo)this.moRepository.lookup(ipHostLinkLdn);
                if (ipHostLinkMo == null) {
                    throw new RbsConfigurationFailedException(OAM_ALTERNATIVE_ACCESS, "Configuration fault, IpHostLink instance is missing.");
                }
                ManagedObject referencedInterface = ipHostLinkMo.getIpInterfaceMoRef(coordinator);
                if (!(referencedInterface instanceof VpnInterface)) {
                    throw new RbsConfigurationFailedException(OAM_ALTERNATIVE_ACCESS, "Inconsistent configuration for OaM IPsec - IpHostLink needs to refer to an VpnInterface");
                }
                VpnInterface referencedVpnInterface = (VpnInterface)referencedInterface;
                IpAccessHostEtMo ipAccessHostEt = (IpAccessHostEtMo)referencedVpnInterface.getIpAccessHostEtRef(coordinator);
                String outerIpAddress = ipAccessHostEt.getIpAddress(coordinator);
                ManagedObject referredOuterInterface = ipAccessHostEt.getIpInterfaceMoRef(coordinator);
                if (referredOuterInterface instanceof IpInterfaceMo) {
                    IpInterfaceMo ipInterface = (IpInterfaceMo)referredOuterInterface;
                    AccessControlListMo accessControlList = (AccessControlListMo)ipInterface.getAccessControlListRef(coordinator);
                    ipSecForOamConfig = new IpSecForOamConfig(ipAccessHostEt, ipInterface, accessControlList, outerIpAddress);
                    break block7;
                }
                if (referredOuterInterface instanceof Ipv6InterfaceMo) {
                    Ipv6InterfaceMo ipv6Interface = (Ipv6InterfaceMo)referredOuterInterface;
                    AccessControlListMo accessControlList = (AccessControlListMo)ipv6Interface.getAccessControlListRef(coordinator);
                    ipSecForOamConfig = new IpSecForOamConfig(ipAccessHostEt, ipv6Interface, accessControlList, outerIpAddress);
                    break block7;
                }
                throw new RbsConfigurationFailedException(OAM_ALTERNATIVE_ACCESS, "Inconsistent configuration for OaM IPsec - IpAccessHostEt needs to refer to an IpInterface or Ipv6Interface");
            }
            catch (MoAccessException mae) {
                throw new RbsConfigurationFailedException(OAM_ALTERNATIVE_ACCESS, "Unable to determine IpSec for OaM configuration. ", (Exception)((Object)mae));
            }
        }
        return ipSecForOamConfig;
    }

    private void linkIpAndIpAccessHostEt(IpSecForOamConfig inIpSecForOamConfig, Coordinator coordinator) throws RbsConfigurationFailedException {
        IpMo ipMo = (IpMo)this.moRepository.lookup("ManagedElement=1,IpOam=1,Ip=1");
        if (ipMo == null) {
            throw new RbsConfigurationFailedException(OAM_ALTERNATIVE_ACCESS, "Missing IP MO");
        }
        try {
            String ipMoLdn = ipMo.getLocalDistinguishedName();
            String[] attributeNameList = new String[]{"ipAccessHostEtRef"};
            Object[] valueList = new Object[]{ipMo.getIpAccessHostEtRef(coordinator)};
            this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging((ManagedObject)ipMo, "ipAccessHostEtRef", inIpSecForOamConfig.ipAccessHostEt, coordinator);
            this.ipRollbackStack.pushSet(ipMoLdn, attributeNameList, valueList);
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException(OAM_ALTERNATIVE_ACCESS, "Unable to set reference between Ip and IpAccessHostEt", (Exception)((Object)mae));
        }
    }

    private void createAndSetDefaultAcl(OaMAlternativeAccessSourceData[] alternativeAccessSourceData, IpSecForOamConfig inIpSecForOamConfig, Coordinator coordinator) throws RbsConfigurationFailedException {
        ManagedObject accessControlList;
        try {
            accessControlList = this.createDefaultAcl(alternativeAccessSourceData, inIpSecForOamConfig, coordinator);
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException(OAM_ALTERNATIVE_ACCESS, "Unable to create AccessControlList MO.", (Exception)((Object)mae));
        }
        try {
            String[] attributeNameList = new String[]{"accessControlListRef"};
            Object[] valueList = null;
            IpInterfaceMo ipv4_or_ipv6_interface = null;
            if (inIpSecForOamConfig.ipInterface != null) {
                ipv4_or_ipv6_interface = inIpSecForOamConfig.ipInterface;
                valueList = new Object[]{inIpSecForOamConfig.ipInterface.getAccessControlListRef(coordinator)};
            } else if (inIpSecForOamConfig.ipv6Interface != null) {
                ipv4_or_ipv6_interface = inIpSecForOamConfig.ipv6Interface;
                valueList = new Object[]{inIpSecForOamConfig.ipv6Interface.getAccessControlListRef(coordinator)};
            }
            this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging((ManagedObject)ipv4_or_ipv6_interface, "accessControlListRef", accessControlList, coordinator);
            this.ipRollbackStack.pushSet(ipv4_or_ipv6_interface.getLocalDistinguishedName(), attributeNameList, valueList);
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException(OAM_ALTERNATIVE_ACCESS, "Unable to set reference to AccessControlList MO.", (Exception)((Object)mae));
        }
    }

    private ManagedObject createDefaultAcl(OaMAlternativeAccessSourceData[] alternativeAccessSourceData, IpSecForOamConfig inIpSecForOamConfig, Coordinator coordinator) throws MoAccessException {
        String aclId = this.findLowestFreeAclId();
        Struct[] aclEntries = this.createNewAclEntries(alternativeAccessSourceData, inIpSecForOamConfig);
        ManagedObject ipSystemMo = this.moRepository.lookup("ManagedElement=1,IpSystem=1");
        if (ipSystemMo == null) {
            throw new RbsConfigurationFailedException(OAM_ALTERNATIVE_ACCESS, "Missing IpSystem MO");
        }
        AttrListImpl attrList = new AttrListImpl();
        attrList.addElement("aclEntries", (Object)aclEntries);
        attrList.addElement("userLabel", (Object)OAM_ALTERNATIVE_ACCESS);
        AccessControlListMo accessControlListMo = (AccessControlListMo)this.rbsConfigurationSiteBasicHelper.createMoWithLogging(ipSystemMo, attrList, aclId, "AccessControlList", this.moFactoryMgr, coordinator);
        String aclLdn = accessControlListMo.getLocalDistinguishedName();
        this.ipRollbackStack.pushDelete(aclLdn);
        return accessControlListMo;
    }

    private String findLowestFreeAclId() {
        int index = 1;
        while (this.moRepository.lookup("ManagedElement=1,IpSystem=1,AccessControlList=" + index) != null) {
            ++index;
        }
        return Integer.toString(index);
    }

    private void modifyCurrentAcl(OaMAlternativeAccessSourceData[] alternativeAccessSourceData, IpSecForOamConfig inIpSecForOamConfig, Coordinator coordinator) throws RbsConfigurationFailedException {
        Struct[] existingAclEntries;
        try {
            existingAclEntries = inIpSecForOamConfig.accessControlList.getAclEntries(coordinator);
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException(OAM_ALTERNATIVE_ACCESS, "Unable to read existing AclEntries", (Exception)((Object)mae));
        }
        Struct[] newAclEntries = this.createNewAclEntries(alternativeAccessSourceData, inIpSecForOamConfig);
        Struct[] modifiedAclEntries = new Struct[existingAclEntries.length + newAclEntries.length];
        System.arraycopy(newAclEntries, 0, modifiedAclEntries, 0, newAclEntries.length);
        System.arraycopy(existingAclEntries, 0, modifiedAclEntries, newAclEntries.length, existingAclEntries.length);
        try {
            this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging((ManagedObject)inIpSecForOamConfig.accessControlList, "aclEntries", modifiedAclEntries, coordinator);
            String accessControlListLdn = inIpSecForOamConfig.accessControlList.getLocalDistinguishedName();
            String[] attributeNameList = new String[]{"aclEntries"};
            Object[] valueList = new Object[]{existingAclEntries};
            this.ipRollbackStack.pushSet(accessControlListLdn, attributeNameList, valueList);
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException(OAM_ALTERNATIVE_ACCESS, "Unable to set modified ACL Entries", (Exception)((Object)mae));
        }
    }

    private Struct[] createNewAclEntries(OaMAlternativeAccessSourceData[] alternativeAccessSourceData, IpSecForOamConfig inIpSecForOamConfig) throws RbsConfigurationFailedException {
        String DROP_ACTION = "DROP";
        String BYPASS_ACTION = "BYPASS";
        String ICMP_TYPE_IRRELEVANT = "256";
        String DEFAULT_NETWORKPREFIX_DROP = "0";
        String LOCAL_IP_ADDRESS_BYPASS = inIpSecForOamConfig.outerIpAddress;
        String LOCAL_NETWORKPREFIX_BYPASS = "32";
        String LOCAL_PORT_BYPASS = "22";
        String PORT_FILTERING_OFF = Boolean.FALSE.toString();
        String PORT_FILTERING_ON = Boolean.TRUE.toString();
        String PROTOCOL_TYPE_TCP = "TCP";
        String DEFAULT_IP_ADDRESS_DROP = "0.0.0.0";
        String DEFAULT_PORT = "0";
        String DEFAULT_IPV6_ADDRESS_DROP = "::";
        String LOCAL_IPV6_NETWORKPREFIX_BYPASS = "128";
        Struct[] aclEntries = new Struct[alternativeAccessSourceData.length + 1];
        try {
            for (int index = 0; index < alternativeAccessSourceData.length; ++index) {
                String remoteNetworkPrefixBypass;
                String remoteIpAddressBypass = alternativeAccessSourceData[index].getIpAddress();
                if (inIpSecForOamConfig.ipInterface != null) {
                    remoteNetworkPrefixBypass = RbsConfigurationIpHelperImpl.isIpv4Address(alternativeAccessSourceData[index].getNetworkMask()) ? RbsConfigurationIpHelperImpl.calculateNetworkPrefixLength(alternativeAccessSourceData[index].getNetworkMask()).toString() : alternativeAccessSourceData[index].getNetworkMask();
                    aclEntries[index] = new AclEntriesData("BYPASS", "256", Integer.toString(index + 1), LOCAL_IP_ADDRESS_BYPASS, "32", "22", PORT_FILTERING_ON, "TCP", remoteIpAddressBypass, remoteNetworkPrefixBypass, "0", PORT_FILTERING_OFF).getAclEntry();
                    aclEntries[alternativeAccessSourceData.length] = new AclEntriesData("DROP", "256", Integer.toString(aclEntries.length + 1), "0.0.0.0", "0", "0", PORT_FILTERING_OFF, "TCP", "0.0.0.0", "0", "0", PORT_FILTERING_OFF).getAclEntry();
                    continue;
                }
                if (inIpSecForOamConfig.ipv6Interface == null) continue;
                remoteNetworkPrefixBypass = alternativeAccessSourceData[index].getNetworkMask();
                aclEntries[index] = new AclEntriesData("BYPASS", "256", Integer.toString(index + 1), LOCAL_IP_ADDRESS_BYPASS, "128", "22", PORT_FILTERING_ON, "TCP", remoteIpAddressBypass, remoteNetworkPrefixBypass, "0", PORT_FILTERING_OFF).getAclEntry();
                aclEntries[alternativeAccessSourceData.length] = new AclEntriesData("DROP", "256", Integer.toString(aclEntries.length + 1), "::", "0", "0", PORT_FILTERING_OFF, "TCP", "::", "0", "0", PORT_FILTERING_OFF).getAclEntry();
            }
        }
        catch (IOException ioe) {
            throw new RbsConfigurationFailedException(OAM_ALTERNATIVE_ACCESS, "Unable to create ACL Entries", ioe);
        }
        return aclEntries;
    }

    private class IpSecForOamConfig {
        protected final IpAccessHostEtMo ipAccessHostEt;
        protected final String outerIpAddress;
        protected final IpInterfaceMo ipInterface;
        protected final Ipv6InterfaceMo ipv6Interface;
        protected final AccessControlListMo accessControlList;

        protected IpSecForOamConfig(IpAccessHostEtMo inIpAccessHostEt, IpInterfaceMo inIpInterface, AccessControlListMo inAccessControlList, String inOuterIpAddress) {
            this.ipAccessHostEt = inIpAccessHostEt;
            this.ipInterface = inIpInterface;
            this.ipv6Interface = null;
            this.accessControlList = inAccessControlList;
            this.outerIpAddress = inOuterIpAddress;
        }

        protected IpSecForOamConfig(IpAccessHostEtMo inIpAccessHostEt, Ipv6InterfaceMo inIpv6Interface, AccessControlListMo inAccessControlList, String inOuterIpAddress) {
            this.ipAccessHostEt = inIpAccessHostEt;
            this.ipInterface = null;
            this.ipv6Interface = inIpv6Interface;
            this.accessControlList = inAccessControlList;
            this.outerIpAddress = inOuterIpAddress;
        }
    }
}

