/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.RollbackStack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.RollbackStackImpl;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class RbsConfigurationSiteBasicHelper {
    private RollbackStack rollbackStack = null;
    private static final Class THIS_CLASS = RbsConfigurationSiteBasicHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String SITE_BASIC_FAULT = "Fault when activating Site Basic";

    public RbsConfigurationSiteBasicHelper(RbsConfigurationMao inRbsConfigurationMao, MoRepositoryWrapper inMoRepositoryWrapper) {
        this.rollbackStack = RollbackStackImpl.getInstance(inRbsConfigurationMao, inMoRepositoryWrapper);
        this.rollbackStack.clearStack();
    }

    public ManagedObject createMoWithLogging(ManagedObject parentMo, AttrListImpl attrList, String moId, String moType, MoFactoryMgrWrapper aFactoryMgr, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createMoWithLogging()");
        MoFactory moFactory = aFactoryMgr.lookup(moType);
        if (moFactory == null) {
            String msg = "Could not find the system created MO Factory of type " + moType;
            throw new RbsConfigurationFailedException(SITE_BASIC_FAULT, msg);
        }
        ManagedObject createdMo = null;
        try {
            String[] attributeStrings = new String[attrList.size()];
            Object[] valueStrings = new Object[attrList.size()];
            for (int i = 0; i < attrList.size(); ++i) {
                attributeStrings[i] = attrList.getName(i);
                valueStrings[i] = attrList.getValue(i);
            }
            logger.traceDebug(THIS_CLASS, "CreateMO :" + moType + " id:" + moId + " attr:" + this.attrListToString(attrList));
            createdMo = moFactory.createMo(parentMo, (AttrList)attrList, moId, null, coordinator);
            if (createdMo != null) {
                this.pushDeleteForRollback(createdMo, coordinator);
            }
            ConfigurationReportLoggerFactory.getLogger().logAction(moType, "create", attributeStrings, valueStrings);
        }
        catch (MoAccessException mae) {
            String faultMsg = ExceptionHelper.appendReason((String)("Could not create MO of type: " + moType), (Throwable)mae);
            throw new RbsConfigurationFailedException(faultMsg);
        }
        logger.traceReturn(THIS_CLASS, "createMoWithLogging()");
        return createdMo;
    }

    public void setAttributeWithLogging(ManagedObject mo, String attributeName, Object attributeValue, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "setAttributeWithLogging()");
        try {
            logger.traceDebug(THIS_CLASS, "setAttr :" + mo.getFullDistinguishedName() + " attr:" + attributeName + " val:" + attributeValue);
            this.pushSetForRollback(mo, attributeName, coordinator);
            mo.setAttribute(attributeName, attributeValue, coordinator);
            ConfigurationReportLoggerFactory.getLogger().logAttribute(mo.getType(), attributeName, attributeValue);
        }
        catch (Exception e) {
            String faultMsg = ExceptionHelper.appendReason((String)("Could not set " + attributeName + " to value: " + attributeValue), (Throwable)e);
            throw new RbsConfigurationFailedException(faultMsg);
        }
        logger.traceReturn(THIS_CLASS, "setAttributeWithLogging()");
    }

    public void setAttrFromAttrList(ManagedObject moToSet, AttrListImpl attrList, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "setAttrFromAttrList()");
        try {
            logger.traceDebug(THIS_CLASS, "setAttrFromAttrList :" + moToSet.getFullDistinguishedName() + " attr:" + this.attrListToString(attrList));
            String[] attributeNames = new String[attrList.size()];
            Object[] attributeValues = new Object[attrList.size()];
            if (attrList.size() > 0) {
                for (int i = 0; i < attrList.size(); ++i) {
                    attributeNames[i] = attrList.getName(i);
                    attributeValues[i] = attrList.getValue(i);
                }
                this.pushSetForRollback(moToSet, attributeNames, coordinator);
                moToSet.setAttributes(attributeNames, attributeValues, coordinator);
                ConfigurationReportLoggerFactory.getLogger().logAction(moToSet.getType(), "set", attributeNames, attributeValues);
            }
        }
        catch (Exception e) {
            String faultMsg = ExceptionHelper.appendReason((String)("Could not set attributes for: " + moToSet.toString()), (Throwable)e);
            throw new RbsConfigurationFailedException(faultMsg);
        }
        logger.traceReturn(THIS_CLASS, "setAttrFromAttrList()");
    }

    public void pushSetForRollback(ManagedObject mo, String[] attributeNames, Coordinator coordinator) throws RbsConfigurationFailedException {
        try {
            Object[] rollbackAttributeValues = mo.getAttributes(attributeNames, coordinator);
            this.rollbackStack.pushSet(mo.getLocalDistinguishedName(), attributeNames, rollbackAttributeValues, coordinator);
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException(SITE_BASIC_FAULT, "Unable to read original values on MO: " + mo.getLocalDistinguishedName(), (Exception)((Object)mae));
        }
    }

    public void pushSetForRollbackNoReadTrans(ManagedObject mo, String[] attributeNames, Coordinator coordinator) throws RbsConfigurationFailedException {
        try {
            Object[] rollbackAttributeValues = mo.getAttributes(attributeNames, null);
            this.rollbackStack.pushSet(mo.getLocalDistinguishedName(), attributeNames, rollbackAttributeValues, coordinator);
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException(SITE_BASIC_FAULT, "Unable to read original values on MO: " + mo.getLocalDistinguishedName(), (Exception)((Object)mae));
        }
    }

    public void pushSetForRollback(ManagedObject mo, String attributeName, Coordinator coordinator) throws RbsConfigurationFailedException {
        this.pushSetForRollback(mo, new String[]{attributeName}, coordinator);
    }

    public void pushSetForRollbackNoReadTrans(ManagedObject mo, String attributeName, Coordinator coordinator) throws RbsConfigurationFailedException {
        this.pushSetForRollbackNoReadTrans(mo, new String[]{attributeName}, coordinator);
    }

    public void pushDeleteForRollback(ManagedObject mo, Coordinator coordinator) {
        this.rollbackStack.pushDelete(mo.getLocalDistinguishedName(), coordinator);
    }

    public void pushCreateForRollback(ManagedObject mo, String[] attributeNames, Object[] attributeValues, Coordinator coordinator) {
        this.rollbackStack.pushCreate(mo.getLocalDistinguishedName(), attributeNames, attributeValues, coordinator);
    }

    public void pushActionForRollback(ManagedObject managedObject, String actionName, String[] attributeNames, Object[] attributeValues, Coordinator coordinator) {
        this.rollbackStack.pushAction(managedObject.getLocalDistinguishedName(), actionName, attributeNames, attributeValues, coordinator);
    }

    private String attrListToString(AttrListImpl attr) {
        if (attr == null || attr.size() == 0) {
            return "";
        }
        String str = "";
        for (int i = 0; i < attr.size(); ++i) {
            str = str + "Attribute: " + attr.getName(i) + '=' + attr.getValue(i) + '\n';
        }
        return str;
    }

    protected void setRollbackStack(RollbackStack inRollbackStack) {
        this.rollbackStack = inRollbackStack;
    }
}

