/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.ipoam.IpRoutingTableMo;
import se.ericsson.cello.ipsec.IpSecTunnelMo;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.iptransport.GigaBitEthernetMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.sync.SynchronizationMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.auxpluginunit.AuxPlugInUnitMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.IpHostLinkAddressSubscriber;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationSmrsHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ResetHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.UpgradeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.ManagedElementDataConfigHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.NtpServerConfigHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.OaMAlternativeAccessHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.RbsConfigurationSiteBasic;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.RbsConfigurationSiteBasicHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.RbsConfigurationSiteBasicParser;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.SiteBasicConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.VerifyIpSecLicenseInstalled;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AccessControlListData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.DnsResolverData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.ENodeBFunctionData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.GpsOutSyncLinkData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.GpsSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.HptsiSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpAccessHostEtData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpInterfaceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpRoutingTableData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSecData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSystemData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.Ipv6Data;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.Ipv6InterfaceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.NodeGroupSyncMemberData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.PacketFrequencySyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.PacketTimeSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.RbsConfigurationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.SiteBasicData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.StaticRoutesData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.SynchronizationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.TimingUnitData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.TuSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.VpnInterfaceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.WantedPositionData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.ReleaseDhcpIfTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.CreateGigaBitEthernetMo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.DisableTuOutTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.RemoveOriginalIpConfigurationTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.RemoveTemporaryTunnelTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.UnlockHptsiTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.UnlockPacketFrequencyTp;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.security.cppsec.esa.ExpressSecurityActivation;

public class RbsConfigurationSiteBasicImpl
implements RbsConfigurationSiteBasic {
    private static final String DU_2 = "DU-2";
    private static final String DU_1 = "DU-1";
    private static final String IPINTERFACE_ID1 = "1";
    private static final String IPV6_ID = "1";
    private static final int DEFAULT_MAX_WAITING_TIME = 10000;
    private static final int MAX_WAITING_TIME;
    private static final Class THIS_CLASS;
    private static final AbstractLogger logger;
    private final transient MoFactoryMgrWrapper aFactoryMgr;
    private boolean getNewFile = false;
    private final RbsConfigurationHelper helper;
    private final RbsConfigurationMao rbsConfiguration;
    private final RbsConfigurationContext rbsConfigurationContext;
    private final RbsConfigurationSiteBasicHelper rbsConfigurationSiteBasicHelper;
    private final String remoteFilePath;
    private final boolean validateXml;
    private final GenericMaoContext genericMaoContext;
    private final MoRepositoryWrapper aMoRepository;
    private static final String SITE_BASIC_FAULT = "Fault when activating Site Basic";
    private static final String VPN = "vpn";
    private ExpressSecurityActivation esa = null;
    private Object esaLock = null;
    private boolean isNpc = false;
    private boolean finishedParsing = false;
    private SiteBasicData siteBasicData = null;
    private boolean isTempTunnel = false;
    int phase = 0;

    public RbsConfigurationSiteBasicImpl(RbsConfigurationMao inRbsConfiguration, boolean inValidateXml) {
        this.rbsConfiguration = inRbsConfiguration;
        this.rbsConfigurationContext = this.rbsConfiguration.getRbsConfigurationContext();
        this.genericMaoContext = this.rbsConfigurationContext.getGenericMaoContext();
        this.aMoRepository = this.genericMaoContext.getMoRepositoryWrapper();
        this.aFactoryMgr = this.genericMaoContext.getMoFactoryMgrWrapper();
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        this.remoteFilePath = FileParameters.instance(inRbsConfiguration).getSiteBasicRemotePath();
        this.validateXml = inValidateXml;
        this.rbsConfigurationSiteBasicHelper = new RbsConfigurationSiteBasicHelper(this.rbsConfiguration, this.aMoRepository);
        this.isNpc = true;
    }

    public RbsConfigurationSiteBasicImpl(RbsConfigurationMao inRbsConfigurationMao, boolean inValidateXml, ExpressSecurityActivation aEsa, Object aEsaLock) {
        this.rbsConfiguration = inRbsConfigurationMao;
        this.rbsConfigurationContext = this.rbsConfiguration.getRbsConfigurationContext();
        this.genericMaoContext = this.rbsConfigurationContext.getGenericMaoContext();
        this.aMoRepository = this.genericMaoContext.getMoRepositoryWrapper();
        this.aFactoryMgr = this.genericMaoContext.getMoFactoryMgrWrapper();
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        this.remoteFilePath = FileParameters.instance(inRbsConfigurationMao).getSiteBasicRemotePath();
        this.validateXml = inValidateXml;
        this.rbsConfigurationSiteBasicHelper = new RbsConfigurationSiteBasicHelper(this.rbsConfiguration, this.aMoRepository);
        this.esa = aEsa;
        this.esaLock = aEsaLock;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        if (this.phase == 0) {
            this.finishedParsing = false;
            this.parseSiteBasicFile();
            this.finishedParsing = true;
            if (!this.gigabitEthernetExists()) {
                new CreateGigaBitEthernetMo().createNewGigabitEthernetMoInstance(this.rbsConfiguration.getRbsConfigurationContext().getGenericMaoContext());
            }
            if (this.siteBasicData != null && this.siteBasicData.getIpData() != null && this.siteBasicData.getIpData().getIpHostLinkData() != null) {
                try {
                    TransactionHandler.run(new ReleaseDhcpIfTp(this.genericMaoContext));
                }
                catch (RbsConfigurationFailedException e) {
                    logger.traceDebug(THIS_CLASS, "Unable to release DHCP lease, it might not have existed in the first place");
                }
            }
            if (this.siteBasicData != null && this.siteBasicData.getIpSystemData() != null && this.siteBasicData.getIpSystemData().getIpsecData() != null && this.siteBasicData.getIpSystemData().getIpsecData().getFeatureState() != null && this.siteBasicData.getIpSystemData().getIpsecData().getFeatureState().intValue() == RbsConfigurationDefinitions.ACTIVATED.intValue()) {
                this.verifySufficientLicenseInstalled();
            }
            this.waitForHsiToComplete();
            this.tearDownTemporaryTunnelIfExists();
            this.runSiteBasicConfiguration(coordinator);
            this.phase = 1;
        } else if (this.phase == 1) {
            this.waitForIpHostLinkAddress(this.siteBasicData.getIpData(), coordinator);
            this.runSiteBasicConfiguration_2(coordinator);
            this.phase = 2;
        } else if (this.phase == 2) {
            TransactionHandler.run(new UnlockHptsiTp(this.aMoRepository, "administrativeState"));
            TransactionHandler.run(new UnlockPacketFrequencyTp(this.aMoRepository, "administrativeState"));
            ProgressReportHandler.getInstance().updateProgressReportInformation(1700, 5, "Successfully activated Site Basic configuration", true);
            this.helper.setRbsConfigLevel(RbsConfigurationDefinitions.RBS_CL_SITE_BASIC);
            this.phase = 3;
        }
    }

    private boolean gigabitEthernetExists() {
        MoRepositoryWrapper moWrapper = this.rbsConfigurationContext.getGenericMaoContext().getMoRepositoryWrapper();
        GigaBitEthernetMo gigabitEthernetMo = (GigaBitEthernetMo)moWrapper.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1");
        return gigabitEthernetMo != null;
    }

    private SiteBasicData parseSiteBasicFile() throws NoSuchAttributeException, MoAccessException {
        String siteBasicFilePath = FileParameters.instance(this.rbsConfiguration).getSiteBasicFilePath();
        try {
            ProgressReportHandler.getInstance().updateProgressReportInformation(1600, 3, "Parsing Site Basic file: " + StringHelper.doubleQuote((String)siteBasicFilePath), true);
            RbsConfigurationSiteBasicParser parser = new RbsConfigurationSiteBasicParser(this.genericMaoContext);
            this.siteBasicData = parser.parseSiteBasicFile(siteBasicFilePath, this.validateXml);
            ProgressReportHandler.getInstance().updateProgressReportInformation(1600, 5, "Successfully parsed Site Basic file: " + StringHelper.doubleQuote((String)siteBasicFilePath), true);
        }
        catch (IOException ioe) {
            String slogan = "IO Fault";
            String faultMsg = "Could not parse files needed for Site Basic.";
            ProgressReportHandler.getInstance().updateProgressReportInformation(1600, 4, "Exception caught: " + ioe.getMessage(), true);
            throw new RbsConfigurationFailedException("IO Fault", "Could not parse files needed for Site Basic.", ioe);
        }
        catch (RbsConfigurationFailedException rcfe) {
            String faultMsg = ExceptionHelper.appendReason((String)"Could not parse files needed for Site Basic.", (Throwable)((Object)rcfe));
            ProgressReportHandler.getInstance().updateProgressReportInformation(1600, 4, faultMsg, true);
            throw rcfe;
        }
        catch (NoClassDefFoundError exc) {
            String errorMsg = "Faulty SiteBasicFile.";
            logger.traceGeneral(THIS_CLASS, "NoClassDefFoundError " + exc.getMessage());
            if (exc.getMessage().equalsIgnoreCase("java.sql.SQLException")) {
                logger.traceGeneral(THIS_CLASS, "Unsupported revision of SiteBasic XML file.");
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OAM_CONFIG_FILE_FAULT, "ErroneousInput", "Faulty SiteBasicFile.");
            }
            throw exc;
        }
        return this.siteBasicData;
    }

    private void runSiteBasicConfiguration(Coordinator coordinator) throws InactiveTransactionException, MoHasChildrenException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "runSiteBasicConfiguration()");
        ProgressReportHandler.getInstance().updateProgressReportInformation(1700, 3, "Activating Site Basic configuration", true);
        try {
            if (this.siteBasicData != null) {
                this.prepareForOamIpSecIfUsed();
                this.createSiteBasicMos(coordinator);
                this.createSiteBasicRefs(coordinator);
                this.configureAlternativeAccess(this.siteBasicData.getIpData(), coordinator);
                this.configureDnsAutoConfigInterfaceRef(coordinator);
            }
        }
        catch (RbsConfigurationFailedException rcfe) {
            ProgressReportHandler.getInstance().updateProgressReportInformation(1700, 4, rcfe.getMessage(), true);
            throw rcfe;
        }
        logger.traceReturn(THIS_CLASS, "runSiteBasicConfiguration()");
    }

    private void runSiteBasicConfiguration_2(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "runSiteBasicConfiguration_2()");
        this.configureSynchronization(this.siteBasicData.getSynchronizationData(), coordinator);
        logger.traceReturn(THIS_CLASS, "runSiteBasicConfiguration_2()");
    }

    private boolean isTempTunnelExisting() {
        logger.traceEnter(THIS_CLASS, "isTempTunnelExisting()");
        boolean ipSecTunnelExists = Boolean.FALSE;
        MoRepositoryWrapper moWrapper = this.rbsConfigurationContext.getGenericMaoContext().getMoRepositoryWrapper();
        IpSecTunnelMo ipSecTunnelMo = (IpSecTunnelMo)moWrapper.lookup("ManagedElement=1,IpSystem=1,IpSec=1,IpSecTunnel=1");
        if (ipSecTunnelMo != null) {
            ipSecTunnelExists = Boolean.TRUE;
        }
        logger.traceReturn(THIS_CLASS, "isTempTunnelExisting()");
        return ipSecTunnelExists;
    }

    private boolean usedUpgrade() {
        UpgradeParameters up = UpgradeParameters.instance(this.rbsConfiguration);
        String localUpFilePath = up.getUpgradePackageFilePath();
        String remoteUpFilePath = up.getUpgradePackageRemotePath();
        boolean upgrade = RbsConfigurationHelper.existsAndNotEmpty(localUpFilePath) || RbsConfigurationHelper.existsAndNotEmpty(remoteUpFilePath);
        logger.traceDebug(THIS_CLASS, "usedUpgrade() " + upgrade);
        return upgrade;
    }

    private void threadSleep(int milisec) {
        try {
            Thread.sleep(milisec);
        }
        catch (InterruptedException e) {
            logger.traceDebug(THIS_CLASS, "Thread interrupted while sleeping. " + e);
        }
    }

    private void waitForHsiToComplete() {
        logger.traceEnter(THIS_CLASS, "waitForHsiToComplete()");
        int MAX_WAITING_RADIO = 100;
        int SLEEP_TIME = 3000;
        if (this.usedUpgrade()) {
            ArrayList<ManagedObject> configuredAuxMoList = new ArrayList<ManagedObject>();
            int waitCounter = 0;
            MoIterator auxMoIter = this.genericMaoContext.getMoRepositoryWrapper().lookupType("AuxPlugInUnit");
            if (auxMoIter != null) {
                while (auxMoIter.hasMoreElements()) {
                    configuredAuxMoList.add(auxMoIter.nextMo());
                }
            }
            while (!configuredAuxMoList.isEmpty()) {
                if (waitCounter > 100) {
                    logger.traceDebug(THIS_CLASS, "Time out. " + configuredAuxMoList.size() + " AuxPlugInUnit(s) did not execute Hardware Sensitive Install.");
                    break;
                }
                Iterator auxIter = configuredAuxMoList.iterator();
                while (auxIter.hasNext()) {
                    AuxPlugInUnitMao auxPiu = (AuxPlugInUnitMao)auxIter.next();
                    if (this.hsiNotSupported(auxPiu)) {
                        auxIter.remove();
                        continue;
                    }
                    if (this.hsiCompleted(auxPiu)) {
                        auxIter.remove();
                        waitCounter = 0;
                        logger.traceDebug(THIS_CLASS, "Hardware Sensitive Install completed for AuxPlugInUnit=" + auxPiu);
                        continue;
                    }
                    if (auxPiu == null || !auxPiu.isTriggeredFromNodeControl()) continue;
                    this.waitForInstall(auxPiu);
                    auxIter.remove();
                    waitCounter = 0;
                }
                this.threadSleep(3000);
                ++waitCounter;
            }
        }
        logger.traceReturn(THIS_CLASS, "waitForHsiToComplete()");
    }

    private boolean hsiNotSupported(AuxPlugInUnitMao auxPiu) {
        boolean hsiNotSupported = false;
        if (auxPiu != null) {
            try {
                PiuTypeMoSU_Access piuTypeMo = (PiuTypeMoSU_Access)auxPiu.getAttribute("piuType", null);
                hsiNotSupported = piuTypeMo.getLocalDistinguishedName().indexOf("INITIALRBSRD_*") > -1;
            }
            catch (NoSuchAttributeException nsae) {
                logger.traceAbnormal(THIS_CLASS, "Couldn't fetch piuType for AuxPlugInUnit=" + auxPiu + ". " + (Object)((Object)nsae));
            }
            catch (MoAccessException mae) {
                logger.traceAbnormal(THIS_CLASS, "Couldn't access AuxPlugInUnit=" + auxPiu + ". " + (Object)((Object)mae));
            }
        }
        return hsiNotSupported;
    }

    private void waitForInstall(AuxPlugInUnitMao auxPiu) {
        int MAX_WAITING_INSTALL = 720;
        int SLEEP_TIME = 5000;
        int waitCounter = 0;
        while (!this.hsiCompleted(auxPiu) && auxPiu.isTriggeredFromNodeControl()) {
            if (waitCounter > 720) {
                logger.traceError(THIS_CLASS, "Timeout during wait for Hardware Sensitive Install to complete for AuxPlugInUnit=" + auxPiu);
                break;
            }
            this.threadSleep(5000);
            ++waitCounter;
        }
        if (this.hsiCompleted(auxPiu)) {
            logger.traceDebug(THIS_CLASS, "Hardware Sensitive Install completed for AuxPlugInUnit=" + auxPiu);
        } else {
            logger.traceDebug(THIS_CLASS, "Hardware Sensitive Install failed for AuxPlugInUnit=" + auxPiu);
        }
    }

    private boolean hsiCompleted(AuxPlugInUnitMao auxMo) {
        boolean hsiCompleted = false;
        if (auxMo != null) {
            try {
                PiuTypeMoSU_Access piuTypeMo = (PiuTypeMoSU_Access)auxMo.getAttribute("piuType", null);
                hsiCompleted = auxMo.isLmInInstalledState(piuTypeMo, null) && piuTypeMo.getLocalDistinguishedName().indexOf("INITIAL") == -1;
            }
            catch (MoAccessException mae) {
                logger.traceDebug(THIS_CLASS, "Failed to access auxMo=" + auxMo + "." + (Object)((Object)mae));
            }
        }
        return hsiCompleted;
    }

    private void tearDownTemporaryTunnelIfExists() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "tearDownTemporaryTunnelIfExists");
        this.isTempTunnel = this.isTempTunnelExisting();
        if (this.isTempTunnel) {
            ProgressReportHandler.getInstance().updateProgressReportInformation(1650, 3, "Tearing down the temporary IpSec tunnel", true);
            try {
                TransactionHandler.run(new RemoveTemporaryTunnelTp(this.rbsConfigurationContext.getGenericMaoContext(), Boolean.FALSE));
                ProgressReportHandler.getInstance().updateProgressReportInformation(1650, 5, "Finished tearing down the temporary IpSec tunnel", true);
            }
            catch (RbsConfigurationFailedException e) {
                ConfigurationReportLoggerFactory.getLogger().logFailure("tearDownTemporaryTunnelIfExists", "Failure in temporary tunnel teardown");
                ProgressReportHandler.getInstance().updateProgressReportInformation(1650, 0, "Failed in tearing down the temporary IpSec tunnel", true);
                throw new RbsConfigurationFailedException("Tear down temporary tunnel", "Failure to remove original oam ip config", (Exception)((Object)e));
            }
        } else {
            ProgressReportHandler.getInstance().updateProgressReportInformation(1650, 2, "On trusted network - skipping tear down of the temporary tunnel", true);
        }
        logger.traceReturn(THIS_CLASS, "tearDownTemporaryTunnelIfExists");
    }

    private void prepareForOamIpSecIfUsed() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "prepareForOamIpSecIfUsed()");
        if (!this.isTempTunnel && this.siteBasicData.getIpData() != null && this.siteBasicData.getIpData().getIpHostLinkData() != null) {
            try {
                TransactionHandler.run(new RemoveOriginalIpConfigurationTp(this.siteBasicData, this.rbsConfigurationContext.getGenericMaoContext()));
            }
            catch (RbsConfigurationFailedException e) {
                ConfigurationReportLoggerFactory.getLogger().logFailure("removeCurrentOamIpIfIpsec", "Failure in remove original ip oam setup");
                throw new RbsConfigurationFailedException("Remove default Oam", "Failure to remove original oam ip config", (Exception)((Object)e));
            }
        }
        logger.traceReturn(THIS_CLASS, "prepareForOamIpSecIfUsed()");
    }

    private void verifySufficientLicenseInstalled() throws RbsConfigurationFailedException {
        VerifyIpSecLicenseInstalled verifyIpSecLicenseInstalled = new VerifyIpSecLicenseInstalled(this.rbsConfiguration, this.aMoRepository, this.helper);
        verifyIpSecLicenseInstalled.verifyLicense();
    }

    private void createSiteBasicRefs(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createSiteBasicRefs()");
        if (this.siteBasicData.geteNodeBFunctionData() != null) {
            this.createENodeBFunctionRefs(this.siteBasicData.geteNodeBFunctionData(), coordinator);
        }
        if (this.siteBasicData.getIpInterfaceData() != null) {
            this.createIpInterfaceRefs(this.siteBasicData.getIpInterfaceData(), coordinator);
        }
        if (this.siteBasicData.getIpSystemData() != null && this.siteBasicData.getIpSystemData().getIpv6InterfaceData() != null) {
            this.createIpv6InterfaceRefs(this.siteBasicData.getIpSystemData().getIpv6InterfaceData(), coordinator);
        }
        logger.traceReturn(THIS_CLASS, "createSiteBasicRefs()");
    }

    private void configureDnsAutoConfigInterfaceRef(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "configureDnsAutoConfigInterfaceRef()");
        int IKE_MODE = RbsConfigurationDefinitions.VPN_INTERFACE_CONF_MODE_IKE;
        int DHCP_MODE = RbsConfigurationDefinitions.IP_INTERFACE_CONFIGURATION_MODE_DHCP;
        if (this.siteBasicData.getIpData() != null && this.siteBasicData.getIpData().getDnsServer1() == null && this.siteBasicData.getIpData().getDnsServer2() == null && this.siteBasicData.getIpData().getDnsServer3() == null) {
            IpMo ipMo = (IpMo)this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1");
            IpHostLinkMo ipHostLink = null;
            ManagedObject ipHostLinkRef = null;
            MoIterator ipHostLinks = this.aMoRepository.lookupType("IpHostLink");
            while (ipHostLinks.hasMoreElements()) {
                ipHostLink = (IpHostLinkMo)ipHostLinks.nextMo();
                ipHostLinkRef = ipHostLink.getIpInterfaceMoRef(coordinator);
                if (ipHostLink == null || ipHostLinkRef == null || (!(ipHostLinkRef instanceof VpnInterfaceMo) || ((VpnInterfaceMo)ipHostLinkRef).getConfigurationMode(coordinator) != IKE_MODE) && (!(ipHostLinkRef instanceof IpInterfaceMo) || ((IpInterfaceMo)ipHostLinkRef).getConfigurationMode(coordinator) != DHCP_MODE)) continue;
                ipMo.setDnsAutoConfigInterfaceRef(ipHostLinkRef, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "configureDnsAutoConfigInterfaceRef()");
    }

    protected void createIpInterfaceRefs(IpInterfaceData[] ipInterfaceData, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createIpInterfaceRefs()");
        ManagedObject ipInterfaceMo = null;
        for (int i = 0; i < ipInterfaceData.length; ++i) {
            ipInterfaceMo = this.getIpInterfaceMo(ipInterfaceData[i]);
            if (ipInterfaceData[i].getAccessControlListRefLdn() == null) continue;
            ManagedObject referencedAccessControlListMo = this.aMoRepository.lookup(ipInterfaceData[i].getAccessControlListRefLdn());
            if (referencedAccessControlListMo == null) {
                throw new RbsConfigurationFailedException("AccessControlList MO refered by " + ipInterfaceMo.getRelativeDistinguishedName() + " does not exist.");
            }
            this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging(ipInterfaceMo, "accessControlListRef", referencedAccessControlListMo, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "createIpInterfaceRefs()");
    }

    protected void createIpv6InterfaceRefs(Ipv6InterfaceData[] ipv6InterfaceData, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createIpv6InterfaceRefs()");
        ManagedObject ipv6InterfaceMo = null;
        for (int i = 0; i < ipv6InterfaceData.length; ++i) {
            ipv6InterfaceMo = this.getIpv6InterfaceMo(ipv6InterfaceData[i]);
            if (ipv6InterfaceData[i].getAccessControlListRefLdn() == null) continue;
            ManagedObject referencedAccessControlListMo = this.aMoRepository.lookup(ipv6InterfaceData[i].getAccessControlListRefLdn());
            if (referencedAccessControlListMo == null) {
                throw new RbsConfigurationFailedException("AccessControlList MO refered by " + ipv6InterfaceMo.getRelativeDistinguishedName() + " does not exist.");
            }
            this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging(ipv6InterfaceMo, "accessControlListRef", referencedAccessControlListMo, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "createIpv6InterfaceRefs()");
    }

    private ManagedObject getIpInterfaceMo(IpInterfaceData ipInterfaceData) throws RbsConfigurationFailedException {
        ManagedObject ipInterfaceMo = null;
        if (ipInterfaceData != null && ipInterfaceData.getIpInterfaceId().equals("1")) {
            String ipInterFaceLdn = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1";
            ipInterfaceMo = this.aMoRepository.lookup(ipInterFaceLdn);
        } else if (ipInterfaceData != null && ipInterfaceData.getIpInterFaceSlot().equalsIgnoreCase(DU_1)) {
            String ipInterFaceLdn = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=" + ipInterfaceData.getIpInterfaceId();
            ipInterfaceMo = this.aMoRepository.lookup(ipInterFaceLdn);
        } else if (ipInterfaceData != null && ipInterfaceData.getIpInterFaceSlot().equalsIgnoreCase(DU_2)) {
            String ipInterFaceLdn = "ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=2,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=" + ipInterfaceData.getIpInterfaceId();
            ipInterfaceMo = this.aMoRepository.lookup(ipInterFaceLdn);
        } else {
            throw new RbsConfigurationFailedException("The attribute: syncSlot must have the value DU-1 or DU-2.");
        }
        return ipInterfaceMo;
    }

    private ManagedObject getIpv6InterfaceMo(Ipv6InterfaceData ipv6InterfaceData) throws RbsConfigurationFailedException {
        ManagedObject ipv6InterfaceMo = null;
        if (ipv6InterfaceData == null) {
            throw new RbsConfigurationFailedException("The ipv6Interface data is null");
        }
        String ipv6InterFaceLdn = "ManagedElement=1,IpSystem=1,Ipv6Interface=" + ipv6InterfaceData.getIpv6InterfaceId();
        ipv6InterfaceMo = this.aMoRepository.lookup(ipv6InterFaceLdn);
        return ipv6InterfaceMo;
    }

    protected void createENodeBFunctionRefs(ENodeBFunctionData eNodeBFunctionData, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createENodeBFunctionRefs()");
        if (eNodeBFunctionData.getUpIpAccessHostRef() != null) {
            ManagedObject eNodeBFunctionMo = this.aMoRepository.lookup("ManagedElement=1,ENodeBFunction=1");
            ManagedObject upIpAccessHostRef = this.aMoRepository.lookup(eNodeBFunctionData.getUpIpAccessHostRef());
            ManagedObject dnsSelectionS1X2Ref = this.aMoRepository.lookup(eNodeBFunctionData.getDnsSelectionS1X2Ref());
            if (upIpAccessHostRef == null) {
                throw new RbsConfigurationFailedException(SITE_BASIC_FAULT, "Faulty SiteBasic file. Referenced IpAccessHostEt with LDN " + eNodeBFunctionData.getUpIpAccessHostRef() + " to be used for PayLoad traffic does not exist." + " Could not set reference ENodeBFunction.upIpAccessHostRef.");
            }
            this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging(eNodeBFunctionMo, "upIpAddressRef", upIpAccessHostRef, coordinator);
            if (dnsSelectionS1X2Ref != null) {
                this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging(eNodeBFunctionMo, "dnsSelectionS1X2Ref", dnsSelectionS1X2Ref, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "createENodeBFunctionRefs()");
    }

    protected void createSiteBasicMos(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "createSiteBasicMos()");
        this.configureIpInterface(this.siteBasicData.getIpInterfaceData(), coordinator);
        this.configureIp(this.siteBasicData.getIpData(), coordinator);
        this.configureENodeBFunction(this.siteBasicData.geteNodeBFunctionData(), coordinator);
        this.configureENodeBFunctionTimePhase(this.siteBasicData.geteNodeBFunctionData(), coordinator);
        TransactionHandler.run(new ManagedElementDataConfigHandler(this.rbsConfigurationSiteBasicHelper, SiteBasicConfigurationHelper.findManagedElementDataMo(this.aMoRepository), this.siteBasicData.getManagedElementDataData()));
        TransactionHandler.run(new NtpServerConfigHandler(this.genericMaoContext, this.rbsConfigurationSiteBasicHelper, this.siteBasicData.getManagedElementDataData()));
        this.configureIpSystem(this.siteBasicData.getIpSystemData(), this.siteBasicData.getSynchronizationData(), coordinator);
        this.configureIpHostLink(this.siteBasicData.getIpData(), coordinator);
        this.configureIpRoutingTable(this.siteBasicData.getIpData(), coordinator);
        this.configureGpsAndHptsiAndTuSyncRef(this.siteBasicData.getTimingUnitData(), this.siteBasicData.getTuSyncRefData(), this.siteBasicData.getGpsSyncRefData(), this.siteBasicData.getGpsOutSyncLinkData(), this.siteBasicData.getHptsiSyncRefData(), coordinator);
        SynchronizationMo synchMo = (SynchronizationMo)this.aMoRepository.lookup("ManagedElement=1,TransportNetwork=1,Synchronization=1");
        if (this.siteBasicData.getSynchronizationData() != null) {
            synchMo.setAttribute("telecomStandard", (Object)this.siteBasicData.getSynchronizationData().getTelecomStandard(), coordinator);
            if (this.siteBasicData.getSynchronizationData().getMinQualityLevel() != null) {
                synchMo.setAttribute("minQualityLevel", (Object)this.siteBasicData.getSynchronizationData().getMinQualityLevel(), coordinator);
            }
            synchMo.setAttribute("selectionProcessMode", (Object)this.siteBasicData.getSynchronizationData().getSelectionProcessMode(), coordinator);
            if (this.siteBasicData.getSynchronizationData().getPacketFrequencySyncRefData() != null) {
                this.configurePacketFrequencySyncRef(this.siteBasicData.getSynchronizationData().getPacketFrequencySyncRefData(), coordinator);
                synchMo.setAttribute("ptpFreqFeatureState", (Object)RbsConfigurationDefinitions.ACTIVATED, coordinator);
            } else {
                synchMo.setAttribute("ptpFreqFeatureState", (Object)RbsConfigurationDefinitions.DEACTIVATED, coordinator);
            }
            if (this.siteBasicData.getSynchronizationData().getPacketTimeSyncRefData() != null) {
                this.configurePacketTimeSyncRef(this.siteBasicData.getSynchronizationData().getPacketTimeSyncRefData(), coordinator);
                synchMo.setAttribute("ptpTimeFeatureState", (Object)RbsConfigurationDefinitions.ACTIVATED, coordinator);
            } else {
                synchMo.setAttribute("ptpTimeFeatureState", (Object)RbsConfigurationDefinitions.DEACTIVATED, coordinator);
            }
            if (this.siteBasicData.getSynchronizationData().getNodeGroupSyncMemberData() != null) {
                this.configureNodeGroupSyncMember(this.siteBasicData.getSynchronizationData().getNodeGroupSyncMemberData(), coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "createSiteBasicMos()");
    }

    private void configureAlternativeAccess(IpData ipData, Coordinator coordinator) throws RbsConfigurationFailedException {
        boolean configurationDataProvided;
        boolean configurationRequested = ipData != null && ipData.getOaMAlternativeAccess() != null && ipData.getOaMAlternativeAccess() != false;
        boolean bl = configurationDataProvided = ipData != null && ipData.getOaMAlternativeAccessSourceData() != null && ipData.getOaMAlternativeAccessSourceData().length > 0;
        if (configurationRequested && configurationDataProvided) {
            OaMAlternativeAccessHelper oaMAlternativeAccessHelper = new OaMAlternativeAccessHelper();
            oaMAlternativeAccessHelper.activateOaMAlternativeAccess(ipData, this.rbsConfigurationSiteBasicHelper, this.aMoRepository, this.aFactoryMgr, coordinator);
        } else if (!(!configurationRequested && !configurationDataProvided || configurationRequested && configurationDataProvided)) {
            ConfigurationReportLoggerFactory.getLogger().logFailure("O&M Alternative access", "Incomplete configuration for alternative O&M connection provided, alternative access will not be configured");
        }
    }

    protected void configureIpHostLink(IpData ipData, Coordinator coordinator) throws RbsConfigurationFailedException {
        if (ipData != null && ipData.getIpHostLinkData() != null) {
            this.createNewIpHostLink(ipData, coordinator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForIpHostLinkAddress(IpData ipData, Coordinator coordinator) {
        block12: {
            if (ipData != null && ipData.getIpHostLinkData() != null) {
                ManagedObject refMo = this.aMoRepository.lookup(ipData.getIpHostLinkData().getIpInterfaceLdn());
                ManagedObject ipMo = this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1");
                int IKE_MODE = RbsConfigurationDefinitions.VPN_INTERFACE_CONF_MODE_IKE;
                int DHCP_MODE = RbsConfigurationDefinitions.IP_INTERFACE_CONFIGURATION_MODE_DHCP;
                try {
                    if ((refMo == null || !(refMo instanceof VpnInterfaceMo) || ((VpnInterfaceMo)refMo).getConfigurationMode(coordinator) != IKE_MODE) && (!(refMo instanceof IpInterfaceMo) || ((IpInterfaceMo)refMo).getConfigurationMode(coordinator) != DHCP_MODE)) break block12;
                    ((IpMo)ipMo).setDnsAutoConfigInterfaceRef(refMo, coordinator);
                    IpHostLinkAddressSubscriber subscriber = new IpHostLinkAddressSubscriber(this.rbsConfiguration);
                    subscriber.subscribe();
                    IpHostLinkAddressSubscriber ipHostLinkAddressSubscriber = subscriber;
                    synchronized (ipHostLinkAddressSubscriber) {
                        try {
                            subscriber.wait(120000L);
                        }
                        catch (InterruptedException ie) {
                            logger.traceDebug(THIS_CLASS, "Interrupted while waiting. " + ie);
                        }
                        finally {
                            subscriber.unsubscribe();
                        }
                    }
                    if (subscriber.getIpAddress().equals("")) {
                        logger.traceError(THIS_CLASS, "Unable to get IP address for IpHostLink=" + ipData.getIpHostLinkData().getIpHostLinkId());
                    }
                }
                catch (MoAccessException e) {
                    logger.traceError(THIS_CLASS, "Error while trying to wait for IpHostLink AVC");
                }
            }
        }
    }

    private void createNewIpHostLink(IpData ipData, Coordinator coordinator) throws RbsConfigurationFailedException {
        ManagedObject ipMo = this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1");
        try {
            this.rbsConfiguration.storePersistently("ipHostLinkRdnValue", ipData.getIpHostLinkData().getIpHostLinkId());
            this.rbsConfigurationSiteBasicHelper.createMoWithLogging(ipMo, (AttrListImpl)ipData.getIpHostLinkData().getAttrList(this.aMoRepository, coordinator), ipData.getIpHostLinkData().getIpHostLinkId(), "IpHostLink", this.aFactoryMgr, coordinator);
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException("SiteBasic fault", "Unable to create IpHostLink= " + ipData.getIpHostLinkData().getIpHostLinkId(), (Exception)((Object)mae));
        }
    }

    private void configureIp(IpData ipData, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "configureIp()");
        if (ipData != null) {
            ManagedObject ipMo = this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1");
            if (ipMo == null) {
                throw new MoAccessException("The MO: Ipwas not found."){};
            }
            this.rbsConfigurationSiteBasicHelper.setAttrFromAttrList(ipMo, ipData.createIpAttrList(), coordinator);
        }
        logger.traceReturn(THIS_CLASS, "configureIp()");
    }

    private void configureIpRoutingTable(IpData ipData, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "configureIpRoutingTable()");
        if (ipData != null && ipData.getIpRoutingTableData() != null) {
            IpRoutingTableData ipRoutingTableData = ipData.getIpRoutingTableData();
            IpRoutingTableMo ipRoutingTableMo = (IpRoutingTableMo)this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1");
            if (ipRoutingTableMo == null) {
                throw new RbsConfigurationFailedException("The IpRoutingTable MO is missing.");
            }
            this.rbsConfigurationSiteBasicHelper.pushSetForRollback((ManagedObject)ipRoutingTableMo, "staticRoutes", coordinator);
            if (ipRoutingTableData != null) {
                for (int i = 0; i < ipRoutingTableData.getStaticRoutes().length; ++i) {
                    StaticRoutesData staticRoute = ipRoutingTableData.getStaticRoutes()[i];
                    ipRoutingTableMo.actionAddStaticRoute(staticRoute.getIpAddress(), staticRoute.getNetworkMask(), staticRoute.getNextHopIpAddr(), staticRoute.getRouteMetric().intValue(), staticRoute.getRedistribute().booleanValue(), coordinator);
                }
                if (ipRoutingTableData.getUserLabel() != null) {
                    this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging((ManagedObject)ipRoutingTableMo, "userLabel", ipRoutingTableData.getUserLabel(), coordinator);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "configureIpRoutingTable()");
    }

    private void configureSynchronization(SynchronizationData synchronizationData, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "configureSynchronization()");
        if (synchronizationData != null) {
            Map synchronizationDataRefMap = synchronizationData.getSyncPriorityRefMap();
            Map useReceiverQlDataMap = synchronizationData.getUseReceiverQlData();
            Map adminQualityDataMap = synchronizationData.getAdminQualityData();
            Iterator synchronizationIterator = synchronizationDataRefMap.entrySet().iterator();
            Integer syncPriority = null;
            while (synchronizationIterator.hasNext()) {
                Map.Entry mapOutPutEntry = synchronizationIterator.next();
                String syncRefLdn = (String)mapOutPutEntry.getValue();
                ManagedObject syncRefMo = this.aMoRepository.lookup(syncRefLdn);
                if (syncRefMo == null) {
                    throw new RbsConfigurationFailedException("Sync source " + syncRefLdn + " has not been created.");
                }
                syncPriority = (Integer)mapOutPutEntry.getKey();
                SynchronizationMo synchMo = (SynchronizationMo)this.aMoRepository.lookup("ManagedElement=1,TransportNetwork=1,Synchronization=1");
                if (syncRefLdn.startsWith("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=") || syncRefLdn.startsWith("ManagedElement=1,TransportNetwork=1,Synchronization=1,PacketFrequencySyncRef=")) {
                    Integer useReceivedQl = (Integer)useReceiverQlDataMap.get(syncPriority);
                    Integer adminQualityData = (Integer)adminQualityDataMap.get(syncPriority);
                    logger.traceDebug(THIS_CLASS, "ActionAddSyncfRef:" + syncRefMo.getFullDistinguishedName() + " prio:" + syncPriority + " useReceivedQl:" + useReceivedQl + " adminQualityData:" + adminQualityData);
                    try {
                        synchMo.actionAddSyncRefResourceQl(syncRefMo, syncPriority.intValue(), useReceivedQl.intValue(), adminQualityData.intValue(), coordinator);
                    }
                    catch (MoAccessException e) {
                        logger.traceError(THIS_CLASS, "Problem with synchronization MO actionAddSyncRefResource");
                        throw e;
                    }
                }
                logger.traceDebug(THIS_CLASS, "ActionAddSyncfRef:" + syncRefMo.getFullDistinguishedName() + " prio:" + syncPriority);
                try {
                    synchMo.actionAddSyncRefResource(syncRefMo, syncPriority.intValue(), coordinator);
                }
                catch (MoAccessException e) {
                    logger.traceError(THIS_CLASS, "Problem with synchronization MO actionAddSyncRefResource");
                    throw e;
                }
                this.rbsConfigurationSiteBasicHelper.pushActionForRollback((ManagedObject)synchMo, "actionRemoveSyncRefResource", new String[]{"syncReference"}, new Object[]{syncRefMo}, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "configureSynchronization()");
    }

    private void configurePacketFrequencySyncRef(PacketFrequencySyncRefData[] packetFrequencySyncRefDataArray, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configurePacketFrequencySyncRef()");
        if (packetFrequencySyncRefDataArray != null) {
            ManagedObject synchronizationMo = this.aMoRepository.lookup("ManagedElement=1,TransportNetwork=1,Synchronization=1");
            for (int i = 0; i < packetFrequencySyncRefDataArray.length; ++i) {
                if (packetFrequencySyncRefDataArray[i] == null) continue;
                ManagedObject ipAccessHostEtRefMo = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,IpAccessHostEt=" + packetFrequencySyncRefDataArray[i].getIpAccessHostEtRef());
                ManagedObject packetFrequencySyncRefMo = this.aMoRepository.lookup("ManagedElement=1,TransportNetwork=1,Synchronization=1,PacketFrequencySyncRef=" + packetFrequencySyncRefDataArray[i].getPacketFrequencySyncRefId());
                if (packetFrequencySyncRefMo != null) continue;
                this.rbsConfigurationSiteBasicHelper.createMoWithLogging(synchronizationMo, packetFrequencySyncRefDataArray[i].createpacketFrequencySyncRefAttrList(ipAccessHostEtRefMo), packetFrequencySyncRefDataArray[i].getPacketFrequencySyncRefId(), "PacketFrequencySyncRef", this.aFactoryMgr, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "configurePacketFrequencySyncRef()");
    }

    private void configurePacketTimeSyncRef(PacketTimeSyncRefData[] packetTimeSyncRefDataArray, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configurePacketTimeSyncRef()");
        if (packetTimeSyncRefDataArray != null) {
            ManagedObject synchronizationMo = this.aMoRepository.lookup("ManagedElement=1,TransportNetwork=1,Synchronization=1");
            for (int i = 0; i < packetTimeSyncRefDataArray.length; ++i) {
                if (packetTimeSyncRefDataArray[i] == null) continue;
                ManagedObject gigaBitEthernetMo = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1");
                ManagedObject packetTimeSyncRefMo = this.aMoRepository.lookup("ManagedElement=1,TransportNetwork=1,Synchronization=1,PacketTimeSyncRef=" + packetTimeSyncRefDataArray[i].getPacketTimeSyncRefId());
                if (packetTimeSyncRefMo != null) continue;
                this.rbsConfigurationSiteBasicHelper.createMoWithLogging(synchronizationMo, packetTimeSyncRefDataArray[i].createpacketTimeSyncRefAttrList(gigaBitEthernetMo), packetTimeSyncRefDataArray[i].getPacketTimeSyncRefId(), "PacketTimeSyncRef", this.aFactoryMgr, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "configurePacketTimeSyncRef()");
    }

    private void configureNodeGroupSyncMember(NodeGroupSyncMemberData nodeGroupSyncMemberData, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureNodeGroupSyncMember()");
        if (nodeGroupSyncMemberData != null) {
            ManagedObject synchronizationMo = this.aMoRepository.lookup("ManagedElement=1,TransportNetwork=1,Synchronization=1");
            ManagedObject nodeGroupSyncMemberMo = this.aMoRepository.lookup("ManagedElement=1,TransportNetwork=1,Synchronization=1,NodeGroupSyncMember=" + nodeGroupSyncMemberData.getNodeGroupSyncMemberId());
            if (nodeGroupSyncMemberMo == null) {
                this.rbsConfigurationSiteBasicHelper.createMoWithLogging(synchronizationMo, nodeGroupSyncMemberData.createNodeGroupSyncMemberAttrList(), nodeGroupSyncMemberData.getNodeGroupSyncMemberId(), "NodeGroupSyncMember", this.aFactoryMgr, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "configureNodeGroupSyncMember()");
    }

    private void configureGpsAndHptsiAndTuSyncRef(TimingUnitData timingUnitData, TuSyncRefData[] tuSyncRefData, GpsSyncRefData[] gpsSyncRefData, GpsOutSyncLinkData[] gpsOutSyncLinkData, HptsiSyncRefData[] hptsiSyncRefData, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureGpsAndHptsiAndTuSyncRef()");
        if (timingUnitData != null) {
            logger.traceDebug(THIS_CLASS, "Attributes to be set on TU : gpsOutEnabled:" + timingUnitData.getGpsOutEnabled() + " hptsiOutEnabled:" + timingUnitData.getHptsiOutEnabled());
            if (timingUnitData.getGpsOutEnabled().booleanValue() || timingUnitData.getHptsiOutEnabled().booleanValue()) {
                Boolean outHptsi = Boolean.FALSE;
                Boolean outGps = Boolean.FALSE;
                if (timingUnitData.getGpsOutEnabled().booleanValue()) {
                    outGps = Boolean.TRUE;
                }
                if (timingUnitData.getHptsiOutEnabled().booleanValue()) {
                    outHptsi = Boolean.TRUE;
                }
                this.enableGpsOrHptsiOut(coordinator, outGps, outHptsi);
            } else {
                logger.traceGeneral(THIS_CLASS, "Setting AttributesgpsOutEnabled , hptsiOutEnabled to FALSE on TU ");
                TransactionHandler.run(new DisableTuOutTp(this.aMoRepository, "gpsOutEnabled"));
                TransactionHandler.run(new DisableTuOutTp(this.aMoRepository, "hptsiOutEnabled"));
            }
            if (tuSyncRefData != null) {
                for (int i = 0; i < tuSyncRefData.length; ++i) {
                    SiteBasicConfigurationHelper.createTuSyncRef(this.rbsConfigurationSiteBasicHelper, tuSyncRefData[i], coordinator, this.aFactoryMgr, this.aMoRepository);
                }
            }
            if (hptsiSyncRefData != null) {
                for (int i = 0; i < hptsiSyncRefData.length; ++i) {
                    SiteBasicConfigurationHelper.createHptsiSyncRef(this.rbsConfigurationSiteBasicHelper, hptsiSyncRefData[i], coordinator, this.aFactoryMgr, this.aMoRepository);
                }
            }
            if (gpsSyncRefData != null) {
                for (int i = 0; i < gpsSyncRefData.length; ++i) {
                    SiteBasicConfigurationHelper.createGpsSyncRef(this.rbsConfigurationSiteBasicHelper, gpsSyncRefData[i], coordinator, this.aFactoryMgr, this.aMoRepository);
                }
            }
            if (gpsOutSyncLinkData != null) {
                for (int i = 0; i < gpsOutSyncLinkData.length; ++i) {
                    SiteBasicConfigurationHelper.createGpsOutSyncLink(this.rbsConfigurationSiteBasicHelper, gpsOutSyncLinkData[i], coordinator, this.aFactoryMgr, this.aMoRepository);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "configureGpsAndHptsiAndTuSyncRef()");
    }

    private void enableGpsOrHptsiOut(Coordinator coordinator, Boolean gpsout, Boolean hptsiout) throws RbsConfigurationFailedException {
        try {
            MoIterator timingUnits = this.aMoRepository.lookupType("TimingUnit");
            while (timingUnits != null && timingUnits.hasMoreElements()) {
                ManagedObject timingUnit = timingUnits.nextMo();
                timingUnit.setAttribute("gpsOutEnabled", (Object)gpsout, coordinator);
                timingUnit.setAttribute("hptsiOutEnabled", (Object)hptsiout, coordinator);
                ConfigurationReportLoggerFactory.getLogger().logAttribute(timingUnit.getRelativeDistinguishedName(), "gpsOutEnabled", (Object)gpsout);
                ConfigurationReportLoggerFactory.getLogger().logAttribute(timingUnit.getRelativeDistinguishedName(), "hptsiOutEnabled", (Object)hptsiout);
            }
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException("GPS /HPTSI out Configuration", "Unable to set Gps Or Hptsi Out attributes on the TimingUnit, see exception", (Exception)((Object)mae));
        }
    }

    private void configureIpInterface(IpInterfaceData[] ipInterfaceData, Coordinator coordinator) throws MoHasChildrenException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "configureIpInterface()");
        if (ipInterfaceData != null) {
            for (int i = 0; i < ipInterfaceData.length; ++i) {
                if (ipInterfaceData[i] == null) continue;
                SiteBasicConfigurationHelper.handleIpInterfaceCreation(this.rbsConfigurationSiteBasicHelper, ipInterfaceData[i], coordinator, this.aFactoryMgr, this.aMoRepository);
            }
        }
        logger.traceReturn(THIS_CLASS, "configureIpInterface()");
    }

    private void configureIpSystem(IpSystemData ipSystemData, SynchronizationData synchronizationData, Coordinator coordinator) throws MoHasChildrenException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "configureIpSystem()");
        VpnInterfaceData[] vpnInterfaceDatas = null;
        if (this.siteBasicData.getIpSystemData() != null) {
            vpnInterfaceDatas = this.siteBasicData.getIpSystemData().getVpnInterfaceData();
        }
        boolean ipv6Used = false;
        if (vpnInterfaceDatas != null && vpnInterfaceDatas.length > 1) {
            for (int i = 0; i < vpnInterfaceDatas.length; ++i) {
                if (vpnInterfaceDatas[i].getIpVersion() == null || !vpnInterfaceDatas[i].getIpVersion().equalsIgnoreCase("IP_V6")) continue;
                ipv6Used = true;
            }
        }
        if (ipSystemData != null && synchronizationData != null) {
            this.configureIpv6Data(ipSystemData.getIpv6Data(), ipv6Used, coordinator);
            this.configureIpv6InterfaceData(ipSystemData.getIpv6InterfaceData(), coordinator);
            this.configureIpAccessHostEt(ipSystemData.getIpAccessHostEtData(), coordinator);
            this.configureVpnInterfaceData(ipSystemData.getVpnInterfaceData(), coordinator);
            this.configureIpAccessHostEt(ipSystemData.getIpAccessHostEtData(), coordinator);
            this.configureDnsResolverData(ipSystemData.getDnsResolverData(), coordinator);
            this.configureAccessControlListData(ipSystemData.getAccessControlListData(), coordinator);
            this.handleIpSecData(ipSystemData.getIpsecData(), coordinator);
        }
        logger.traceReturn(THIS_CLASS, "configureIpSystem()");
    }

    private void handleIpSecData(IpSecData ipSecData, Coordinator coordinator) throws RbsConfigurationFailedException, MoAccessException {
        if (ipSecData != null) {
            try {
                ProgressReportHandler.getInstance().updateProgressReportInformation(1800, 3, "Creating IPSec Managed Objects and attributes", true);
                this.configureIpSecData(ipSecData, coordinator);
                ProgressReportHandler.getInstance().updateProgressReportInformation(1800, 5, "Successfully created Managed Objects for IPSec ", true);
            }
            catch (IOException ioe) {
                throw new RbsConfigurationFailedException("Error when configuring IpSecData: " + ioe.getMessage());
            }
        }
    }

    private void configureVpnInterfaceData(VpnInterfaceData[] vpnInterfaceData, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "configureVpnInterfaceData()");
        if (vpnInterfaceData == null) {
            logger.traceDebug(THIS_CLASS, "\n\n ipSystemData.vpnInterfaceData == null \n\n");
        } else {
            for (int i = 0; i < vpnInterfaceData.length; ++i) {
                VpnInterfaceData currentVpnInterfaceData = vpnInterfaceData[i];
                ManagedObject ipAccessHostEtRef = this.aMoRepository.lookup(currentVpnInterfaceData.getIpAccessHostEtRefLdn());
                ManagedObject ipSystemMo = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1");
                this.rbsConfigurationSiteBasicHelper.createMoWithLogging(ipSystemMo, currentVpnInterfaceData.createVpnInterfaceAttrList(ipAccessHostEtRef), currentVpnInterfaceData.getVpnInterfaceId(), "VpnInterface", this.aFactoryMgr, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "configureVpnInterfaceData()");
    }

    private void configureDnsResolverData(DnsResolverData[] dnsResolverData, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "configureDnsResolverData()");
        if (dnsResolverData != null) {
            for (int i = 0; i < dnsResolverData.length; ++i) {
                DnsResolverData currentDnsResolverData = dnsResolverData[i];
                ManagedObject ipAccessHostEtRef = this.aMoRepository.lookup(currentDnsResolverData.getIpAccessHostEtRefLdn());
                ManagedObject ipSystemMo = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1");
                this.rbsConfigurationSiteBasicHelper.createMoWithLogging(ipSystemMo, currentDnsResolverData.createDnsResolverAttrList(ipAccessHostEtRef), currentDnsResolverData.getDnsResolverId(), "DnsResolver", this.aFactoryMgr, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "configureDnsResolverData()");
    }

    private void configureIpSecData(IpSecData ipsecData, Coordinator coordinator) throws MoAccessException, IOException {
        logger.traceEnter(THIS_CLASS, "configureIpSecData()");
        ManagedObject ipSecMo = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,IpSec=1");
        if (ipSecMo == null) {
            throw new RbsConfigurationFailedException("IpSec MO not created");
        }
        this.rbsConfigurationSiteBasicHelper.setAttrFromAttrList(ipSecMo, ipsecData.createIpSecAttrList(), coordinator);
        this.configureIkePeerData(ipsecData, coordinator, ipSecMo);
        this.configureIpSecTunnelData(ipsecData, coordinator, ipSecMo);
        logger.traceReturn(THIS_CLASS, "configureIpSecData()");
    }

    private void configureIpSecTunnelData(IpSecData ipsecData, Coordinator coordinator, ManagedObject ipSecMo) throws MoAccessException, IOException {
        for (int i = 0; i < ipsecData.getIpSecTunnelData().length; ++i) {
            if (ipsecData.getIpSecTunnelData() == null || ipsecData.getIpSecTunnelData()[i] == null) continue;
            SiteBasicConfigurationHelper.createIpSecTunnel(this.rbsConfigurationSiteBasicHelper, ipsecData.getIpSecTunnelData()[i], this.aFactoryMgr, ipSecMo, coordinator, this.aMoRepository);
        }
    }

    private void configureIkePeerData(IpSecData ipsecData, Coordinator coordinator, ManagedObject ipSecMo) throws MoAccessException {
        for (int i = 0; i < ipsecData.getIkePeerData().length; ++i) {
            if (ipsecData.getIkePeerData() == null || ipsecData.getIkePeerData()[i] == null) continue;
            SiteBasicConfigurationHelper.createIkePeer(this.rbsConfigurationSiteBasicHelper, ipsecData.getIkePeerData()[i], this.aFactoryMgr, ipSecMo, coordinator);
        }
    }

    private void configureIpv6Data(Ipv6Data[] ipv6Data, boolean isIpv6Used, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureIpv6Data()");
        ManagedObject ipSystemMo = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1");
        ManagedObject ipv6Mo = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,Ipv6=1");
        if (ipv6Data != null) {
            for (int i = 0; i < ipv6Data.length; ++i) {
                if (ipv6Data[i] == null || ipv6Mo != null) continue;
                this.rbsConfigurationSiteBasicHelper.createMoWithLogging(ipSystemMo, ipv6Data[i].createIpv6AttrList(), "1", "Ipv6", this.aFactoryMgr, coordinator);
            }
        } else if (isIpv6Used && ipv6Mo == null) {
            AttrListImpl attrList = new AttrListImpl();
            attrList.addElement("featureState", (Object)RbsConfigurationDefinitions.ACTIVATED);
            this.rbsConfigurationSiteBasicHelper.createMoWithLogging(ipSystemMo, attrList, "1", "Ipv6", this.aFactoryMgr, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "configureIpv6Data()");
    }

    private void configureIpv6InterfaceData(Ipv6InterfaceData[] ipv6InterfaceData, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureIpv6InterfaceData()");
        if (ipv6InterfaceData != null) {
            ManagedObject ipSystemMo = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1");
            for (int i = 0; i < ipv6InterfaceData.length; ++i) {
                if (ipv6InterfaceData == null || ipv6InterfaceData[i] == null) continue;
                this.rbsConfigurationSiteBasicHelper.createMoWithLogging(ipSystemMo, ipv6InterfaceData[i].createIpv6InterfaceAttrList(this.aMoRepository), ipv6InterfaceData[i].getIpv6InterfaceId(), "Ipv6Interface", this.aFactoryMgr, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "configureIpv6InterfaceData()");
    }

    private void configureAccessControlListData(AccessControlListData[] accessControlListData, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "configureAccessControlListData()");
        RbsConfigurationSiteBasicImpl.deleteInitialAcl(this.aMoRepository, coordinator);
        if (accessControlListData != null) {
            for (int i = 0; i < accessControlListData.length; ++i) {
                SiteBasicConfigurationHelper.createAccessControlList(this.rbsConfigurationSiteBasicHelper, accessControlListData[i], coordinator, this.aMoRepository, this.aFactoryMgr);
            }
        }
        logger.traceReturn(THIS_CLASS, "configureAccessControlListData()");
    }

    private void configureIpAccessHostEt(IpAccessHostEtData[] ipAccessHostEtData, Coordinator coordinator) throws MoHasChildrenException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "configureIpAccessHostEt()");
        if (ipAccessHostEtData != null) {
            for (int i = 0; i < ipAccessHostEtData.length; ++i) {
                boolean isVpnInterface;
                ManagedObject ipInterfaceRefMo;
                boolean okToCreateIpAccessHostEt = false;
                String ipAccessHostEtLdn = "ManagedElement=1,IpSystem=1,IpAccessHostEt=" + ipAccessHostEtData[i].getIpAccessHostEtId();
                okToCreateIpAccessHostEt = this.okToCreateIpAccessHostEt(ipAccessHostEtData[i], ipAccessHostEtLdn, ipInterfaceRefMo = this.aMoRepository.lookup(ipAccessHostEtData[i].getIpInterfaceMoRefLdn()), isVpnInterface = ipAccessHostEtData[i].getIpInterfaceMoRefLdn().toLowerCase().indexOf(VPN) != -1);
                if (!okToCreateIpAccessHostEt) continue;
                SiteBasicConfigurationHelper.createIpAccessHostEtAndChildren(this.rbsConfigurationSiteBasicHelper, ipAccessHostEtData[i], coordinator, this.aFactoryMgr, this.aMoRepository, this.rbsConfiguration);
            }
        }
        logger.traceReturn(THIS_CLASS, "configureIpAccessHostEt()");
    }

    private boolean okToCreateIpAccessHostEt(IpAccessHostEtData ipAccessHostEtData, String ipAccessHostEtLdn, ManagedObject ipInterfaceRefMo, boolean isVpnInterface) throws RbsConfigurationFailedException {
        boolean okToCreateIpAccessHostEt = false;
        if (null == ipInterfaceRefMo && !isVpnInterface) {
            throw new RbsConfigurationFailedException("Inconsistent configuration file", "IpAccessHostEt=" + ipAccessHostEtData.getIpAccessHostEtId() + " refers to unspecified IpInterface " + ipAccessHostEtData.getIpInterfaceMoRefLdn());
        }
        if (null != ipInterfaceRefMo && null == this.aMoRepository.lookup(ipAccessHostEtLdn)) {
            okToCreateIpAccessHostEt = true;
        }
        return okToCreateIpAccessHostEt;
    }

    private void configureENodeBFunction(ENodeBFunctionData eNodeBFunctionData, Coordinator coordinator) throws InactiveTransactionException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureENodeBFunction()");
        if (eNodeBFunctionData != null) {
            this.configureOssCorbaNameServer(eNodeBFunctionData.getRbsConfigurationData(), coordinator);
            this.configureWantedPosition(eNodeBFunctionData.getRbsConfigurationData(), coordinator);
        }
        logger.traceReturn(THIS_CLASS, "configureENodeBFunction()");
    }

    private void configureOssCorbaNameServer(RbsConfigurationData rbsConfigurationData, Coordinator coordinator) throws InactiveTransactionException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureOssCorbaNameServer()");
        if (rbsConfigurationData != null) {
            try {
                this.rbsConfiguration.setAttribute("ossCorbaNameServiceAddress", rbsConfigurationData.getOssCorbaNameServer());
                ConfigurationReportLoggerFactory.getLogger().logAttribute("RbsConfiguration", "ossCorbaNameServiceAddress", (Object)rbsConfigurationData.getOssCorbaNameServer());
            }
            catch (MoAccessException mae) {
                String faultMsg = "Could not set attribute: ossCorbaNameServiceAddress with value: " + rbsConfigurationData.getOssCorbaNameServer() + ". Please correct this via OSS later.";
                ProgressReportHandler.getInstance().updateProgressReportInformation(1700, 4, faultMsg, true);
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, SITE_BASIC_FAULT, faultMsg);
                coordinator.rollbackOnly();
            }
        }
        logger.traceReturn(THIS_CLASS, "configureOssCorbaNameServer()");
    }

    void configureWantedPosition(RbsConfigurationData rbsConfigurationData, Coordinator coordinator) throws InactiveTransactionException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureWantedPosition()");
        if (rbsConfigurationData != null) {
            WantedPositionData data = rbsConfigurationData.getWantedPositionData();
            try {
                this.rbsConfiguration.setWantedPosition(data.getLongitude(), data.getLatitude(), data.getAltitude(), data.getTolerance());
                ConfigurationReportLoggerFactory.getLogger().logAttribute("RbsConfiguration", "wantedPosition", (Object)rbsConfigurationData.getWantedPositionData().getWantedPositionDataStruct());
            }
            catch (Exception e) {
                if (e instanceof MoAccessException || e instanceof TransactionRolledBackException || e instanceof InactiveTransactionException) {
                    String faultMsg = "Could not set attribute: wantedPosition with value: (longitude: \"" + data.getLongitude() + "\", latitude: \"" + data.getLatitude() + "\", altitude: \"" + data.getAltitude() + "\", tolerance: " + data.getTolerance() + "). Please correct this via OSS later.";
                    ProgressReportHandler.getInstance().updateProgressReportInformation(1700, 4, faultMsg, true);
                    this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, SITE_BASIC_FAULT, faultMsg);
                    coordinator.rollbackOnly();
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        logger.traceReturn(THIS_CLASS, "configureWantedPosition()");
    }

    public void configureENodeBFunctionTimePhase(ENodeBFunctionData eNodeBFunctionData, Coordinator coordinator) throws InactiveTransactionException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureENodeBFunctionTimePhase()");
        ManagedObject eNodeBFunctionMo = this.aMoRepository.lookup("ManagedElement=1,ENodeBFunction=1");
        if (eNodeBFunctionData != null) {
            if (eNodeBFunctionData.getTimeAndPhaseSynchCritical() != null) {
                this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging(eNodeBFunctionMo, "timeAndPhaseSynchCritical", eNodeBFunctionData.getTimeAndPhaseSynchCritical(), coordinator);
            }
            if (eNodeBFunctionData.getTimeAndPhaseSynchAlignment() != null) {
                this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging(eNodeBFunctionMo, "timeAndPhaseSynchAlignment", eNodeBFunctionData.getTimeAndPhaseSynchAlignment(), coordinator);
            }
            if (eNodeBFunctionData.getTimePhaseMaxDeviation() != null) {
                this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging(eNodeBFunctionMo, "timePhaseMaxDeviation", eNodeBFunctionData.getTimePhaseMaxDeviation(), coordinator);
            }
            if (eNodeBFunctionData.getTimePhaseMaxDeviationCdma2000() != null) {
                this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging(eNodeBFunctionMo, "timePhaseMaxDeviationCdma2000", eNodeBFunctionData.getTimePhaseMaxDeviationCdma2000(), coordinator);
            }
            if (eNodeBFunctionData.getTimePhaseMaxDeviationMbms() != null) {
                this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging(eNodeBFunctionMo, "timePhaseMaxDeviationMbms", eNodeBFunctionData.getTimePhaseMaxDeviationMbms(), coordinator);
            }
            if (eNodeBFunctionData.getTimePhaseMaxDeviationOtdoa() != null) {
                this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging(eNodeBFunctionMo, "timePhaseMaxDeviationOtdoa", eNodeBFunctionData.getTimePhaseMaxDeviationOtdoa(), coordinator);
            }
            if (eNodeBFunctionData.getTimePhaseMaxDeviationSib16() != null) {
                this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging(eNodeBFunctionMo, "timePhaseMaxDeviationSib16", eNodeBFunctionData.getTimePhaseMaxDeviationSib16(), coordinator);
            }
            if (eNodeBFunctionData.getTimePhaseMaxDeviationTdd() != null) {
                this.rbsConfigurationSiteBasicHelper.setAttributeWithLogging(eNodeBFunctionMo, "timePhaseMaxDeviationTdd", eNodeBFunctionData.getTimePhaseMaxDeviationTdd(), coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "configureENodeBFunctionTimePhase()");
    }

    private static void deleteInitialAcl(MoRepositoryWrapper moRepositoryWrapper, Coordinator coordinator) {
        ManagedObject initialIpInterface = moRepositoryWrapper.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1");
        try {
            ManagedObject initialAccessControlList;
            if (initialIpInterface != null) {
                initialIpInterface.setAttribute("accessControlListRef", null, coordinator);
            }
            if ((initialAccessControlList = moRepositoryWrapper.lookup("ManagedElement=1,IpSystem=1,AccessControlList=initAcl")) == null) {
                logger.traceDebug(THIS_CLASS, "Initial AccessControlList MO did not exist.");
            } else {
                initialAccessControlList.delete(coordinator);
            }
        }
        catch (MoAccessException mae) {
            String msg = "Unable to delete the initial AccessControlList MO";
            ConfigurationReportLoggerFactory.getLogger().logFailure(SITE_BASIC_FAULT, "Unable to delete the initial AccessControlList MO");
            logger.traceDebug(THIS_CLASS, "Unable to delete the initial AccessControlList MO due to exception: " + ExceptionHelper.convertToString((Throwable)mae));
        }
    }

    public boolean loop(int noOfLoops) throws RbsConfigurationFailedException {
        this.helper.waitForRetry("Site Basic");
        if (this.getNewFile) {
            this.getSiteBasicFile();
        }
        return true;
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        if (RbsConfigurationHelper.existsAndNotEmpty(this.remoteFilePath)) {
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OAM_CONFIG_FILE_FAULT, "Site Basic failure!", "Existing Site Basic xml file is not correct. Getting new file. Original trace: " + (exception instanceof RbsConfigurationFailedException ? ((RbsConfigurationFailedException)((Object)exception)).getFormattedMessages() : exception.toString()));
            this.getNewFile = true;
            ProgressReportHandler.getInstance().updateProgressReportInformation(1600, 4, "Site Basic failure! Existing Site Basic xml file is not correct. Getting new file...", true);
        } else {
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OAM_CONFIG_FILE_FAULT, "Site Basic failure!", "Existing Site Basic xml file is not correct. Replace the file on node with a correct version. Original trace: " + (exception instanceof RbsConfigurationFailedException ? ((RbsConfigurationFailedException)((Object)exception)).getFormattedMessages() : exception.toString()));
            ProgressReportHandler.getInstance().updateProgressReportInformation(1600, 4, "Site Basic failure! Existing Site Basic xml file is not correct. Replace the file on node with a correct version! ", true);
        }
        this.restartNodeIfNeededAndNotNpc();
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OAM_CONFIG_FILE_FAULT, "Configuration failed!", "Transaction failure. Retrying. Exception: " + ExceptionHelper.convertToString((Throwable)exception));
        this.restartNodeIfNeededAndNotNpc();
    }

    private void restartNodeIfNeededAndNotNpc() {
        logger.traceEnter(THIS_CLASS, "restartNodeIfNeededAndNotNpc()");
        if (!this.isNpc && this.finishedParsing) {
            String failureSlogan = "Site Basic failure!";
            ResetHelper rh = new ResetHelper(this.rbsConfiguration);
            rh.resetSecurityActivationAndRestartNode("Site Basic failure!", this.esa, this.esaLock);
            try {
                Thread.sleep(MAX_WAITING_TIME);
            }
            catch (InterruptedException ie) {
                logger.traceAbnormal(THIS_CLASS, "Interrupted while sleeping.");
            }
            logger.traceReturn(THIS_CLASS, "restartNodeIfNeededAndNotNpc()");
        }
    }

    private void getSiteBasicFile() throws RbsConfigurationFailedException {
        ((RbsConfigurationSmrsHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationSmrsHelper.class)).getFileFromFtp(1600, this.remoteFilePath, this.helper.getLocalPath() + "SiteBasic.xml");
    }

    static {
        int waitingTime = 10000;
        if ("true".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            waitingTime = 500;
        }
        MAX_WAITING_TIME = waitingTime;
        THIS_CLASS = RbsConfigurationSiteBasicImpl.class;
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }
}

