/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.DtdSiteBasicDataConverter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.SiteBasicParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.SiteBasicData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.omf.mao.xml.Parser;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class RbsConfigurationSiteBasicParser {
    private static final Class THIS_CLASS = RbsConfigurationSiteBasicParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected String schemaPath = "rbsManagerMetaData/rbsConfiguration/";
    private final MoRepositoryWrapper aMoRepository;

    public RbsConfigurationSiteBasicParser(GenericMaoContext inGenericMaoContext) {
        this.aMoRepository = inGenericMaoContext.getMoRepositoryWrapper();
    }

    public SiteBasicData parseSiteBasicFile(String siteBasicFilePath, boolean validateXml) throws IOException, NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "parseSiteBasicFile() - siteBasicFilePath = " + siteBasicFilePath + ", validate = " + validateXml);
        SiteBasicData siteBasicData = null;
        Parser parser = ParserHelper.createParser(siteBasicFilePath, validateXml, this.schemaPath);
        List xmlList = parser.getXMLelements();
        if (xmlList == null) {
            throw new IOException("Could not parse site basic xml file, invalid XML.");
        }
        Iterator xmlIter = xmlList.iterator();
        while (xmlIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)xmlIter.next();
            if (!"OamAccessConfiguration".equalsIgnoreCase(xmlChild.getType())) continue;
            siteBasicData = DtdSiteBasicDataConverter.convertOamAccessConfiguration(xmlChild, this.aMoRepository);
            break;
        }
        if (siteBasicData == null) {
            siteBasicData = SiteBasicParserHelper.createSiteBasicDataStructure(xmlList);
        }
        logger.traceReturn(THIS_CLASS, "parseSiteBasicFile()");
        return siteBasicData;
    }
}

