/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.helpers.AttributesImpl;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AccessControlListData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AclEntriesData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AllowedTransformsDataIkePeer;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AllowedTransformsDataIpSecTunnel;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.DnsResolverData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.ENodeBFunctionData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.FormatData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.GpsOutSyncLinkData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.GpsSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.HptsiSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IkePeerData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpAccessHostEtData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpHostLinkData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpInterfaceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpRoutingTableData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSecData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSecTunnelData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSystemData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.Ipv6Data;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.Ipv6InterfaceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.ManagedElementDataData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.NodeGroupSyncMemberData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.OaMAlternativeAccessSourceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.PacketFrequencySyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.PacketTimeSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.RbsConfigurationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.SiteBasicData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.StaticRoutesData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.SyncRiPort;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.SynchronizationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.TimingUnitData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.TrafficSelectorIpAddressRange;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.TuSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.VpnInterfaceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.WantedPositionData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class SiteBasicParserHelper {
    private static final Class THIS_CLASS = SiteBasicParserHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String[] syncPriorityAttributes = new String[]{"syncPriorityRef1", "syncPriorityRef2", "syncPriorityRef3", "syncPriorityRef4", "syncPriorityRef5", "syncPriorityRef6", "syncPriorityRef7", "syncPriorityRef8"};
    private static final String[] adminQualityAttributes = new String[]{"adminQuality1", "adminQuality2", "adminQuality3", "adminQuality4", "adminQuality5", "adminQuality6", "adminQuality7", "adminQuality8"};
    private static final String[] useReceiverQlAttributes = new String[]{"useReceivedQl1", "useReceivedQl2", "useReceivedQl3", "useReceivedQl4", "useReceivedQl5", "useReceivedQl6", "useReceivedQl7", "useReceivedQl8"};

    private SiteBasicParserHelper() {
    }

    protected static SiteBasicData createSiteBasicDataStructure(List xmlList) throws IOException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createSiteBasicDataStructure()");
        Map xmlElementMap = ParserHelper.createXmlTypeElementMap(xmlList);
        Iterator xmlIter = xmlList.iterator();
        IpData ipData = null;
        FormatData formatData = SiteBasicParserHelper.createFormatData(xmlElementMap);
        ENodeBFunctionData eNodeBFunctionData = SiteBasicParserHelper.createENodeBFunctionData(xmlElementMap);
        ManagedElementDataData managedElementDataData = SiteBasicParserHelper.createManagedElementDataData(xmlElementMap);
        IpSystemData ipSystemData = SiteBasicParserHelper.createIpSystemData(xmlElementMap);
        List ipInterfaceDataList = SiteBasicParserHelper.createIpInterfaceData(xmlElementMap);
        TimingUnitData timingUnitData = SiteBasicParserHelper.createTimingUnitData(xmlElementMap);
        List tuSyncRefDataList = SiteBasicParserHelper.createTuSyncRefData(xmlElementMap);
        List gpsSyncRefDataList = SiteBasicParserHelper.createGpsSyncRefData(xmlElementMap);
        List gpsOutSyncLinkDataList = SiteBasicParserHelper.createGpsOutSyncLinkData(xmlElementMap);
        List hptsiSyncRefDataList = SiteBasicParserHelper.createHptsiSyncRefData(xmlElementMap);
        SynchronizationData synchronizationData = SiteBasicParserHelper.createSynchronizationData(xmlElementMap);
        while (xmlIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)xmlIter.next();
            if (!"Ip".equalsIgnoreCase(xmlChild.getType())) continue;
            ipData = SiteBasicParserHelper.createIpData(xmlChild);
        }
        IpInterfaceData[] ipInterfaceData = new IpInterfaceData[ipInterfaceDataList.size()];
        ipInterfaceDataList.toArray(ipInterfaceData);
        TuSyncRefData[] tuSyncRefData = new TuSyncRefData[tuSyncRefDataList.size()];
        tuSyncRefDataList.toArray(tuSyncRefData);
        GpsSyncRefData[] gpsSyncRefData = new GpsSyncRefData[gpsSyncRefDataList.size()];
        gpsSyncRefDataList.toArray(gpsSyncRefData);
        GpsOutSyncLinkData[] gpsOutSyncLinkData = new GpsOutSyncLinkData[gpsOutSyncLinkDataList.size()];
        gpsOutSyncLinkDataList.toArray(gpsOutSyncLinkData);
        HptsiSyncRefData[] hptsiSyncRefData = new HptsiSyncRefData[hptsiSyncRefDataList.size()];
        hptsiSyncRefDataList.toArray(hptsiSyncRefData);
        SiteBasicData siteBasicData = new SiteBasicData(formatData, ipData, eNodeBFunctionData, managedElementDataData, ipSystemData, ipInterfaceData, timingUnitData, tuSyncRefData, gpsSyncRefData, gpsOutSyncLinkData, hptsiSyncRefData, synchronizationData);
        logger.traceReturn(THIS_CLASS, "createSiteBasicDataStructure()");
        return siteBasicData;
    }

    private static TimingUnitData createTimingUnitData(Map xmlElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createTimingUnitData()");
        TimingUnitData timingUnitData = null;
        String xmlTag = "TimingUnit".toLowerCase(Locale.getDefault());
        if (xmlElementMap.containsKey(xmlTag)) {
            XMLElement xmlElement = (XMLElement)((List)xmlElementMap.get(xmlTag)).get(0);
            Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
            String outhptsienable = "hptsiOutEnabled".toLowerCase(Locale.getDefault());
            String outgpsenable = "gpsOutEnabled".toLowerCase(Locale.getDefault());
            if (attrNameValueMap.containsKey(outhptsienable)) {
                timingUnitData = new TimingUnitData(outhptsienable, (String)attrNameValueMap.get(outhptsienable));
            } else if (attrNameValueMap.containsKey(outgpsenable)) {
                timingUnitData = new TimingUnitData(outgpsenable, (String)attrNameValueMap.get("gpsOutEnabled".toLowerCase(Locale.getDefault())));
            }
        } else {
            timingUnitData = new TimingUnitData("GPS or HPTSI out not specified", "disabled set by default");
        }
        logger.traceReturn(THIS_CLASS, "createTimingUnitData()");
        return timingUnitData;
    }

    private static IpData createIpData(XMLElement xmlElement) throws IOException {
        OaMAlternativeAccessSourceData[] oaMAlternativeAccessSourceData;
        logger.traceEnter(THIS_CLASS, "createIpData()");
        List xmlChildren = xmlElement.getChildren();
        Iterator xmlChildIter = xmlChildren.iterator();
        IpRoutingTableData ipRoutingTableData = null;
        IpHostLinkData ipHostLinkData = null;
        ArrayList<OaMAlternativeAccessSourceData> oaMAlternativeAccessSourceDataList = new ArrayList<OaMAlternativeAccessSourceData>();
        while (xmlChildIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)xmlChildIter.next();
            if ("IpRoutingTable".equalsIgnoreCase(xmlChild.getType())) {
                ipRoutingTableData = SiteBasicParserHelper.createIpRoutingTableData(xmlChild);
            }
            if ("IpHostLink".equalsIgnoreCase(xmlChild.getType())) {
                ipHostLinkData = SiteBasicParserHelper.createIpHostLinkData(xmlChild);
            }
            if (!"oaMAlternativeAccessSource".equalsIgnoreCase(xmlChild.getType())) continue;
            oaMAlternativeAccessSourceDataList.add(SiteBasicParserHelper.createOaMAlternativeAccessSourceData(xmlChild));
        }
        if (oaMAlternativeAccessSourceDataList.isEmpty()) {
            oaMAlternativeAccessSourceData = null;
        } else {
            oaMAlternativeAccessSourceData = new OaMAlternativeAccessSourceData[oaMAlternativeAccessSourceDataList.size()];
            oaMAlternativeAccessSourceDataList.toArray(oaMAlternativeAccessSourceData);
        }
        AttributesImpl attributes = xmlElement.getAttributes();
        String dnsServer1 = SiteBasicParserHelper.getAttribute("dnsServer1", attributes);
        String dnsServer2 = SiteBasicParserHelper.getAttribute("dnsServer2", attributes);
        String dnsServer3 = SiteBasicParserHelper.getAttribute("dnsServer3", attributes);
        String dscp = SiteBasicParserHelper.getAttribute("dscp", attributes);
        String oaMAlternativeAccess = SiteBasicParserHelper.getAttribute("oaMAlternativeAccess", attributes);
        IpData ipData = new IpData(dnsServer1, dnsServer2, dnsServer3, dscp, ipRoutingTableData, oaMAlternativeAccess, ipHostLinkData, oaMAlternativeAccessSourceData);
        logger.traceReturn(THIS_CLASS, "createIpData()");
        return ipData;
    }

    private static OaMAlternativeAccessSourceData createOaMAlternativeAccessSourceData(XMLElement xmlElement) {
        logger.traceEnter(THIS_CLASS, "createOaMAlternativeAccessSourceData()");
        AttributesImpl attributes = xmlElement.getAttributes();
        String ipAddress = SiteBasicParserHelper.getAttribute("ipAddress", attributes);
        String networkMask = SiteBasicParserHelper.getAttribute("networkMask", attributes);
        OaMAlternativeAccessSourceData oaMAlternativeAccessSource = new OaMAlternativeAccessSourceData(ipAddress, networkMask);
        logger.traceReturn(THIS_CLASS, "createOaMAlternativeAccessSourceData()");
        return oaMAlternativeAccessSource;
    }

    private static IpHostLinkData createIpHostLinkData(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "createIpHostLinkData()");
        AttributesImpl attributes = xmlElement.getAttributes();
        String ipHostLinkId = SiteBasicParserHelper.getAttribute("IpHostLinkId", attributes);
        String ipAddress = SiteBasicParserHelper.getAttribute("ipAddress", attributes);
        String ipInterfaceMoRef = SiteBasicParserHelper.getAttribute("ipInterfaceMoRef", attributes);
        String userLabel = SiteBasicParserHelper.getAttribute("userLabel", attributes);
        IpHostLinkData ipHostLink = new IpHostLinkData(ipHostLinkId, ipAddress, ipInterfaceMoRef, userLabel);
        logger.traceReturn(THIS_CLASS, "createIpHostLinkData()");
        return ipHostLink;
    }

    private static IpRoutingTableData createIpRoutingTableData(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "createIpRoutingTableData()");
        AttributesImpl attributes = xmlElement.getAttributes();
        String ipRoutingTableId = null;
        String userLabel = null;
        StaticRoutesData[] staticRoutesData = null;
        for (int index = 0; index < attributes.getLength(); ++index) {
            if ("IpRoutingTableId".equalsIgnoreCase(attributes.getQName(index))) {
                ipRoutingTableId = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if (!"userLabel".equalsIgnoreCase(attributes.getQName(index))) continue;
            userLabel = StringHelper.emptyStringToNull((String)attributes.getValue(index));
        }
        staticRoutesData = SiteBasicParserHelper.createStaticRoutesData(xmlElement);
        IpRoutingTableData ipRoutingTableData = new IpRoutingTableData(ipRoutingTableId, staticRoutesData, userLabel);
        logger.traceReturn(THIS_CLASS, "createIpRoutingTableData()");
        return ipRoutingTableData;
    }

    private static StaticRoutesData[] createStaticRoutesData(XMLElement xmlElement) throws IOException {
        StaticRoutesData[] staticRoutesData;
        logger.traceEnter(THIS_CLASS, "createStaticRoutesData()");
        List xmlChildren = xmlElement.getChildren();
        Iterator xmlChildIter = xmlChildren.iterator();
        ArrayList<StaticRoutesData> staticRoutesDataList = new ArrayList<StaticRoutesData>();
        while (xmlChildIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)xmlChildIter.next();
            if (!"staticRoutes".equalsIgnoreCase(xmlChild.getType())) continue;
            staticRoutesDataList.add(SiteBasicParserHelper.createStaticRoute(xmlChild));
        }
        if (staticRoutesDataList.isEmpty()) {
            staticRoutesData = null;
        } else {
            staticRoutesData = new StaticRoutesData[staticRoutesDataList.size()];
            staticRoutesDataList.toArray(staticRoutesData);
        }
        logger.traceReturn(THIS_CLASS, "createStaticRoutesData()");
        return staticRoutesData;
    }

    private static StaticRoutesData createStaticRoute(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "createStaticRoute()");
        AttributesImpl attributes = xmlElement.getAttributes();
        String indexOfStaticRoute = SiteBasicParserHelper.getAttribute("indexOfStaticRoute", attributes);
        String ipAddress = SiteBasicParserHelper.getAttribute("ipAddress", attributes);
        String networkMask = SiteBasicParserHelper.getAttribute("networkMask", attributes);
        String nextHopIpAddr = SiteBasicParserHelper.getAttribute("nextHopIpAddr", attributes);
        String redistribute = SiteBasicParserHelper.getAttribute("redistribute", attributes);
        String routeMetric = SiteBasicParserHelper.getAttribute("routeMetric", attributes);
        StaticRoutesData staticRoute = new StaticRoutesData(indexOfStaticRoute, ipAddress, networkMask, nextHopIpAddr, redistribute, routeMetric);
        logger.traceReturn(THIS_CLASS, "createStaticRoute()");
        return staticRoute;
    }

    private static String getAttribute(String attributeName, AttributesImpl attributes) {
        String attributeValue = null;
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (!attributeName.equalsIgnoreCase(attributes.getQName(index))) continue;
            attributeValue = StringHelper.emptyStringToNull((String)attributes.getValue(index));
        }
        return attributeValue;
    }

    private static List createIpInterfaceData(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createIpInterfaceData()");
        ArrayList<IpInterfaceData> ipInterfaceDataList = new ArrayList<IpInterfaceData>();
        String xmlTag = "IpInterface".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(((XMLElement)iter.next()).getAttributes());
                IpInterfaceData ipInterfaceData = new IpInterfaceData((String)attrNameValueMap.get("accessControlListRef".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("IpInterfaceId".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("networkPrefixLength".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("defaultRouter0".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("vid".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ipInterfaceSlot".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("configurationMode".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("userLabel".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("dhcpClientIdentifierType".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("dhcpClientIdentifier".toLowerCase(Locale.getDefault())));
                ipInterfaceDataList.add(ipInterfaceData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createIpInterfaceData()");
        return ipInterfaceDataList;
    }

    private static SynchronizationData createSynchronizationData(Map xmlTypeElementMap) throws RbsConfigurationFailedException, IOException {
        logger.traceEnter(THIS_CLASS, "createSynchronizationData()");
        SynchronizationData synchronizationData = null;
        PacketFrequencySyncRefData[] packetFrequencySyncRefData = SiteBasicParserHelper.createPacketFrequencySyncRefData(xmlTypeElementMap);
        PacketTimeSyncRefData[] packetTimeSyncRefData = SiteBasicParserHelper.createPacketTimeSyncRefData(xmlTypeElementMap);
        String xmlTag = "Synchronization".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            XMLElement xmlElement = (XMLElement)((List)xmlTypeElementMap.get(xmlTag)).get(0);
            List xmlChildren = xmlElement.getChildren();
            Map childElementMap = ParserHelper.createXmlTypeElementMap(xmlChildren);
            NodeGroupSyncMemberData nodeGroupSyncMemberData = SiteBasicParserHelper.createNodeGroupSyncMemberData(childElementMap);
            Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
            HashMap syncPriorityRefMap = new HashMap();
            HashMap adminQualityMap = new HashMap();
            HashMap useReceivedQlMap = new HashMap();
            String telecomStandard = (String)attrNameValueMap.get("telecomStandard".toLowerCase(Locale.getDefault()));
            for (int i = 0; i < syncPriorityAttributes.length; ++i) {
                String syncPriority = syncPriorityAttributes[i].toLowerCase(Locale.getDefault());
                String adminQuality = adminQualityAttributes[i].toLowerCase(Locale.getDefault());
                String useReceiverQl = useReceiverQlAttributes[i].toLowerCase(Locale.getDefault());
                if (!attrNameValueMap.containsKey(syncPriority)) continue;
                syncPriorityRefMap.put(new Integer(i + 1), attrNameValueMap.get(syncPriority));
                if (attrNameValueMap.containsKey(adminQuality)) {
                    adminQualityMap.put(new Integer(i + 1), attrNameValueMap.get(adminQuality));
                } else if (telecomStandard == null) {
                    adminQualityMap.put(new Integer(i + 1), "QL_SSU_A");
                } else if (telecomStandard.equals("OPTION_II")) {
                    adminQualityMap.put(new Integer(i + 1), "QL_ST2");
                } else if (telecomStandard.equals("OPTION_III")) {
                    adminQualityMap.put(new Integer(i + 1), "QL_UNK");
                } else {
                    adminQualityMap.put(new Integer(i + 1), "QL_SSU_A");
                }
                if (attrNameValueMap.containsKey(useReceiverQl)) {
                    useReceivedQlMap.put(new Integer(i + 1), attrNameValueMap.get(useReceiverQl));
                    continue;
                }
                useReceivedQlMap.put(new Integer(i + 1), "FALSE");
            }
            String minQualityLevel = (String)attrNameValueMap.get("minQualityLevel".toLowerCase(Locale.getDefault()));
            String selectionProcessMode = (String)attrNameValueMap.get("selectionProcessMode".toLowerCase(Locale.getDefault()));
            synchronizationData = new SynchronizationData(syncPriorityRefMap, (String)attrNameValueMap.get("userLabel".toLowerCase(Locale.getDefault())), packetFrequencySyncRefData, packetTimeSyncRefData, nodeGroupSyncMemberData, telecomStandard, minQualityLevel, selectionProcessMode, adminQualityMap, useReceivedQlMap);
        }
        logger.traceReturn(THIS_CLASS, "createSynchronizationData()");
        return synchronizationData;
    }

    private static List createTuSyncRefData(Map xmlTypeElementMap) {
        logger.traceEnter(THIS_CLASS, "createTuSyncRefData()");
        ArrayList<TuSyncRefData> tuSyncRefDataList = new ArrayList<TuSyncRefData>();
        String xmlTag = "TuSyncRef".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(((XMLElement)iter.next()).getAttributes());
                TuSyncRefData tuSyncRefData = new TuSyncRefData((String)attrNameValueMap.get("TuSyncRefId".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("tuSyncRefSlot".toLowerCase(Locale.getDefault())));
                tuSyncRefDataList.add(tuSyncRefData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createTuSyncRefData()");
        return tuSyncRefDataList;
    }

    public static WantedPositionData createWantedPositionData(Map xmlTypeElementMap) {
        logger.traceEnter(THIS_CLASS, "createWantedPositionData()");
        Integer tolerance = new Integer(50);
        WantedPositionData wantedPositionData = new WantedPositionData("-", "-", "-", tolerance);
        String xmlTag = "wantedPosition".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            AttributesImpl attributes = ((XMLElement)((List)xmlTypeElementMap.get(xmlTag)).get(0)).getAttributes();
            Map attrNameValueMap = ParserHelper.createAttrNameValueMap(attributes);
            if (attrNameValueMap.containsKey("tolerance")) {
                tolerance = new Integer(Integer.parseInt(attrNameValueMap.get("tolerance").toString()));
            }
            wantedPositionData = new WantedPositionData((String)attrNameValueMap.get("longitude".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("latitude".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("altitude".toLowerCase(Locale.getDefault())), tolerance);
        }
        logger.traceReturn(THIS_CLASS, "createWantedPositionData()");
        return wantedPositionData;
    }

    private static List createGpsSyncRefData(Map xmlTypeElementMap) {
        logger.traceEnter(THIS_CLASS, "createGpsSyncRefData()");
        ArrayList<GpsSyncRefData> gpsSyncRefDataList = new ArrayList<GpsSyncRefData>();
        String xmlTag = "GpsSyncRef".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(((XMLElement)iter.next()).getAttributes());
                GpsSyncRefData gpsSyncRefData = new GpsSyncRefData((String)attrNameValueMap.get("GpsSyncRefId".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("gpsSyncRefSlot".toLowerCase(Locale.getDefault())));
                gpsSyncRefDataList.add(gpsSyncRefData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createGpsSyncRefData()");
        return gpsSyncRefDataList;
    }

    private static List createGpsOutSyncLinkData(Map xmlTypeElementMap) {
        logger.traceEnter(THIS_CLASS, "createGpsOutSyncLinkData()");
        ArrayList<GpsOutSyncLinkData> gpsOutSyncLinkDataList = new ArrayList<GpsOutSyncLinkData>();
        String xmlTag = "GpsOutSyncLink".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(((XMLElement)iter.next()).getAttributes());
                GpsOutSyncLinkData gpsOutSyncLinkData = new GpsOutSyncLinkData((String)attrNameValueMap.get("GpsOutSyncLinkId".toLowerCase(Locale.getDefault())));
                gpsOutSyncLinkDataList.add(gpsOutSyncLinkData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createGpsOutSyncLinkData()");
        return gpsOutSyncLinkDataList;
    }

    private static NodeGroupSyncMemberData createNodeGroupSyncMemberData(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createNodeGroupSyncMemberData()");
        NodeGroupSyncMemberData nodeGroupSyncMemberData = null;
        String xmlTag = "NodeGroupSyncMember".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            XMLElement xmlElement = (XMLElement)((List)xmlTypeElementMap.get(xmlTag)).get(0);
            Map childElementMap = ParserHelper.createXmlTypeElementMap(xmlElement.getChildren());
            List syncRiPortList = SiteBasicParserHelper.createSyncRiPortCandidateData(childElementMap);
            SyncRiPort[] syncRiPortArray = null;
            if (!syncRiPortList.isEmpty()) {
                syncRiPortArray = new SyncRiPort[syncRiPortList.size()];
                syncRiPortList.toArray(syncRiPortArray);
            }
            Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
            String nodeGroupSyncMemberId = (String)attrNameValueMap.get("NodeGroupSyncMemberId".toLowerCase(Locale.getDefault()));
            String syncNodePrio = (String)attrNameValueMap.get("syncNodePriority".toLowerCase(Locale.getDefault()));
            nodeGroupSyncMemberData = new NodeGroupSyncMemberData(nodeGroupSyncMemberId, syncNodePrio, syncRiPortArray);
        }
        logger.traceReturn(THIS_CLASS, "createNodeGroupSyncMemberData()");
        return nodeGroupSyncMemberData;
    }

    private static List createSyncRiPortCandidateData(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createSyncRiPortCandidateData()");
        ArrayList<SyncRiPort> syncRiPortCandidateList = new ArrayList<SyncRiPort>();
        String xmlTag = "syncRiPortCandidate".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                XMLElement xmlElement = (XMLElement)iter.next();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                SyncRiPort syncRiPort = new SyncRiPort((String)attrNameValueMap.get("duNumber".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("duRiPort".toLowerCase(Locale.getDefault())));
                syncRiPortCandidateList.add(syncRiPort);
            }
        }
        logger.traceReturn(THIS_CLASS, "createSyncRiPortCandidateData()");
        return syncRiPortCandidateList;
    }

    private static List createHptsiSyncRefData(Map xmlTypeElementMap) {
        logger.traceEnter(THIS_CLASS, "createHptsiSyncRefData()");
        ArrayList<HptsiSyncRefData> hptsiSyncRefDataList = new ArrayList<HptsiSyncRefData>();
        String xmlTag = "HptsiSyncRef".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(((XMLElement)iter.next()).getAttributes());
                HptsiSyncRefData htpsiSyncRefData = new HptsiSyncRefData((String)attrNameValueMap.get("HptsiSyncRefId".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("hptsiSyncRefSlot".toLowerCase(Locale.getDefault())));
                hptsiSyncRefDataList.add(htpsiSyncRefData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createHptsiSyncRefData()");
        return hptsiSyncRefDataList;
    }

    private static IpSystemData createIpSystemData(Map xmlTypeElementMap) throws IOException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createIpSystemData()");
        IpSystemData ipSystemData = null;
        String xmlTag = "IpSystem".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            XMLElement xmlElement = (XMLElement)((List)xmlTypeElementMap.get(xmlTag)).get(0);
            List xmlChildren = xmlElement.getChildren();
            Map childElementMap = ParserHelper.createXmlTypeElementMap(xmlChildren);
            List ipAccessHostEtDataList = SiteBasicParserHelper.createIpAccessHostEtData(childElementMap);
            List vpnInterfaceDataList = SiteBasicParserHelper.createVpnInterfaceData(childElementMap);
            IpSecData ipSecData = SiteBasicParserHelper.createIpSecData(childElementMap);
            List accessControlListDataList = SiteBasicParserHelper.createAccessControlListData(childElementMap);
            List ipv6DataList = SiteBasicParserHelper.createIpv6ListData(childElementMap);
            List ipv6InterfaceDataList = SiteBasicParserHelper.createIpv6InterfaceListData(childElementMap);
            List dnsResolverDataList = SiteBasicParserHelper.createDnsResolverData(childElementMap);
            IpAccessHostEtData[] ipAccessHostEtData = null;
            if (!ipAccessHostEtDataList.isEmpty()) {
                ipAccessHostEtData = new IpAccessHostEtData[ipAccessHostEtDataList.size()];
                ipAccessHostEtDataList.toArray(ipAccessHostEtData);
            }
            VpnInterfaceData[] vpnInterfaceData = null;
            if (!vpnInterfaceDataList.isEmpty()) {
                vpnInterfaceData = new VpnInterfaceData[vpnInterfaceDataList.size()];
                vpnInterfaceDataList.toArray(vpnInterfaceData);
            }
            AccessControlListData[] accessControlListData = null;
            if (!accessControlListDataList.isEmpty()) {
                accessControlListData = new AccessControlListData[accessControlListDataList.size()];
                accessControlListDataList.toArray(accessControlListData);
            }
            Ipv6Data[] ipv6Data = null;
            if (!ipv6DataList.isEmpty()) {
                ipv6Data = new Ipv6Data[ipv6DataList.size()];
                ipv6DataList.toArray(ipv6Data);
            }
            Ipv6InterfaceData[] ipv6InterfaceData = null;
            if (!ipv6InterfaceDataList.isEmpty()) {
                ipv6InterfaceData = new Ipv6InterfaceData[ipv6InterfaceDataList.size()];
                ipv6InterfaceDataList.toArray(ipv6InterfaceData);
            }
            DnsResolverData[] dnsResolverData = null;
            if (!dnsResolverDataList.isEmpty()) {
                dnsResolverData = new DnsResolverData[dnsResolverDataList.size()];
                dnsResolverDataList.toArray(dnsResolverData);
            }
            ipSystemData = new IpSystemData(ipAccessHostEtData, vpnInterfaceData, ipSecData, accessControlListData, ipv6Data, ipv6InterfaceData, dnsResolverData);
        }
        logger.traceReturn(THIS_CLASS, "createIpSystemData()");
        return ipSystemData;
    }

    private static List createIpv6ListData(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createIpv6ListData()");
        ArrayList<Ipv6Data> ipv6ListData = new ArrayList<Ipv6Data>();
        String xmlTag = "Ipv6".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                XMLElement xmlElement = (XMLElement)iter.next();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                Ipv6Data ipv6Data = new Ipv6Data((String)attrNameValueMap.get("featureState".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("userLabel".toLowerCase(Locale.getDefault())));
                ipv6ListData.add(ipv6Data);
            }
        }
        logger.traceReturn(THIS_CLASS, "createIpv6ListData()");
        return ipv6ListData;
    }

    private static List createIpv6InterfaceListData(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createIpv6InterfaceListData()");
        ArrayList<Ipv6InterfaceData> ipv6InterfaceListData = new ArrayList<Ipv6InterfaceData>();
        String xmlTag = "Ipv6Interface".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                XMLElement xmlElement = (XMLElement)iter.next();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                Ipv6InterfaceData ipv6InterfaceData = new Ipv6InterfaceData((String)attrNameValueMap.get("accessControlListRef".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ethernetRef".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("Ipv6InterfaceId".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("mtu".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("vid".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("vLan".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("userLabel".toLowerCase(Locale.getDefault())));
                ipv6InterfaceListData.add(ipv6InterfaceData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createIpv6InterfaceListData()");
        return ipv6InterfaceListData;
    }

    private static List createAccessControlListData(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createAccessControlListData()");
        ArrayList<AccessControlListData> accessControlListDataList = new ArrayList<AccessControlListData>();
        String xmlTag = "AccessControlList".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                XMLElement xmlElement = (XMLElement)iter.next();
                List xmlChildren = xmlElement.getChildren();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                Map childElementMap = ParserHelper.createXmlTypeElementMap(xmlChildren);
                List aclEntriesDataList = SiteBasicParserHelper.createAclEntriesData(childElementMap);
                AclEntriesData[] aclEntriesData = new AclEntriesData[aclEntriesDataList.size()];
                aclEntriesDataList.toArray(aclEntriesData);
                AccessControlListData accessControlListData = new AccessControlListData((String)attrNameValueMap.get("AccessControlListId".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("userLabel".toLowerCase(Locale.getDefault())), aclEntriesData);
                accessControlListDataList.add(accessControlListData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createAccessControlListData()");
        return accessControlListDataList;
    }

    private static List createAclEntriesData(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createAclEntriesData()");
        ArrayList<AclEntriesData> aclEntriesDataList = new ArrayList<AclEntriesData>();
        String xmlTag = "aclEntries".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                XMLElement xmlElement = (XMLElement)iter.next();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                AclEntriesData aclEntriesData = new AclEntriesData((String)attrNameValueMap.get("aclAction".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("icmpType".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("aclPriority".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("localIpAddress".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("localIpAddressMask".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("localPort".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("localPortFiltering".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("protocol".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("remoteIpAddress".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("remoteIpAddressMask".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("remotePort".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("remotePortFiltering".toLowerCase(Locale.getDefault())));
                aclEntriesDataList.add(aclEntriesData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createAclEntriesData()");
        return aclEntriesDataList;
    }

    private static IpSecData createIpSecData(Map xmlTypeElementMap) throws IOException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createIpSecData()");
        IpSecData ipSecData = null;
        String xmlTag = "IpSec".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            XMLElement xmlElement = (XMLElement)((List)xmlTypeElementMap.get(xmlTag)).get(0);
            List xmlChildren = xmlElement.getChildren();
            Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
            Map childElementMap = ParserHelper.createXmlTypeElementMap(xmlChildren);
            List ikePeerDataList = SiteBasicParserHelper.createIkePeerData(childElementMap);
            List ipSecTunnelDataList = SiteBasicParserHelper.createIpSecTunnelData(childElementMap);
            IkePeerData[] ikePeerData = null;
            if (!ikePeerDataList.isEmpty()) {
                ikePeerData = new IkePeerData[ikePeerDataList.size()];
                ikePeerDataList.toArray(ikePeerData);
            }
            IpSecTunnelData[] ipSecTunnelData = null;
            if (!ipSecTunnelDataList.isEmpty()) {
                ipSecTunnelData = new IpSecTunnelData[ipSecTunnelDataList.size()];
                ipSecTunnelDataList.toArray(ipSecTunnelData);
            }
            ipSecData = new IpSecData((String)attrNameValueMap.get("certExpirWarnTime".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("featureState".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("userLabel".toLowerCase(Locale.getDefault())), ikePeerData, ipSecTunnelData);
        }
        logger.traceReturn(THIS_CLASS, "createIpSecData()");
        return ipSecData;
    }

    private static List createIpSecTunnelData(Map xmlTypeElementMap) throws IOException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createIpSecTunnelData()");
        ArrayList<IpSecTunnelData> ipSecTunnelDataList = new ArrayList<IpSecTunnelData>();
        String xmlTag = "IpSecTunnel".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                XMLElement xmlElement = (XMLElement)iter.next();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                Map childElementMap = ParserHelper.createXmlTypeElementMap(xmlElement.getChildren());
                List allowedTransformsDataIpSecTunnelList = SiteBasicParserHelper.createAllowedTransformsDataIpSecTunnel(childElementMap);
                ArrayList<TrafficSelectorIpAddressRange> tsLocalIpAddressRangesDataList = new ArrayList<TrafficSelectorIpAddressRange>();
                String inIpAddress = (String)attrNameValueMap.get("tsLocalIpAddress".toLowerCase(Locale.getDefault()));
                String inMask = (String)attrNameValueMap.get("tsLocalIpAddressMask".toLowerCase(Locale.getDefault()));
                tsLocalIpAddressRangesDataList.add(new TrafficSelectorIpAddressRange(inIpAddress, inMask));
                List tsRemoteIpAddressRangesDataList = SiteBasicParserHelper.createTsRemoteIpAddressRanges(childElementMap);
                AllowedTransformsDataIpSecTunnel[] allowedTransformsDataIpSecTunnel = null;
                if (!allowedTransformsDataIpSecTunnelList.isEmpty()) {
                    allowedTransformsDataIpSecTunnel = new AllowedTransformsDataIpSecTunnel[allowedTransformsDataIpSecTunnelList.size()];
                    allowedTransformsDataIpSecTunnelList.toArray(allowedTransformsDataIpSecTunnel);
                }
                IpSecTunnelData ipSecTunnelData = new IpSecTunnelData((String)attrNameValueMap.get("ikePeerRef".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("IpSecTunnelId".toLowerCase(Locale.getDefault())), tsLocalIpAddressRangesDataList, (String)attrNameValueMap.get("tsProtocols".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("priority".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("userLabel".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("vpnInterfaceRef".toLowerCase(Locale.getDefault())), allowedTransformsDataIpSecTunnel, tsRemoteIpAddressRangesDataList);
                ipSecTunnelDataList.add(ipSecTunnelData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createIpSecTunnelData()");
        return ipSecTunnelDataList;
    }

    private static List createTsRemoteIpAddressRanges(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createTsRemoteIpAddressRanges()");
        ArrayList<TrafficSelectorIpAddressRange> tsRemoteIpAddressRangesDataList = new ArrayList<TrafficSelectorIpAddressRange>();
        String xmlTag = "tsRemoteIpAddressRanges".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                XMLElement xmlElement = (XMLElement)iter.next();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                TrafficSelectorIpAddressRange tsRemoteIpAddressRangesData = new TrafficSelectorIpAddressRange((String)attrNameValueMap.get("ipAddress".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("mask".toLowerCase(Locale.getDefault())));
                tsRemoteIpAddressRangesDataList.add(tsRemoteIpAddressRangesData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createTsRemoteIpAddressRanges()");
        return tsRemoteIpAddressRangesDataList;
    }

    private static List createAllowedTransformsDataIpSecTunnel(Map xmlTypeElementMap) {
        logger.traceEnter(THIS_CLASS, "createAllowedTransformsDataIpSecTunnel()");
        ArrayList<AllowedTransformsDataIpSecTunnel> allowedTransformsDataList = new ArrayList<AllowedTransformsDataIpSecTunnel>();
        String xmlTag = "allowedTransforms".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                XMLElement xmlElement = (XMLElement)iter.next();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                AllowedTransformsDataIpSecTunnel allowedTransformsDataIpSecTunnel = new AllowedTransformsDataIpSecTunnel((String)attrNameValueMap.get("encryptionAlgorithm".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("integrityAlgorithm".toLowerCase(Locale.getDefault())));
                allowedTransformsDataList.add(allowedTransformsDataIpSecTunnel);
            }
        }
        logger.traceReturn(THIS_CLASS, "createAllowedTransformsDataIpSecTunnel()");
        return allowedTransformsDataList;
    }

    private static List createIkePeerData(Map xmlTypeElementMap) throws IOException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createIkePeerData()");
        ArrayList<IkePeerData> ikePeerDataList = new ArrayList<IkePeerData>();
        String xmlTag = "IkePeer".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                XMLElement xmlElement = (XMLElement)iter.next();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                Map childElementMap = ParserHelper.createXmlTypeElementMap(xmlElement.getChildren());
                List allowedTransformsDataList = SiteBasicParserHelper.createAllowedTransformsData(childElementMap);
                AllowedTransformsDataIkePeer[] allowedTransformsData = null;
                if (!allowedTransformsDataList.isEmpty()) {
                    allowedTransformsData = new AllowedTransformsDataIkePeer[allowedTransformsDataList.size()];
                    allowedTransformsDataList.toArray(allowedTransformsData);
                }
                IkePeerData ikePeerData = new IkePeerData((String)attrNameValueMap.get("authenticationMethod".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("childSaLifeTimeDataLimit".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("childSaLifeTime".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("IkePeerId".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ikeSaLifeTime".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("logging".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("peerIdentityIdfqdn".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("peerIdentityIdType".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("peerIdentityIpv4Address".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("peerIpAddress".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("encoding".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("preSharedKey".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("userLabel".toLowerCase(Locale.getDefault())), allowedTransformsData, (String)attrNameValueMap.get("ownIdentityIdFqdn".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ownIdentityIdType".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ownIdentityIpv4Address".toLowerCase(Locale.getDefault())));
                ikePeerDataList.add(ikePeerData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createIkePeerData()");
        return ikePeerDataList;
    }

    private static List createAllowedTransformsData(Map xmlTypeElementMap) {
        logger.traceEnter(THIS_CLASS, "createAllowedTransformsData()");
        ArrayList<AllowedTransformsDataIkePeer> allowedTransformsDataList = new ArrayList<AllowedTransformsDataIkePeer>();
        String xmlTag = "allowedTransforms".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                XMLElement xmlElement = (XMLElement)iter.next();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                AllowedTransformsDataIkePeer allowedTransformsDataIkePeer = new AllowedTransformsDataIkePeer((String)attrNameValueMap.get("diffieHellmanGroup".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("encryptionAlgorithm".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("integrityAlgorithm".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("pseudoRandomFunction".toLowerCase(Locale.getDefault())));
                allowedTransformsDataList.add(allowedTransformsDataIkePeer);
            }
        }
        logger.traceReturn(THIS_CLASS, "createAllowedTransformsData()");
        return allowedTransformsDataList;
    }

    private static List createVpnInterfaceData(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createVpnInterfaceData()");
        ArrayList<VpnInterfaceData> vpnInterfaceDataList = new ArrayList<VpnInterfaceData>();
        String xmlTag = "VpnInterface".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                XMLElement xmlElement = (XMLElement)iter.next();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                VpnInterfaceData vpnInterfaceData = new VpnInterfaceData((String)attrNameValueMap.get("VpnInterfaceId".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ipAccessHostEtRef".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("networkPrefixLength".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("configurationMode".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ipVersion".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("userLabel".toLowerCase(Locale.getDefault())));
                vpnInterfaceDataList.add(vpnInterfaceData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createVpnInterfaceData()");
        return vpnInterfaceDataList;
    }

    private static List createDnsResolverData(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createDnsResolverData()");
        ArrayList<DnsResolverData> dnsResolverDataList = new ArrayList<DnsResolverData>();
        String xmlTag = "DnsResolver".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                XMLElement xmlElement = (XMLElement)iter.next();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                DnsResolverData dnsResolverData = new DnsResolverData((String)attrNameValueMap.get("defDomainName".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("DnsResolverId".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("dnsServerAddress1".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("dnsServerAddress2".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("dnsServerAddress3".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("dnsServerAddress4".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("dnsServerAutoConfig".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("dscp".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ipAccessHostEtRef".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("isSubDomainName".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("userLabel".toLowerCase(Locale.getDefault())));
                dnsResolverDataList.add(dnsResolverData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createDnsResolverData()");
        return dnsResolverDataList;
    }

    private static List createIpAccessHostEtData(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createIpAccessHostEtData()");
        ArrayList<IpAccessHostEtData> ipAccessHostEtDataList = new ArrayList<IpAccessHostEtData>();
        String xmlTag = "IpAccessHostEt".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                XMLElement xmlElement = (XMLElement)iter.next();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                Map childElementMap = ParserHelper.createXmlTypeElementMap(xmlElement.getChildren());
                List ipSyncRefDataList = SiteBasicParserHelper.createIpSyncRefData(childElementMap);
                IpSyncRefData[] ipSyncRefData = new IpSyncRefData[ipSyncRefDataList.size()];
                ipSyncRefDataList.toArray(ipSyncRefData);
                IpAccessHostEtData ipAccessHostEtData = new IpAccessHostEtData((String)attrNameValueMap.get("IpAccessHostEtId".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ipAddress".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ipInterfaceMoRef".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("userLabel".toLowerCase(Locale.getDefault())), ipSyncRefData);
                ipAccessHostEtDataList.add(ipAccessHostEtData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createIpAccessHostEtData()");
        return ipAccessHostEtDataList;
    }

    private static List createIpSyncRefData(Map xmlTypeElementMap) {
        logger.traceEnter(THIS_CLASS, "createIpSyncRefData()");
        ArrayList<IpSyncRefData> ipSyncRefDataList = new ArrayList<IpSyncRefData>();
        String xmlTag = "IpSyncRef".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(((XMLElement)iter.next()).getAttributes());
                IpSyncRefData ipSyncRefData = new IpSyncRefData((String)attrNameValueMap.get("IpSyncRefId".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ntpServerIpAddress".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("userLabel".toLowerCase(Locale.getDefault())));
                ipSyncRefDataList.add(ipSyncRefData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createIpSyncRefData()");
        return ipSyncRefDataList;
    }

    private static ManagedElementDataData createManagedElementDataData(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createManagedElementDataData()");
        ManagedElementDataData managedElementDataData = null;
        String xmlTag = "ManagedElementData".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            AttributesImpl attributes = ((XMLElement)((List)xmlTypeElementMap.get(xmlTag)).get(0)).getAttributes();
            Map attrNameValueMap = ParserHelper.createAttrNameValueMap(attributes);
            managedElementDataData = new ManagedElementDataData((String)attrNameValueMap.get("documentServerAddress".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ntpServerAddressPrimary".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ntpServiceActivePrimary".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ntpServerAddressSecondary".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ntpServiceActiveSecondary".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ntpServerAddressThird".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("ntpServiceActiveThird".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("nodeLocalTimeZone".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("daylightSavingTime".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("swServerUrlList".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("docLibUserDefined".toLowerCase(Locale.getDefault())));
        }
        logger.traceReturn(THIS_CLASS, "createManagedElementDataData()");
        return managedElementDataData;
    }

    private static ENodeBFunctionData createENodeBFunctionData(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createENodeBFunctionData()");
        ENodeBFunctionData eNodeBFunctionData = null;
        String xmlTag = "ENodeBFunction".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            XMLElement xmlElement = (XMLElement)((List)xmlTypeElementMap.get(xmlTag)).get(0);
            Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
            Map childElementMap = ParserHelper.createXmlTypeElementMap(xmlElement.getChildren());
            RbsConfigurationData rbsConfigurationData = SiteBasicParserHelper.createRbsConfigurationData(childElementMap);
            String upIpAddressRef = (String)attrNameValueMap.get("upIpAddressRef".toLowerCase(Locale.getDefault()));
            if (upIpAddressRef == null) {
                upIpAddressRef = (String)attrNameValueMap.get("upIpAccessHostRef".toLowerCase(Locale.getDefault()));
            }
            eNodeBFunctionData = new ENodeBFunctionData(upIpAddressRef, rbsConfigurationData, (String)attrNameValueMap.get("timeAndPhaseSynchCritical".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("timeAndPhaseSynchAlignment".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("timePhaseMaxDeviation".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("timePhaseMaxDeviationCdma2000".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("timePhaseMaxDeviationMbms".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("timePhaseMaxDeviationOtdoa".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("timePhaseMaxDeviationSib16".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("timePhaseMaxDeviationTdd".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("dnsSelectionS1X2Ref".toLowerCase(Locale.getDefault())));
        }
        logger.traceReturn(THIS_CLASS, "createENodeBFunctionData()");
        return eNodeBFunctionData;
    }

    private static RbsConfigurationData createRbsConfigurationData(Map xmlTypeElementMap) {
        logger.traceEnter(THIS_CLASS, "createRbsConfigurationData()");
        RbsConfigurationData rbsConfigurationData = null;
        String xmlTag = "RbsConfiguration".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            AttributesImpl attributes = ((XMLElement)((List)xmlTypeElementMap.get(xmlTag)).get(0)).getAttributes();
            Map attrNameValueMap = ParserHelper.createAttrNameValueMap(attributes);
            Map childElementMap = ParserHelper.createXmlTypeElementMap(((XMLElement)((List)xmlTypeElementMap.get(xmlTag)).get(0)).getChildren());
            WantedPositionData wantedPositionData = SiteBasicParserHelper.createWantedPositionData(childElementMap);
            rbsConfigurationData = new RbsConfigurationData((String)attrNameValueMap.get("ossCorbaNameServer".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("nodeIdType".toLowerCase(Locale.getDefault())), (String)attrNameValueMap.get("nodeIdValue".toLowerCase(Locale.getDefault())), wantedPositionData);
        }
        logger.traceReturn(THIS_CLASS, "createRbsConfigurationData()");
        return rbsConfigurationData;
    }

    private static FormatData createFormatData(Map xmlTypeElementMap) {
        logger.traceEnter(THIS_CLASS, "createFormatData()");
        FormatData formatData = null;
        String xmlTag = "Format".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            AttributesImpl attributes = ((XMLElement)((List)xmlTypeElementMap.get(xmlTag)).get(0)).getAttributes();
            Map attrNameValueMap = ParserHelper.createAttrNameValueMap(attributes);
            formatData = new FormatData((String)attrNameValueMap.get("revision".toLowerCase(Locale.getDefault())));
        }
        logger.traceReturn(THIS_CLASS, "createFormatData()");
        return formatData;
    }

    private static PacketFrequencySyncRefData[] createPacketFrequencySyncRefData(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createPacketFrequencySyncRefData()");
        PacketFrequencySyncRefData[] packetFrequencySyncRefDataArr = null;
        String xmlTag = "PacketFrequencySyncRef".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            ArrayList<PacketFrequencySyncRefData> packetFrequencySyncRefDataArray = new ArrayList<PacketFrequencySyncRefData>();
            while (iter.hasNext()) {
                XMLElement xmlElement = (XMLElement)iter.next();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                String ipAccessHostEtRef = (String)attrNameValueMap.get("ipAccessHostEtRef".toLowerCase(Locale.getDefault()));
                String packetFrequencySyncRefId = (String)attrNameValueMap.get("PacketFrequencySyncRefId".toLowerCase(Locale.getDefault()));
                packetFrequencySyncRefId = packetFrequencySyncRefId.substring(packetFrequencySyncRefId.lastIndexOf(45) + 1);
                String ptpDomain = (String)attrNameValueMap.get("ptpDomain".toLowerCase(Locale.getDefault()));
                String serverAddress = (String)attrNameValueMap.get("serverAddress".toLowerCase(Locale.getDefault()));
                ParserHelper.checkMandatoryAttribute((String)"ipAccessHostEtRef", (String)ipAccessHostEtRef);
                ParserHelper.checkMandatoryAttribute((String)"PacketFrequencySyncRefId", (String)packetFrequencySyncRefId);
                ParserHelper.checkMandatoryAttribute((String)"ptpDomain", (String)ptpDomain);
                ParserHelper.checkMandatoryAttribute((String)"serverAddress", (String)serverAddress);
                PacketFrequencySyncRefData packetFrequencySyncRefData = new PacketFrequencySyncRefData(ipAccessHostEtRef, packetFrequencySyncRefId, ptpDomain, serverAddress);
                packetFrequencySyncRefDataArray.add(packetFrequencySyncRefData);
            }
            packetFrequencySyncRefDataArr = new PacketFrequencySyncRefData[packetFrequencySyncRefDataArray.size()];
            packetFrequencySyncRefDataArray.toArray(packetFrequencySyncRefDataArr);
        }
        logger.traceReturn(THIS_CLASS, "createPacketFrequencySyncRefData()");
        return packetFrequencySyncRefDataArr;
    }

    private static PacketTimeSyncRefData[] createPacketTimeSyncRefData(Map xmlTypeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createPacketTimeSyncRefData()");
        PacketTimeSyncRefData[] packetTimeSyncRefDataArr = null;
        String xmlTag = "PacketTimeSyncRef".toLowerCase(Locale.getDefault());
        if (xmlTypeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)xmlTypeElementMap.get(xmlTag)).iterator();
            ArrayList<PacketTimeSyncRefData> packetTimeSyncRefDataArray = new ArrayList<PacketTimeSyncRefData>();
            while (iter.hasNext()) {
                XMLElement xmlElement = (XMLElement)iter.next();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(xmlElement.getAttributes());
                String packetTimeSyncRefId = (String)attrNameValueMap.get("PacketTimeSyncRefId".toLowerCase(Locale.getDefault()));
                packetTimeSyncRefId = packetTimeSyncRefId.substring(packetTimeSyncRefId.lastIndexOf(45) + 1);
                String ptpDomain = (String)attrNameValueMap.get("ptpDomain".toLowerCase(Locale.getDefault()));
                String transportLayerRef = (String)attrNameValueMap.get("transportLayerRef".toLowerCase(Locale.getDefault()));
                ParserHelper.checkMandatoryAttribute((String)"PacketTimeSyncRefId", (String)packetTimeSyncRefId);
                ParserHelper.checkMandatoryAttribute((String)"ptpDomain", (String)ptpDomain);
                ParserHelper.checkMandatoryAttribute((String)"transportLayerRef", (String)transportLayerRef);
                PacketTimeSyncRefData packetTimeSyncRefData = new PacketTimeSyncRefData(packetTimeSyncRefId, ptpDomain, transportLayerRef);
                packetTimeSyncRefDataArray.add(packetTimeSyncRefData);
            }
            packetTimeSyncRefDataArr = new PacketTimeSyncRefData[packetTimeSyncRefDataArray.size()];
            packetTimeSyncRefDataArray.toArray(packetTimeSyncRefDataArr);
        }
        logger.traceReturn(THIS_CLASS, "createPacketTimeSyncRefData()");
        return packetTimeSyncRefDataArr;
    }
}

