/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic;

import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.InstallLicenseTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class VerifyIpSecLicenseInstalled {
    private static final int LICENSE_ENABLED = 1;
    private static final Class THIS_CLASS = VerifyIpSecLicenseInstalled.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper moRepository;
    private final RbsConfigurationMao rbsConfiguration;
    private final RbsConfigurationHelper rbsConfigurationHelper;

    public VerifyIpSecLicenseInstalled(RbsConfigurationMao rbsConfigurationIn, MoRepositoryWrapper moRepositoryIn, RbsConfigurationHelper rbsConfigurationHelperIn) {
        this.moRepository = moRepositoryIn;
        this.rbsConfiguration = rbsConfigurationIn;
        this.rbsConfigurationHelper = rbsConfigurationHelperIn;
    }

    public void verifyLicense() throws RbsConfigurationFailedException {
        while (!this.isIpSecLicenseAvailable()) {
            ConfigurationReportLoggerFactory.getLogger().logInformation("IpSec for O&M License", "Retrying to install license, since the needed license for IpSec is not available in the currently installed lkf.");
            TransactionHandler.run(new InstallLicenseTp(this.rbsConfiguration, this.moRepository, this.rbsConfigurationHelper));
        }
    }

    private boolean isIpSecLicenseAvailable() throws RbsConfigurationFailedException {
        boolean licenseAvailable;
        IpSecMo ipSecMo = (IpSecMo)this.moRepository.lookup("ManagedElement=1,IpSystem=1,IpSec=1");
        if (ipSecMo == null) {
            throw new RbsConfigurationFailedException("IpSec MO is missing");
        }
        try {
            licenseAvailable = 1 == ipSecMo.getLicenseState(null);
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException("IpSec for OaM", "Unable to verify correct license state for IpSec, needed for OaM traffic", (Exception)((Object)mae));
        }
        logger.traceDebug(THIS_CLASS, "Checked if license for IpSec is available: " + licenseAvailable);
        return licenseAvailable;
    }
}

