/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure;

import java.io.IOException;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class AclEntriesData
implements Comparable {
    protected static final Integer RAWIP_PROTOCOL_VALUE = new Integer(255);
    protected static final Integer SCTP_PROTOCOL_VALUE = new Integer(132);
    protected static final Integer UDP_PROTOCOL_VALUE = new Integer(17);
    protected static final Integer TCP_PROTOCOL_VALUE = new Integer(6);
    protected static final Integer ICMP_PROTOCOL_VALUE = new Integer(1);
    protected static final Integer ANY_PROTOCOL_VALUE = new Integer(0);
    protected static final String RAWIP_PROTOCOL = "RAWIP";
    protected static final String SCTP_PROTOCOL = "SCTP";
    protected static final String UDP_PROTOCOL = "UDP";
    protected static final String TCP_PROTOCOL = "TCP";
    protected static final String ICMP_PROTOCOL = "ICMP";
    protected static final String ANY_PROTOCOL = "ANY";
    protected static final Integer BYPASS_ACTION_VALUE = new Integer(0);
    protected static final Integer DROP_ACTION_VALUE = new Integer(1);
    protected static final String DROP = "DROP";
    protected static final String BYPASS = "BYPASS";
    protected static final Integer DEFAULT_ICMP_TYPE = new Integer(256);
    private static final Class THIS_CLASS = AclEntriesData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public transient String aclPriority = null;
    public transient Integer aclAction = null;
    public transient Integer icmpType = DEFAULT_ICMP_TYPE;
    public transient String localIpAddress = null;
    public transient Integer localIpAddressMask = null;
    public transient Integer localPort = null;
    public transient Boolean localPortFiltering = Boolean.FALSE;
    public transient Integer protocol = ANY_PROTOCOL_VALUE;
    public transient String remoteIpAddress = null;
    public transient Integer remoteIpAddressMask = null;
    public transient Integer remotePort = null;
    public transient Boolean remotePortFiltering = Boolean.FALSE;

    public AclEntriesData(String inAclAction, String inIcmpType, String inAclPriority, String inLocalIpAddress, String inLocalIpAddressMask, String inLocalPort, String inLocalPortFiltering, String inProtocol, String inRemoteIpAddress, String inRemoteIpAddressMask, String inRemotePort, String inRemotePortFiltering) throws IOException {
        this.aclPriority = inAclPriority;
        this.aclAction = this.handleAclAction(inAclAction);
        if (inIcmpType != null) {
            this.icmpType = ParserHelper.convertIntegerAttribute((String)"icmpType", (String)inIcmpType);
        }
        this.localIpAddress = inLocalIpAddress;
        if (inLocalIpAddressMask != null) {
            this.localIpAddressMask = ParserHelper.convertIntegerAttribute((String)"localIpAddressMask", (String)inLocalIpAddressMask);
        }
        if (inLocalPort != null) {
            this.localPort = ParserHelper.convertIntegerAttribute((String)"localPort", (String)inLocalPort);
        }
        if (this.localPortFiltering != null) {
            this.localPortFiltering = ParserHelper.convertOptionBoolean((String)"localPortFiltering", (String)inLocalPortFiltering);
        }
        if (inProtocol != null) {
            this.protocol = this.handleProtocol(inProtocol);
        }
        this.remoteIpAddress = inRemoteIpAddress;
        if (inRemoteIpAddressMask != null) {
            this.remoteIpAddressMask = ParserHelper.convertIntegerAttribute((String)"remoteIpAddressMask", (String)inRemoteIpAddressMask);
        }
        if (inRemotePort != null) {
            this.remotePort = ParserHelper.convertIntegerAttribute((String)"remotePort", (String)inRemotePort);
        }
        if (inRemotePortFiltering != null) {
            this.remotePortFiltering = ParserHelper.convertOptionBoolean((String)"remotePortFiltering", (String)inRemotePortFiltering);
        }
    }

    private Integer handleProtocol(String inProtocol) {
        logger.traceEnter(THIS_CLASS, "handleProtocol()");
        Integer returnValue = null;
        if (ANY_PROTOCOL.equalsIgnoreCase(inProtocol)) {
            returnValue = ANY_PROTOCOL_VALUE;
        } else if (ICMP_PROTOCOL.equalsIgnoreCase(inProtocol)) {
            returnValue = ICMP_PROTOCOL_VALUE;
        } else if (TCP_PROTOCOL.equalsIgnoreCase(inProtocol)) {
            returnValue = TCP_PROTOCOL_VALUE;
        } else if (UDP_PROTOCOL.equalsIgnoreCase(inProtocol)) {
            returnValue = UDP_PROTOCOL_VALUE;
        } else if (SCTP_PROTOCOL.equalsIgnoreCase(inProtocol)) {
            returnValue = SCTP_PROTOCOL_VALUE;
        } else if (RAWIP_PROTOCOL.equalsIgnoreCase(inProtocol)) {
            returnValue = RAWIP_PROTOCOL_VALUE;
        }
        logger.traceReturn(THIS_CLASS, "handleProtocol()");
        return returnValue;
    }

    private Integer handleAclAction(String inAclAction) {
        logger.traceEnter(THIS_CLASS, "handleAclAction()");
        Integer returnValue = null;
        if (BYPASS.equalsIgnoreCase(inAclAction)) {
            returnValue = BYPASS_ACTION_VALUE;
        } else if (DROP.equalsIgnoreCase(inAclAction)) {
            returnValue = DROP_ACTION_VALUE;
        }
        logger.traceReturn(THIS_CLASS, "handleAclAction()");
        return returnValue;
    }

    public StructImpl getAclEntry() {
        logger.traceEnter(THIS_CLASS, "getAclEntry()");
        String[] aclEntryAttrArray = new String[11];
        Object[] aclEntryValuesArray = new Object[11];
        aclEntryAttrArray[0] = "aclAction";
        aclEntryAttrArray[1] = "icmpType";
        aclEntryAttrArray[2] = "localIpAddress";
        aclEntryAttrArray[3] = "localIpAddressMask";
        aclEntryAttrArray[4] = "localPort";
        aclEntryAttrArray[5] = "localPortFiltering";
        aclEntryAttrArray[6] = "protocol";
        aclEntryAttrArray[7] = "remoteIpAddress";
        aclEntryAttrArray[8] = "remoteIpAddressMask";
        aclEntryAttrArray[9] = "remotePort";
        aclEntryAttrArray[10] = "remotePortFiltering";
        aclEntryValuesArray[0] = this.aclAction;
        aclEntryValuesArray[1] = this.icmpType;
        aclEntryValuesArray[2] = this.localIpAddress;
        aclEntryValuesArray[3] = this.localIpAddressMask;
        aclEntryValuesArray[4] = this.localPort;
        aclEntryValuesArray[5] = this.localPortFiltering;
        aclEntryValuesArray[6] = this.protocol;
        aclEntryValuesArray[7] = this.remoteIpAddress;
        aclEntryValuesArray[8] = this.remoteIpAddressMask;
        aclEntryValuesArray[9] = this.remotePort;
        aclEntryValuesArray[10] = this.remotePortFiltering;
        StructImpl aclEntry = new StructImpl(aclEntryAttrArray, aclEntryValuesArray);
        logger.traceReturn(THIS_CLASS, "getAclEntry()");
        return aclEntry;
    }

    public int compareTo(Object otherObject) {
        int result2 = 0;
        if (otherObject instanceof AclEntriesData) {
            int otherAclPriority;
            AclEntriesData otherAclEntriesData = (AclEntriesData)otherObject;
            int ownAclPriority = Integer.parseInt(this.aclPriority);
            if (ownAclPriority < (otherAclPriority = Integer.parseInt(otherAclEntriesData.aclPriority))) {
                result2 = -1;
            } else if (ownAclPriority > otherAclPriority) {
                result2 = 1;
            }
        }
        return result2;
    }
}

