/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure;

import java.io.IOException;
import java.util.ArrayList;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AttrListHelpers;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class DnsResolverData {
    private static final Class THIS_CLASS = DnsResolverData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private transient String defDomainName;
    private transient String dnsResolverId;
    private transient String dnsServerAddress1;
    private transient String dnsServerAddress2;
    private transient String dnsServerAddress3;
    private transient String dnsServerAddress4;
    private transient Boolean dnsServerAutoConfig;
    private final transient Integer dscp;
    private final transient String ipAccessHostEtRefLdn;
    private transient Boolean isSubDomainName;
    private transient String userLabel = "";

    public DnsResolverData(String inDefDomainName, String inDnsResolverId, String inDnsServerAddress1, String inDnsServerAddress2, String inDnsServerAddress3, String inDnsServerAddress4, String inDnsServerAutoConfig, String inDscp, String inIpAccessHostEtRef, String inIsSubDomainName, String inUserLabel) throws IOException {
        this.defDomainName = StringHelper.emptyStringToDefault((String)inDefDomainName, (String)"");
        this.dnsResolverId = inDnsResolverId;
        this.dnsServerAddress1 = inDnsServerAddress1;
        this.dnsServerAddress2 = inDnsServerAddress2;
        this.dnsServerAddress3 = inDnsServerAddress3;
        this.dnsServerAddress4 = inDnsServerAddress4;
        this.dnsServerAutoConfig = inDnsServerAutoConfig != null ? ParserHelper.convertOptionBoolean((String)"dnsServerAutoConfig", (String)inDnsServerAutoConfig) : Boolean.FALSE;
        this.dscp = inDscp != null ? ParserHelper.convertIntegerAttribute((String)"dscp", (String)inDscp) : new Integer(48);
        this.ipAccessHostEtRefLdn = "ManagedElement=1,IpSystem=1,IpAccessHostEt=" + inIpAccessHostEtRef;
        this.isSubDomainName = inIsSubDomainName != null ? ParserHelper.convertOptionBoolean((String)"isSubDomainName", (String)inIsSubDomainName) : Boolean.TRUE;
        this.userLabel = StringHelper.emptyStringToDefault((String)inUserLabel, (String)"");
    }

    private String[] createDnsServerAddresses() {
        ArrayList<String> dnsServerList = new ArrayList<String>();
        if (this.getDnsServerAddress1() != null) {
            dnsServerList.add(this.getDnsServerAddress1());
        }
        if (this.getDnsServerAddress2() != null) {
            dnsServerList.add(this.getDnsServerAddress2());
        }
        if (this.getDnsServerAddress3() != null) {
            dnsServerList.add(this.getDnsServerAddress3());
        }
        if (this.getDnsServerAddress4() != null) {
            dnsServerList.add(this.getDnsServerAddress4());
        }
        String[] dnsServerAddresses = null;
        if (!dnsServerList.isEmpty()) {
            dnsServerAddresses = new String[dnsServerList.size()];
            dnsServerList.toArray(dnsServerAddresses);
        }
        return dnsServerAddresses;
    }

    public AttrListImpl createDnsResolverAttrList(ManagedObject referencedDnsResolver) {
        logger.traceEnter(THIS_CLASS, "createDnsResolverAttrList()");
        AttrListImpl attrList = new AttrListImpl();
        String[] dnsServerAddresses = this.createDnsServerAddresses();
        AttrListHelpers.addElementCheckNull("defDomainName", this.defDomainName, attrList);
        AttrListHelpers.addElementCheckNull("DnsResolverId", this.dnsResolverId, attrList);
        AttrListHelpers.addElementCheckNull("dnsServerAutoConfig", this.dnsServerAutoConfig, attrList);
        AttrListHelpers.addElementCheckNull("dscp", this.dscp, attrList);
        AttrListHelpers.addElementCheckNull("ipAccessHostEtRef", referencedDnsResolver, attrList);
        AttrListHelpers.addElementCheckNull("isSubDomainName", this.isSubDomainName, attrList);
        AttrListHelpers.addElementCheckNull("userLabel", this.userLabel, attrList);
        AttrListHelpers.addElementCheckNull("dnsServerAddress", dnsServerAddresses, attrList);
        logger.traceReturn(THIS_CLASS, "createDnsResolverAttrList()");
        return attrList;
    }

    public String getDefDomainName() {
        return this.defDomainName;
    }

    public String getDnsResolverId() {
        return this.dnsResolverId;
    }

    public String getDnsServerAddress1() {
        return this.dnsServerAddress1;
    }

    public String getDnsServerAddress2() {
        return this.dnsServerAddress2;
    }

    public String getDnsServerAddress3() {
        return this.dnsServerAddress3;
    }

    public String getDnsServerAddress4() {
        return this.dnsServerAddress4;
    }

    public Boolean getDnsServerAutoConfig() {
        return this.dnsServerAutoConfig;
    }

    public Integer getDscp() {
        return this.dscp;
    }

    public String getIpAccessHostEtRefLdn() {
        return this.ipAccessHostEtRefLdn;
    }

    public Boolean getIsSubDomainName() {
        return this.isSubDomainName;
    }

    public String getUserLabel() {
        return this.userLabel;
    }
}

