/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure;

import java.io.IOException;
import java.util.ArrayList;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AttrListHelpers;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpHostLinkData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpRoutingTableData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.OaMAlternativeAccessSourceData;

public class IpData {
    private final transient String dnsServer1;
    private final transient String dnsServer2;
    private final transient String dnsServer3;
    private final transient Integer dscp;
    private final transient IpRoutingTableData ipRoutingTableData;
    private final transient Boolean oaMAlternativeAccess;
    private final transient IpHostLinkData ipHostLinkData;
    private final transient OaMAlternativeAccessSourceData[] oaMAlternativeAccessSourceData;

    public IpData(String inDnsServer1, String inDnsServer2, String inDnsServer3, String inDscp, IpRoutingTableData inIpRoutingTableData, String inOaMAlternativeAccess, IpHostLinkData inIpHostLinkData, OaMAlternativeAccessSourceData[] inOaMAlternativeAccessSourceData) throws IOException {
        this.dnsServer1 = inDnsServer1;
        this.dnsServer2 = inDnsServer2;
        this.dnsServer3 = inDnsServer3;
        this.dscp = ParserHelper.convertIntegerAttribute((String)"dscp", (String)inDscp);
        this.ipRoutingTableData = inIpRoutingTableData;
        this.oaMAlternativeAccess = ParserHelper.convertOptionBoolean((String)"oaMAlternativeAccess", (String)inOaMAlternativeAccess);
        this.ipHostLinkData = inIpHostLinkData;
        this.oaMAlternativeAccessSourceData = inOaMAlternativeAccessSourceData;
    }

    private String[] createDnsServerArray() {
        ArrayList<String> dnsServersList = new ArrayList<String>();
        if (this.getDnsServer1() != null) {
            dnsServersList.add(this.getDnsServer1());
        }
        if (this.getDnsServer2() != null) {
            dnsServersList.add(this.getDnsServer2());
        }
        if (this.getDnsServer3() != null) {
            dnsServersList.add(this.getDnsServer3());
        }
        String[] dnsServersArray = null;
        if (!dnsServersList.isEmpty()) {
            dnsServersArray = new String[dnsServersList.size()];
            dnsServersList.toArray(dnsServersArray);
        }
        return dnsServersArray;
    }

    public AttrListImpl createIpAttrList() {
        AttrListImpl attrList = new AttrListImpl();
        String[] dnsServersArray = this.createDnsServerArray();
        AttrListHelpers.addElementCheckNull("dnsServerAddresses", dnsServersArray, attrList);
        AttrListHelpers.addElementCheckNull("dscp", this.getDscp(), attrList);
        return attrList;
    }

    public String getDnsServer1() {
        return this.dnsServer1;
    }

    public String getDnsServer2() {
        return this.dnsServer2;
    }

    public String getDnsServer3() {
        return this.dnsServer3;
    }

    public Integer getDscp() {
        return this.dscp;
    }

    public IpRoutingTableData getIpRoutingTableData() {
        return this.ipRoutingTableData;
    }

    public Boolean getOaMAlternativeAccess() {
        return this.oaMAlternativeAccess;
    }

    public IpHostLinkData getIpHostLinkData() {
        return this.ipHostLinkData;
    }

    public OaMAlternativeAccessSourceData[] getOaMAlternativeAccessSourceData() {
        return this.oaMAlternativeAccessSourceData;
    }
}

