/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure;

import java.io.IOException;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AttrListHelpers;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;

public class IpInterfaceData {
    private static final Class THIS_CLASS = IpInterfaceData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final transient String accessControlListRefLdn;
    private final transient String ipInterfaceId;
    private final transient Integer networkPrefixLength;
    private final transient String defaultRouter0;
    private final transient Integer vid;
    private final transient String ipInterFaceSlot;
    private final transient String userLabel;
    public transient String configurationMode = "MANUAL";
    public transient String dhcpClientIdentifierType;
    public transient String dhcpClientIdentifier;

    public IpInterfaceData(String inAccessControlListRef, String inIpInterfaceId, String inNetworkPrefixLength, String inDefaultRouter0, String inVid, String inIpInterFaceSlot, String inConfigurationMode, String inUserLabel, String inDhcpClientIdentifierType, String inDhcpClientIdentifier) throws IOException {
        this.accessControlListRefLdn = inAccessControlListRef == null ? null : "ManagedElement=1,IpSystem=1,AccessControlList=" + inAccessControlListRef;
        this.ipInterfaceId = inIpInterfaceId;
        this.networkPrefixLength = ParserHelper.convertIntegerAttribute((String)"networkPrefixLength", (String)inNetworkPrefixLength);
        this.defaultRouter0 = inDefaultRouter0;
        this.vid = ParserHelper.convertIntegerAttribute((String)"vid", (String)inVid);
        this.ipInterFaceSlot = inIpInterFaceSlot;
        this.configurationMode = inConfigurationMode;
        this.userLabel = inUserLabel;
        this.dhcpClientIdentifierType = inDhcpClientIdentifierType;
        this.dhcpClientIdentifier = inDhcpClientIdentifier;
    }

    public AttrListImpl createIpInterFaceAttrList() {
        logger.traceEnter(THIS_CLASS, "createIpInterFaceAttrList()");
        AttrListImpl attrList = new AttrListImpl();
        Integer manual = RbsConfigurationDefinitions.IP_INTERFACE_CONFIGURATION_MODE_MANUAL;
        Integer dhcp = RbsConfigurationDefinitions.IP_INTERFACE_CONFIGURATION_MODE_DHCP;
        Integer configurationModeIntVal = null;
        AttrListHelpers.addElementCheckNull("networkPrefixLength", this.networkPrefixLength, attrList);
        AttrListHelpers.addElementCheckNull("defaultRouter0", this.defaultRouter0, attrList);
        attrList.addElement("rps", (Object)Boolean.FALSE);
        AttrListHelpers.addElementCheckNull("userLabel", this.userLabel, attrList);
        configurationModeIntVal = this.configurationMode != null && this.configurationMode.compareTo("DHCP") == 0 ? dhcp : manual;
        AttrListHelpers.addElementCheckNull("configurationMode", configurationModeIntVal, attrList);
        if (this.getVid() == null) {
            attrList.addElement("vLan", (Object)Boolean.FALSE);
        } else if (this.getVid() == -1) {
            attrList.addElement("vLan", (Object)Boolean.FALSE);
        } else {
            attrList.addElement("vid", (Object)this.vid);
            attrList.addElement("vLan", (Object)Boolean.TRUE);
        }
        Integer dhcpClientIdentifierTypeIntVal = null;
        if (this.dhcpClientIdentifierType != null) {
            dhcpClientIdentifierTypeIntVal = this.dhcpClientIdentifierType.compareTo("AUTOMATIC_MAC") == 0 ? RbsConfigurationDefinitions.IP_INTERFACE_DHCP_CLIENT_IDENTIFIER_TYPE_AUTOMATIC_MAC : (this.dhcpClientIdentifierType.compareTo("AUTOMATIC_SERIAL_NUMBER") == 0 ? RbsConfigurationDefinitions.IP_INTERFACE_DHCP_CLIENT_IDENTIFIER_TYPE_AUTOMATIC_SERIAL_NUMBER : (this.dhcpClientIdentifierType.compareTo("MANUAL") == 0 ? RbsConfigurationDefinitions.IP_INTERFACE_DHCP_CLIENT_IDENTIFIER_TYPE_MANUAL : (this.dhcpClientIdentifierType.compareTo("NO_CLIENT_IDENTIFIER") == 0 ? RbsConfigurationDefinitions.IP_INTERFACE_DHCP_CLIENT_IDENTIFIER_TYPE_NO_CLIENT_IDENTIFIER : RbsConfigurationDefinitions.IP_INTERFACE_DHCP_CLIENT_IDENTIFIER_TYPE_AUTOMATIC)));
            StructImpl dhcpClientIdentifierAttr = new StructImpl(new String[]{"clientIdentifier", "clientIdentifierType"}, new Object[]{this.dhcpClientIdentifier == null ? "" : this.dhcpClientIdentifier, dhcpClientIdentifierTypeIntVal});
            AttrListHelpers.addElementCheckNull("dhcpClientIdentifier", dhcpClientIdentifierAttr, attrList);
        }
        logger.traceReturn(THIS_CLASS, "createIpInterFaceAttrList()");
        return attrList;
    }

    public String getAccessControlListRefLdn() {
        return this.accessControlListRefLdn;
    }

    public String getIpInterfaceId() {
        return this.ipInterfaceId;
    }

    public Integer getNetworkPrefixLength() {
        return this.networkPrefixLength;
    }

    public String getDefaultRouter0() {
        return this.defaultRouter0;
    }

    public Integer getVid() {
        return this.vid;
    }

    public String getIpInterFaceSlot() {
        return this.ipInterFaceSlot;
    }

    public String getUserLabel() {
        return this.userLabel;
    }

    public String getDhcpClientIdentifier() {
        return this.dhcpClientIdentifier;
    }

    public String getDhcpClientIdentifierType() {
        return this.dhcpClientIdentifierType;
    }
}

