/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure;

import java.io.IOException;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AttrListHelpers;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IkePeerData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSecTunnelData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpSecData {
    private static final Class THIS_CLASS = IpSecData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String DEACTIVATED = "DEACTIVATED";
    protected static final String ACTIVATED = "ACTIVATED";
    protected static final Integer DEACTIVATED_VALUE = new Integer(0);
    protected static final Integer ACTIVATED_VALUE = new Integer(1);
    private transient Integer certExpirWarnTime = new Integer(90);
    private transient Integer featureState;
    private transient String userLabel = "";
    private final transient IkePeerData[] ikePeerData;
    private final transient IpSecTunnelData[] ipSecTunnelData;

    public IpSecData(String inCertExpirWarnTime, String inFeatureState, String inUserLabel, IkePeerData[] inIkePeerData, IpSecTunnelData[] inIpSecTunnelData) throws IOException {
        if (this.certExpirWarnTime != null) {
            this.certExpirWarnTime = ParserHelper.convertIntegerAttribute((String)"certExpirWarnTime", (String)inCertExpirWarnTime);
        }
        if (inFeatureState != null && inFeatureState.equalsIgnoreCase(ACTIVATED)) {
            this.featureState = ACTIVATED_VALUE;
        } else if (inFeatureState != null && inFeatureState.equalsIgnoreCase(DEACTIVATED)) {
            this.featureState = DEACTIVATED_VALUE;
        }
        this.userLabel = inUserLabel;
        this.ikePeerData = inIkePeerData;
        this.ipSecTunnelData = inIpSecTunnelData;
    }

    public AttrListImpl createIpSecAttrList() {
        logger.traceEnter(THIS_CLASS, "createIpSecAttrList()");
        AttrListImpl attrList = new AttrListImpl();
        AttrListHelpers.addElementCheckNull("certExpirWarnTime", this.certExpirWarnTime, attrList);
        AttrListHelpers.addElementCheckNull("featureState", this.featureState, attrList);
        AttrListHelpers.addElementCheckNull("userLabel", this.userLabel, attrList);
        logger.traceReturn(THIS_CLASS, "createIpSecAttrList()");
        return attrList;
    }

    public Integer getCertExpirWarnTime() {
        return this.certExpirWarnTime;
    }

    public void setCertExpirWarnTime(Integer certExpirWarnTimeIn) {
        this.certExpirWarnTime = certExpirWarnTimeIn;
    }

    public Integer getFeatureState() {
        return this.featureState;
    }

    public void setFeatureState(Integer featureStateIn) {
        this.featureState = featureStateIn;
    }

    public String getUserLabel() {
        return this.userLabel;
    }

    public void setUserLabel(String userLabelIn) {
        this.userLabel = userLabelIn;
    }

    public IkePeerData[] getIkePeerData() {
        return this.ikePeerData;
    }

    public IpSecTunnelData[] getIpSecTunnelData() {
        return this.ipSecTunnelData;
    }
}

