/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AllowedTransformsDataIpSecTunnel;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AttrListHelpers;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.TrafficSelectorIpAddressRange;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpSecTunnelData {
    private static final Class THIS_CLASS = IpSecTunnelData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final transient String ikePeerRefLdn;
    private final transient String ipSecTunnelId;
    private final transient String tsProtocols;
    private transient String userLabel = "";
    private final transient String vpnInterfaceRefLdn;
    private transient StructImpl[] allowedTransforms = null;
    private transient StructImpl[] tsRemoteIpAddressRanges = null;
    private transient StructImpl[] tsLocalIpAddressRanges;
    private final transient Integer priority;
    private static final String RAWIP = "RAWIP";
    private static final String SCTP = "SCTP";
    private static final String UDP = "UDP";
    private static final String TCP = "TCP";
    private static final String ICMP = "ICMP";
    private static final String ANY = "ANY";
    private static final Map tsProtocolsMap = new HashMap();
    private final String[] attributes = new String[]{"encryptionAlgorithm", "integrityAlgorithm"};

    public IpSecTunnelData(String inIkePeerRef, String inIpSecTunnelId, List inTsLocalIpAddressRangesDataList, String inTsProtocols, String inPriority, String inUserLabel, String inVpnInterfaceRef, AllowedTransformsDataIpSecTunnel[] inAllowedTransformsData, List tsRemoteIpAddressRangesDataList) throws IOException, RbsConfigurationFailedException {
        this(inIkePeerRef, inIpSecTunnelId, inTsLocalIpAddressRangesDataList, inTsProtocols, inPriority, inUserLabel, inVpnInterfaceRef, inAllowedTransformsData, tsRemoteIpAddressRangesDataList, Boolean.FALSE);
    }

    public IpSecTunnelData(String inIkePeerRef, String inIpSecTunnelId, List inTsLocalIpAddressRangesDataList, String inTsProtocols, String inPriority, String inUserLabel, String inVpnInterfaceRef, AllowedTransformsDataIpSecTunnel[] inAllowedTransformsData, List tsRemoteIpAddressRangesDataList, boolean inIsTempTunnel) throws IOException, RbsConfigurationFailedException {
        this(inIkePeerRef, inIpSecTunnelId, inTsLocalIpAddressRangesDataList, inTsProtocols, inPriority, inUserLabel, inVpnInterfaceRef, inAllowedTransformsData, tsRemoteIpAddressRangesDataList, inIsTempTunnel ? Boolean.TRUE : Boolean.FALSE);
    }

    private IpSecTunnelData(String inIkePeerRef, String inIpSecTunnelId, List inTsLocalIpAddressRangesDataList, String inTsProtocols, String inPriority, String inUserLabel, String inVpnInterfaceRef, AllowedTransformsDataIpSecTunnel[] inAllowedTransformsData, List tsRemoteIpAddressRangesDataList, Boolean isTempTunnel) throws IOException, RbsConfigurationFailedException {
        this.ikePeerRefLdn = "ManagedElement=1,IpSystem=1,IpSec=1,IkePeer=" + inIkePeerRef;
        this.ipSecTunnelId = inIpSecTunnelId;
        this.tsLocalIpAddressRanges = new StructImpl[inTsLocalIpAddressRangesDataList.size()];
        Iterator tsLocalIpAdressIterator = inTsLocalIpAddressRangesDataList.iterator();
        int idx = 0;
        while (tsLocalIpAdressIterator.hasNext()) {
            TrafficSelectorIpAddressRange currentTsLocalIpAddressRange = (TrafficSelectorIpAddressRange)tsLocalIpAdressIterator.next();
            this.tsLocalIpAddressRanges[idx] = IpSecTunnelData.createTsIpAddressRangeStruct(currentTsLocalIpAddressRange);
            ++idx;
        }
        this.tsProtocols = inTsProtocols;
        this.priority = ParserHelper.convertIntegerAttribute((String)"priority", (String)inPriority);
        this.userLabel = inUserLabel;
        this.vpnInterfaceRefLdn = "ManagedElement=1,IpSystem=1,VpnInterface=" + inVpnInterfaceRef;
        if (inAllowedTransformsData == null && !isTempTunnel.booleanValue()) {
            logger.traceGeneral(THIS_CLASS, "Missing mandatory IpSecTunnel xml element: allowedTransforms, using default values.");
            this.allowedTransforms = this.createDefaultAllowedTransforms();
        } else {
            this.allowedTransforms = inAllowedTransformsData == null && isTempTunnel != false ? this.createDefaultAllowedTransformsTempTunnel() : this.handleAllowedTransforms(inAllowedTransformsData);
        }
        this.tsRemoteIpAddressRanges = new StructImpl[tsRemoteIpAddressRangesDataList.size()];
        Iterator tsRemoteIpAdressIterator = tsRemoteIpAddressRangesDataList.iterator();
        idx = 0;
        while (tsRemoteIpAdressIterator.hasNext()) {
            TrafficSelectorIpAddressRange currentTsRemoteIpAddressRange = (TrafficSelectorIpAddressRange)tsRemoteIpAdressIterator.next();
            this.tsRemoteIpAddressRanges[idx] = IpSecTunnelData.createTsIpAddressRangeStruct(currentTsRemoteIpAddressRange);
            ++idx;
        }
    }

    private StructImpl[] createDefaultAllowedTransforms() {
        logger.traceEnter(THIS_CLASS, "createDefaultAllowedTransforms()");
        StructImpl[] inAllowedTransforms = new StructImpl[10];
        Object[] values0 = new Object[]{RbsConfigurationDefinitions.ENCRYPTION_ALGORITHM.get("AES_CBC_128"), RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("AES_XCBC_MAC_96")};
        Object[] values1 = new Object[]{RbsConfigurationDefinitions.ENCRYPTION_ALGORITHM.get("AES_CBC_128"), RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("HMAC_SHA_1_96")};
        Object[] values2 = new Object[]{RbsConfigurationDefinitions.ENCRYPTION_ALGORITHM.get("AES_CBC_128"), RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("HMAC_MD5_96")};
        Object[] values3 = new Object[]{RbsConfigurationDefinitions.ENCRYPTION_ALGORITHM.get("AES_CBC_256"), RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("AES_XCBC_MAC_96")};
        Object[] values4 = new Object[]{RbsConfigurationDefinitions.ENCRYPTION_ALGORITHM.get("AES_CBC_256"), RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("HMAC_SHA_1_96")};
        Object[] values5 = new Object[]{RbsConfigurationDefinitions.ENCRYPTION_ALGORITHM.get("AES_CBC_256"), RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("HMAC_MD5_96")};
        Object[] values6 = new Object[]{RbsConfigurationDefinitions.ENCRYPTION_ALGORITHM.get("ALG_3DES_CBC"), RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("AES_XCBC_MAC_96")};
        Object[] values7 = new Object[]{RbsConfigurationDefinitions.ENCRYPTION_ALGORITHM.get("ALG_3DES_CBC"), RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("HMAC_SHA_1_96")};
        Object[] values8 = new Object[]{RbsConfigurationDefinitions.ENCRYPTION_ALGORITHM.get("ALG_3DES_CBC"), RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("HMAC_MD5_96")};
        Object[] values9 = new Object[]{RbsConfigurationDefinitions.ENCRYPTION_ALGORITHM.get("NULL"), RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("HMAC_SHA_1_96")};
        inAllowedTransforms[0] = new StructImpl(this.attributes, values0);
        inAllowedTransforms[1] = new StructImpl(this.attributes, values1);
        inAllowedTransforms[2] = new StructImpl(this.attributes, values2);
        inAllowedTransforms[3] = new StructImpl(this.attributes, values3);
        inAllowedTransforms[4] = new StructImpl(this.attributes, values4);
        inAllowedTransforms[5] = new StructImpl(this.attributes, values5);
        inAllowedTransforms[6] = new StructImpl(this.attributes, values6);
        inAllowedTransforms[7] = new StructImpl(this.attributes, values7);
        inAllowedTransforms[8] = new StructImpl(this.attributes, values8);
        inAllowedTransforms[9] = new StructImpl(this.attributes, values9);
        logger.traceReturn(THIS_CLASS, "createDefaultAllowedTransforms()");
        return inAllowedTransforms;
    }

    private StructImpl[] createDefaultAllowedTransformsTempTunnel() {
        logger.traceEnter(THIS_CLASS, "createDefaultAllowedTransformsTempTunnel()");
        StructImpl[] inAllowedTransforms = new StructImpl[1];
        Object[] values0 = new Object[]{RbsConfigurationDefinitions.ENCRYPTION_ALGORITHM.get("AES_CBC_128"), RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("HMAC_SHA_1_96")};
        inAllowedTransforms[0] = new StructImpl(this.attributes, values0);
        logger.traceReturn(THIS_CLASS, "createDefaultAllowedTransformsTempTunnel()");
        return inAllowedTransforms;
    }

    private StructImpl[] handleAllowedTransforms(AllowedTransformsDataIpSecTunnel[] inAllowedTransformsData) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "handleAllowedTransforms()");
        StructImpl[] allowedTransformsStructArray = new StructImpl[inAllowedTransformsData.length];
        for (int i = 0; i < inAllowedTransformsData.length; ++i) {
            Object[] allowedTransformsValues = new Object[]{this.getEncryptionAlgorithm(inAllowedTransformsData[i]), this.getIntegrityAlgorithm(inAllowedTransformsData[i])};
            allowedTransformsStructArray[i] = new StructImpl(this.attributes, allowedTransformsValues);
        }
        logger.traceReturn(THIS_CLASS, "handleAllowedTransforms()");
        return allowedTransformsStructArray;
    }

    private Object getEncryptionAlgorithm(AllowedTransformsDataIpSecTunnel inAllowedTransformsData) throws RbsConfigurationFailedException {
        Object encryptionAlgorithm;
        if ("NULL".equalsIgnoreCase(inAllowedTransformsData.getEncryptionAlgorithm())) {
            encryptionAlgorithm = RbsConfigurationDefinitions.ENCRYPTION_ALGORITHM.get("NULL");
        } else if ("AES_CBC_128".equalsIgnoreCase(inAllowedTransformsData.getEncryptionAlgorithm())) {
            encryptionAlgorithm = RbsConfigurationDefinitions.ENCRYPTION_ALGORITHM.get("AES_CBC_128");
        } else if ("AES_CBC_256".equalsIgnoreCase(inAllowedTransformsData.getEncryptionAlgorithm())) {
            encryptionAlgorithm = RbsConfigurationDefinitions.ENCRYPTION_ALGORITHM.get("AES_CBC_256");
        } else if ("ALG_3DES_CBC".equalsIgnoreCase(inAllowedTransformsData.getEncryptionAlgorithm())) {
            encryptionAlgorithm = RbsConfigurationDefinitions.ENCRYPTION_ALGORITHM.get("ALG_3DES_CBC");
        } else {
            throw new RbsConfigurationFailedException("Incorrect value for: encryptionAlgorithm should be either NULL, AES_CBC_128, AES_CBC_256 or ALG_3DES_CBC");
        }
        return encryptionAlgorithm;
    }

    private Object getIntegrityAlgorithm(AllowedTransformsDataIpSecTunnel inAllowedTransformsData) throws RbsConfigurationFailedException {
        Object integrityAlgorithm;
        if ("NULL".equalsIgnoreCase(inAllowedTransformsData.getIntegrityAlgorithm())) {
            integrityAlgorithm = RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("NULL");
        } else if ("AES_XCBC_MAC_96".equalsIgnoreCase(inAllowedTransformsData.getIntegrityAlgorithm())) {
            integrityAlgorithm = RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("AES_XCBC_MAC_96");
        } else if ("HMAC_SHA_1_96".equalsIgnoreCase(inAllowedTransformsData.getIntegrityAlgorithm())) {
            integrityAlgorithm = RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("HMAC_SHA_1_96");
        } else if ("HMAC_MD5_96".equalsIgnoreCase(inAllowedTransformsData.getIntegrityAlgorithm())) {
            integrityAlgorithm = RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("HMAC_MD5_96");
        } else if ("HMAC_SHA2_256_128".equalsIgnoreCase(inAllowedTransformsData.getIntegrityAlgorithm())) {
            integrityAlgorithm = RbsConfigurationDefinitions.IP_SEC_TUNNEL_INTEGRITY_ALGORITHM.get("HMAC_SHA2_256_128");
        } else {
            throw new RbsConfigurationFailedException("Incorrect value for: integrityAlgorithm should be either NULL, AES_XCBC_MAC_96, HMAC_SHA_1_96 or HMAC_MD5_96 or HMAC_SHA2_256_128");
        }
        return integrityAlgorithm;
    }

    private static StructImpl createTsIpAddressRangeStruct(TrafficSelectorIpAddressRange currentTsRemoteIpAddressRange) {
        logger.traceEnter(THIS_CLASS, "createTsIpAddressRangeStruct()");
        String[] tsIpAddressRangesAttr = new String[2];
        Object[] tsIpAddressRangesValues = new Object[2];
        tsIpAddressRangesAttr[0] = "ipAddress";
        tsIpAddressRangesAttr[1] = "mask";
        tsIpAddressRangesValues[0] = currentTsRemoteIpAddressRange.getIpAddress();
        tsIpAddressRangesValues[1] = currentTsRemoteIpAddressRange.getMask();
        StructImpl tsIpAddressRangeStruct = new StructImpl(tsIpAddressRangesAttr, tsIpAddressRangesValues);
        logger.traceReturn(THIS_CLASS, "createTsIpAddressRangeStruct()");
        return tsIpAddressRangeStruct;
    }

    private int[] handleTsProtocols() {
        logger.traceEnter(THIS_CLASS, "handleTsProtocols()");
        Integer returnValue = (Integer)tsProtocolsMap.get(ANY);
        if (this.tsProtocols != null && tsProtocolsMap.containsKey(this.tsProtocols.toUpperCase(Locale.getDefault()))) {
            returnValue = (Integer)tsProtocolsMap.get(this.tsProtocols.toUpperCase(Locale.getDefault()));
        }
        int[] returnArray = new int[]{returnValue};
        logger.traceReturn(THIS_CLASS, "handleTsProtocols()");
        return returnArray;
    }

    public AttrListImpl createIpSecTunnelAttrList(ManagedObject referencedIkePeerMo, ManagedObject referencedVpnInterface) throws IOException {
        logger.traceEnter(THIS_CLASS, "createIpSecTunnelAttrList()");
        AttrListImpl attrList = new AttrListImpl();
        int[] tsProtocol = this.handleTsProtocols();
        AttrListHelpers.addElementCheckNull("tsRemoteIpAddressRanges", this.tsRemoteIpAddressRanges, attrList);
        AttrListHelpers.addElementCheckNull("tsLocalIpAddressRanges", this.tsLocalIpAddressRanges, attrList);
        AttrListHelpers.addElementCheckNull("tsProtocols", tsProtocol, attrList);
        AttrListHelpers.addElementCheckNull("userLabel", this.userLabel, attrList);
        AttrListHelpers.addElementCheckNull("allowedTransforms", this.allowedTransforms, attrList);
        AttrListHelpers.addElementCheckNull("ikePeerRef", referencedIkePeerMo, attrList);
        AttrListHelpers.addElementCheckNull("priority", this.priority, attrList);
        AttrListHelpers.addElementCheckNull("vpnInterfaceRef", referencedVpnInterface, attrList);
        logger.traceReturn(THIS_CLASS, "createIpSecTunnelAttrList()");
        return attrList;
    }

    public String getIkePeerRefLdn() {
        return this.ikePeerRefLdn;
    }

    public String getIpSecTunnelId() {
        return this.ipSecTunnelId;
    }

    public String getTsProtocols() {
        return this.tsProtocols;
    }

    public String getUserLabel() {
        return this.userLabel;
    }

    public void setUserLabel(String userLabelIn) {
        this.userLabel = userLabelIn;
    }

    public String getVpnInterfaceRefLdn() {
        return this.vpnInterfaceRefLdn;
    }

    public StructImpl[] getAllowedTransforms() {
        return this.allowedTransforms;
    }

    public void setAllowedTransforms(StructImpl[] allowedTransformsIn) {
        this.allowedTransforms = allowedTransformsIn;
    }

    public StructImpl[] getTsRemoteIpAddressRanges() {
        return this.tsRemoteIpAddressRanges;
    }

    public void setTsLocalIpAddressRanges(TrafficSelectorIpAddressRange[] currentTsLocalIpAddressRanges) {
        StructImpl[] tsLocal = new StructImpl[currentTsLocalIpAddressRanges.length];
        for (int i = 0; i < currentTsLocalIpAddressRanges.length; ++i) {
            tsLocal[i] = IpSecTunnelData.createTsIpAddressRangeStruct(currentTsLocalIpAddressRanges[i]);
        }
        this.tsLocalIpAddressRanges = tsLocal;
    }

    public void setTsRemoteIpAddressRanges(TrafficSelectorIpAddressRange[] currentTsRemoteIpAddressRanges) {
        StructImpl[] tsRemote = new StructImpl[currentTsRemoteIpAddressRanges.length];
        for (int i = 0; i < currentTsRemoteIpAddressRanges.length; ++i) {
            tsRemote[i] = IpSecTunnelData.createTsIpAddressRangeStruct(currentTsRemoteIpAddressRanges[i]);
        }
        this.tsRemoteIpAddressRanges = tsRemote;
    }

    public void setTsRemoteIpAddressRanges(StructImpl[] tsRemoteIpAddressRangesIn) {
        this.tsRemoteIpAddressRanges = tsRemoteIpAddressRangesIn;
    }

    public StructImpl[] getTsLocalIpAddressRanges() {
        return this.tsLocalIpAddressRanges;
    }

    public Integer getPriority() {
        return this.priority;
    }

    static {
        tsProtocolsMap.put(ANY, new Integer(0));
        tsProtocolsMap.put(ICMP, new Integer(1));
        tsProtocolsMap.put(TCP, new Integer(6));
        tsProtocolsMap.put(UDP, new Integer(17));
        tsProtocolsMap.put(SCTP, new Integer(132));
        tsProtocolsMap.put(RAWIP, new Integer(255));
    }
}

