/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AttrListHelpers;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.SyncRiPort;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class NodeGroupSyncMemberData {
    private static final Class THIS_CLASS = NodeGroupSyncMemberData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private transient String nodeGroupSyncMemberId;
    private transient Integer syncNodePriority;
    private transient StructImpl[] syncRiPortCandidateStruct = null;
    public static final Map duRiPortMap = new HashMap();

    public NodeGroupSyncMemberData(String inNodeGroupSyncMemberId, String inSyncNodePriority, SyncRiPort[] inSyncRiPortCandidateData) throws IOException {
        this.nodeGroupSyncMemberId = inNodeGroupSyncMemberId;
        this.syncNodePriority = ParserHelper.convertIntegerAttribute((String)"syncNodePriority", (String)inSyncNodePriority);
        this.syncRiPortCandidateStruct = this.createSyncRiPortCandidateStruct(inSyncRiPortCandidateData);
    }

    private StructImpl[] createSyncRiPortCandidateStruct(SyncRiPort[] inSyncRiPortCandidateData) {
        logger.traceEnter(THIS_CLASS, "createSyncRiPortCandidateStruct()");
        String[] attributes = new String[]{"duNumber", "duRiPort"};
        StructImpl[] syncRiPortCandidateStructArray = new StructImpl[inSyncRiPortCandidateData.length];
        for (int i = 0; i < inSyncRiPortCandidateData.length; ++i) {
            Object[] syncRiPortCandidateStructValues = new Object[2];
            SyncRiPort syncRiPort = inSyncRiPortCandidateData[i];
            syncRiPortCandidateStructValues[0] = syncRiPort.getDuNumber();
            syncRiPortCandidateStructValues[1] = duRiPortMap.get(syncRiPort.getDuRiPort());
            syncRiPortCandidateStructArray[i] = new StructImpl(attributes, syncRiPortCandidateStructValues);
        }
        logger.traceReturn(THIS_CLASS, "createSyncRiPortCandidateStruct()");
        return syncRiPortCandidateStructArray;
    }

    public AttrListImpl createNodeGroupSyncMemberAttrList() {
        logger.traceEnter(THIS_CLASS, "createNodeGroupSyncMemberAttrList()");
        AttrListImpl attrList = new AttrListImpl();
        AttrListHelpers.addElementCheckNull("NodeGroupSyncMemberId", this.nodeGroupSyncMemberId, attrList);
        AttrListHelpers.addElementCheckNull("syncNodePriority", this.syncNodePriority, attrList);
        AttrListHelpers.addElementCheckNull("syncRiPortCandidate", this.syncRiPortCandidateStruct, attrList);
        logger.traceReturn(THIS_CLASS, "createNodeGroupSyncMemberAttrList()");
        return attrList;
    }

    public String getNodeGroupSyncMemberId() {
        return this.nodeGroupSyncMemberId;
    }

    public Integer getSyncNodePriority() {
        return this.syncNodePriority;
    }

    public StructImpl[] getSyncRiPortCandidate() {
        return this.syncRiPortCandidateStruct;
    }

    static {
        duRiPortMap.put("RI_PORT_A", new Integer(1));
        duRiPortMap.put("RI_PORT_B", new Integer(2));
        duRiPortMap.put("RI_PORT_C", new Integer(3));
        duRiPortMap.put("RI_PORT_D", new Integer(4));
        duRiPortMap.put("RI_PORT_E", new Integer(5));
        duRiPortMap.put("RI_PORT_F", new Integer(6));
    }
}

