/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.NodeGroupSyncMemberData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.PacketFrequencySyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.PacketTimeSyncRefData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class SynchronizationData {
    private static final Class THIS_CLASS = SynchronizationData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String IP = "ip";
    private transient Map syncPriorityRefMap;
    private transient String userLabel = "";
    private static final String DU_1 = "du-1";
    private static final String DU_2 = "du-2";
    private static final String GPS_1 = "gps-1";
    private static final String GPSOUT_1 = "gpsout-1";
    private static final String PT = "PT";
    private static final String PF = "PF";
    private static final String HPTSI_1 = "hptsi-1";
    private static final String GE_1 = "ge-1";
    private transient PacketFrequencySyncRefData[] packetFrequencySyncRefData;
    private transient PacketTimeSyncRefData[] packetTimeSyncRefData;
    private transient NodeGroupSyncMemberData nodeGroupSyncMemberData;
    private transient Integer telecomStandard;
    private transient Integer minQualityLevel;
    private transient Integer selectionProcessMode;
    private transient Map adminQualityData;
    private transient Map useReceiverQlData;

    public SynchronizationData(Map inSyncPriorityRefMap, String inUserLabel, PacketFrequencySyncRefData[] inPacketFrequencySyncRefData, PacketTimeSyncRefData[] inPacketTimeSyncRefData, NodeGroupSyncMemberData inNodeGroupSyncMemberData, String inTelecomStandard, String inMinQualityLevel, String inSelectionProcessMode, Map inAdminQualityData, Map inUseReceiverQlData) throws RbsConfigurationFailedException {
        this.syncPriorityRefMap = this.convertRefMapToLdn(inSyncPriorityRefMap);
        this.userLabel = inUserLabel;
        this.packetFrequencySyncRefData = inPacketFrequencySyncRefData;
        this.packetTimeSyncRefData = inPacketTimeSyncRefData;
        this.nodeGroupSyncMemberData = inNodeGroupSyncMemberData;
        this.telecomStandard = this.convertTelecomStandardToInteger(inTelecomStandard);
        this.minQualityLevel = this.convertMinQualityLevelToInteger(inMinQualityLevel);
        this.selectionProcessMode = this.convertSelectionProcessModeToInteger(inSelectionProcessMode);
        this.adminQualityData = this.convertAdminQualityDataToInteger(inAdminQualityData);
        this.useReceiverQlData = this.convertUseReceiverQlDataToInteger(inUseReceiverQlData);
    }

    public SynchronizationData(Map inSyncPriorityRefMap, String inUserLabel) throws RbsConfigurationFailedException {
        if (inSyncPriorityRefMap != null) {
            this.syncPriorityRefMap = this.convertRefMapToLdn(inSyncPriorityRefMap);
            this.adminQualityData = new HashMap(inSyncPriorityRefMap.size());
            this.useReceiverQlData = new HashMap(inSyncPriorityRefMap.size());
            Iterator adminQualityDataIterator = inSyncPriorityRefMap.entrySet().iterator();
            while (adminQualityDataIterator.hasNext()) {
                Map.Entry mapOutPutEntry = adminQualityDataIterator.next();
                this.adminQualityData.put(mapOutPutEntry.getKey(), (Integer)RbsConfigurationDefinitions.qLevelMap.get("NOT_DEFINED"));
                this.useReceiverQlData.put(mapOutPutEntry.getKey(), RbsConfigurationDefinitions.FALSE);
            }
        }
        this.userLabel = inUserLabel;
        this.telecomStandard = RbsConfigurationDefinitions.OPTION_I;
        this.minQualityLevel = (Integer)RbsConfigurationDefinitions.qLevelMap.get("NOT_DEFINED");
        this.selectionProcessMode = RbsConfigurationDefinitions.QL_DISABLED;
    }

    private Map convertAdminQualityDataToInteger(Map inAdminQualityData) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convertAdminQualityDataToInteger()");
        HashMap newAdminQuality = new HashMap();
        Iterator newAdminQualityDataIterator = inAdminQualityData.entrySet().iterator();
        while (newAdminQualityDataIterator.hasNext()) {
            Map.Entry mapOutPutEntry = newAdminQualityDataIterator.next();
            String adminQualityValue = (String)mapOutPutEntry.getValue();
            if (adminQualityValue == null) continue;
            newAdminQuality.put(mapOutPutEntry.getKey(), this.convertQualityLevelToInteger(adminQualityValue));
        }
        logger.traceReturn(THIS_CLASS, "convertAdminQualityDataToInteger()");
        return newAdminQuality;
    }

    private Map convertUseReceiverQlDataToInteger(Map inUseReceiverQlData) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convertUseReceiverQlDataToInteger()");
        HashMap newUseReceiverQl = new HashMap();
        Iterator useReceiverQlDataIterator = inUseReceiverQlData.entrySet().iterator();
        while (useReceiverQlDataIterator.hasNext()) {
            Map.Entry mapOutPutEntry = useReceiverQlDataIterator.next();
            String useReceiverQlValue = (String)mapOutPutEntry.getValue();
            if (useReceiverQlValue == null) continue;
            if (useReceiverQlValue.equals("FALSE")) {
                newUseReceiverQl.put(mapOutPutEntry.getKey(), RbsConfigurationDefinitions.FALSE);
                continue;
            }
            if (useReceiverQlValue.equals("TRUE")) {
                newUseReceiverQl.put(mapOutPutEntry.getKey(), RbsConfigurationDefinitions.TRUE);
                continue;
            }
            newUseReceiverQl.put(mapOutPutEntry.getKey(), RbsConfigurationDefinitions.FALSE);
        }
        logger.traceReturn(THIS_CLASS, "convertUseReceiverQlDataToInteger()");
        return newUseReceiverQl;
    }

    private Integer convertTelecomStandardToInteger(String inTelecomStandard) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convertTelecomStandardToInteger()");
        Integer newTelecomStandard = inTelecomStandard != null ? (inTelecomStandard.equals("OPTION_I") ? RbsConfigurationDefinitions.OPTION_I : (inTelecomStandard.equals("OPTION_II") ? RbsConfigurationDefinitions.OPTION_II : (inTelecomStandard.equals("OPTION_III") ? RbsConfigurationDefinitions.OPTION_III : RbsConfigurationDefinitions.OPTION_I))) : RbsConfigurationDefinitions.OPTION_I;
        logger.traceReturn(THIS_CLASS, "convertTelecomStandardToInteger()");
        return newTelecomStandard;
    }

    private Integer convertSelectionProcessModeToInteger(String inSelectionProcessMode) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convertSelectionProcessModeToInteger()");
        Integer newSelectionProcessMode = inSelectionProcessMode != null ? (inSelectionProcessMode.equals("QL_DISABLED") ? RbsConfigurationDefinitions.QL_DISABLED : (inSelectionProcessMode.equals("QL_ENABLED") ? RbsConfigurationDefinitions.QL_ENABLED : RbsConfigurationDefinitions.QL_DISABLED)) : RbsConfigurationDefinitions.QL_DISABLED;
        logger.traceReturn(THIS_CLASS, "convertSelectionProcessModeToInteger()");
        return newSelectionProcessMode;
    }

    private Integer convertMinQualityLevelToInteger(String inMinQualityLevel) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convertMinQualityLevelToInteger()");
        if (inMinQualityLevel != null) {
            logger.traceReturn(THIS_CLASS, "convertMinQualityLevelToInteger()");
            return this.convertQualityLevelToInteger(inMinQualityLevel);
        }
        logger.traceReturn(THIS_CLASS, "convertMinQualityLevelToInteger()");
        return null;
    }

    private Map convertRefMapToLdn(Map inSyncPriorityRefMap) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convertRefMapToLdn()");
        HashMap synchronizationDataRefMap = new HashMap();
        Iterator synchronizationIterator = inSyncPriorityRefMap.entrySet().iterator();
        while (synchronizationIterator.hasNext()) {
            Map.Entry mapOutPutEntry = synchronizationIterator.next();
            String syncPriorityRef = (String)mapOutPutEntry.getValue();
            if (syncPriorityRef == null) continue;
            String moLdn = this.convertSyncPriorityRefToLdn(syncPriorityRef);
            synchronizationDataRefMap.put(mapOutPutEntry.getKey(), moLdn);
        }
        logger.traceReturn(THIS_CLASS, "convertRefMapToLdn()");
        return synchronizationDataRefMap;
    }

    private String convertSyncPriorityRefToLdn(String syncPriorityRef) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convertSyncPriorityRefToLdn(), SyncPriorityRef = " + syncPriorityRef);
        String ldnBase = null;
        if (syncPriorityRef.toLowerCase(Locale.getDefault()).startsWith(DU_1)) {
            ldnBase = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,TimingUnit=1,TuSyncRef=";
        } else if (syncPriorityRef.toLowerCase(Locale.getDefault()).startsWith(DU_2)) {
            ldnBase = "ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=2,TimingUnit=1,TuSyncRef=";
        } else if (syncPriorityRef.toLowerCase(Locale.getDefault()).startsWith(GPS_1)) {
            ldnBase = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,TimingUnit=1,GpsSyncRef=";
        } else if (syncPriorityRef.toLowerCase(Locale.getDefault()).startsWith(GPSOUT_1)) {
            ldnBase = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,TimingUnit=1,GpsOutSyncLink=";
        } else if (syncPriorityRef.toLowerCase(Locale.getDefault()).startsWith(IP)) {
            String stringWithoutIp = syncPriorityRef.substring(syncPriorityRef.indexOf(45) + 1);
            String ipAccessHostEtId = stringWithoutIp.substring(0, syncPriorityRef.indexOf(45) - 1);
            ldnBase = "ManagedElement=1,IpSystem=1,IpAccessHostEt=" + ipAccessHostEtId + "," + "IpSyncRef" + "=";
        } else if (syncPriorityRef.toLowerCase(Locale.getDefault()).startsWith(PF.toLowerCase())) {
            ldnBase = "ManagedElement=1,TransportNetwork=1,Synchronization=1,PacketFrequencySyncRef=";
        } else if (syncPriorityRef.toLowerCase(Locale.getDefault()).startsWith(PT.toLowerCase())) {
            ldnBase = "ManagedElement=1,TransportNetwork=1,Synchronization=1,PacketTimeSyncRef=";
        } else if (syncPriorityRef.toLowerCase(Locale.getDefault()).startsWith(HPTSI_1)) {
            ldnBase = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,TimingUnit=1,HptsiSyncRef=";
        } else if (syncPriorityRef.toLowerCase(Locale.getDefault()).startsWith(GE_1)) {
            ldnBase = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=";
        } else {
            throw new RbsConfigurationFailedException("The Syncref MO with attribute: syncSlot = " + syncPriorityRef + " has an incorrect syntax.");
        }
        String syncRefId = syncPriorityRef.substring(syncPriorityRef.lastIndexOf(45) + 1);
        String syncRefLdn = ldnBase + syncRefId;
        logger.traceReturn(THIS_CLASS, "convertSyncPriorityRefToLdn(), moLdn = " + syncRefLdn);
        return syncRefLdn;
    }

    private Integer convertQualityLevelToInteger(String qualityLevel) {
        logger.traceEnter(THIS_CLASS, "convertQualityLevelToInteger()");
        Integer qualityLevelInteger = (Integer)RbsConfigurationDefinitions.qLevelMap.get(qualityLevel);
        if (qualityLevelInteger == null) {
            qualityLevelInteger = (Integer)RbsConfigurationDefinitions.qLevelMap.get("NOT_DEFINED");
        }
        logger.traceReturn(THIS_CLASS, "convertQualityLevelToInteger()");
        return qualityLevelInteger;
    }

    public Map getSyncPriorityRefMap() {
        return this.syncPriorityRefMap;
    }

    public void setSyncPriorityRefMap(Map syncPriorityRefMapIn) {
        this.syncPriorityRefMap = syncPriorityRefMapIn;
    }

    public String getUserLabel() {
        return this.userLabel;
    }

    public Integer getTelecomStandard() {
        return this.telecomStandard;
    }

    public Integer getMinQualityLevel() {
        return this.minQualityLevel;
    }

    public Integer getSelectionProcessMode() {
        return this.selectionProcessMode;
    }

    public Map getAdminQualityData() {
        return this.adminQualityData;
    }

    public Map getUseReceiverQlData() {
        return this.useReceiverQlData;
    }

    public void setUserLabel(String userLabelIn) {
        this.userLabel = userLabelIn;
    }

    public PacketFrequencySyncRefData[] getPacketFrequencySyncRefData() {
        return this.packetFrequencySyncRefData;
    }

    public void setPacketFrequencySyncRefData(PacketFrequencySyncRefData[] packetFrequencySyncRefDataIn) {
        this.packetFrequencySyncRefData = packetFrequencySyncRefDataIn;
    }

    public PacketTimeSyncRefData[] getPacketTimeSyncRefData() {
        return this.packetTimeSyncRefData;
    }

    public void setPacketTimeSyncRefData(PacketTimeSyncRefData[] packetTimeSyncRefDataIn) {
        this.packetTimeSyncRefData = packetTimeSyncRefDataIn;
    }

    public NodeGroupSyncMemberData getNodeGroupSyncMemberData() {
        return this.nodeGroupSyncMemberData;
    }
}

