/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure;

import java.io.IOException;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AttrListHelpers;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class VpnInterfaceData {
    private static final Class THIS_CLASS = VpnInterfaceData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private transient String vpnInterfaceId = "1";
    private final transient String ipAccessHostEtRefLdn;
    private final transient Integer networkPrefixLength;
    private transient String configurationMode = "MANUAL";
    private transient String ipVersion = "IP_V4";
    private transient String userLabel = "";
    private transient String subnet = null;

    public VpnInterfaceData(String inVpnInterfaceId, String inIpAccessHostEtRef, String inNetworkPrefixLength, String inConfigurationMode, String inIpVersion, String inUserLabel) throws IOException {
        if (inVpnInterfaceId != null) {
            this.vpnInterfaceId = inVpnInterfaceId;
        }
        this.ipAccessHostEtRefLdn = "ManagedElement=1,IpSystem=1,IpAccessHostEt=" + inIpAccessHostEtRef;
        this.networkPrefixLength = ParserHelper.convertIntegerAttribute((String)"networkPrefixLength", (String)inNetworkPrefixLength);
        this.configurationMode = inConfigurationMode;
        this.ipVersion = inIpVersion;
        this.userLabel = inUserLabel;
    }

    public AttrListImpl createVpnInterfaceAttrList(ManagedObject referencedVpnInterface) {
        logger.traceEnter(THIS_CLASS, "createVpnInterfaceAttrList()");
        AttrListImpl attrList = new AttrListImpl();
        Integer manual = RbsConfigurationDefinitions.VPN_INTERFACE_CONF_MODE_MANUAL;
        Integer ike = RbsConfigurationDefinitions.VPN_INTERFACE_CONF_MODE_IKE;
        Integer configurationModeIntVal = null;
        Integer ipv4 = RbsConfigurationDefinitions.VPN_INTERFACE_IP_VERSION_V4;
        Integer ipv6 = RbsConfigurationDefinitions.VPN_INTERFACE_IP_VERSION_V6;
        Integer ipVersionIntVal = null;
        AttrListHelpers.addElementCheckNull("userLabel", this.userLabel, attrList);
        AttrListHelpers.addElementCheckNull("ipAccessHostEtRef", referencedVpnInterface, attrList);
        configurationModeIntVal = this.configurationMode != null && this.configurationMode.compareTo("IKE") == 0 ? ike : manual;
        AttrListHelpers.addElementCheckNull("configurationMode", configurationModeIntVal, attrList);
        ipVersionIntVal = this.ipVersion != null && this.ipVersion.compareTo("IP_V6") == 0 ? ipv6 : ipv4;
        AttrListHelpers.addElementCheckNull("ipVersion", ipVersionIntVal, attrList);
        logger.traceReturn(THIS_CLASS, "createVpnInterfaceAttrList()");
        return attrList;
    }

    public String getVpnInterfaceId() {
        return this.vpnInterfaceId;
    }

    public void setVpnInterfaceId(String vpnInterfaceIdIn) {
        this.vpnInterfaceId = vpnInterfaceIdIn;
    }

    public String getIpAccessHostEtRefLdn() {
        return this.ipAccessHostEtRefLdn;
    }

    public Integer getNetworkPrefixLength() {
        return this.networkPrefixLength;
    }

    public String getUserLabel() {
        return this.userLabel;
    }

    public void setUserLabel(String userLabelIn) {
        this.userLabel = userLabelIn;
    }

    public String getSubnet() {
        return this.subnet;
    }

    public void setSubnet(String subnetIn) {
        this.subnet = subnetIn;
    }

    public String getConfigurationMode() {
        return this.configurationMode;
    }

    public void setConfigurationMode(String configurationModeIn) {
        this.configurationMode = configurationModeIn;
    }

    public String getIpVersion() {
        return this.ipVersion;
    }

    public void setIpVersion(String ipVersionIn) {
        this.ipVersion = ipVersionIn;
    }
}

