/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.interfaces.RetAntennaConfigurationFileSender;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationSmrsHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.AbstractConfigureRetProfileThread;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.RetSubUnitParser;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.RetSubUnitParserFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.RetSubUnitParserImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.smrs.SmrsInfo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.logger.ConfigurationReportLogger;
import se.ericsson.crbs.omf.mao.indications.avc.AvcRegistratorFactoryImpl;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class ConfigureRetProfileThreadImpl
extends AbstractConfigureRetProfileThread
implements AvcSubscriber {
    private static final int DEFAULT_MAX_WAITING_TIME = 10000;
    private static final int MAX_WAITING_TIME;
    protected static final String CALIBRATION_STATUS_ATTR = "calibrationStatus";
    protected static final String THREAD_NAME = "CRBS_lmCatOamLmU_RbsConfiguration_configureRetProfileThread";
    protected static final Object WAITING_MUTEX;
    private static final Class THIS_CLASS;
    private static final AbstractLogger logger;
    protected static final int UNKNOWN = 0;
    protected static final int STARTED = 1;
    protected static final int FINISHED = 2;
    protected static final int FAILED = 3;
    protected static final String[] CALIBRATION_STATUS_VALUES;
    private static final String RBS_CONFIGURATION_REPORT_LOG_SLOGAN = "Load RET-profile and perform calibration status:";
    private final RbsConfigurationMao rbsConfigurationMao;
    private final MoRepositoryWrapper moRepositoryWrapper;
    private final RbsConfigurationContext rbsConfigurationContext;
    private final ProgressReportHandler progressReportHandler;
    private final ConfigurationReportLogger rbsConfigurationReportLogger;
    private final StringBuffer configFileProgressMessage;
    private boolean oneOrMoreFailed = false;
    private final Map calibrationStatusProgress = new HashMap();
    private boolean hasBeenStarted = false;
    private boolean hasFinsihed = false;
    protected boolean reRunRequested = false;
    private Thread runningThread;

    public ConfigureRetProfileThreadImpl(RbsConfigurationMao inRbsConfigurationMao) {
        super(THREAD_NAME);
        this.rbsConfigurationMao = inRbsConfigurationMao;
        this.rbsConfigurationContext = this.rbsConfigurationMao.getRbsConfigurationContext();
        this.moRepositoryWrapper = this.rbsConfigurationContext.getGenericMaoContext().getMoRepositoryWrapper();
        this.configFileProgressMessage = new StringBuffer();
        this.progressReportHandler = ProgressReportHandler.getInstance();
        this.rbsConfigurationReportLogger = ConfigurationReportLoggerFactory.getLogger();
    }

    public Thread getThread() {
        return this.runningThread;
    }

    public void start() {
        Thread newThread = new Thread((Runnable)this, this.threadName);
        newThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.traceEnter(THIS_CLASS, "run()");
        try {
            if (this.hasFinsihed) {
                logger.traceGeneral(THIS_CLASS, "This thread has already been run and finished at least once. Re-run requested.");
            } else if (this.hasBeenStarted && this.runningThread != null) {
                logger.traceAbnormal(THIS_CLASS, "This thread has already been run - re-run requested.");
                this.reRunRequested = true;
                try {
                    logger.traceGeneral(THIS_CLASS, "Waiting for previous run to finish first");
                    this.runningThread.join();
                }
                catch (InterruptedException e) {
                    logger.traceAbnormal(THIS_CLASS, "Previous thread interrupted");
                }
                logger.traceGeneral(THIS_CLASS, "Previous run to finish. Running again");
            }
            this.hasBeenStarted = true;
            this.reRunRequested = false;
            this.runningThread = Thread.currentThread();
            this.configureRetProfile();
        }
        finally {
            this.hasFinsihed = true;
        }
        logger.traceReturn(THIS_CLASS, "run()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureRetProfile() {
        logger.traceEnter(THIS_CLASS, "configureRetProfile()");
        String siteEquipmentFilePath = FileParameters.instance(this.rbsConfigurationMao).getSiteEquipmentFilePath();
        try {
            RetSubUnitParser retSubUnitParser = RetSubUnitParserFactory.getInstance().getRetSubUnitParser(this.rbsConfigurationMao);
            RetSubUnitParserImpl.AntennaConfigurationFileHolder[] antennaConfigurationFileHolders = retSubUnitParser.parseAntennaConfigurationFiles(siteEquipmentFilePath);
            if (antennaConfigurationFileHolders.length == 0) {
                this.updateProgressReportInformation(2, "No antenna configuration files specified");
            } else {
                this.runConfigurationFiles(antennaConfigurationFileHolders);
                this.launchSubscription();
                this.waitForCalibrationStatusNotifications();
            }
        }
        catch (Exception e) {
            String errorMsg = ExceptionHelper.appendReason((String)"Failed to calibrate antennas", (Throwable)e);
            this.updateProgressReportInformation(6, errorMsg);
        }
        finally {
            AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, "RetSubUnit", CALIBRATION_STATUS_ATTR);
        }
        logger.traceReturn(THIS_CLASS, "configureRetProfile()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCalibrationStatusNotifications() {
        block10: {
            String message;
            long startTime;
            logger.traceEnter(THIS_CLASS, "waitForCalibrationStatusNotifications()");
            do {
                startTime = System.currentTimeMillis();
                Object object = WAITING_MUTEX;
                synchronized (object) {
                    try {
                        WAITING_MUTEX.notifyAll();
                        WAITING_MUTEX.wait(MAX_WAITING_TIME);
                    }
                    catch (Exception e) {
                        logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)"Failed to wait for next notification", (Throwable)e));
                    }
                }
                if (this.reRunRequested) {
                    message = "\nCalibration of antennas will be re-run. Result will not be check unil after re-run";
                    this.updateProgressReportInformation(true, "\nCalibration of antennas will be re-run. Result will not be check unil after re-run");
                    this.logInformationInConfigurationReport("\nCalibration of antennas will be re-run. Result will not be check unil after re-run");
                } else if (this.allFinished()) {
                    message = "\nAll calibrated successfully";
                    StringBuffer tmpBuf = this.getProgressMessage("\nAll calibrated successfully");
                    this.updateProgressReportInformation(true, tmpBuf.toString());
                    this.logInformationInConfigurationReport(tmpBuf.toString());
                } else {
                    if (!this.allFinishedOrFailed()) continue;
                    this.logInformationInConfigurationReport(this.getProgressMessage(null).toString());
                }
                break block10;
            } while (!this.activityOnGoing(startTime));
            message = "\nNo calibration ongoing and supervising timer has timed out after " + (double)MAX_WAITING_TIME / 1000.0 + " sec.";
            logger.traceAbnormal(THIS_CLASS, message);
            this.logInformationInConfigurationReport(this.getProgressMessage(message).toString());
        }
        logger.traceReturn(THIS_CLASS, "waitForCalibrationStatusNotifications()");
    }

    private boolean activityOnGoing(long startTime) {
        return System.currentTimeMillis() - startTime >= (long)MAX_WAITING_TIME && !this.oneOrMoreStarted();
    }

    private void logInformationInConfigurationReport(String message) {
        this.rbsConfigurationReportLogger.logInformation(RBS_CONFIGURATION_REPORT_LOG_SLOGAN, message);
    }

    private StringBuffer getProgressMessage(String message) {
        StringBuffer tmpBuf = new StringBuffer(5000);
        tmpBuf.append(this.configFileProgressMessage);
        tmpBuf.append(this.getCalibrationProgressMessage());
        if (message != null) {
            tmpBuf.append(message);
        }
        return tmpBuf;
    }

    private boolean allFinished() {
        Iterator values = this.calibrationStatusProgress.values().iterator();
        boolean allAreFinished = true;
        while (values.hasNext()) {
            if (values.next().toString().equalsIgnoreCase(CALIBRATION_STATUS_VALUES[2])) continue;
            allAreFinished = false;
            break;
        }
        return allAreFinished;
    }

    private boolean allFinishedOrFailed() {
        Iterator values = this.calibrationStatusProgress.values().iterator();
        boolean allAreFinishedOrFailed = true;
        while (values.hasNext()) {
            Object nextValue = values.next();
            if (!nextValue.toString().equalsIgnoreCase(CALIBRATION_STATUS_VALUES[0]) && !nextValue.toString().equalsIgnoreCase(CALIBRATION_STATUS_VALUES[1])) continue;
            allAreFinishedOrFailed = false;
            break;
        }
        return allAreFinishedOrFailed;
    }

    private boolean oneOrMoreStarted() {
        Iterator values = this.calibrationStatusProgress.values().iterator();
        boolean foundStarted = false;
        while (values.hasNext()) {
            if (!values.next().toString().equalsIgnoreCase(CALIBRATION_STATUS_VALUES[1])) continue;
            foundStarted = true;
            break;
        }
        return foundStarted;
    }

    private void launchSubscription() throws MoAccessException {
        this.fetchCurrentCalibrationStatus(null);
        AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, "RetSubUnit", CALIBRATION_STATUS_ATTR);
    }

    private void runConfigurationFiles(RetSubUnitParserImpl.AntennaConfigurationFileHolder[] antennaConfigurationFileHolders) {
        logger.traceEnter(THIS_CLASS, "runConfigurationFiles()");
        RbsConfigurationSmrsHelper rbsConfigurationSmrsHelper = (RbsConfigurationSmrsHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationSmrsHelper.class);
        SmrsInfo smrsInfo = rbsConfigurationSmrsHelper.getSmrsInfo();
        for (int i = 0; i < antennaConfigurationFileHolders.length; ++i) {
            RetAntennaConfigurationFileSender retAntennaConfigurationFileSender = (RetAntennaConfigurationFileSender)this.moRepositoryWrapper.lookup(antennaConfigurationFileHolders[i].ldn);
            this.updateProgressReportInformation(3, "Activating antenna configuration files");
            ActionTransactionPackage actionTransactionPackage = new ActionTransactionPackage(retAntennaConfigurationFileSender, smrsInfo, antennaConfigurationFileHolders[i].antennaConfigurationFile);
            try {
                TransactionHandler.run(actionTransactionPackage);
                continue;
            }
            catch (RbsConfigurationFailedException rcfe) {
                this.logSendConfigFileProgress(retAntennaConfigurationFileSender.getLocalDistinguishedName(), antennaConfigurationFileHolders[i].antennaConfigurationFile, (Exception)((Object)rcfe));
            }
        }
        logger.traceReturn(THIS_CLASS, "runConfigurationFiles()");
    }

    protected void logSendConfigFileProgress(String ldn, String antennaConfigurationFile, Exception exception) {
        if (exception == null) {
            this.configFileProgressMessage.append("Successful download of ");
            this.configFileProgressMessage.append(StringHelper.doubleQuote((String)antennaConfigurationFile));
            this.configFileProgressMessage.append(" to: ");
            this.configFileProgressMessage.append(ldn);
            this.configFileProgressMessage.append('\n');
        } else {
            this.oneOrMoreFailed = true;
            this.configFileProgressMessage.append("Failed download of ");
            this.configFileProgressMessage.append(StringHelper.doubleQuote((String)antennaConfigurationFile));
            this.configFileProgressMessage.append(" to: ");
            this.configFileProgressMessage.append(ldn);
            this.configFileProgressMessage.append('\n');
        }
        this.updateProgressReportInformation(false, this.configFileProgressMessage.toString());
    }

    private void logCalibratingProgress(String ldn, int calibrationStatus) {
        this.calibrationStatusProgress.put(ldn, CALIBRATION_STATUS_VALUES[calibrationStatus]);
        if (calibrationStatus == 3) {
            this.oneOrMoreFailed = true;
        }
        StringBuffer tmpBuf = new StringBuffer(5000);
        tmpBuf.append(this.configFileProgressMessage);
        tmpBuf.append(this.getCalibrationProgressMessage());
        this.updateProgressReportInformation(false, tmpBuf.toString());
    }

    private String getCalibrationProgressMessage() {
        StringBuffer resultBuf = new StringBuffer(1000);
        Iterator entrySet = this.calibrationStatusProgress.entrySet().iterator();
        while (entrySet.hasNext()) {
            Map.Entry entry = entrySet.next();
            resultBuf.append("Calibration of: ");
            resultBuf.append(StringHelper.doubleQuote((String)entry.getKey().toString()));
            resultBuf.append(" - ");
            resultBuf.append(entry.getValue().toString());
            resultBuf.append('\n');
        }
        return resultBuf.toString();
    }

    private void updateProgressReportInformation(boolean allFinished, String message) {
        int finishedOrWarningStatus = allFinished ? 5 : 3;
        int status = this.oneOrMoreFailed ? 6 : finishedOrWarningStatus;
        this.updateProgressReportInformation(status, message);
    }

    private void updateProgressReportInformation(int status, String message) {
        this.progressReportHandler.updateProgressReportInformation(2575, status, message, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportAvc(String ldn, String attributeName, Object attributeValue, Coordinator coordinator) {
        Object object = WAITING_MUTEX;
        synchronized (object) {
            if (CALIBRATION_STATUS_ATTR.equalsIgnoreCase(attributeName) && attributeValue instanceof Integer) {
                Integer intValue = (Integer)attributeValue;
                this.logCalibratingProgress(ldn, intValue);
            }
            WAITING_MUTEX.notifyAll();
        }
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.fetchCurrentCalibrationStatus(coordinator);
    }

    private void fetchCurrentCalibrationStatus(Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        MoIterator moIterator = this.moRepositoryWrapper.lookupType("RetSubUnit");
        while (moIterator.hasMoreElements()) {
            ManagedObject retSubUnitMo = moIterator.nextMo();
            Object calirationStatus = retSubUnitMo.getAttribute(CALIBRATION_STATUS_ATTR, coordinator);
            this.reportAvc(retSubUnitMo.getLocalDistinguishedName(), CALIBRATION_STATUS_ATTR, calirationStatus, coordinator);
        }
    }

    static {
        int waitingTime = 10000;
        if ("true".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            waitingTime = 500;
        }
        MAX_WAITING_TIME = waitingTime;
        WAITING_MUTEX = new Object();
        THIS_CLASS = ConfigureRetProfileThreadImpl.class;
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
        CALIBRATION_STATUS_VALUES = new String[]{"UNKNOWN", "STARTED", "FINISHED", "FAILED"};
    }

    private class ActionTransactionPackage
    implements TransactionPackage {
        private final RetAntennaConfigurationFileSender retAntennaConfigurationFileSender;
        private final SmrsInfo smrsInfo;
        private final String antennaConfigurationFile;

        public ActionTransactionPackage(RetAntennaConfigurationFileSender theRetAntennaConfigurationFileSender, SmrsInfo theSmrsInfo, String theAntennaConfigurationFile) {
            this.retAntennaConfigurationFileSender = theRetAntennaConfigurationFileSender;
            this.smrsInfo = theSmrsInfo;
            this.antennaConfigurationFile = theAntennaConfigurationFile;
        }

        public void execute(Coordinator coordinator) throws MoAccessException {
            String ldn = this.retAntennaConfigurationFileSender.getLocalDistinguishedName();
            ConfigureRetProfileThreadImpl.this.calibrationStatusProgress.put(ldn, CALIBRATION_STATUS_VALUES[0]);
            String smrsServer = this.smrsInfo.getSmrsServer();
            String smrsUserName = this.smrsInfo.getSmrsUserName();
            String smrsPassword = this.smrsInfo.getSmrsPassword();
            this.retAntennaConfigurationFileSender.actionSendAntennaConfigurationFile(smrsServer, this.antennaConfigurationFile, smrsUserName, smrsPassword, coordinator);
            this.logActionInConfigurationReport(smrsServer, smrsUserName);
            ConfigureRetProfileThreadImpl.this.logSendConfigFileProgress(ldn, this.antennaConfigurationFile, null);
        }

        private void logActionInConfigurationReport(String smrsServer, String smrsUserName) {
            String[] attributesNames = new String[]{"server", "path", "userName", "password"};
            Object[] attributeValues = new String[]{smrsServer, this.antennaConfigurationFile, smrsUserName, "***"};
            ConfigureRetProfileThreadImpl.this.rbsConfigurationReportLogger.logAction(this.retAntennaConfigurationFileSender.getType(), "actionSendAntennaConfigurationFile", attributesNames, attributeValues);
        }

        public void handleExecutionException(Exception exception) {
            ConfigureRetProfileThreadImpl.this.logSendConfigFileProgress(this.retAntennaConfigurationFileSender.getLocalDistinguishedName(), this.antennaConfigurationFile, exception);
        }

        public void handleTransactionException(Exception exception) {
            ConfigureRetProfileThreadImpl.this.logSendConfigFileProgress(this.retAntennaConfigurationFileSender.getLocalDistinguishedName(), this.antennaConfigurationFile, exception);
        }
    }
}

