/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.helpers.AttributesImpl;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.AntennaEquipmentData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.PositionCoordinatesData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.RadioDotUnitData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.RadioEquipmentData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.RadioUnitData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.RiPortData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.SectorEquipmentData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class CreateSectorEquipments {
    private static final Class THIS_CLASS = CreateSectorEquipments.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private HashSet siteRadioDotUnitIds = new HashSet();
    private HashSet siteRadioDotUnitRdiPortRefs = new HashSet();
    private HashSet siteRadioUnits = new HashSet();

    public SectorEquipmentData[] createSectorEquipments(Map typeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createSectorEquipments()");
        ArrayList<SectorEquipmentData> sectorEquipments = new ArrayList<SectorEquipmentData>();
        String xmlTag = "SectorEquipment".toLowerCase(Locale.getDefault());
        if (typeElementMap.containsKey(xmlTag)) {
            Iterator iter = ((List)typeElementMap.get(xmlTag)).iterator();
            while (iter.hasNext()) {
                XMLElement xmlChild = (XMLElement)iter.next();
                SectorEquipmentData sectorEquipment = this.parseSectorEquipment(xmlChild);
                sectorEquipments.add(sectorEquipment);
            }
        }
        SectorEquipmentData[] sectorEquipmentArr = new SectorEquipmentData[sectorEquipments.size()];
        sectorEquipments.toArray(sectorEquipmentArr);
        logger.traceReturn(THIS_CLASS, "createSectorEquipments()");
        return sectorEquipmentArr;
    }

    private SectorEquipmentData parseSectorEquipment(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseSectorEquipment()");
        String sectorFunctionId = null;
        String defaultConfiguredOutputPower = "20000";
        String configuredOutputPower = "20000";
        String mixedModeRadio = null;
        AntennaEquipmentData antennaEquipment = null;
        RadioEquipmentData radioEquipment = null;
        String txPowerPersistentLock = null;
        AttributesImpl attributes = xmlElement.getAttributes();
        Map attrNameValueMap = ParserHelper.createAttrNameValueMap(attributes);
        sectorFunctionId = this.getStringValueEmptyStringToNull(attrNameValueMap, "SectorFunctionId");
        configuredOutputPower = this.getStringValueEmptyStringToDefault(attrNameValueMap, "configuredOutputPower", "20000");
        Integer intConfiguredOutputPower = ParserHelper.convertIntegerAttribute((String)"SectorEquipment.configuredOutputPower", (String)configuredOutputPower);
        mixedModeRadio = this.getStringValueEmptyStringToNull(attrNameValueMap, "mixedModeRadio");
        txPowerPersistentLock = this.getStringValueEmptyStringToNull(attrNameValueMap, "txPowerPersistentLock");
        ParserHelper.checkMandatoryAttribute((String)"SectorEquipment.SectorFunctionId", (String)sectorFunctionId);
        Map typeElementMap = ParserHelper.createXmlTypeElementMap(xmlElement.getChildren());
        antennaEquipment = this.createAntennaEquipment(typeElementMap);
        radioEquipment = this.createRadioEquipment(typeElementMap);
        logger.traceReturn(THIS_CLASS, "parseSectorEquipment()");
        return new SectorEquipmentData(antennaEquipment, radioEquipment, sectorFunctionId, intConfiguredOutputPower, mixedModeRadio, txPowerPersistentLock);
    }

    private RadioEquipmentData createRadioEquipment(Map typeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createRadioEquipment()");
        RadioEquipmentData radioEquipment = null;
        String xmlTag = "RadioEquipment".toLowerCase(Locale.getDefault());
        if (typeElementMap.containsKey(xmlTag)) {
            List elements = (List)typeElementMap.get(xmlTag);
            if (elements.size() > 1) {
                throw new IOException("Invalid XML file: SectorEquipment.RadioEquipment is out of bounds. Min: 1 Max: 1.");
            }
            radioEquipment = this.parseRadioEquipment((XMLElement)elements.get(0));
        } else {
            logger.info(THIS_CLASS, "createRadioEquipment() SectorEquipment.RadioEquipment missing.");
        }
        logger.traceReturn(THIS_CLASS, "createRadioEquipment()");
        return radioEquipment;
    }

    private AntennaEquipmentData createAntennaEquipment(Map typeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createAntennaEquipment()");
        AntennaEquipmentData antennaEquipment = null;
        String xmlTag = "AntennaEquipment".toLowerCase(Locale.getDefault());
        if (typeElementMap.containsKey(xmlTag)) {
            List elements = (List)typeElementMap.get(xmlTag);
            if (elements.size() > 1) {
                throw new IOException("Invalid XML file: SectorEquipment.AntennaEquipment is out of bounds. Min: 1 Max: 1.");
            }
            antennaEquipment = this.parseAntennaEquipment((XMLElement)elements.get(0));
        }
        logger.traceReturn(THIS_CLASS, "createAntennaEquipment()");
        return antennaEquipment;
    }

    private RadioEquipmentData parseRadioEquipment(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseRadioEquipment()");
        List xmlChildren = xmlElement.getChildren();
        Map typeElementMap = ParserHelper.createXmlTypeElementMap(xmlChildren);
        Object[] radioUnitArr = this.createRadioUnit(typeElementMap);
        Object[] radioDotUnitArr = this.createRadioDotUnit(typeElementMap);
        ParserHelper.checkCardinality("SectorEquipment.RadioEquipment.RadioUnit", radioUnitArr, 1, Integer.MAX_VALUE);
        ParserHelper.checkCardinality("SectorEquipment.RadioEquipment.RadioDotUnit", radioDotUnitArr, 0, Integer.MAX_VALUE);
        logger.traceReturn(THIS_CLASS, "parseRadioEquipment()");
        if (radioDotUnitArr.length != 0) {
            return new RadioEquipmentData((RadioUnitData[])radioUnitArr, (RadioDotUnitData[])radioDotUnitArr);
        }
        return new RadioEquipmentData((RadioUnitData[])radioUnitArr);
    }

    private RadioUnitData[] createRadioUnit(Map typeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createRadioUnit()");
        ArrayList<RadioUnitData> radioUnits = new ArrayList<RadioUnitData>();
        String xmlTag = "RadioUnit".toLowerCase(Locale.getDefault());
        if (typeElementMap.containsKey(xmlTag)) {
            List elements = (List)typeElementMap.get(xmlTag);
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                XMLElement xmlChild = (XMLElement)iter.next();
                RadioUnitData radioUnit = this.parseRadioUnit(xmlChild);
                radioUnits.add(radioUnit);
            }
        }
        RadioUnitData[] radioUnitArr = new RadioUnitData[radioUnits.size()];
        radioUnits.toArray(radioUnitArr);
        logger.traceReturn(THIS_CLASS, "createRadioUnit()");
        return radioUnitArr;
    }

    private RadioDotUnitData[] createRadioDotUnit(Map typeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createRadioDotUnit()");
        ArrayList<RadioDotUnitData> radioDotUnits = new ArrayList<RadioDotUnitData>();
        String xmlTag = "RadioDotUnit".toLowerCase(Locale.getDefault());
        if (typeElementMap.containsKey(xmlTag)) {
            List elements = (List)typeElementMap.get(xmlTag);
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                XMLElement xmlChild = (XMLElement)iter.next();
                RadioDotUnitData radioDotUnit = this.parseRadioDotUnit(xmlChild);
                if (!this.siteRadioDotUnitIds.add(radioDotUnit.unitId)) {
                    throw new IOException("duplicated unitId " + radioDotUnit.unitId + " found for " + "RadioDotUnit");
                }
                if (!this.siteRadioDotUnitRdiPortRefs.add(radioDotUnit.rdiPortRef)) {
                    throw new IOException("duplicated rdiPortRef " + radioDotUnit.rdiPortRef + " found for " + "RadioDotUnit");
                }
                if (!this.siteRadioUnits.contains(radioDotUnit.getReferencedIru())) {
                    throw new IOException("rdiPortRef of RadioDotUnit " + radioDotUnit.unitId + " is referencing non existing " + "RadioUnit" + " " + radioDotUnit.getReferencedIru());
                }
                radioDotUnits.add(radioDotUnit);
            }
        }
        RadioDotUnitData[] radioDotUnitArr = new RadioDotUnitData[radioDotUnits.size()];
        radioDotUnits.toArray(radioDotUnitArr);
        logger.traceReturn(THIS_CLASS, "createRadioDotUnit()");
        return radioDotUnitArr;
    }

    private AntennaEquipmentData parseAntennaEquipment(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseAntennaEquipment()");
        List xmlChildren = xmlElement.getChildren();
        Map typeElementMap = ParserHelper.createXmlTypeElementMap(xmlChildren);
        Object[] rbBranchRefArr = this.createRfBranch(typeElementMap);
        ParserHelper.checkCardinality("SectorEquipment.AntennaEquipment.rfBranchRef", rbBranchRefArr, 0, 24);
        logger.traceReturn(THIS_CLASS, "parseAntennaEquipment()");
        return new AntennaEquipmentData((String[])rbBranchRefArr);
    }

    private String[] createRfBranch(Map typeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createRfBranch()");
        ArrayList<String> rfBranchRefs = new ArrayList<String>();
        String xmlTag = "rfBranchRef".toLowerCase(Locale.getDefault());
        if (typeElementMap.containsKey(xmlTag)) {
            List elements = (List)typeElementMap.get(xmlTag);
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                XMLElement xmlChild = (XMLElement)iter.next();
                String rfBranchRef = this.parseRfBranchRef(xmlChild);
                rfBranchRefs.add(rfBranchRef);
            }
        }
        String[] rbBranchRefArr = rfBranchRefs.toArray(new String[rfBranchRefs.size()]);
        logger.traceReturn(THIS_CLASS, "createRfBranch()");
        return rbBranchRefArr;
    }

    private String parseRfBranchRef(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseRfBranchRef()");
        String rfBranchId = null;
        AttributesImpl attributes = xmlElement.getAttributes();
        Map attrNameValueMap = ParserHelper.createAttrNameValueMap(attributes);
        rfBranchId = this.getStringValueEmptyStringToNull(attrNameValueMap, "rfBranchId");
        ParserHelper.checkMandatoryAttribute((String)"SectorEquipment.AntennaEquipment.rfBranchRef.rfBranchId", (String)rfBranchId);
        logger.traceReturn(THIS_CLASS, "parseRfBranchRef()");
        return rfBranchId;
    }

    private RadioUnitData parseRadioUnit(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseRadioUnit()");
        AttributesImpl attributes = xmlElement.getAttributes();
        Map attrNameValueMap = ParserHelper.createAttrNameValueMap(attributes);
        String unitId = this.getStringValueEmptyStringToNull(attrNameValueMap, "unitId");
        String primaryPort = this.getStringValueEmptyStringToNull(attrNameValueMap, "primaryPort");
        String positionRef = this.getStringValueEmptyStringToNull(attrNameValueMap, "positionRef");
        String secondaryPort = this.getStringValueEmptyStringToNull(attrNameValueMap, "secondaryPort");
        ParserHelper.checkMandatoryAttribute((String)"SectorEquipment.RadioEquipment.RadioUnit.unitId", (String)unitId);
        RadioUnitData rud = new RadioUnitData(unitId, positionRef);
        if (primaryPort != null) {
            rud.addRiPort(new RiPortData("DATA_1", primaryPort));
        }
        if (secondaryPort != null) {
            rud.addRiPort(new RiPortData("DATA_2", secondaryPort));
        }
        this.siteRadioUnits.add(unitId);
        List riPorts = xmlElement.getChildren();
        for (int riPortsIndex = 0; riPortsIndex < riPorts.size(); ++riPortsIndex) {
            XMLElement riPort = (XMLElement)riPorts.get(riPortsIndex);
            if (!riPort.getType().equalsIgnoreCase("RiPort")) continue;
            Map riPortAttrNameValueMap = ParserHelper.createAttrNameValueMap(riPort.getAttributes());
            String id = this.getStringValueEmptyStringToNull(riPortAttrNameValueMap, "id");
            String ref = this.getStringValueEmptyStringToNull(riPortAttrNameValueMap, "ref");
            if (id == null || ref == null) continue;
            rud.addRiPort(new RiPortData(id, ref));
        }
        logger.traceReturn(THIS_CLASS, "parseRadioUnit()");
        return rud;
    }

    private RadioDotUnitData parseRadioDotUnit(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseRadioDotUnit()");
        AttributesImpl attributes = xmlElement.getAttributes();
        Map attrNameValueMap = ParserHelper.createAttrNameValueMap(attributes);
        String unitId = this.getStringValueEmptyStringToNull(attrNameValueMap, "unitId");
        String rdiPortRef = this.getStringValueEmptyStringToNull(attrNameValueMap, "rdiPortRef");
        String positionInformation = this.getStringValueEmptyStringToNull(attrNameValueMap, "positionInformation");
        ParserHelper.checkMandatoryAttribute((String)"SectorEquipment.RadioEquipment.RadioDotUnit.unitId", (String)unitId);
        ParserHelper.checkMandatoryAttribute((String)"SectorEquipment.RadioEquipment.RadioDotUnit.rdiPortRef", (String)rdiPortRef);
        RadioDotUnitData rdud = positionInformation != null ? new RadioDotUnitData(unitId, rdiPortRef, positionInformation) : new RadioDotUnitData(unitId, rdiPortRef);
        List positionCoordinates = xmlElement.getChildren();
        for (int positionCoordinatesIndex = 0; positionCoordinatesIndex < positionCoordinates.size(); ++positionCoordinatesIndex) {
            XMLElement positionCoordinate = (XMLElement)positionCoordinates.get(positionCoordinatesIndex);
            if (!positionCoordinate.getType().equalsIgnoreCase("PositionCoordinates")) continue;
            Map positionCoordinatesAttrNameValueMap = ParserHelper.createAttrNameValueMap(positionCoordinate.getAttributes());
            String longitude = this.getStringValueEmptyStringToNull(positionCoordinatesAttrNameValueMap, "longitude");
            String latitude = this.getStringValueEmptyStringToNull(positionCoordinatesAttrNameValueMap, "latitude");
            String altitude = this.getStringValueEmptyStringToNull(positionCoordinatesAttrNameValueMap, "altitude");
            String geoDatum = this.getStringValueEmptyStringToNull(positionCoordinatesAttrNameValueMap, "geoDatum");
            if (longitude == null || latitude == null || altitude == null || geoDatum == null) continue;
            rdud.addPositionCoordinates(new PositionCoordinatesData(longitude, latitude, altitude, geoDatum));
        }
        logger.traceReturn(THIS_CLASS, "parseRadioDotUnit()");
        return rdud;
    }

    private String getStringValueEmptyStringToNull(Map attrNameValueMap, String key) {
        String value = StringHelper.emptyStringToNull((String)((String)attrNameValueMap.get(key.toLowerCase(Locale.getDefault()))));
        return value;
    }

    private String getStringValueEmptyStringToDefault(Map attrNameValueMap, String key, String defaultValue) {
        String value = StringHelper.emptyStringToDefault((String)((String)attrNameValueMap.get(key.toLowerCase(Locale.getDefault()))), (String)defaultValue);
        return value;
    }
}

