/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment;

import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.PlugInUnitFinder;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class PiuTypeFinder {
    private static final Class THIS_CLASS = PiuTypeFinder.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    private PiuTypeFinder() {
    }

    public static final PiuTypeAccess findPiuType(String productName, MoRepositoryWrapper aMoRepository, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "findPiuType(productName) - productName = " + productName);
        PiuTypeAccess result2 = null;
        if (PiuTypeFinder.isRadioUnit(productName)) {
            result2 = (PiuTypeAccess)aMoRepository.lookup("ManagedElement=1,SwManagement=1,PiuType=INITIALRBSRU_*");
        } else if (PiuTypeFinder.isRemoteRadioUnit(productName)) {
            result2 = (PiuTypeAccess)aMoRepository.lookup("ManagedElement=1,SwManagement=1,PiuType=INITIALRBSRRU_*");
        } else if (PiuTypeFinder.isIndoorRadioUnit(productName)) {
            result2 = (PiuTypeAccess)aMoRepository.lookup("ManagedElement=1,SwManagement=1,PiuType=INITIALRBSIRU_*");
        } else if (PiuTypeFinder.isRadioDotUnit(productName)) {
            result2 = (PiuTypeAccess)aMoRepository.lookup("ManagedElement=1,SwManagement=1,PiuType=INITIALRBSRD_*");
        } else if (PiuTypeFinder.isXmuRadioUnit(productName)) {
            result2 = (PiuTypeAccess)aMoRepository.lookup("ManagedElement=1,SwManagement=1,PiuType=INITIALRBSXMU_*");
        } else if (PiuTypeFinder.isXmu03RadioUnit(productName)) {
            result2 = (PiuTypeAccess)aMoRepository.lookup("ManagedElement=1,SwManagement=1,PiuType=INITIALRBSXMU03_*");
        } else if (PiuTypeFinder.isSlaveDigitalUnit(productName)) {
            result2 = PiuTypeFinder.getSlaveDuPiuType(aMoRepository, coordinator);
        } else {
            MoIterator piuTypes = aMoRepository.lookupType("PiuType");
            if (piuTypes == null || !piuTypes.hasMoreElements()) {
                ConfigurationReportLoggerFactory.getLogger().logInformation("Site Equipment", "Did not find a suitable PiuType with correct relations for product " + productName);
            } else {
                result2 = PiuTypeFinder.findPiuTypeWithLeastAmountOfConfiguredChildren(productName, coordinator, piuTypes);
            }
        }
        String resultRdn = result2 == null ? "No PiuType found!" : result2.getRelativeDistinguishedName();
        logger.traceReturn(THIS_CLASS, "findPiuType(productName) - result = " + resultRdn);
        return result2;
    }

    private static PiuTypeAccess findPiuTypeWithLeastAmountOfConfiguredChildren(String productName, Coordinator coordinator, MoIterator piuTypes) {
        PiuTypeAccess result2 = null;
        int resultChildren = -1;
        while (piuTypes.hasMoreElements()) {
            PiuTypeAccess piuType = (PiuTypeAccess)piuTypes.nextElement();
            try {
                if (!productName.equalsIgnoreCase((String)piuType.getProductData(coordinator).getValue("productName"))) continue;
                Struct[] moConfiguration = piuType.getMoConfiguration(coordinator);
                if (moConfiguration == null) {
                    result2 = piuType;
                    break;
                }
                if (moConfiguration.length >= resultChildren && resultChildren != -1) continue;
                result2 = piuType;
                resultChildren = moConfiguration.length;
            }
            catch (MoAccessException mae) {
                ConfigurationReportLoggerFactory.getLogger().logInformation("Configuration failure", "Could not retrieve the productName from piuType: " + piuType.toString());
            }
        }
        return result2;
    }

    private static boolean isRadioUnit(String productName) {
        return "RU".equalsIgnoreCase(productName);
    }

    private static boolean isRemoteRadioUnit(String productName) {
        return "RRU".equalsIgnoreCase(productName);
    }

    private static boolean isIndoorRadioUnit(String productName) {
        return "IRU".equalsIgnoreCase(productName);
    }

    private static boolean isRadioDotUnit(String productName) {
        return "RD".equalsIgnoreCase(productName);
    }

    private static boolean isXmuRadioUnit(String productName) {
        return "XMU".equalsIgnoreCase(productName);
    }

    private static boolean isXmu03RadioUnit(String productName) {
        return "XMU03".equalsIgnoreCase(productName);
    }

    private static boolean isSlaveDigitalUnit(String productName) {
        return "SLAVE_DU".equalsIgnoreCase(productName);
    }

    private static PiuTypeAccess getSlaveDuPiuType(MoRepositoryWrapper aMoRepository, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "getSlaveDuPiuType()");
        PiuTypeAccess masterPiuType = null;
        PiuTypeAccess slavePiuType = null;
        try {
            ManagedObject masterPiu = PlugInUnitFinder.findPlugInUnit("DU-1", aMoRepository);
            try {
                masterPiuType = (PiuTypeAccess)((PlugInUnitMo)masterPiu).getPiuType(coordinator);
            }
            catch (MoAccessException e) {
                logger.traceError(THIS_CLASS, "Cannot get DU-1 PiuType.");
            }
        }
        catch (RbsConfigurationFailedException e1) {
            logger.traceError(THIS_CLASS, "Cannot get DU-1 PlugInUnit Mo");
        }
        slavePiuType = masterPiuType;
        if (masterPiuType != null) {
            String masterPiuTypeName = masterPiuType.getRelativeDistinguishedName();
            int idx = masterPiuTypeName.indexOf("=");
            String masterPiuTypeId = masterPiuTypeName.substring(idx + 1);
            PiuTypeAccess piuType = null;
            if (masterPiuTypeId.equals("KDU137624/3_*") || masterPiuTypeId.equals("KDU137624/31_*")) {
                piuType = (PiuTypeAccess)aMoRepository.lookup("ManagedElement=1,SwManagement=1,PiuType=KDU137624/31_*");
            } else if (masterPiuTypeId.equals("KDU137624/1_*") || masterPiuTypeId.equals("KDU137624/11_*")) {
                piuType = (PiuTypeAccess)aMoRepository.lookup("ManagedElement=1,SwManagement=1,PiuType=KDU137624/11_*");
            }
            if (piuType != null) {
                slavePiuType = piuType;
            }
        }
        logger.traceReturn(THIS_CLASS, "getSlaveDuPiuType()");
        return slavePiuType;
    }
}

