/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class PlugInUnitFinder {
    private static final Class THIS_CLASS = PlugInUnitFinder.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    private PlugInUnitFinder() {
    }

    public static ManagedObject findPlugInUnit(String unitRDN, MoRepositoryWrapper moWrapper) throws RbsConfigurationFailedException {
        String unitLDN = "";
        if (unitRDN.startsWith("RRU") || unitRDN.startsWith("RD")) {
            unitLDN = "ManagedElement=1,Equipment=1,AuxPlugInUnit=" + unitRDN;
        } else if (unitRDN.startsWith("XMU03")) {
            unitLDN = PlugInUnitFinder.decodeXMU03toLDN(unitRDN);
        } else if (unitRDN.startsWith("RU") || unitRDN.startsWith("IRU") || unitRDN.startsWith("XMU")) {
            unitLDN = PlugInUnitFinder.decodeXRUtoLDN(unitRDN);
        } else if (unitRDN.startsWith("DU")) {
            unitLDN = PlugInUnitFinder.decodeDUtoLDN(unitRDN);
        } else {
            String msg = "Unknown PlugInUnit: " + unitRDN;
            throw new RbsConfigurationFailedException(msg);
        }
        ManagedObject auxMo = moWrapper.lookup(unitLDN);
        if (auxMo == null) {
            String msg = "Could not find the MO " + unitLDN;
            throw new RbsConfigurationFailedException(msg);
        }
        return auxMo;
    }

    protected static String decodeXRUtoLDN(String unitRDN) {
        int firstSeparator = unitRDN.indexOf(45);
        int secondSeparator = unitRDN.indexOf(45, firstSeparator + 1);
        int thirdSeparator = unitRDN.indexOf(45, secondSeparator + 1);
        try {
            String rbsSubrackId = unitRDN.substring(firstSeparator + 1, secondSeparator);
            String rbsSlotId = thirdSeparator == -1 ? unitRDN.substring(secondSeparator + 1) : unitRDN.substring(secondSeparator + 1, thirdSeparator);
            return "ManagedElement=1,Equipment=1,RbsSubrack=" + rbsSubrackId + "," + "RbsSlot" + "=" + rbsSlotId + ",AuxPlugInUnit=" + unitRDN;
        }
        catch (Exception e) {
            logger.traceAbnormal(THIS_CLASS, "Unexepected exception. " + e);
            return null;
        }
    }

    protected static String decodeXMU03toLDN(String unitRDN) {
        int firstSeparator = unitRDN.indexOf(45);
        int secondSeparator = unitRDN.indexOf(45, firstSeparator + 1);
        if (secondSeparator == -1) {
            return "ManagedElement=1,Equipment=1,AuxPlugInUnit=" + unitRDN;
        }
        try {
            String rbsSubrackId = unitRDN.substring(firstSeparator + 1, secondSeparator);
            String rbsSlotId = unitRDN.substring(secondSeparator + 1);
            return "ManagedElement=1,Equipment=1,RbsSubrack=" + rbsSubrackId + "," + "RbsSlot" + "=" + rbsSlotId + ",AuxPlugInUnit=" + unitRDN;
        }
        catch (Exception e) {
            logger.traceAbnormal(THIS_CLASS, "Unexepected exception. " + e);
            return null;
        }
    }

    protected static String decodeDUtoLDN(String unitRDN) throws RbsConfigurationFailedException {
        String duLDN = "";
        int firstSeparator = unitRDN.indexOf(45);
        int secondSeparator = unitRDN.indexOf(45, firstSeparator + 1);
        int piuID = 0;
        try {
            piuID = secondSeparator == -1 ? Integer.parseInt(unitRDN.substring(firstSeparator + 1)) : Integer.parseInt(unitRDN.substring(firstSeparator + 1, secondSeparator));
            if (piuID > 0) {
                duLDN = "ManagedElement=1,Equipment=1,Subrack=1,Slot=" + piuID + "," + "PlugInUnit" + "=" + "1";
            }
        }
        catch (Exception e) {
            String msg = "PlugInUnit " + unitRDN + " not found!";
            throw new RbsConfigurationFailedException(msg);
        }
        return duLDN;
    }
}

