/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment;

import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class PlugInUnitHelper {
    private static final Class THIS_CLASS = PlugInUnitHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final MoFactoryMgrWrapper aFactoryMgr;

    public PlugInUnitHelper(GenericMaoContext aGenericMaoContext) {
        logger.traceEnter(THIS_CLASS, "PlugInUnitHelper()");
        this.aMoRepository = aGenericMaoContext.getMoRepositoryWrapper();
        this.aFactoryMgr = aGenericMaoContext.getMoFactoryMgrWrapper();
        logger.traceReturn(THIS_CLASS, "PlugInUnitHelper()");
    }

    protected void prepareChildrenForAllPlugInUnits(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "prepareChildrenForAllPlugInUnits()");
        MoIterator plugInUnits = this.aMoRepository.lookupType("PlugInUnit");
        while (plugInUnits.hasMoreElements()) {
            PlugInUnitMo plugInUnitMo = (PlugInUnitMo)plugInUnits.nextMo();
            try {
                this.preparePiuChildren(coordinator, plugInUnitMo);
            }
            catch (MoAccessException mae) {
                String msg = "MoAccessException caught when creating childs for: " + plugInUnitMo.getLocalDistinguishedName() + "Original exception:" + mae.getVariablesAsString();
                logger.traceAbnormal(THIS_CLASS, msg);
            }
        }
        logger.traceReturn(THIS_CLASS, "prepareChildrenForAllPlugInUnits()");
    }

    private void preparePiuChildren(Coordinator coordinator, PlugInUnitMo plugInUnitMo) throws MoAccessException {
        PiuTypeAccess piuType = (PiuTypeAccess)plugInUnitMo.getPiuType(coordinator);
        if (piuType == null) {
            logger.traceDebug(THIS_CLASS, "No PiuType specified, can not autoCreate children.");
        } else {
            Struct[] moConfigurations = piuType.getMoConfiguration(coordinator);
            if (moConfigurations == null) {
                logger.traceDebug(THIS_CLASS, "No Mo Configuration list found. No autocreation will be performed.");
            } else {
                for (int i = 0; i < moConfigurations.length; ++i) {
                    Struct configuration = moConfigurations[i];
                    String ldn = this.getLdn(plugInUnitMo, piuType, configuration);
                    ManagedObject managedobject = this.aMoRepository.lookup(ldn);
                    if (managedobject == null) {
                        logger.traceDebug(THIS_CLASS, "WARNING: MO Parent defined in PiuType not found, parent:" + ldn);
                        continue;
                    }
                    String moType = piuType.getMoConfigurationHardwareMoTypeName(configuration);
                    String moId = piuType.getMoConfigurationMoIdentity(configuration);
                    logger.traceDebug(THIS_CLASS, "Creating MO of type: " + moType);
                    MoFactory mofactory = this.aFactoryMgr.lookup(moType);
                    if (mofactory == null) {
                        logger.traceDebug(THIS_CLASS, "WARNING:MoFactory not found " + moType);
                        continue;
                    }
                    ManagedObject riPort = this.aMoRepository.lookup(ldn + "," + moType + "=" + moId);
                    if (riPort != null) continue;
                    AttrListImpl attrlistimpl = new AttrListImpl(0);
                    mofactory.createMo(managedobject, (AttrList)attrlistimpl, moId, null, coordinator);
                }
            }
        }
    }

    private String getLdn(PlugInUnitMo plugInUnitMo, PiuTypeAccess piuType, Struct configuration) throws MoAccessException {
        String ldn = plugInUnitMo.getLocalDistinguishedName();
        String subParentLdn = piuType.getMoConfigurationHardwaresSubParentLDN(configuration);
        if (!"".equals(subParentLdn)) {
            ldn = ldn + "," + subParentLdn;
        }
        return ldn;
    }
}

