/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment;

import java.util.ArrayList;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.AbstractRbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationUnlockHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.SectorEquipmentData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SectorHelper
extends AbstractRbsConfigurationHelper {
    private static final Class THIS_CLASS = SectorHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private MoFactoryMgrWrapper aFactoryMgr;
    private MoRepositoryWrapper aMoRepository;
    private static final String sfFailureSlogan = "Sector Function configuration failure";

    protected void init(GenericMaoContext aGenericMaoContext, RbsConfigurationMao aRbsConfiguration, RbsConfigurationContext aRbsConfigurationContext) {
        super.init(aGenericMaoContext, aRbsConfiguration, aRbsConfigurationContext);
        this.aMoRepository = aGenericMaoContext.getMoRepositoryWrapper();
        this.aFactoryMgr = aGenericMaoContext.getMoFactoryMgrWrapper();
    }

    protected void createSectorFunctionMo(SectorEquipmentData sectorEquipmentData, Coordinator coordinator) throws RbsConfigurationFailedException {
        String msg;
        logger.traceEnter(THIS_CLASS, "createSectorFunctionMo()");
        ManagedObject managedElement = this.aMoRepository.lookup("ManagedElement=1");
        if (managedElement == null) {
            String msg2 = "Could not find the system created MO ManagedElement=1";
            ((RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class)).setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, sfFailureSlogan, "Could not find the system created MO ManagedElement=1");
            throw new RbsConfigurationFailedException("Could not find the system created MO ManagedElement=1");
        }
        String currentLDN = "ManagedElement=1,SectorEquipmentFunction=" + sectorEquipmentData.sectorFunctionId;
        MoFactory sfMoFactory = this.aFactoryMgr.lookup("SectorEquipmentFunction");
        AttrListImpl attrList = new AttrListImpl();
        String[] rfBranchData = sectorEquipmentData.antennaEquipment.rfbranchRef;
        ArrayList<ManagedObject> rfBranches = new ArrayList<ManagedObject>();
        for (int index = 0; index < rfBranchData.length; ++index) {
            String antennaUnitGroupId = this.getAntennaUnitGroupId(rfBranchData[index]);
            String rfBranchId = this.getRfBranchId(rfBranchData[index]);
            String rfBranchLdn = "ManagedElement=1,Equipment=1,AntennaUnitGroup=" + antennaUnitGroupId + "," + "RfBranch" + "=" + rfBranchId;
            String multicastAntennaBranchLdn = "ManagedElement=1,Equipment=1,AntennaUnitGroup=" + antennaUnitGroupId + "," + "MulticastAntennaBranch" + "=" + rfBranchId;
            ManagedObject rfBranch = this.aMoRepository.lookup(rfBranchLdn);
            ManagedObject multicastAntennaBranchMo = this.aMoRepository.lookup(multicastAntennaBranchLdn);
            ManagedObject addBranchMo = null;
            if (rfBranch != null) {
                addBranchMo = rfBranch;
            } else if (multicastAntennaBranchMo != null) {
                addBranchMo = multicastAntennaBranchMo;
            } else {
                String faultMsg = "Could not find the referenced RfBranch MO with LDN: " + rfBranchLdn + ".";
                throw new RbsConfigurationFailedException("SectorEquipmentFunction", faultMsg);
            }
            rfBranches.add(addBranchMo);
        }
        attrList.addElement("rfBranchRef", (Object)rfBranches.toArray(new ManagedObject[rfBranches.size()]));
        attrList.addElement("configuredOutputPower", (Object)sectorEquipmentData.configuredOutputPower);
        attrList.addElement("mixedModeRadio", (Object)sectorEquipmentData.mixedModeRadio);
        attrList.addElement("txPowerPersistentLock", (Object)sectorEquipmentData.txPowerPersistentLock);
        try {
            ManagedObject sfMo = this.aMoRepository.lookup(currentLDN);
            if (sfMo == null) {
                sfMo = sfMoFactory.createMo(managedElement, (AttrList)attrList, sectorEquipmentData.sectorFunctionId, null, coordinator);
                RbsConfigurationUnlockHelper.getInstance().registerCreatedMo(sfMo, coordinator);
                ConfigurationReportLoggerFactory.getLogger().logAction("SectorEquipmentFunction", "create", new String[]{"LDN", "mixedModeRadio"}, new Object[]{"ManagedElement=1,SectorEquipmentFunction=" + sectorEquipmentData.sectorFunctionId, sectorEquipmentData.mixedModeRadio});
            }
        }
        catch (MoAccessException mae) {
            msg = "Failed to create the MO with LDN: " + currentLDN + ".";
            throw new RbsConfigurationFailedException("SectorEquipmentFunction", msg, (Exception)((Object)mae));
        }
        catch (InactiveTransactionException ite) {
            msg = "Failed to create the MO with LDN: " + currentLDN + ".";
            throw new RbsConfigurationFailedException("SectorEquipmentFunction", msg, (Exception)((Object)ite));
        }
        logger.traceReturn(THIS_CLASS, "createSectorFunctionMo()");
    }

    private String getAntennaUnitGroupId(String rfBranchId) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getAntennaUnitGroupId() " + rfBranchId);
        String result2 = null;
        try {
            result2 = rfBranchId.substring(0, rfBranchId.indexOf(45));
        }
        catch (StringIndexOutOfBoundsException exception) {
            throw new RbsConfigurationFailedException("SectorEquipmentFunction", "Unable to extract rfBranchRef from " + rfBranchId, exception);
        }
        logger.traceReturn(THIS_CLASS, "getAntennaUnitGroupId() " + result2);
        return result2;
    }

    private String getRfBranchId(String rfBranchId) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getRfBranchId() " + rfBranchId);
        String result2 = null;
        try {
            result2 = rfBranchId.substring(rfBranchId.indexOf(45) + 1);
        }
        catch (StringIndexOutOfBoundsException exception) {
            throw new RbsConfigurationFailedException("SectorEquipmentFunction", "Unable to extract rfBranchRef from " + rfBranchId, exception);
        }
        logger.traceReturn(THIS_CLASS, "getRfBranchId() " + result2);
        return result2;
    }

    public String getHelperName() {
        return this.getClass().getName();
    }
}

