/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure;

import java.io.IOException;

public class AlarmPortData {
    public final transient int alarmPortId;
    public final transient String alarmSlogan;
    public final transient boolean normallyOpen;
    public final transient int perceivedServerity;
    public final transient int probableCause;

    public AlarmPortData(int alarmPortIdIn, String alarmSloganIn, boolean normallyOpenIn, String perceivedServerityStringIn, int probableCauseIn) throws IOException {
        this.alarmPortId = alarmPortIdIn;
        this.alarmSlogan = alarmSloganIn;
        this.normallyOpen = normallyOpenIn;
        this.perceivedServerity = this.decodePsToInt(perceivedServerityStringIn);
        this.probableCause = probableCauseIn;
    }

    private int decodePsToInt(String perceivedSeverityString) throws IOException {
        int perceivedSeverity = 0;
        if (perceivedSeverityString.equalsIgnoreCase("CRITICAL")) {
            perceivedSeverity = 2;
        } else if (perceivedSeverityString.equalsIgnoreCase("MAJOR")) {
            perceivedSeverity = 3;
        } else if (perceivedSeverityString.equalsIgnoreCase("MINOR")) {
            perceivedSeverity = 4;
        } else if (perceivedSeverityString.equalsIgnoreCase("WARNING")) {
            perceivedSeverity = 5;
        } else {
            String msg = "Invalid NPC Configuration file: The alarmPort's perceivedServerity not recognized. (Input was " + perceivedSeverityString + ")";
            throw new IOException(msg);
        }
        return perceivedSeverity;
    }
}

