/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.helpers.AttributesImpl;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class NodeData {
    private static final Class THIS_CLASS = NodeData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private String site;
    private boolean loadSharingControlSystem;
    private boolean redundantControlSystem;
    private boolean lmtPortsLocked;

    public NodeData(String siteIn, boolean loadSharingControlSystemIn, boolean redundantControlSystemIn, boolean lmtPortsLockedIn) {
        this.setSite(siteIn);
        this.setLoadSharingControlSystem(loadSharingControlSystemIn);
        this.setRedundantControlSystem(redundantControlSystemIn);
        this.setLmtPortsLocked(lmtPortsLockedIn);
    }

    public void createNodeData(Map typeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createNodeData()");
        String xmlTag = "NodeData".toLowerCase(Locale.getDefault());
        if (typeElementMap.containsKey(xmlTag)) {
            List elements = (List)typeElementMap.get(xmlTag);
            if (elements.size() > 1) {
                throw new IOException("Invalid XML file: There are more than one element of type NodeData.");
            }
            if (!elements.isEmpty()) {
                String defaultLoadSharingControlSystem = "NO";
                String localLoadSharingControlSystem = "NO";
                String defaultRedundantControlSystem = "NO";
                String localRedundantControlSystem = "NO";
                AttributesImpl attributes = ((XMLElement)elements.get(0)).getAttributes();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(attributes);
                localLoadSharingControlSystem = this.getStringValueEmptyStringToDefault(attrNameValueMap, "loadSharingControlSystem", "NO");
                localRedundantControlSystem = this.getStringValueEmptyStringToDefault(attrNameValueMap, "redundantControlSystem", "NO");
                this.setSite(this.getStringValueEmptyStringToDefault(attrNameValueMap, "site", ""));
                String lmtPortsState = this.getStringValueEmptyStringToDefault(attrNameValueMap, "lmtPorts", "");
                logger.traceDebug(THIS_CLASS, "The value of lmtPorts in site equipment file: " + lmtPortsState);
                this.setLmtPortsLocked(lmtPortsState.equalsIgnoreCase("LOCKED"));
                if (localLoadSharingControlSystem.equalsIgnoreCase("yes")) {
                    this.setLoadSharingControlSystem(true);
                }
                if (localRedundantControlSystem.equalsIgnoreCase("yes")) {
                    this.setRedundantControlSystem(true);
                }
            }
        } else {
            throw new IOException("Invalid XML file: Elemnt of type NodeData is missing.");
        }
        logger.traceReturn(THIS_CLASS, "createNodeData()");
    }

    private String getStringValueEmptyStringToDefault(Map attrNameValueMap, String key, String defaultValue) {
        String value = StringHelper.emptyStringToDefault((String)((String)attrNameValueMap.get(key.toLowerCase(Locale.getDefault()))), (String)defaultValue);
        return value;
    }

    public String getSite() {
        return this.site;
    }

    public void setSite(String inSite) {
        this.site = inSite;
    }

    public boolean isLoadSharingControlSystem() {
        return this.loadSharingControlSystem;
    }

    public void setLoadSharingControlSystem(boolean inLoadSharingControlSystem) {
        this.loadSharingControlSystem = inLoadSharingControlSystem;
    }

    public boolean isRedundantControlSystem() {
        return this.redundantControlSystem;
    }

    public void setRedundantControlSystem(boolean inRedundantControlSystem) {
        this.redundantControlSystem = inRedundantControlSystem;
    }

    public boolean isLmtPortsLocked() {
        return this.lmtPortsLocked;
    }

    public void setLmtPortsLocked(boolean lmtPortsLockedIn) {
        this.lmtPortsLocked = lmtPortsLockedIn;
    }
}

