/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.helpers.AttributesImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class RiLinkData {
    private static final Class THIS_CLASS = RiLinkData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private transient String riLinkId;
    private transient String riPortRef1;
    private transient String riPortRef2;
    private transient Integer transportType;

    public RiLinkData(String inRiLinkId, String inRiPortRef1, String inRiPortRef2, Integer inTransportType) {
        this.riLinkId = inRiLinkId;
        this.riPortRef1 = inRiPortRef1;
        this.riPortRef2 = inRiPortRef2;
        this.transportType = inTransportType;
    }

    public static List createRiLinkData(Map typeElementMap) throws IOException {
        List elements;
        logger.traceEnter(THIS_CLASS, "createRiLinkData()");
        String xmlTag = "RiLink".toLowerCase(Locale.getDefault());
        ArrayList<RiLinkData> riLinks = new ArrayList<RiLinkData>();
        if (typeElementMap.containsKey(xmlTag) && !(elements = (List)typeElementMap.get(xmlTag)).isEmpty()) {
            for (int i = 0; i < elements.size(); ++i) {
                AttributesImpl attributes = ((XMLElement)elements.get(i)).getAttributes();
                Map attrNameValueMap = ParserHelper.createAttrNameValueMap(attributes);
                String riLinkId = (String)attrNameValueMap.get("riLinkId".toLowerCase());
                String localTransportType = (String)attrNameValueMap.get("transportType".toLowerCase());
                Integer transportType = RiLinkData.convertTransportTypeToInt(localTransportType);
                String localRiPortRef1 = (String)attrNameValueMap.get("riPortRef1".toLowerCase());
                String localRiPortRef2 = (String)attrNameValueMap.get("riPortRef2".toLowerCase());
                if (localRiPortRef1 == null) {
                    throw new IOException("Invalid XML file: Element of type riPortRef1 is missing.");
                }
                if (localRiPortRef2 == null) {
                    throw new IOException("Invalid XML file: Element of type riPortRef2 is missing.");
                }
                RiLinkData riLinkData = new RiLinkData(riLinkId, localRiPortRef1, localRiPortRef2, transportType);
                riLinks.add(riLinkData);
            }
        }
        logger.traceReturn(THIS_CLASS, "createRiLinkData()");
        return riLinks;
    }

    public static Integer convertTransportTypeToInt(String attrTransportType) {
        if (attrTransportType.equals("NOT_SET")) {
            return (Integer)RbsConfigurationDefinitions.TRANSPORT_TYPE.get("NOT_SET");
        }
        if (attrTransportType.equals("CPRI_OVER_DWDM_LINEAR")) {
            return (Integer)RbsConfigurationDefinitions.TRANSPORT_TYPE.get("CPRI_OVER_DWDM_LINEAR");
        }
        if (attrTransportType.equals("CPRI_OVER_DWDM_RING")) {
            return (Integer)RbsConfigurationDefinitions.TRANSPORT_TYPE.get("CPRI_OVER_DWDM_RING");
        }
        if (attrTransportType.equals("CPRI_OVER_CWDM_LINEAR")) {
            return (Integer)RbsConfigurationDefinitions.TRANSPORT_TYPE.get("CPRI_OVER_CWDM_LINEAR");
        }
        if (attrTransportType.equals("CPRI_OVER_CWDM_RING")) {
            return (Integer)RbsConfigurationDefinitions.TRANSPORT_TYPE.get("CPRI_OVER_CWDM_RING");
        }
        if (attrTransportType.equals("CPRI_OVER_MICROWAVE_PTOP")) {
            return (Integer)RbsConfigurationDefinitions.TRANSPORT_TYPE.get("CPRI_OVER_MICROWAVE_PTOP");
        }
        if (attrTransportType.equals("CPRI_OVER_MICROWAVE_PTOM")) {
            return (Integer)RbsConfigurationDefinitions.TRANSPORT_TYPE.get("CPRI_OVER_MICROWAVE_PTOM");
        }
        if (attrTransportType.equals("CPRI_OVER_GIGABIT_ETHERNET")) {
            return (Integer)RbsConfigurationDefinitions.TRANSPORT_TYPE.get("CPRI_OVER_GIGABIT_ETHERNET");
        }
        if (attrTransportType.equals("CPRI_OVER_DIRECT_CABLE")) {
            return (Integer)RbsConfigurationDefinitions.TRANSPORT_TYPE.get("CPRI_OVER_DIRECT_CABLE");
        }
        return (Integer)RbsConfigurationDefinitions.TRANSPORT_TYPE.get("NOT_SET");
    }

    public String getRiLinkId() {
        return this.riLinkId;
    }

    public String getRiPortRef1() {
        return this.riPortRef1;
    }

    public String getRiPortRef2() {
        return this.riPortRef2;
    }

    public Integer getTransportType() {
        return this.transportType;
    }
}

