/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.smrs;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import se.ericsson.crbs.cat.common.FileHelper;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class HashHelper {
    private static final String UTF8 = "UTF-8";
    private static final String SHA1 = "SHA-1";
    private static final Class THIS_CLASS = HashHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    private HashHelper() {
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            buf.append(HashHelper.toHex(data[i]));
        }
        return buf.toString();
    }

    public static String computeSha1Hash(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] sha1hash = new byte[40];
        MessageDigest md = MessageDigest.getInstance(SHA1);
        md.reset();
        sha1hash = md.digest(text.getBytes(UTF8));
        return HashHelper.convertToHex(sha1hash);
    }

    private static String hexChr(int b) {
        return Integer.toHexString(b & 0xF);
    }

    private static String toHex(int b) {
        return HashHelper.hexChr((b & 0xF0) >> 4) + HashHelper.hexChr(b & 0xF);
    }

    public static void checkSha1HashAgainstFile(String expectedHash, String filePath) throws HashException {
        logger.traceEnter(THIS_CLASS, "checkSha1HashAgainstFile(" + expectedHash + ", " + filePath + ")");
        try {
            String fileContents = FileHelper.getFileContents(new File(filePath));
            String computedHash = HashHelper.computeSha1Hash(fileContents);
            logger.traceDebug(THIS_CLASS, "Computed hash = " + computedHash);
            if (!expectedHash.equalsIgnoreCase(computedHash)) {
                throw new HashException("The file, \"" + filePath + "\", does not match the provided hash");
            }
        }
        catch (IOException ioe) {
            throw new HashException("Could not read the provided file path: " + StringHelper.doubleQuote((String)filePath), ioe);
        }
        catch (HashException he) {
            throw he;
        }
        catch (Exception e) {
            throw new HashException("Failed to compute hash from the file: " + StringHelper.doubleQuote((String)filePath), e);
        }
        logger.traceReturn(THIS_CLASS, "checkSha1HashAgainstFile(" + expectedHash + ", " + filePath + ")");
    }

    public static class HashException
    extends Exception {
        public HashException(String errorMsg) {
            super(errorMsg);
        }

        public HashException(String errorMsg, Throwable throwable) {
            super(errorMsg, throwable);
        }
    }
}

