/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.IWaiter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.PlugInUnitFinder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.RbsConfigurationSiteEquipmentFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.Waiter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.DigitalEquipmentData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.DigitalUnitData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.InterPiuLinkData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.RiPortData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;

public class ActivateExtensionDUStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = ActivateExtensionDUStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private DigitalEquipmentData digitalEquipmentData = null;
    private IWaiter waiter = new Waiter();
    private boolean isRestarted = false;

    public ActivateExtensionDUStateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 71);
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        this.digitalEquipmentData = RbsConfigurationSiteEquipmentFactory.getInstance().getRbsConfigurationSiteEquipment(this.rbsConfigurationMao, false).getDigitalEquipmentData();
        if (this.digitalEquipmentData != null && this.digitalEquipmentData.getDigitalUnit().length > 0) {
            this.restartExtPiuMos(this.digitalEquipmentData);
            if (this.isRestarted) {
                this.updateProgressReportInformation(1810, 5, "The step Restart Extension DU is successfully finished.", true);
                this.updateProgressReportInformation(1820, 3, "The step Wait for DU up has been started.", true);
                if (this.waitForDUsUp(this.digitalEquipmentData)) {
                    this.updateProgressReportInformation(1820, 5, "The step Wait for DU up is successfully finished.", true);
                }
            } else {
                this.updateProgressReportInformation(1820, 2, "The step Wait for DU up is skipped.", true);
            }
        } else {
            this.updateProgressReportInformation(1810, 2, "The step Restart Extension DU is skipped.", true);
            this.updateProgressReportInformation(1820, 2, "The step Wait for DU up is skipped.", true);
        }
        this.stateHolder = new StateHolder(true, 73);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public boolean waitForDUsUp(DigitalEquipmentData digitalEquipmentDataIn) {
        int waited;
        logger.traceEnter(THIS_CLASS, "waitForDUsUp()");
        boolean nodeUp = true;
        int maxwait = 300;
        boolean ret = false;
        ConfigurationReportLoggerFactory.getLogger().logInformation("WAIT", "Wait for all DU up");
        for (waited = 0; waited < 300 && this.isRestarted && digitalEquipmentDataIn != null; ++waited) {
            nodeUp = true;
            for (int digitalUnitIndex = 0; digitalUnitIndex < digitalEquipmentDataIn.getDigitalUnit().length; ++digitalUnitIndex) {
                String duName = digitalEquipmentDataIn.getDigitalUnit()[digitalUnitIndex].unitId;
                int idx = duName.lastIndexOf("-");
                String duId = duName.substring(idx + 1);
                String ldn = "ManagedElement=1,Equipment=1,Subrack=1,Slot=" + duId + "," + "PlugInUnit" + "=" + "1" + "," + "SubDeviceGroup" + "=du-1";
                ManagedObject subDevMo = this.moRepositoryWrapper.lookup(ldn);
                if (subDevMo == null) {
                    logger.info(THIS_CLASS, ldn + " Mo is null");
                    nodeUp = false;
                    continue;
                }
                try {
                    Integer operState = (Integer)subDevMo.getAttribute("operationalState", null);
                    if (operState == 1) continue;
                    nodeUp = false;
                    continue;
                }
                catch (NoSuchAttributeException e) {
                    logger.traceDebug(THIS_CLASS, "NoSuchAttributeExceptio when getting operationalState value: " + e.getMessage());
                    continue;
                }
                catch (MoAccessException e) {
                    logger.traceDebug(THIS_CLASS, "MoAccessException when getting operationalState value: " + e.getMessage());
                }
            }
            if (nodeUp) {
                ret = true;
                break;
            }
            this.waiter.waitForSec(1);
        }
        logger.traceDebug(THIS_CLASS, "waited " + waited + " seconds for waiting node up.");
        if (waited == 300) {
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_RESTART_EXT_DU_FAULT, "Restart of node failed", "Timeout to wait for all DUs up.");
        }
        logger.traceReturn(THIS_CLASS, "waitForDUsUp()");
        return ret;
    }

    private boolean waitForPiuEnable(PlugInUnitMo piu, DigitalEquipmentData digitalEquipmentDataIn, String duId, String childDuId) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "waitForPiuEnable()");
        boolean ret = false;
        int maxwait = 180;
        int waited = 0;
        DigitalUnitData digitalUnitData = digitalEquipmentDataIn.getDigitalUnitForId(duId);
        String riPortLdn = null;
        String riPortId = null;
        for (int i = 0; i < digitalUnitData.getRiPorts().size(); ++i) {
            int idx;
            String riPortRef = ((RiPortData)digitalUnitData.getRiPorts().get(i)).getRef();
            String enderDuName = riPortRef.substring(0, idx = riPortRef.lastIndexOf(45));
            if (!enderDuName.equals(childDuId)) continue;
            riPortId = ((RiPortData)digitalUnitData.getRiPorts().get(i)).getId();
            break;
        }
        riPortLdn = piu.getLocalDistinguishedName() + "," + "RiPort" + "=" + riPortId;
        Integer operState = RbsConfigurationDefinitions.DEACTIVATED;
        int piuState = 0;
        while (waited < 180) {
            try {
                piuState = piu.getOperationalState(null);
                if (riPortId == null) {
                    if (piuState == 1) {
                        ret = true;
                        this.waiter.waitForSec(5);
                        break;
                    }
                } else {
                    ManagedObject riPortMo = this.moRepositoryWrapper.lookup(riPortLdn);
                    if (riPortMo != null) {
                        operState = (Integer)riPortMo.getAttribute("operationalState", null);
                    }
                    if (piuState == 1 && operState.equals(RbsConfigurationDefinitions.ACTIVATED)) {
                        ret = true;
                        this.waiter.waitForSec(5);
                        break;
                    }
                }
            }
            catch (MoAccessException mae) {
                logger.traceDebug(THIS_CLASS, "Cannot get attribute operationalState from riPortMo. " + (Object)((Object)mae));
            }
            this.waiter.waitForSec(1);
            ++waited;
        }
        if (waited == 180) {
            String errMsg = null;
            errMsg = riPortId == null ? "waitForPiuEnable() timeout on waiting for PIU enable: \n" + piu.getLocalDistinguishedName() + " OperationalState is " + piuState : "waitForPiuEnable() timeout on waiting for PIU and RiPort enable: \n" + piu.getLocalDistinguishedName() + " OperationalState is " + piuState + "\n" + riPortLdn + " OperationalState is " + operState;
            throw new RbsConfigurationFailedException(errMsg);
        }
        logger.traceReturn(THIS_CLASS, "waitForPiuEnable()");
        return ret;
    }

    public List getNeedRestartExtDUs(DigitalEquipmentData digitalEquipmentDataIn) {
        logger.traceEnter(THIS_CLASS, "getNeedRestartExtDUs()");
        ArrayList<String[]> extPiuList = new ArrayList<String[]>();
        LinkedList<String[]> queue = new LinkedList<String[]>();
        DigitalUnitData masterDu = digitalEquipmentDataIn.getDigitalUnitForId("DU-1");
        if (masterDu == null) {
            logger.traceReturn(THIS_CLASS, "getNeedRestartExtDUs()");
            return extPiuList;
        }
        HashSet<String> childNodes = new HashSet<String>();
        for (int digitalUnitIndex = 0; digitalUnitIndex < digitalEquipmentDataIn.getDigitalUnit().length; ++digitalUnitIndex) {
            DigitalUnitData curDU = digitalEquipmentDataIn.getDigitalUnit()[digitalUnitIndex];
            if (!curDU.unitId.equals("DU-1")) {
                if (!curDU.getInterPiuLinks().isEmpty() || !curDU.getRiPorts().isEmpty()) continue;
                childNodes.add(curDU.unitId);
                continue;
            }
            for (int interPiuLinkIndex = 0; interPiuLinkIndex < curDU.getInterPiuLinks().size(); ++interPiuLinkIndex) {
                InterPiuLinkData interPiuLink = (InterPiuLinkData)curDU.getInterPiuLinks().get(interPiuLinkIndex);
                childNodes.add(interPiuLink.getRef());
            }
            for (int riPortIndex = 0; riPortIndex < curDU.getRiPorts().size(); ++riPortIndex) {
                RiPortData riPort = (RiPortData)curDU.getRiPorts().get(riPortIndex);
                String curRiPortRef = riPort.getRef();
                int idx = curRiPortRef.lastIndexOf(45);
                String enderDuName = curRiPortRef.substring(0, idx);
                childNodes.add(enderDuName);
            }
        }
        Iterator it = childNodes.iterator();
        while (it.hasNext()) {
            String[] queueItem = new String[]{masterDu.unitId, (String)it.next()};
            queue.add(queueItem);
        }
        while (!queue.isEmpty()) {
            String[] nodesPair = (String[])queue.getFirst();
            queue.removeFirst();
            String parentDuName = nodesPair[0];
            String curDuName = nodesPair[1];
            childNodes.clear();
            DigitalUnitData curDu = digitalEquipmentDataIn.getDigitalUnitForId(curDuName);
            if (curDu != null) {
                for (int riPortIndex = 0; riPortIndex < curDu.getRiPorts().size(); ++riPortIndex) {
                    int idx;
                    RiPortData riPort = (RiPortData)curDu.getRiPorts().get(riPortIndex);
                    String curRiPortRef = riPort.getRef();
                    String enderDuName = curRiPortRef.substring(0, idx = curRiPortRef.lastIndexOf(45));
                    if (enderDuName.equals(parentDuName)) continue;
                    childNodes.add(enderDuName);
                }
            }
            it = childNodes.iterator();
            while (it.hasNext()) {
                String[] queueItem = new String[]{curDuName, (String)it.next()};
                queue.add(queueItem);
            }
            boolean needRestart = true;
            if (parentDuName.equals("DU-1") && digitalEquipmentDataIn.checkInterPiuLinkToDU1(curDuName)) {
                needRestart = false;
            }
            if (!needRestart) continue;
            extPiuList.add(nodesPair);
        }
        logger.traceReturn(THIS_CLASS, "getNeedRestartExtDUs()");
        return extPiuList;
    }

    public void restartExtPiuMos(DigitalEquipmentData digitalEquipmentDataIn) {
        logger.traceEnter(THIS_CLASS, "restartExtPiuMos()");
        List extDuPairList = this.getNeedRestartExtDUs(digitalEquipmentDataIn);
        if (extDuPairList.size() > 0) {
            this.updateProgressReportInformation(1810, 3, "The step Restart Extension DU has been started.", true);
        } else {
            this.updateProgressReportInformation(1810, 2, "The step Restart Extension DU is skipped.", true);
        }
        for (int idx = 0; idx < extDuPairList.size(); ++idx) {
            String[] nodesPair = (String[])extDuPairList.get(idx);
            String parentDuName = nodesPair[0];
            String curDuName = nodesPair[1];
            try {
                PlugInUnitMo parentPiu = (PlugInUnitMo)PlugInUnitFinder.findPlugInUnit(parentDuName, this.moRepositoryWrapper);
                PlugInUnitMo curPiu = (PlugInUnitMo)PlugInUnitFinder.findPlugInUnit(curDuName, this.moRepositoryWrapper);
                TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
                Control control = null;
                control = transFact.create(0);
                Coordinator coordinator = control.getCoordinator();
                if (this.waitForPiuEnable(parentPiu, digitalEquipmentDataIn, parentDuName, curDuName)) {
                    try {
                        logger.traceDebug(THIS_CLASS, "start to restart ext du " + curDuName);
                        curPiu.actionManualRestart(0, 30, "Restart extension PIU for multi-DU configuration", coordinator);
                        String msg = "Restart extension PIU for multi-DU configuration: " + curDuName;
                        ConfigurationReportLoggerFactory.getLogger().logInformation("Restart", msg);
                        this.isRestarted = true;
                    }
                    catch (MoAccessException mae) {
                        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_RESTART_EXT_DU_FAULT, "Restart of node failed", mae.getMessage());
                    }
                }
                control.getTerminator().commit();
                continue;
            }
            catch (TransactionRolledBackException e) {
                logger.traceError(THIS_CLASS, e.getMessage());
                continue;
            }
            catch (InactiveTransactionException e) {
                logger.traceError(THIS_CLASS, e.getMessage());
                continue;
            }
            catch (RbsConfigurationFailedException e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_RESTART_EXT_DU_FAULT, "Restart of node failed", e.getMessage());
            }
        }
        logger.traceReturn(THIS_CLASS, "restartExtPiuMos()");
    }

    public void setWaiter(IWaiter inWaiter) {
        this.waiter = inWaiter;
    }

    public void setIsRestarted(boolean flag) {
        this.isRestarted = flag;
    }

    public boolean getIsRestarted() {
        return this.isRestarted;
    }
}

