/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.security.SecurityMo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationSmrsHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.SensitiveDataHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.OssInformerHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.security.cppsec.esa.EsaSecurityChecksums;
import se.ericsson.security.cppsec.esa.ExpressSecurityActivation;
import se.ericsson.security.cppsec.esa.SecurityActivationException;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;

public class ActivateSecurityLevelStateExecutor
extends AbstractStateExecutor {
    protected static final String CHECKSUM_VERSION = "1.0";
    private static final Class THIS_CLASS = ActivateSecurityLevelStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final ExpressSecurityActivation esa;
    private int nextState = 76;
    protected boolean tryAgain;

    public ActivateSecurityLevelStateExecutor(RbsConfigurationMao inRbsConfigurationMao, ExpressSecurityActivation inEsa) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 76);
        this.esa = inEsa;
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        this.nextState = 80;
        if (SecurityParameters.instance(this.rbsConfigurationMao).getActivateSecurityAsBoolean()) {
            try {
                int minLevel = (Integer)this.rbsConfigurationMao.retrievePersistently("minimumSecurityLevel");
                int wantedLevel = (Integer)this.rbsConfigurationMao.retrievePersistently("wantedSecurityLevel");
                SecurityMo secMo = (SecurityMo)this.moRepositoryWrapper.lookup("ManagedElement=1,SystemFunctions=1,Security=1");
                logger.traceGeneral(THIS_CLASS, "secMo: " + secMo);
                if (null == secMo) {
                    String msg = "Could not find the Security Mo";
                    logger.info(THIS_CLASS, "Could not find the Security Mo");
                    throw new RbsConfigurationFailedException("No Security MO", "No Security MO");
                }
                int currentLevel = secMo.getOperationalSecurityLevel(null);
                this.activateSecurityLevel(minLevel, wantedLevel, currentLevel, secMo);
            }
            catch (MoAccessException mae) {
                this.handleMoAccessException(mae);
                this.nextState = 75;
            }
            catch (SecurityActivationException sae) {
                this.handleSecurityActivationException(sae);
                this.nextState = 75;
            }
        }
        this.stateHolder = new StateHolder(true, this.nextState);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void activateSecurityLevel(int minLevel, int wantedLevel, int inCurrentLevel, SecurityMo secMo) throws MoAccessException, SecurityActivationException {
        logger.traceEnter(THIS_CLASS, "activateSecurityLevel()");
        int currentLevel = inCurrentLevel;
        this.updateProgressReportInformation(2200, 3, "Activating node security", true);
        String iscfFilePath = SecurityParameters.instance(this.rbsConfigurationMao).getLocalInitialSecurityConfigurationFile();
        RbsConfigurationSmrsHelper rbsConfigurationSmrsHelper = (RbsConfigurationSmrsHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationSmrsHelper.class);
        String userName = rbsConfigurationSmrsHelper.getSmrsInfo().getSmrsUserName();
        SensitiveDataHelper sensitiveDataHelper = (SensitiveDataHelper)this.rbsConfigurationContext.getHelper(SensitiveDataHelper.class);
        String rbsIntegrationCode = sensitiveDataHelper.retrieveRbsIntegrationCode();
        try {
            this.rbsConfigurationMao.storePersistently("reachedSecurityLevel", new Integer(currentLevel));
            this.esa.activateSecurity(iscfFilePath, rbsIntegrationCode, userName);
            currentLevel = secMo.getOperationalSecurityLevel(null);
            if (currentLevel >= minLevel) {
                ((RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class)).setRbsConfigLevel(RbsConfigurationDefinitions.RBS_CL_SECURITY_ACTIVE);
                currentLevel = this.finishSuccessfulInstallation(secMo, minLevel, wantedLevel);
            }
        }
        catch (SecurityActivationException sae) {
            currentLevel = secMo.getOperationalSecurityLevel(null);
            this.handleSecurityActivationException(secMo, wantedLevel, minLevel, currentLevel, sae);
        }
        catch (SecurityActivationInputException saie) {
            this.handleSecurityActivationInputException(saie);
        }
        logger.traceReturn(THIS_CLASS, "activateSecurityLevel()");
    }

    private int finishSuccessfulInstallation(SecurityMo secMo, int minSecLevel, int wantedSecLevel) throws MoAccessException, SecurityActivationException {
        logger.traceEnter(THIS_CLASS, "finishSuccessfulInstallation()");
        this.tryAgain = false;
        this.nextState = 80;
        int currentLevel = secMo.getOperationalSecurityLevel(null);
        String iscfFilePath = SecurityParameters.instance(this.rbsConfigurationMao).getLocalInitialSecurityConfigurationFile();
        RbsConfigurationSmrsHelper rbsConfigurationSmrsHelper = (RbsConfigurationSmrsHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationSmrsHelper.class);
        String userName = rbsConfigurationSmrsHelper.getSmrsInfo().getSmrsUserName();
        SensitiveDataHelper sensitiveDataHelper = (SensitiveDataHelper)this.rbsConfigurationContext.getHelper(SensitiveDataHelper.class);
        String rbsIntegrationCode = sensitiveDataHelper.retrieveRbsIntegrationCode();
        EsaSecurityChecksums checksums = null;
        try {
            checksums = this.esa.calculateChecksums(iscfFilePath, rbsIntegrationCode, userName);
        }
        catch (SecurityActivationInputException saie) {
            this.handleSecurityActivationInputException(saie);
        }
        this.rbsConfigurationMao.storePersistently("reachedSecurityLevel", new Integer(currentLevel));
        this.rbsConfigurationMao.storePersistently("sshKey", checksums.getSshdRSAfingerprint());
        String securityChecksumL1 = checksums.getSCSlvl1();
        String securityChecksumL2 = checksums.getSCSlvl2();
        String securityChecksumL3 = checksums.getSCSlvl3();
        String securityChecksums = this.calculateSecurityChecksums(securityChecksumL1, securityChecksumL2, securityChecksumL3);
        this.rbsConfigurationMao.storePersistently("securityChecksums", securityChecksums);
        this.rbsConfigurationMao.storePersistently("securityChecksumVersion", this.getSecurityChecksumVersion());
        if (currentLevel < wantedSecLevel) {
            logger.traceAbnormal(THIS_CLASS, "But managed to reach minimum security level");
            String warningMessage = "Failed to reach wanted security level (" + wantedSecLevel + ") but managed to reach minimum security level (" + minSecLevel + ")";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SECURITY_ACTIVATION_FAULT, "Security activation failure!", warningMessage);
            this.updateProgressReportInformation(2200, 6, warningMessage, true);
        } else {
            String info = "Successfully activated node security";
            this.updateProgressReportInformation(2200, 5, "Successfully activated node security", true);
        }
        if (currentLevel > 1) {
            this.waitForSecureCorba();
        }
        logger.traceReturn(THIS_CLASS, "finishSuccessfulInstallation()");
        return currentLevel;
    }

    private void waitForSecureCorba() throws MoAccessException {
        IpMo ipMo = (IpMo)this.moRepositoryWrapper.lookup("ManagedElement=1,IpOam=1,Ip=1");
        String ipv6InterfaceName = ipMo.getNodeIpv6InterfaceName(null);
        boolean isIpv6 = false;
        if (ipv6InterfaceName != null && ipv6InterfaceName.trim().length() > 0) {
            isIpv6 = true;
        }
        OssInformerHelper ossInformerHelper = new OssInformerHelper(this.helper, this.moRepositoryWrapper, isIpv6);
        while (!ossInformerHelper.isCorbaSecure()) {
            logger.traceDebug(THIS_CLASS, "Waiting for the orb to become secure.");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.traceDebug(THIS_CLASS, "Unexpected interrupt");
            }
        }
    }

    protected String getSecurityChecksumVersion() {
        return CHECKSUM_VERSION;
    }

    protected String calculateSecurityChecksums(String securityChecksumLevel1, String securityChecksumLevel2, String securityChecksumLevel3) {
        String result2 = securityChecksumLevel1;
        if (securityChecksumLevel2 != null && securityChecksumLevel2.length() > 0) {
            result2 = result2 + "," + securityChecksumLevel2;
            if (securityChecksumLevel3 != null && securityChecksumLevel3.length() > 0) {
                result2 = result2 + "," + securityChecksumLevel3;
            }
        }
        return result2;
    }

    protected void handleSecurityActivationException(SecurityMo secMo, int wantedLevel, int minLevel, int currentLevel, SecurityActivationException sae) throws MoAccessException, SecurityActivationException {
        logger.traceAbnormal(THIS_CLASS, "Failed to reach wanted security level " + sae.getMessage());
        if (currentLevel >= minLevel) {
            this.finishSuccessfulInstallation(secMo, minLevel, wantedLevel);
        } else {
            logger.traceAbnormal(THIS_CLASS, "Will retry... ");
            String errorMsg = "Security activation failure! Will retry...";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SECURITY_CONFIGURATION_FAULT, "Security activation failure! Will retry...", sae.getMessage());
            this.updateProgressReportInformation(2200, 4, "Security activation failure! Will retry...", true);
            this.resetSecurityInstallation();
        }
    }

    protected void handleSecurityActivationException(SecurityActivationException sae) {
        String errorMsg = "Security activation failure! Will retry...";
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SECURITY_CONFIGURATION_FAULT, "Security activation failure! Will retry...", sae.getMessage());
        this.updateProgressReportInformation(2200, 4, "Security activation failure! Will retry...", true);
        this.resetSecurityInstallation();
    }

    protected void handleSecurityActivationInputException(SecurityActivationInputException saie) {
        String errorMsg = "Security activation failure! Will retry...";
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SECURITY_CONFIGURATION_FAULT, "Security activation failure! Will retry...", saie.getMessage());
        this.updateProgressReportInformation(2200, 4, "Security activation failure! Will retry...", true);
        logger.info(THIS_CLASS, ExceptionHelper.appendReason((String)("activateSecurityLevel: " + saie.getMessage()), (Throwable)saie));
        this.resetSecurityInstallation();
    }

    protected void handleMoAccessException(MoAccessException mae) {
        String errorMsg = "Security activation failure! Will retry...";
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SECURITY_CONFIGURATION_FAULT, "Security activation failure! Will retry...", mae.getMessage());
        this.updateProgressReportInformation(2200, 4, "Security activation failure! Will retry...", true);
        this.resetSecurityInstallation();
    }

    private void resetSecurityInstallation() {
        logger.traceEnter(THIS_CLASS, "resetSecurityInstallation()");
        try {
            this.esa.reset();
        }
        catch (SecurityActivationException e) {
            logger.traceDebug(THIS_CLASS, "esa.reset throw exception: " + e.getStackTrace().toString());
        }
        logger.traceReturn(THIS_CLASS, "resetSecurityInstallation()");
    }
}

