/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.UpgradeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.RbsConfigurationUpgrade;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.RbsConfigurationUpgradeFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.SetRollbackCv;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeException;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class ContinueUpgradeStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = ContinueUpgradeStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public ContinueUpgradeStateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 40);
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        ProgressReportHandler.getInstance().setIntegrationCanBeCancelled(Boolean.FALSE);
        boolean rebootRequested = false;
        String upId = (String)this.rbsConfigurationMao.retrievePersistently("UpgradePackageId");
        try {
            RbsConfigurationUpgrade rbsUpgrade = RbsConfigurationUpgradeFactory.createRbsConfigurationUpgrade("", "", "", "", false, this.rbsConfigurationMao.getRbsConfigurationContext());
            rebootRequested = rbsUpgrade.continueUpgrade(upId, null, this.moRepositoryWrapper);
            if (rebootRequested) {
                this.stateHolder = new StateHolder(false, 40);
            } else {
                SetRollbackCv setRollbackCv = new SetRollbackCv(this.rbsConfigurationMao);
                setRollbackCv.setRollbackCvAfterUpgrade();
                this.updateProgressReportInformation(700, 5, "Upgrade fully finished", true);
                this.stateHolder = new StateHolder(true, 50);
            }
        }
        catch (UpgradeException upe) {
            String localUpgradePath = UpgradeParameters.instance(this.rbsConfigurationMao).getUpgradePackageFilePath();
            String errorMsg = ExceptionHelper.appendReason((String)"Upgrade failed.", (Throwable)upe);
            if (RbsConfigurationHelper.existsAndNotEmpty(localUpgradePath) && !"DoNoTuSeVaLuEfRoMsUmMaRy".equals(localUpgradePath)) {
                errorMsg = ExceptionHelper.appendReason((String)("Upgrade failed. Retrying with a new local Upgrade file. Please upload a new upgrade file to the node to the path: " + localUpgradePath), (Throwable)upe);
                this.stateHolder = new StateHolder(true, 30);
            } else {
                errorMsg = ExceptionHelper.appendReason((String)"Upgrade failed. Retrying after fetching a new Summary file from the SMRS.", (Throwable)upe);
                this.stateHolder = new StateHolder(true, 21);
            }
            this.updateProgressReportInformation(700, 0, errorMsg, true);
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade failure!", errorMsg);
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }
}

