/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationSmrsHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.isi.RbsConfigurationIsiHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.ScenarioParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.UpgradeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.createcv.CreateAiCvFactory;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class FetchFilesStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = FetchFilesStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private String rootPrefix = "";

    public FetchFilesStateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 21);
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        try {
            this.restoreAutoIntegrationParametersIfNlhExists();
            RbsConfigurationSmrsHelper smrsHelper = (RbsConfigurationSmrsHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationSmrsHelper.class);
            smrsHelper.getAndProcessSummaryFile();
            this.chooseNextState();
        }
        catch (RbsConfigurationFailedException rcfe) {
            String errorMsg = ExceptionHelper.appendReason((String)"SMRS info has been lost.", (Throwable)((Object)rcfe));
            this.updateProgressReportInformation(300, 4, errorMsg, false);
            this.updateProgressReportInformation(400, 4, errorMsg, false);
            this.updateProgressReportInformation(1500, 4, errorMsg, false);
            this.updateProgressReportInformation(900, 4, errorMsg, true);
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SMRS_CONNECTION_FAULT, "Missing information", errorMsg);
            this.stateHolder = new StateHolder(true, 21);
        }
        catch (NoClassDefFoundError exc) {
            String errorMsg = "Faulty SummaryFile";
            logger.traceGeneral(THIS_CLASS, "NoClassDefFoundError " + exc.getMessage());
            if (exc.getMessage().equalsIgnoreCase("java.sql.SQLException")) {
                logger.traceGeneral(THIS_CLASS, "Error parsing Summary XML file");
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SUMMARY_FILE_FAULT, "ErroneousInput", "Faulty SummaryFile");
                this.stateHolder = new StateHolder(true, 21);
            }
            throw exc;
        }
        if (ScenarioParameters.instance(this.rbsConfigurationMao).getWithGuiScenario() == 2 && !this.nlhExists() && this.stateHandler.getWaitForIntegrate()) {
            try {
                this.createWareHouseCv();
            }
            catch (RbsConfigurationFailedException e) {
                this.stateHolder = new StateHolder(true, 21);
            }
        }
        this.decideIfToActivateSecurity();
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void chooseNextState() {
        if (this.shouldWaitForIntegrateAction()) {
            this.stateHandler.setWaitForIntegrate(true);
            this.stateHolder = new StateHolder(true, 23);
        } else {
            this.stateHolder = new StateHolder(true, 25);
        }
    }

    private boolean shouldWaitForIntegrateAction() {
        if (this.stateHandler.getNextStateExecutorIfReset() == -100) {
            return this.stateHandler.getWaitForIntegrate();
        }
        this.stateHandler.reset(-100);
        int scenario = ScenarioParameters.instance(this.rbsConfigurationMao).getWithGuiScenario();
        return scenario == 1 || scenario == 3 || scenario == 2;
    }

    public void decideIfToActivateSecurity() {
        logger.traceEnter(THIS_CLASS, "decideIfToActivateSecurity()");
        boolean activateSecurity = SecurityParameters.instance(this.rbsConfigurationMao).getActivateSecurityAsBoolean();
        String localIscf = SecurityParameters.instance().getLocalInitialSecurityConfigurationFile();
        logger.traceDebug(THIS_CLASS, "decideIfToActivateSecurity() localIscf: " + localIscf + ", activateSecurity:" + activateSecurity);
        if (localIscf.trim().length() == 0) {
            SecurityParameters.instance().setActivateSecurity("false");
        } else {
            File localIscfFile = new File(localIscf);
            if (localIscfFile.exists()) {
                SecurityParameters.instance().setActivateSecurity("true");
            } else {
                SecurityParameters.instance().setActivateSecurity("false");
            }
        }
        logger.traceReturn(THIS_CLASS, "decideIfToActivateSecurity() activateSecurity: " + SecurityParameters.instance(this.rbsConfigurationMao).getActivateSecurity());
    }

    private void restoreAutoIntegrationParametersIfNlhExists() throws RbsConfigurationFailedException {
        if (this.nlhExists()) {
            RbsConfigurationIsiHelper isiHelper = (RbsConfigurationIsiHelper)this.rbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationIsiHelper.class);
            try {
                isiHelper.restoreAutoIntegrationParameters(this.rootPrefix + "/c/systemfiles/lte/autointegration/Nlh.xml");
                Map sftpData = isiHelper.getSftpData(this.rootPrefix + "/c/systemfiles/lte/autointegration/Nlh.xml");
                if (sftpData != null) {
                    String upPath = (String)sftpData.get("upgradeFilePath");
                    UpgradeParameters.instance(this.rbsConfigurationMao).setUpgradePackageRemotePath(upPath);
                }
            }
            catch (IOException ioe) {
                String slogen = "Failure while trying to restore AutoIntegration Parameters ";
                logger.traceError(THIS_CLASS, "Failure while trying to restore AutoIntegration Parameters " + ioe.getMessage(), (Throwable)ioe);
                throw new RbsConfigurationFailedException("Failure while trying to restore AutoIntegration Parameters ");
            }
            catch (GeneralSecurityException se) {
                String slogen = "Failure while trying to decrypt nlh.xml ";
                logger.traceError(THIS_CLASS, "Failure while trying to decrypt nlh.xml " + se.getMessage(), (Throwable)se);
                throw new RbsConfigurationFailedException("Failure while trying to decrypt nlh.xml ");
            }
            FileParameters.instance(this.rbsConfigurationMao).setNodeSelfConfigurationMode("InitialSoftwareInstallationPerformed");
        } else {
            FileParameters.instance(this.rbsConfigurationMao).setNodeSelfConfigurationMode("InitialSoftwareInstallationNotPerformed");
        }
    }

    private boolean nlhExists() {
        File nlhFile = new File(this.rootPrefix + "/c/systemfiles/lte/autointegration/Nlh.xml");
        return nlhFile.exists() && nlhFile.isFile();
    }

    protected void setUnitTestRootPrefix(String prefix) {
        this.rootPrefix = prefix;
    }

    protected String getUnitTestRootPrefix() {
        return this.rootPrefix;
    }

    private void createWareHouseCv() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "CreateWareHouseCv()");
        boolean success = CreateAiCvFactory.instance(this.rbsConfigurationMao).createCv("NetWorkLoaderDownloadingComplete", "CV created after download complete.", "Could not create CV after finishing Network Loader downloading");
        ConfigurationReportLoggerFactory.getLogger().flushLogEntryBufferToFile();
        if (!success) {
            ConfigurationReportLoggerFactory.getLogger().logFailure("Network Loader Failure", "Warehouse CV NetWorkLoaderDownloadingComplete is NOT created.");
            throw new RbsConfigurationFailedException("Failed to create CV for Warehouse scenario");
        }
        ConfigurationReportLoggerFactory.getLogger().logInformation("Network Loader", "Warehouse CV NetWorkLoaderDownloadingComplete is created and startable.");
        logger.traceReturn(THIS_CLASS, "CreateWareHouseCv() : NetWorkLoaderDownloadingComplete");
    }
}

