/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.io.IOException;
import java.security.GeneralSecurityException;
import se.ericsson.crbs.cat.common.FileHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.DomXmlModifyHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.FqdnIpAddressPair;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.FqdnOrIpAddress;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.isi.RbsConfigurationIsiHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.transactionpackages.SetLogicalNameTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.InnerIpConfigurationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.NodeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.OuterIpConfigurationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecGwAddresses;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.WebServerAddresses;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.FileEncryptor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.FetchSiteInstallationTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.ReconfigureIpStack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.ReleaseDhcpIfTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.SiteInstallationFileParser;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse.EgisStateMonitor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class FetchSiteInstallationFileStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = FetchSiteInstallationFileStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public FetchSiteInstallationFileStateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 20);
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        if (this.skipFetchSiteInstallation()) {
            this.updateProgressReportInformation(250, 2, "Fetching SiteInstallation skipped as smrs data exists", true);
            logger.traceDebug(THIS_CLASS, "Fetch SiteInstallation.xml file skipped");
            this.stateHolder = new StateHolder(true, 21);
        } else {
            this.updateProgressReportInformation(250, 3, "Fetch SiteInstallation file from web server", true);
            ConfigurationReportLoggerFactory.getLogger().logInformation("Fetch SiteInstallation", "Fetch SiteInstallation file from web server.");
            FqdnOrIpAddress[] webServerAddresses = WebServerAddresses.instance(this.rbsConfigurationMao).getWebServerAddresses();
            boolean siFetchedOK = false;
            for (int w = 0; w < webServerAddresses.length && !siFetchedOK; ++w) {
                siFetchedOK = this.fetchAndParseSI(webServerAddresses[w].getAddressValue());
            }
            if (!EgisStateMonitor.getInstance().getIsEgisResponseFetched() && !siFetchedOK) {
                siFetchedOK = this.fetchAndParseSI(null);
            }
            IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
            SecGwAddresses secGwAddresses = SecGwAddresses.instance(this.rbsConfigurationMao);
            if (!siFetchedOK) {
                if (!(EgisStateMonitor.getInstance().getIsEgisResponseFetched() || webServerAddresses.length != 0 || !secGwAddresses.isEmpty() && secGwAddresses.hasNextSecGwAddress())) {
                    String defaultSecGwFqdn = ip.getDomainName() == null || ip.getDomainName().trim().length() == 0 ? "secgw.ai.ericsson" : "secgw.ai.ericsson." + ip.getDomainName();
                    secGwAddresses.pushSecGwAddress(new FqdnIpAddressPair(null, defaultSecGwFqdn));
                    ip.getOuterIpConfigurationData().setInitialSecGwFqdn(defaultSecGwFqdn);
                }
                String msg = "Failed to fetch and parse SiteInstallation file ";
                this.updateProgressReportInformation(250, 0, "Failed to fetch and parse SiteInstallation file ", true);
                ConfigurationReportLoggerFactory.getLogger().logFailure("Fetch SiteInstallation", "Fetch or parse SiteInstallation.xml failed.");
                logger.traceDebug(THIS_CLASS, "Failed to fetch and parse SiteInstallation file ");
                try {
                    TransactionHandler.run(new ReleaseDhcpIfTp(this.rbsConfigurationContext.getGenericMaoContext()));
                }
                catch (RbsConfigurationFailedException rcfe) {
                    logger.traceAbnormal(THIS_CLASS, "Failed to Release DHCP, reason: " + (Object)((Object)rcfe));
                }
                if (!secGwAddresses.hasNextSecGwAddress()) {
                    this.cleanAiParamters();
                }
                this.stateHolder = new StateHolder(true, 11);
            } else {
                try {
                    TransactionHandler.run(new SetLogicalNameTp(NodeParameters.instance(this.rbsConfigurationMao).getLogicalName(), this.moRepositoryWrapper));
                    if (!(ip.getOuterIpConfigurationData().getInitialSecGwIpAdd() != null && ip.getOuterIpConfigurationData().getInitialSecGwIpAdd().trim().length() != 0 || ip.getOuterIpConfigurationData().getInitialSecGwFqdn() != null && ip.getOuterIpConfigurationData().getInitialSecGwFqdn().trim().length() != 0)) {
                        new ReconfigureIpStack(this.rbsConfigurationMao).reconfigure();
                    }
                    this.updateProgressReportInformation(250, 5, "Successfully fetched SiteInstallation file from web server", true);
                    ConfigurationReportLoggerFactory.getLogger().logInformation("Fetch SiteInstallation", "Successfully fetched SiteInstallation file from web server.");
                    this.stateHolder = new StateHolder(true, 21);
                }
                catch (Exception e) {
                    String msg = "Failed to reconfigure IP stack: " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage());
                    this.updateProgressReportInformation(250, 0, "Failed to reconfigure IP stack : " + e, true);
                    logger.traceDebug(THIS_CLASS, msg);
                    try {
                        TransactionHandler.run(new SetLogicalNameTp("", this.moRepositoryWrapper));
                    }
                    catch (RbsConfigurationFailedException rcfe) {
                        logger.traceAbnormal(THIS_CLASS, "Failed to set logicalName to empty string, reason: " + (Object)((Object)rcfe));
                    }
                    this.cleanAiParamters();
                    this.stateHolder = new StateHolder(true, 11);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private boolean skipFetchSiteInstallation() {
        FileParameters fp = FileParameters.instance(this.rbsConfigurationMao);
        return this.notEmpty(fp.getSmrsSummaryFilePath()) && this.notEmpty(fp.getSmrsUserName()) && this.notEmpty(fp.getSmrsPassword()) || this.notEmpty(fp.getSiteBasicFilePath()) && this.notEmpty(fp.getSiteEquipmentFilePath()) || this.notEmpty(fp.getSiteInstallationFilePath());
    }

    private boolean fetchAndParseSI(String webServerAddress) {
        boolean result2 = false;
        try {
            FetchSiteInstallationTp fetchSiTp = new FetchSiteInstallationTp(webServerAddress, this.rbsConfigurationMao);
            TransactionHandler.runWithLoop(fetchSiTp);
            new SiteInstallationFileParser(fetchSiTp.getSiteInstallationXml(), this.rbsConfigurationMao).parse();
            result2 = true;
            this.saveSiToLocalFile(fetchSiTp.getSiteInstallationXml());
            this.encryptSiteInstallFile();
        }
        catch (Exception e) {
            logger.traceDebug(THIS_CLASS, "Fetch or parse SiteInstallation.xml failed: " + e.getMessage());
        }
        return result2;
    }

    private void encryptSiteInstallFile() {
        String localSiteInstallFilePath = this.helper.getLocalPath() + "SiteInstallation.xml";
        FileEncryptor encryptor = new FileEncryptor();
        RbsConfigurationIsiHelper isiHelper = (RbsConfigurationIsiHelper)this.rbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationIsiHelper.class);
        try {
            encryptor.encryptFile(localSiteInstallFilePath, isiHelper.getXmlEncryptionKey());
        }
        catch (IOException ioe) {
            logger.traceDebug(THIS_CLASS, "Read SiteInstallation.xml failed: " + ioe.getMessage());
        }
        catch (GeneralSecurityException gse) {
            logger.traceDebug(THIS_CLASS, "Encryption of SiteInstallation.xml failed: " + gse.getMessage());
        }
    }

    private void saveSiToLocalFile(String inSiteInstallationXml) throws RbsConfigurationFailedException {
        String localSiPath = this.helper.getLocalPath() + "SiteInstallation.xml";
        FileParameters.instance(this.rbsConfigurationMao).setSiteInstallationFilePath(localSiPath);
        String siXml = inSiteInstallationXml;
        FileHelper.writeToFile((String)localSiPath, (String)siXml, (boolean)false);
        IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
        String secGw = ip.getOuterIpConfigurationData().getInitialSecGwIpAdd();
        String SecGwFqdn = ip.getOuterIpConfigurationData().getInitialSecGwFqdn();
        int secGwPos = inSiteInstallationXml.indexOf("SecGW");
        if (secGwPos < 0 && RbsConfigurationHelper.existsAndNotEmpty(secGw)) {
            DomXmlModifyHelper domXmlModifier = new DomXmlModifyHelper(localSiPath);
            domXmlModifier.updateXmlElement("RbsSiteInstallationFile", "UntrustedNetworkTemporaryConfigurationData", new String[0], new String[0]);
            domXmlModifier.updateXmlElement("UntrustedNetworkTemporaryConfigurationData", "OuterIpConfigurationData", new String[0], new String[0]);
            domXmlModifier.updateXmlElement("OuterIpConfigurationData", "SecGW", new String[]{"ipAddress"}, new String[]{secGw});
            if (RbsConfigurationHelper.existsAndNotEmpty(SecGwFqdn)) {
                domXmlModifier.updateXmlAttribute("SecGW", "FQDN", SecGwFqdn);
            }
            domXmlModifier.writeToFile();
        }
    }

    private void cleanAiParamters() {
        FileParameters.instance().delete();
        IpParameters.instance(this.rbsConfigurationMao).delete();
        OuterIpConfigurationData.instance(this.rbsConfigurationMao).delete();
        InnerIpConfigurationData.instance(this.rbsConfigurationMao).delete();
        NodeParameters.instance(this.rbsConfigurationMao).delete();
        SecurityParameters.instance(this.rbsConfigurationMao).delete();
        SecGwAddresses.instance(this.rbsConfigurationMao).delete();
    }

    private boolean notEmpty(String str) {
        return str != null && str.length() > 0;
    }
}

