/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.io.File;
import se.ericsson.crbs.cat.common.ZipFileHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.isi.IsiHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.isi.RbsConfigurationIsiHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.ScenarioParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.ReleaseDhcpIfTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.IpStackConfigurator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.RestartNodeTp;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class InitialSoftwareInstallationStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = InitialSoftwareInstallationStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private String rootDir = "";

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String inRootDir) {
        this.rootDir = inRootDir;
    }

    public InitialSoftwareInstallationStateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 25);
        FileParameters.instance(this.rbsConfigurationMao).setIntegrationBasicPackageFileExtractPath(RbsConfigurationDefinitions.ISI_TEMP_PATH);
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        if (RbsConfigurationHelper.existsAndNotEmpty(FileParameters.instance(this.rbsConfigurationMao).getIntegrationBasicPackageFilePath()) && !this.nlhExists()) {
            this.executeInitialSoftwareInstallation();
        } else {
            this.updateProgressReportInformation(420, 2, "Installing Integration Basic Package", true);
            this.stateHolder = new StateHolder(true, 30);
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void executeInitialSoftwareInstallation() {
        this.updateProgressReportInformation(420, 3, "Installing Integration Basic Package", true);
        this.prepareRollbackDir(RbsConfigurationDefinitions.ISI_BACKUP_C);
        ConfigurationReportLoggerFactory.getLogger().logInformation("Network Loader", "Installing Integration Basic Package");
        boolean success = true;
        try {
            FileParameters fileParameters = FileParameters.instance(this.rbsConfigurationMao);
            logger.traceDebug(THIS_CLASS, "Unzip IHBP from " + fileParameters.getIntegrationBasicPackageFilePath() + " to directory " + fileParameters.getIntegrationBasicPackageFileExtractPath());
            ZipFileHelper.unzipFile((String)fileParameters.getIntegrationBasicPackageFilePath(), (String)fileParameters.getIntegrationBasicPackageFileExtractPath());
        }
        catch (FileHelper.FileException e) {
            logger.traceAbnormal(THIS_CLASS, "Failed to unzip IHBP file due to exception: " + e.getMessage());
            success = false;
        }
        if (success) {
            IsiHandler isiHandler = new IsiHandler(this.rbsConfigurationMao);
            try {
                isiHandler.execute();
                ConfigurationReportLoggerFactory.getLogger().logInformation("Initial Software Installation Complete", "Restart Node and start Node Self Configuration");
                ConfigurationReportLoggerFactory.getLogger().flushLogEntryBufferToFile();
                this.updateProgressReportInformation(420, 5, "Installing Integration Basic Package", true);
            }
            catch (RbsConfigurationFailedException e) {
                logger.traceDebug(THIS_CLASS, "Installation of Integration Basic Package Failed: " + e.getMessage());
                success = false;
            }
        }
        try {
            TransactionHandler.run(new ReleaseDhcpIfTp(this.rbsConfigurationContext.getGenericMaoContext()));
        }
        catch (RbsConfigurationFailedException e) {
            logger.traceDebug(THIS_CLASS, "Unable to release DHCP lease, it might not have existed in the first place");
        }
        if (success) {
            try {
                if (ScenarioParameters.instance(this.rbsConfigurationMao).getWithGuiScenario() != 0) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        logger.traceDebug(THIS_CLASS, "Wating for GUI polling interrupted: " + e.getMessage());
                    }
                }
                FileParameters.instance(this.rbsConfigurationMao).setNodeSelfConfigurationMode("InitialSoftwareInstallationPerformed");
                this.restartNode();
            }
            catch (RbsConfigurationFailedException e) {
                logger.traceDebug(THIS_CLASS, "Node Restart Failed: " + e.getMessage());
                this.initialSoftwareInstallationRollBack();
            }
        } else {
            this.initialSoftwareInstallationRollBack();
        }
    }

    private void prepareRollbackDir(String backupDirPath) {
        logger.traceEnter(THIS_CLASS, "prepareRollbackDir() " + backupDirPath);
        File cBackup = new File(backupDirPath);
        if (!cBackup.exists() && !cBackup.mkdir()) {
            logger.info(THIS_CLASS, "Fail to create " + backupDirPath);
        }
        logger.traceReturn(THIS_CLASS, "prepareRollbackDir()");
    }

    private void initialSoftwareInstallationRollBack() {
        logger.traceEnter(THIS_CLASS, "initialSoftwareInstallationRollBack()");
        this.updateProgressReportInformation(420, 0, "Installing Integration Basic Package", true);
        ConfigurationReportLoggerFactory.getLogger().logInformation("Network Loader", "Installation of Integration Basic Package failed. Start over AI from beginning.");
        try {
            RbsConfigurationIsiHelper isiHelper = (RbsConfigurationIsiHelper)this.rbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationIsiHelper.class);
            isiHelper.cleanConfigurationFilesAndIsiTempFiles(this.rootDir);
        }
        catch (FileHelper.FileException e) {
            logger.traceError(THIS_CLASS, "Exception happens during ISI rollback " + e.getMessage());
        }
        this.helper.setRbsConfigLevel(RbsConfigurationDefinitions.RBS_CL_BASIC_CV);
        IpStackConfigurator ipStackConfigurator = new IpStackConfigurator(this.rbsConfigurationMao);
        ipStackConfigurator.cleanIpStack(true);
        IpParameters.instance(this.rbsConfigurationMao).delete();
        FileParameters.instance(this.rbsConfigurationMao).delete();
        this.stateHolder = new StateHolder(true, 0);
        logger.traceReturn(THIS_CLASS, "initialSoftwareInstallationRollBack()");
    }

    private void restartNode() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "restartNode()");
        String restartInfo = "Node restart to switch to Integration Basic Package CV.";
        TransactionHandler.run(new RestartNodeTp(this.rbsConfigurationMao, new Integer(2), new Integer(0), restartInfo, "Node restart"));
        logger.traceReturn(THIS_CLASS, "restartNode()");
    }

    private boolean nlhExists() {
        File nlhFile = new File(this.rootDir + "/c/systemfiles/lte/autointegration/Nlh.xml");
        return nlhFile.exists() && nlhFile.isFile();
    }
}

