/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.JarURLConnection;
import java.security.GeneralSecurityException;
import se.ericsson.cello.cns.VendorCredentialsException;
import se.ericsson.cello.cns.VendorCredentialsMgr;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.swmanagement.ConfigurationVersionMo;
import se.ericsson.crbs.cat.common.FileHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.ClientTimeSetter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.isi.RbsConfigurationIsiHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.transactionpackages.SetLogicalNameTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.NodeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.StateMachineParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.FileEncryptor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.CreateIpSecMo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.SiteInstallationFileParser;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialcv.InitialAiCv;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialcv.InitialAiCvFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.AddStaticRouteTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.AssignAllEthernetLinkIpAddressesTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetAutoConfigurationAllowedTp;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.FileLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class IntegrationNotStartedStateExecutor
extends AbstractStateExecutor {
    final GenericMaoContext genericMaoContext;
    private static final Class THIS_CLASS = IntegrationNotStartedStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private FileLogger progressReportFileHandler;
    private RbsConfigurationIsiHelper isiHelper;
    private String prefix;

    public IntegrationNotStartedStateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, false, 0);
        this.genericMaoContext = this.rbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext();
        this.prefix = "";
        this.progressReportFileHandler = inRbsConfigurationMao.getFileLogger();
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        CreateIpSecMo ipSecMoCreator = new CreateIpSecMo(this.moRepositoryWrapper, this.moFactoryMgrWrapper);
        ipSecMoCreator.create();
        try {
            if (this.isInConfigLevelBasicCv() && this.hasVendorCredentials() && !this.isCancelledByUser() && !this.isIpStackConfigured()) {
                SecurityParameters.instance(this.rbsConfigurationMao).setActivateSecurity("true");
                SecurityParameters.instance().setActivateIpSecurity("true");
                this.setIntegrationLogFilePathAndStartlog();
                this.updateNodeUtcTime();
                this.isiHelper = (RbsConfigurationIsiHelper)this.rbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationIsiHelper.class);
                String nlhFilePath = this.prefix + "/c/systemfiles/lte/autointegration/Nlh.xml";
                File nlhFile = new File(nlhFilePath);
                if (nlhFile.exists()) {
                    ConfigurationVersionMo currentCV = this.isiHelper.getCvMo(this.rbsConfigurationMao);
                    String currentCvName = currentCV.getExecutingCv(null);
                    String rollBackCv = this.getRollBackCv(nlhFile);
                    if (!rollBackCv.equalsIgnoreCase(currentCvName)) {
                        this.startNodeSelfConfiguration(nlhFilePath);
                        StateMachineParameters.instance(this.rbsConfigurationMao).setWoLaptopCancelledByUser(Boolean.FALSE.toString());
                    } else {
                        this.cleanUpConfigFiles();
                        this.createAutoIntegrationInitialCv();
                        this.stateHolder = new StateHolder(true, 10);
                    }
                } else {
                    this.createAutoIntegrationInitialCv();
                    this.stateHolder = new StateHolder(true, 10);
                }
            }
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "Failure while trying to start WO laptop ", (Throwable)mae);
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private String getRollBackCv(File nlhFile) {
        String rollBackCv = "basic_cv";
        try {
            rollBackCv = this.isiHelper.getNlRollBackCv(nlhFile.getPath());
            logger.traceDebug(THIS_CLASS, "Network Loader Rollback CV: " + rollBackCv);
        }
        catch (IOException ioe) {
            logger.traceDebug(THIS_CLASS, "Fail to get Network Loader Rollback CV: " + nlhFile.getPath());
        }
        catch (GeneralSecurityException se) {
            logger.traceDebug(THIS_CLASS, "Fail to decrypt file: " + nlhFile.getPath());
        }
        return rollBackCv;
    }

    private void createAutoIntegrationInitialCv() throws RbsConfigurationFailedException {
        String message = "AI wo laptop - to handle cancellation";
        String faultMsg = "Could not create the CV.";
        InitialAiCv iacf = InitialAiCvFactory.instance(this.rbsConfigurationMao);
        String aiWoLaptopCvName = iacf.createInitialCv("RbsConfiguration_Initial", true, "AI wo laptop - to handle cancellation", "Could not create the CV.");
        if (aiWoLaptopCvName != null && aiWoLaptopCvName.trim().length() > 0) {
            iacf.saveCvName(aiWoLaptopCvName);
        }
    }

    private void cleanUpConfigFiles() throws MoAccessException {
        try {
            this.isiHelper.cleanConfigurationFilesAndIsiTempFiles(this.prefix);
            this.isiHelper.removeMergedIbpLoadModules(this.prefix, this.rbsConfigurationMao);
        }
        catch (FileHelper.FileException e) {
            logger.traceDebug(THIS_CLASS, "Fail to clean up: " + e.getMessage());
        }
    }

    private void startNodeSelfConfiguration(String nlhFilePath) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "startNodeSelfConfiguration() nlhFilePath = " + nlhFilePath);
        FileParameters.instance(this.rbsConfigurationMao).setNodeSelfConfigurationMode("InitialSoftwareInstallationPerformed");
        boolean isSemiAutoIntegrationRunning = false;
        try {
            isSemiAutoIntegrationRunning = this.isiHelper.getSftpData(nlhFilePath) != null;
            String sifFilePath = this.prefix + this.isiHelper.getSiteInstallationFile(nlhFilePath);
            FileParameters.instance(this.rbsConfigurationMao).setSiteInstallationFilePath(sifFilePath);
            FileEncryptor encryptor = new FileEncryptor();
            encryptor.decryptFile(sifFilePath, this.isiHelper.getXmlEncryptionKey());
            File tmpFile = new File(sifFilePath + "_decrypted");
            new SiteInstallationFileParser(this.getSiteInstallationXml(tmpFile.getPath()), this.rbsConfigurationMao).parse();
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            TransactionHandler.run(new SetLogicalNameTp(NodeParameters.instance(this.rbsConfigurationMao).getLogicalName(), this.moRepositoryWrapper));
        }
        catch (Exception exp) {
            String slogen = "Failure while trying to restore AutoIntegration Parameters: ";
            logger.traceError(THIS_CLASS, slogen + exp.getMessage(), (Throwable)exp);
            throw new RbsConfigurationFailedException(slogen);
        }
        this.updateNetworkLoaderProgressReport();
        if (!isSemiAutoIntegrationRunning) {
            this.stateHolder = new StateHolder(true, 10);
        } else {
            this.restoreEthernetLink();
            SecurityParameters.instance(this.rbsConfigurationMao).setActivateSecurity("false");
            SecurityParameters.instance().setActivateIpSecurity("false");
            this.updateProgressReportSemiAutoInt();
            SetAutoConfigurationAllowedTp setAutoConfigurationAllowed = new SetAutoConfigurationAllowedTp(this.rbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext(), true);
            try {
                TransactionHandler.run(setAutoConfigurationAllowed);
            }
            catch (RbsConfigurationFailedException rcfe) {
                String msg = "Could not activate autoConfiguration on Mo ManagedElementData.";
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Environment fault", "Could not activate autoConfiguration on Mo ManagedElementData.");
                logger.traceError(THIS_CLASS, "setAutoConfigurationAllowed():Could not activate autoConfiguration on Mo ManagedElementData. Original exception: " + rcfe.getVariablesAsString());
            }
            this.stateHolder = new StateHolder(true, 21);
            logger.traceReturn(THIS_CLASS, "startNodeSelfConfiguration() next state = " + this.stateHolder.getNextState());
        }
    }

    private void restoreEthernetLink() {
        File le0cfg = new File(this.prefix + "/d/configuration/" + "le0.cfg");
        File defaultrouter = new File(this.prefix + "/d/configuration/" + "defaultrouter");
        if (!le0cfg.exists() || !defaultrouter.exists()) {
            logger.traceDebug(THIS_CLASS, "le0.cfg or defaultrouterdoes not exit. Keep default EthernetLink address");
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(le0cfg));
        }
        catch (FileNotFoundException e) {
            logger.traceDebug(THIS_CLASS, "Exception happened when reading le0.cfg to buffer " + e.getMessage());
        }
        String le0ipAddressValue = null;
        String le0SubnetMaskValue = null;
        String le0BroadcastAddressValue = null;
        try {
            le0ipAddressValue = br.readLine();
            le0SubnetMaskValue = br.readLine();
            le0BroadcastAddressValue = br.readLine();
            br.close();
        }
        catch (IOException e) {
            logger.traceDebug(THIS_CLASS, "Exception happened when reading le0.cfg " + e.getMessage());
        }
        String defaultrouterValue = null;
        try {
            defaultrouterValue = FileHelper.getFileContents(defaultrouter).trim();
        }
        catch (IOException e) {
            logger.traceDebug(THIS_CLASS, "Exception happened when reading defaultrouter " + e.getMessage());
        }
        if (le0ipAddressValue != null && le0SubnetMaskValue != null && le0BroadcastAddressValue != null && defaultrouterValue != null) {
            try {
                TransactionHandler.run(new AssignAllEthernetLinkIpAddressesTp(this.genericMaoContext, le0ipAddressValue, le0SubnetMaskValue, le0BroadcastAddressValue));
                TransactionHandler.run(new AddStaticRouteTp(this.rbsConfigurationMao, this.genericMaoContext, "0.0.0.0", "0.0.0.0", defaultrouterValue, 64, false));
            }
            catch (RbsConfigurationFailedException e) {
                logger.traceDebug(THIS_CLASS, "Exception happened when restoring le0 ip configuration " + e.getMessage());
            }
        }
    }

    private void updateNetworkLoaderProgressReport() {
        String detailedInformation = "Finished or Skipped by Network Loader";
        this.updateProgressReportInformation(20, 5, "Finished or Skipped by Network Loader", true);
        this.updateProgressReportInformation(50, 5, "Finished or Skipped by Network Loader", true);
        this.updateProgressReportInformation(95, 5, "Finished or Skipped by Network Loader", true);
        this.updateProgressReportInformation(100, 5, "Finished or Skipped by Network Loader", true);
        this.updateProgressReportInformation(150, 5, "Finished or Skipped by Network Loader", true);
        this.updateProgressReportInformation(200, 5, "Finished or Skipped by Network Loader", true);
        this.updateProgressReportInformation(250, 5, "Finished or Skipped by Network Loader", true);
        this.updateProgressReportInformation(300, 5, "Finished or Skipped by Network Loader", true);
        this.updateProgressReportInformation(400, 5, "Finished or Skipped by Network Loader", true);
        this.updateProgressReportInformation(420, 5, "Finished or Skipped by Network Loader", true);
        this.updateProgressReportInformation(900, 5, "Finished or Skipped by Network Loader", true);
        this.updateProgressReportInformation(1500, 5, "Finished or Skipped by Network Loader", true);
        this.updateProgressReportInformation(500, 5, "Finished or Skipped by Network Loader", true);
        this.updateProgressReportInformation(1900, 5, "Finished or Skipped by Network Loader", true);
    }

    private void updateProgressReportSemiAutoInt() {
        String detailedInformation = "Skipped by Network Loader";
        this.updateProgressReportInformation(2000, 2, "Skipped by Network Loader", true);
        this.updateProgressReportInformation(2200, 2, "Skipped by Network Loader", true);
        this.updateProgressReportInformation(1450, 2, "Skipped by Network Loader", true);
        this.updateProgressReportInformation(1800, 2, "Skipped by Network Loader", true);
        this.updateProgressReportInformation(1850, 2, "Skipped by Network Loader", true);
    }

    private String getSiteInstallationXml(String fileIn) throws IOException {
        return FileHelper.getFileContents(new File(fileIn));
    }

    private void updateNodeUtcTime() throws NoSuchAttributeException, MoAccessException {
        ManagedObject managedElementData = this.moRepositoryWrapper.lookup("ManagedElement=1,ManagedElementData=1");
        if (managedElementData != null) {
            Long currentTime = (Long)managedElementData.getAttribute("nodeUTCTime", null);
            logger.traceDebug(THIS_CLASS, "current time on node: " + currentTime);
            long jarTime = this.getLatestJarTime();
            logger.traceDebug(THIS_CLASS, "current jar time: " + jarTime);
            if (currentTime == null || currentTime < jarTime) {
                ClientTimeSetter clientTimeSetter = new ClientTimeSetter(this.moRepositoryWrapper, this.helper);
                clientTimeSetter.setTime(jarTime);
            }
        }
    }

    private long getLatestJarTime() {
        logger.traceEnter(THIS_CLASS, "getLatestJarTime()");
        if ("true".equalsIgnoreCase(System.getProperty("UNIT_TEST", "false"))) {
            return -1L;
        }
        try {
            String rn = THIS_CLASS.getName().replace('.', '/') + ".class";
            logger.traceDebug(THIS_CLASS, "Path of this class: " + rn);
            JarURLConnection j = (JarURLConnection)ClassLoader.getSystemResource(rn).openConnection();
            logger.traceReturn(THIS_CLASS, "getLatestJarTime()");
            return j.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime();
        }
        catch (IOException e) {
            logger.traceAbnormal(THIS_CLASS, "Failed to open connection towards Jar file. Reason: " + e.getMessage());
            return -1L;
        }
    }

    private boolean isIpStackConfigured() {
        logger.traceEnter(THIS_CLASS, "isIpStackConfigured()");
        boolean ipHostLink = this.checkIfMoExists("IpHostLink");
        boolean ipInterface = this.checkIfMoExists("IpInterface");
        boolean gigaBitEthernet = this.checkIfMoExists("GigaBitEthernet");
        logger.traceReturn(THIS_CLASS, "isIpStackConfigured()");
        return ipHostLink && ipInterface && gigaBitEthernet;
    }

    private boolean checkIfMoExists(String moType) {
        MoIterator moIter = this.moRepositoryWrapper.lookupType(moType);
        return moIter != null && moIter.hasMoreElements();
    }

    private void setIntegrationLogFilePathAndStartlog() throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setIntegrationLogFilePathAndStartlog()");
        String logFilePathSting = (String)this.rbsConfigurationMao.retrievePersistently("integrationLogFilePath");
        if (logFilePathSting == null || logFilePathSting.equals("")) {
            try {
                this.rbsConfigurationMao.storePersistently("integrationLogFilePath", this.progressReportFileHandler.getDefaultFileLogPath());
            }
            catch (MoAccessException e) {
                logger.traceError(THIS_CLASS, "Failed to retrieve Integration log file. Reason: " + e.getMessage());
            }
            String nlhFilePath = this.helper.getLocalPath() + "Nlh.xml";
            boolean nlhFileExists = new File(nlhFilePath).exists();
            if (!nlhFileExists) {
                this.rbsConfigurationMao.integrationStarted();
                ConfigurationReportLoggerFactory.getLogger().finishAndSaveReportFile(false);
                Object reportAttr = this.rbsConfigurationMao.getAttribute("configurationReport");
                StringBuffer reportAttrBuffer = reportAttr == null ? new StringBuffer() : new StringBuffer((String)reportAttr);
                ConfigurationReportLoggerFactory.getLogger().setConfigurationReportStringBuffer(reportAttrBuffer);
                this.rbsConfigurationMao.setReadOnlyAttribute("configurationReport", "");
            } else {
                this.rbsConfigurationMao.integrationContinued();
                Object reportAttr = this.rbsConfigurationMao.getAttribute("configurationReport");
                StringBuffer reportAttrBuffer = reportAttr == null ? new StringBuffer() : new StringBuffer((String)reportAttr);
                this.rbsConfigurationMao.setReadOnlyAttribute("configurationReport", "");
                ConfigurationReportLoggerFactory.getLogger().restoreConfigurationReport(nlhFileExists, reportAttrBuffer);
            }
            this.progressReportHandler.integrationHasBeenStarted(true, true);
        }
        logger.traceReturn(THIS_CLASS, "setIntegrationLogFilePathAndStartlog()");
    }

    private boolean isInConfigLevelBasicCv() throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "isInConfigLevelBasicCv()");
        Integer rbsConfigLevel = (Integer)this.rbsConfigurationMao.getAttribute("rbsConfigLevel");
        boolean result2 = RbsConfigurationDefinitions.RBS_CL_BASIC_CV.intValue() == rbsConfigLevel.intValue();
        logger.traceReturn(THIS_CLASS, "isInConfigLevelBasicCv() " + result2);
        return result2;
    }

    private boolean hasVendorCredentials() {
        logger.traceEnter(THIS_CLASS, "hasVendorCredentials()");
        boolean result2 = false;
        try {
            result2 = VendorCredentialsMgr.getVCInterface().isVCPresent();
        }
        catch (VendorCredentialsException vce) {
            logger.traceDebug(THIS_CLASS, "Failed to read Vendor Credentails, interpret that as there is no VC on the node");
        }
        logger.traceReturn(THIS_CLASS, "hasVendorCredentials() " + result2);
        return result2;
    }

    private boolean isCancelledByUser() {
        logger.traceEnter(THIS_CLASS, "isCancelledByUser()");
        String integrationWasCancelledByUser = StateMachineParameters.instance(this.rbsConfigurationMao).getWoLaptopCancelledByUser();
        boolean result2 = integrationWasCancelledByUser != null && Boolean.TRUE.toString().equalsIgnoreCase(integrationWasCancelledByUser);
        logger.traceReturn(THIS_CLASS, "isCancelledByUser() " + result2);
        return result2;
    }

    protected void setUnitTestRootPrefix(String pathIn) {
        this.prefix = pathIn;
    }
}

