/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.net.UnknownHostException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.InnerIpConfigurationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.NodeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.OuterIpConfigurationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecGwAddresses;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.VlanIds;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.WebServerAddresses;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.ConfiguratorHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.DhcpConfigurator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.IpStackConfigurator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse.EgisConfigurator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse.EgisStateMonitor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetDefaultNtpServerTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpConfigurationStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = IpConfigurationStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public IpConfigurationStateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 11);
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        logger.info(THIS_CLASS, "Running auto integration step 3!");
        int initialVlanId = IpParameters.instance(this.rbsConfigurationMao).getVlanId();
        if (this.doFetchDhcpData() && !EgisStateMonitor.getInstance().isEgisExecuted()) {
            int[] vlans = VlanIds.instance(this.rbsConfigurationMao).getVlanIds();
            this.resetNtpSyncDetails();
            for (int i = 0; i < vlans.length; ++i) {
                IpParameters.instance(this.rbsConfigurationMao).setVlanId(vlans[i]);
                EgisConfigurator egisConfigurator = new EgisConfigurator(this.rbsConfigurationMao, this.helper, this.moRepositoryWrapper);
                egisConfigurator.applyConfiguration();
            }
            EgisStateMonitor.getInstance().setEgisExecuted(true);
        }
        IpParameters.instance(this.rbsConfigurationMao).setVlanId(initialVlanId);
        this.stateHolder = this.configureIpStack() ? new StateHolder(true, 20) : (VlanIds.instance(this.rbsConfigurationMao).hasNextVlanId() ? new StateHolder(true, 11) : new StateHolder(true, 10));
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private boolean configureIpStack() {
        logger.traceEnter(THIS_CLASS, "configureIpStack()");
        logger.traceDebug(THIS_CLASS, "configureIpStack() VlanId: " + IpParameters.instance(this.rbsConfigurationMao).getVlanId() + ", " + VlanIds.instance(this.rbsConfigurationMao).toString());
        boolean configuredSuccessfully = false;
        DhcpConfigurator dhcpConfigurator = new DhcpConfigurator(this.rbsConfigurationMao);
        IpStackConfigurator ipStackConfigurator = new IpStackConfigurator(this.rbsConfigurationMao);
        this.cleanIpStackButLeaveGigabitEthernet(dhcpConfigurator);
        if (IpParameters.instance(this.rbsConfigurationMao).getVlanId() != -2 && VlanIds.instance(this.rbsConfigurationMao).getVlanIds().length == 0) {
            VlanIds.instance(this.rbsConfigurationMao).setVlanIds(new int[]{IpParameters.instance().getVlanId()});
        }
        if (this.doFetchDhcpData()) {
            if (this.vlanOrDhcpConfiguration(configuredSuccessfully, dhcpConfigurator, ipStackConfigurator)) {
                configuredSuccessfully = true;
            } else {
                configuredSuccessfully = false;
                dhcpConfigurator.cleanIpStack(true);
            }
        } else {
            try {
                this.updateProgressReportInformation(100, 2, "Skipped fetching basic IP configuration via DHCP", false);
                ProgressReportHandler.getInstance().setCurrentIpAddress(IpParameters.instance(this.rbsConfigurationMao).getIpAddress(), false);
                configuredSuccessfully = ipStackConfigurator.applyConfiguration(true);
            }
            catch (RbsConfigurationFailedException rcfe) {
                if (rcfe.getLocalizedMessage().trim().equals("Security gateways exhausted")) {
                    IpParameters.instance(this.rbsConfigurationMao).delete();
                    OuterIpConfigurationData.instance(this.rbsConfigurationMao).delete();
                    InnerIpConfigurationData.instance(this.rbsConfigurationMao).delete();
                    SecGwAddresses.instance().delete();
                    WebServerAddresses.instance().delete();
                    return false;
                }
                String errorMsg = "Unable to configure IP settings, original message: " + rcfe.getLocalizedMessage();
                this.updateProgressReportInformation(100, 4, errorMsg, false);
                this.updateProgressReportInformation(200, 4, errorMsg, true);
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "IP configuration fault", errorMsg);
                this.helper.waitForRetry("IP configuration");
            }
            catch (UnknownHostException uhe) {
                String errorMsg = "Unable to configure IP settings, original message: " + uhe.getLocalizedMessage();
                this.updateProgressReportInformation(100, 4, errorMsg, false);
                this.updateProgressReportInformation(200, 4, errorMsg, true);
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "IP configuration fault", errorMsg);
                this.helper.waitForRetry("IP configuration");
            }
        }
        logger.traceReturn(THIS_CLASS, "configureIpStack()");
        return configuredSuccessfully;
    }

    private boolean vlanOrDhcpConfiguration(boolean inConfiguredSuccessfully, DhcpConfigurator inDhcpConfigurator, IpStackConfigurator inIpStackConfigurator) {
        logger.traceEnter(THIS_CLASS, "vlanOrDhcpConfiguration()");
        int tempVlanId = -22;
        while (VlanIds.instance(this.rbsConfigurationMao).hasNextVlanId()) {
            try {
                tempVlanId = VlanIds.instance(this.rbsConfigurationMao).getNextVlanId();
                logger.traceDebug(THIS_CLASS, "Trying with: " + tempVlanId);
                IpParameters.instance(this.rbsConfigurationMao).setVlanId(tempVlanId);
                if (!inDhcpConfigurator.applyConfiguration()) continue;
                inIpStackConfigurator.cleanIpStack(false);
                inConfiguredSuccessfully = inIpStackConfigurator.applyConfiguration(RbsConfigurationHelper.existsAndNotEmpty(NodeParameters.instance(this.rbsConfigurationMao).getDhcpClientIdentifier()));
                break;
            }
            catch (MoAccessException mae) {
                logger.traceDebug(THIS_CLASS, "Received exception when configuring with: " + tempVlanId);
                logger.traceError(THIS_CLASS, mae.getLocalizedMessage());
                IpParameters.instance(this.rbsConfigurationMao).delete();
                inDhcpConfigurator.cleanIpStack(false);
            }
            catch (UnknownHostException uhe) {
                logger.traceDebug(THIS_CLASS, "Received exception when configuring with: " + tempVlanId);
                logger.traceError(THIS_CLASS, uhe.getLocalizedMessage());
                IpParameters.instance(this.rbsConfigurationMao).delete();
                inDhcpConfigurator.cleanIpStack(false);
            }
        }
        logger.traceReturn(THIS_CLASS, "vlanOrDhcpConfiguration()");
        return inConfiguredSuccessfully;
    }

    private void cleanIpStackButLeaveGigabitEthernet(DhcpConfigurator dhcpConfigurator) {
        logger.traceEnter(THIS_CLASS, "cleanIpStackButLeaveGigabitEthernet()");
        dhcpConfigurator.cleanIpStack(false);
        MoIterator moIter = this.moRepositoryWrapper.lookupType("GigaBitEthernet");
        if (moIter == null) {
            ConfiguratorHelper.createGigabitEthernetMo(this.rbsConfigurationContext.getGenericMaoContext(), ConfiguratorHelper.RETRY_SLEEP_TIME, this.helper);
        }
        logger.traceReturn(THIS_CLASS, "cleanIpStackButLeaveGigabitEthernet()");
    }

    private boolean doFetchDhcpData() {
        logger.traceEnter(THIS_CLASS, "doFetchDhcpData()");
        IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
        boolean result2 = (!RbsConfigurationHelper.existsAndNotEmpty(ip.getIpAddress()) || !RbsConfigurationHelper.existsAndNotEmpty(ip.getSubnetMask()) && !RbsConfigurationHelper.existsAndNotEmpty(ip.getNetworkPrefixLength()) || !RbsConfigurationHelper.existsAndNotEmpty(ip.getDefaultRouter())) && (!RbsConfigurationHelper.existsAndNotEmpty(ip.getOuterIpConfigurationData().getOuterIpAddress()) || !RbsConfigurationHelper.existsAndNotEmpty(ip.getOuterIpConfigurationData().getOuterSubnetMask()) || !RbsConfigurationHelper.existsAndNotEmpty(ip.getOuterIpConfigurationData().getOuterDefaultRouterZero()) || !RbsConfigurationHelper.existsAndNotEmpty(ip.getOuterIpConfigurationData().getInitialSecGwFqdn()) && !RbsConfigurationHelper.existsAndNotEmpty(ip.getOuterIpConfigurationData().getInitialSecGwIpAdd()));
        logger.traceReturn(THIS_CLASS, "doFetchDhcpData() " + result2);
        return result2;
    }

    private void resetNtpSyncDetails() {
        logger.traceEnter(THIS_CLASS, "resetNtpSyncDetails()");
        try {
            TransactionHandler.run(new SetDefaultNtpServerTp(this.rbsConfigurationContext.getGenericMaoContext(), "", "169.254.0.10"));
        }
        catch (RbsConfigurationFailedException e) {
            logger.traceDebug(THIS_CLASS, "Unable to reset NTP server MO. " + e.getMessage());
        }
        this.helper.setIsFirstNodeTimeReceivedFromNtp(false);
        logger.traceReturn(THIS_CLASS, "resetNtpSyncDetails()");
    }
}

