/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.AbstractIpSecThread;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class PrepareIpSecurityStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = PrepareIpSecurityStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final AbstractIpSecThread ipSecThread;

    public PrepareIpSecurityStateExecutor(RbsConfigurationMao inRbsConfigurationMao, AbstractIpSecThread inIpSecThread) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 63);
        this.ipSecThread = inIpSecThread;
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        try {
            this.rbsConfigurationMao.storePersistently("wantedIpSecLevel", RbsConfigurationDefinitions.RBS_WANTED_IP_SEC_LEVEL_DEFAULT_VALUE);
            this.rbsConfigurationMao.storePersistently("reachedIpSecLevel", RbsConfigurationDefinitions.RBS_REACHED_IP_SEC_LEVEL_DEFAULT_VALUE);
            this.rbsConfigurationMao.storePersistently("IpSecFingerPrint", "");
            this.rbsConfigurationMao.storePersistently("IpSecSerialNumber", "");
        }
        catch (MoAccessException mae) {
            String errorMsg = ExceptionHelper.appendReason((String)"Unable to persistently store the attributes for IpSec default values!", (Throwable)mae);
            logger.traceError(THIS_CLASS, errorMsg);
        }
        boolean okToStartIpSecThread = false;
        okToStartIpSecThread = this.stateHandler.checkOkToStartIpSecThread();
        if (okToStartIpSecThread) {
            this.ipSecThread.start();
            logger.traceDebug(THIS_CLASS, "IpSec thread started successfully!");
        }
        this.stateHolder = new StateHolder(true, 65);
        logger.traceReturn(THIS_CLASS, "execute()");
    }
}

