/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.AbstractConfigureRetProfileThread;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class ReadyForServiceStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = ReadyForServiceStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final long WAIT_FOR_NEXT_RETRY_INTERVAL = 2000L;
    private final AbstractConfigureRetProfileThread configureRetProfileThread;

    public ReadyForServiceStateExecutor(RbsConfigurationMao inRbsConfigurationMao, AbstractConfigureRetProfileThread inConfigureRetProfileThread) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 130);
        this.configureRetProfileThread = inConfigureRetProfileThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        this.waitForConfigureRetProfileThread();
        boolean readyForService = false;
        while (!readyForService) {
            try {
                readyForService = this.isNodeReadyForService();
                if (readyForService) {
                    this.updateProgressReportInformation(2700, 5, "Node is ready for service", true);
                    this.helper.setRbsConfigLevel(RbsConfigurationDefinitions.RBS_CL_READY_FOR_SERVICE);
                    this.rbsConfigurationMao.setReadOnlyAttribute("progressLevel", new Integer(100));
                    continue;
                }
                this.updateProgressReportInformation(2700, 3, "Waiting for node to be ready for service", true);
            }
            catch (Exception e) {
                String errorMessage = "Failed to determine whether the node is ready for service or not due to: " + ExceptionHelper.getExceptionMessage((Throwable)e) + "\nWill retry...";
                this.updateProgressReportInformation(2700, 4, errorMessage, true);
                logger.traceAbnormal(THIS_CLASS, errorMessage);
            }
            finally {
                if (readyForService) continue;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ignore) {
                    logger.traceAbnormal(THIS_CLASS, "Wait thread killed");
                }
            }
        }
        this.stateHolder = new StateHolder(false, 110);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    protected boolean isNodeReadyForService() throws MoAccessException {
        boolean integrationFinished = this.helper.hasIntegrationCompletePostSetBeenExecuted();
        Integer configLevel = (Integer)this.rbsConfigurationMao.getAttribute("rbsConfigLevel");
        boolean correctConfigLevel = integrationFinished && configLevel != null && (configLevel.intValue() == RbsConfigurationDefinitions.RBS_CL_INTEGRATION_COMPLETE.intValue() || configLevel.intValue() == RbsConfigurationDefinitions.RBS_CL_READY_FOR_SERVICE.intValue());
        return correctConfigLevel;
    }

    private void waitForConfigureRetProfileThread() {
        logger.traceEnter(THIS_CLASS, "waitForConfigureRetProfileThread()");
        while (this.configureRetProfileThread != null && this.configureRetProfileThread.getThread() != null && this.configureRetProfileThread.getThread().isAlive()) {
            try {
                this.updateProgressReportInformation(2700, 3, "Waiting for antenna calibration", true);
                logger.traceGeneral(THIS_CLASS, "Waiting for ConfigureRetProfileThread to terminate...");
                this.configureRetProfileThread.getThread().join(2500L);
            }
            catch (InterruptedException e1) {
                logger.traceAbnormal(THIS_CLASS, "Main thread interrupted.  " + e1.getStackTrace() + "\n Resuming waiting.");
            }
        }
        logger.traceGeneral(THIS_CLASS, "ConfigureRetProfileThread thread terminated");
        logger.traceReturn(THIS_CLASS, "waitForConfigureRetProfileThread()");
    }
}

