/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.createcv;

import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.mom.ConfigurationVersion;
import se.ericsson.cello.swmanagement.ConfigurationVersionMo;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.aicv.AbstractAiCv;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.createcv.CreateAiCv;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class CreateAiCvImpl
extends AbstractAiCv
implements CreateAiCv {
    private static final Class THIS_CLASS = CreateAiCvImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String CV_CREATION_FAULT_REASON = "CV creation failure";
    static /* synthetic */ Class class$se$ericsson$crbs$cat$mao$rbsconfiguration$state$createcv$CreateAiCvImpl$WaitForRetry;

    protected CreateAiCvImpl(RbsConfigurationMao rbsConfigurationMaoIn) {
        super(rbsConfigurationMaoIn);
    }

    public boolean createCv(String newCvName, String comment, String faultMsg) {
        logger.traceEnter(THIS_CLASS, "createCv()" + newCvName);
        boolean success = false;
        int cvIntegrationStep = 2350;
        ConfigurationVersionMo cvMo = this.getCvMo();
        if (cvMo != null && newCvName != null) {
            try {
                this.handleCreateCv(newCvName, false, comment, faultMsg, 2350, (ConfigurationVersion)cvMo);
                this.removeCvFromRollbackListAndDeleteCv("RbsConfiguration_Initial", faultMsg, 2350, (ConfigurationVersion)cvMo);
                ProgressReportHandler.getInstance().updateProgressReportInformation(2350, 5, "Successfully created CV: " + StringHelper.doubleQuote((String)newCvName), true);
                ProgressReportHandler.getInstance().setIntegrationCanBeCancelled(Boolean.TRUE);
                success = true;
            }
            catch (ConfigurationVersionException cve) {
                String errorMsg = faultMsg + " " + (Object)((Object)cve);
                ProgressReportHandler.getInstance().updateProgressReportInformation(2350, 0, errorMsg, true);
                ProgressReportHandler.getInstance().setIntegrationCanBeCancelled(Boolean.TRUE);
                this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, CV_CREATION_FAULT_REASON, errorMsg);
            }
            catch (MoAccessException mae) {
                String errorMsg = faultMsg + " " + RbsConfigurationFailedException.convertVariablesMessage(mae.getVariablesAsString());
                ProgressReportHandler.getInstance().updateProgressReportInformation(2350, 0, errorMsg, true);
                ProgressReportHandler.getInstance().setIntegrationCanBeCancelled(Boolean.TRUE);
                this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, CV_CREATION_FAULT_REASON, errorMsg);
            }
        }
        logger.traceReturn(THIS_CLASS, "createCv() success: " + success);
        return success;
    }

    protected class WaitForRetry {
        final Class THIS_INNER_CLASS = class$se$ericsson$crbs$cat$mao$rbsconfiguration$state$createcv$CreateAiCvImpl$WaitForRetry == null ? (class$se$ericsson$crbs$cat$mao$rbsconfiguration$state$createcv$CreateAiCvImpl$WaitForRetry = CreateAiCvImpl.class$("se.ericsson.crbs.cat.mao.rbsconfiguration.state.createcv.CreateAiCvImpl$WaitForRetry")) : class$se$ericsson$crbs$cat$mao$rbsconfiguration$state$createcv$CreateAiCvImpl$WaitForRetry;
        private int noOfRetries = 0;

        protected WaitForRetry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForRetry(String actionName) {
            logger.traceEnter(THIS_CLASS, "waitForRetry(action) - " + actionName);
            long time = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST")) ? 10L : (this.noOfRetries <= 3 ? 5000L : 100000L);
            try {
                logger.traceDebug(this.THIS_INNER_CLASS, "Sleeping for " + (double)time / 1000.0 + " seconds before new retry. This is the retry number " + this.noOfRetries + ".");
                Class clazz = this.THIS_INNER_CLASS;
                synchronized (clazz) {
                    this.THIS_INNER_CLASS.wait(time);
                }
            }
            catch (InterruptedException ie) {
                logger.traceError(this.THIS_INNER_CLASS, "waitForRetry(action - " + actionName + "):" + "Interrupted while waiting to retry action " + actionName, (Throwable)ie);
            }
            ++this.noOfRetries;
            logger.traceReturn(this.THIS_INNER_CLASS, "waitForRetry(action) - " + actionName);
        }
    }
}

