/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.AddOrModifySshSmrsEntryInAccessControlListTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.DeleteDefaultStaticRouteTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.GetIpAddressAndDefaultRouter0Tp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.ReleaseDhcpIfTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.AddStaticRouteTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CleanIpConfigurationTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.ConfigureIpMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpHostLinkMoIpv6Tp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpv6InterfaceMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpv6MoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetIpAddressOnIpHostLinkTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetNodeInterfaceNameTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetVlanOnIpInterfaceMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetVlanOnIpv6InterfaceMoTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class ReconfigureIpStack {
    private static final Class THIS_CLASS = ReconfigureIpStack.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final RbsConfigurationMao rbsConfigurationMao;

    public ReconfigureIpStack(RbsConfigurationMao rbsConfigurationMaoIn) {
        this.rbsConfigurationMao = rbsConfigurationMaoIn;
    }

    public void reconfigure() throws RbsConfigurationFailedException, UnknownHostException {
        logger.traceEnter(THIS_CLASS, "reconfigure()");
        if (Inet4Address.getByName(IpParameters.instance().getIpAddress()) instanceof Inet4Address) {
            this.applyIpv4Configuration();
        } else {
            this.applyIpv6Configuration();
        }
        logger.traceReturn(THIS_CLASS, "reconfigure()");
    }

    private void applyIpv4Configuration() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "applyIpv4Configuration()");
        IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
        GenericMaoContext genericMaoContext = this.rbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext();
        GetIpAddressAndDefaultRouter0Tp getIpAddressAndDefaultRouter0 = new GetIpAddressAndDefaultRouter0Tp(genericMaoContext);
        TransactionHandler.run(getIpAddressAndDefaultRouter0);
        TransactionHandler.run(new ReleaseDhcpIfTp(genericMaoContext));
        TransactionHandler.run(new SetIpAddressOnIpHostLinkTp(genericMaoContext, ip.getIpAddress(), ip.getSubnetMask(), ip.getDefaultRouter()));
        TransactionHandler.run(new SetVlanOnIpInterfaceMoTp(genericMaoContext, ip.getVlanId()));
        TransactionHandler.runWithLoop(new DeleteDefaultStaticRouteTp(genericMaoContext, getIpAddressAndDefaultRouter0.getDefaultRouter0()));
        TransactionHandler.run(new AddStaticRouteTp(this.rbsConfigurationMao, genericMaoContext, "0.0.0.0", "0.0.0.0", ip.getDefaultRouter(), 16, false));
        TransactionHandler.run(new AddOrModifySshSmrsEntryInAccessControlListTp(this.rbsConfigurationMao, genericMaoContext, getIpAddressAndDefaultRouter0.getIpAddress()));
        TransactionHandler.run(new ConfigureIpMoTp(genericMaoContext, ip.getDnsServerAddress(), ip.getDefaultDomainName(), 0));
        TransactionHandler.run(new SetNodeInterfaceNameTp(this.rbsConfigurationMao, genericMaoContext, "1", null, true));
        logger.traceReturn(THIS_CLASS, "applyIpv4Configuration()");
    }

    private void applyIpv6Configuration() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "applyIpv6Configuration()");
        IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
        GenericMaoContext genericMaoContext = this.rbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext();
        TransactionHandler.run(new CleanIpConfigurationTp(genericMaoContext, true));
        TransactionHandler.run(new CreateIpv6MoTp(genericMaoContext));
        TransactionHandler.run(new CreateIpv6InterfaceMoTp(genericMaoContext));
        TransactionHandler.run(new CreateIpHostLinkMoIpv6Tp(genericMaoContext, ip.getIpAddress(), ip.getNetworkPrefixLength()));
        TransactionHandler.run(new SetVlanOnIpv6InterfaceMoTp(genericMaoContext, ip.getVlanId()));
        TransactionHandler.run(new AddStaticRouteTp(this.rbsConfigurationMao, genericMaoContext, "::", "0", ip.getDefaultRouter(), 16, false));
        TransactionHandler.run(new ConfigureIpMoTp(genericMaoContext, ip.getDnsServerAddress(), ip.getDefaultDomainName(), 0));
        TransactionHandler.run(new SetNodeInterfaceNameTp(this.rbsConfigurationMao, genericMaoContext, "1", null, false));
        logger.traceReturn(THIS_CLASS, "applyIpv6Configuration()");
    }
}

