/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration;

import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CleanIpConfigurationTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.RemoveTemporaryTunnelTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public abstract class IpConfigurator {
    private static final Class THIS_CLASS = IpConfigurator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    final RbsConfigurationMao rbsConfigurationMao;
    protected RbsConfigurationHelper helper;
    protected GenericMaoContext genericMaoContext;

    public IpConfigurator(RbsConfigurationMao inRbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "IpConfigurator()");
        this.rbsConfigurationMao = inRbsConfigurationMao;
        this.helper = (RbsConfigurationHelper)inRbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationHelper.class);
        this.genericMaoContext = inRbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext();
        logger.traceReturn(THIS_CLASS, "IpConfigurator()");
    }

    public void setRbsConfigurationHelperOnlyForBT(RbsConfigurationHelper inRbsConfigurationHelper) {
        this.helper = inRbsConfigurationHelper;
    }

    public void cleanIpStack(boolean inputFlag) {
        try {
            TransactionHandler.run(new RemoveTemporaryTunnelTp(this.genericMaoContext, true));
            TransactionHandler.run(new CleanIpConfigurationTp(this.genericMaoContext, inputFlag));
        }
        catch (RbsConfigurationFailedException rcfe) {
            String errorMsg = "Unable to clean IP settings, original message: " + rcfe.getLocalizedMessage();
            this.updateProgressReportInformation(100, 0, errorMsg, false);
            this.updateProgressReportInformation(200, 0, errorMsg, true);
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "IP configuration fault", errorMsg);
        }
    }

    public void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport) {
        ProgressReportHandler.getInstance().updateProgressReportInformation(integrationStepNumber, status, detailedInformation, updateProgressReport);
    }
}

