/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.ipsec.IkePeerMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.AddressResolver;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.FqdnIpAddressPair;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.FqdnOrIpAddress;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.IpAccessHostEtAddressSubscriber;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.IpHostLinkAddressSubscriber;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecGwAddresses;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.WebServerAddresses;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IkePeerData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSecTunnelData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.TrafficSelectorIpAddressRange;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.ReleaseDhcpIfTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.ConfiguratorHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.IpConfigurator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CleanIpConfigurationTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.ConfigureIpMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIkePeerMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpAccessHostEtMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpHostLinkMoVpnTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpInterfaceMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpSecTunnelMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpv6MoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateVpnInterfaceMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.RemoveTemporaryTunnelTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetAutoDetectionOnVpnInterface;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetDnsAutoConfigInterfaceRefOnIpMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetFeatureActivateOnIpSecMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetNodeInterfaceNameTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetVendorCredentialsOnIpSecMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.UnlockIpAccessHostEtMoTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class IpStackConfigurator
extends IpConfigurator {
    private static final Class THIS_CLASS = IpStackConfigurator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String ipv4TsAllAddresses = "0.0.0.0";
    private static final String ipv6TsAllAddresses = "::";
    private final boolean isTestMode;
    private final MoRepositoryWrapper moRepositoryWrapper;

    public IpStackConfigurator(RbsConfigurationMao inRbsConfigurationMao) {
        super(inRbsConfigurationMao);
        this.moRepositoryWrapper = this.rbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext().getMoRepositoryWrapper();
        this.isTestMode = false;
    }

    public IpStackConfigurator(RbsConfigurationMao inRbsConfigurationMao, boolean inIsTestMode) {
        super(inRbsConfigurationMao);
        this.moRepositoryWrapper = this.rbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext().getMoRepositoryWrapper();
        this.isTestMode = inIsTestMode;
    }

    public boolean applyConfiguration(boolean doSetNodeInterfaceName) throws UnknownHostException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "applyConfiguration()");
        boolean successfulConfiguration = false;
        if (this.doSetupTemporaryTunnel()) {
            this.updateProgressReportInformation(150, 3, "Activation of temporary IpSec tunnel", true);
            this.updateProgressReportInformation(200, 2, "On untrusted network - skipping activation of basic IP configuration", true);
            SecGwAddresses secGwAddresses = SecGwAddresses.instance(this.rbsConfigurationMao);
            IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
            FqdnIpAddressPair fqdnIpAddressPair = null;
            if (!secGwAddresses.isEmpty()) {
                ConfiguratorHelper.applyTrustedNetworkConfiguration(this.genericMaoContext, this.rbsConfigurationMao, doSetNodeInterfaceName);
                FqdnIpAddressPair[] fqdnIpAddressPairs = secGwAddresses.getSecGwAddresses();
                boolean resolveSuccess = false;
                for (int i = 0; i < fqdnIpAddressPairs.length; ++i) {
                    if (fqdnIpAddressPairs[i].getFqdn() != null && fqdnIpAddressPairs[i].getFqdn().length() > 0 && (fqdnIpAddressPairs[i].getIpAddress() == null || fqdnIpAddressPairs[i].getIpAddress().length() == 0)) {
                        try {
                            String ipAddress = AddressResolver.getIpAddressFromFqdn(fqdnIpAddressPairs[i].getFqdn());
                            fqdnIpAddressPairs[i].setIpAddress(ipAddress);
                            resolveSuccess = true;
                        }
                        catch (UnknownHostException e) {
                            logger.traceDebug(THIS_CLASS, "Unable to resolve SecGw FQDN " + fqdnIpAddressPairs[i].getFqdn());
                        }
                        continue;
                    }
                    if (fqdnIpAddressPairs[i].getIpAddress() == null || fqdnIpAddressPairs[i].getIpAddress().length() <= 0 || fqdnIpAddressPairs[i].getFqdn() != null && fqdnIpAddressPairs[i].getFqdn().length() != 0) continue;
                    try {
                        String fqdn = AddressResolver.getFqdnFromIpAddress(fqdnIpAddressPairs[i].getIpAddress());
                        if (fqdn.trim().length() <= 0) continue;
                        fqdnIpAddressPairs[i].setFqdn(fqdn);
                        resolveSuccess = true;
                        continue;
                    }
                    catch (UnknownHostException e) {
                        logger.traceDebug(THIS_CLASS, "Unable to reverse resolve SecGw IP " + fqdnIpAddressPairs[i].getIpAddress());
                    }
                }
                if (resolveSuccess) {
                    secGwAddresses.setSecGwAddresses(fqdnIpAddressPairs);
                    secGwAddresses.setNextSecGwAddress(0);
                }
                if ((fqdnIpAddressPair = secGwAddresses.getSecGwAddress()) == null) {
                    throw new RbsConfigurationFailedException("Security gateways exhausted");
                }
                ip.getOuterIpConfigurationData().setInitialSecGwFqdn(fqdnIpAddressPair.getFqdn());
                ip.getOuterIpConfigurationData().setInitialSecGwIpAdd(fqdnIpAddressPair.getIpAddress());
                TransactionHandler.run(new ReleaseDhcpIfTp(this.genericMaoContext));
                TransactionHandler.run(new CleanIpConfigurationTp(this.genericMaoContext, false, true));
            }
            while (true) {
                if (fqdnIpAddressPair == null) {
                    logger.traceDebug(THIS_CLASS, "No usable security gateway in secGwAddresses");
                } else if (ip.getOuterIpConfigurationData().getInitialSecGwIpAdd() == null || ip.getOuterIpConfigurationData().getInitialSecGwIpAdd().trim().length() <= 0) {
                    fqdnIpAddressPair = secGwAddresses.getSecGwAddress();
                    if (fqdnIpAddressPair == null) {
                        throw new RbsConfigurationFailedException("Security gateways exhausted");
                    }
                    ip.getOuterIpConfigurationData().setInitialSecGwFqdn(fqdnIpAddressPair.getFqdn());
                    ip.getOuterIpConfigurationData().setInitialSecGwIpAdd(fqdnIpAddressPair.getIpAddress());
                    continue;
                }
                try {
                    this.applyTemporaryIpSecConfiguration();
                    successfulConfiguration = true;
                    WebServerAddresses webServerAddresses = WebServerAddresses.instance(this.rbsConfigurationMao);
                    FqdnOrIpAddress[] webServerFqdnIps = webServerAddresses.getWebServerAddresses();
                    ArrayList<FqdnOrIpAddress> resolvedAiws = new ArrayList<FqdnOrIpAddress>();
                    for (int i = 0; i < webServerFqdnIps.length; ++i) {
                        if (webServerFqdnIps[i].getAddressType() == 1 && webServerFqdnIps[i].getAddressValue() != null && webServerFqdnIps[i].getAddressValue().length() > 0) {
                            try {
                                String fqdn = webServerFqdnIps[i].getAddressValue();
                                String ipAddress = AddressResolver.getIpAddressFromFqdn(fqdn);
                                if (ipAddress == null || ipAddress.length() <= 0) continue;
                                resolvedAiws.add(webServerFqdnIps[i]);
                            }
                            catch (UnknownHostException e) {
                                logger.traceDebug(THIS_CLASS, "Unable to resolve AIWS FQDN " + webServerFqdnIps[i].getAddressValue());
                            }
                            continue;
                        }
                        if (webServerFqdnIps[i].getAddressType() != 0 || webServerFqdnIps[i].getAddressValue() == null || webServerFqdnIps[i].getAddressValue().length() <= 0) continue;
                        resolvedAiws.add(webServerFqdnIps[i]);
                    }
                    if (resolvedAiws.size() <= 0) break;
                    webServerAddresses.setWebServerAddresses(resolvedAiws.toArray(new FqdnOrIpAddress[resolvedAiws.size()]));
                }
                catch (RbsConfigurationFailedException e) {
                    if (e.getMessage().trim().compareTo("Inner configuration failed - IPv4 or IPv6 address not set") == 0 && secGwAddresses.hasNextSecGwAddress()) {
                        TransactionHandler.run(new RemoveTemporaryTunnelTp(this.genericMaoContext, true));
                        fqdnIpAddressPair = secGwAddresses.getSecGwAddress();
                        if (fqdnIpAddressPair == null) {
                            throw new RbsConfigurationFailedException("Security gateways exhausted");
                        }
                        ip.getOuterIpConfigurationData().setInitialSecGwFqdn(fqdnIpAddressPair.getFqdn());
                        ip.getOuterIpConfigurationData().setInitialSecGwIpAdd(fqdnIpAddressPair.getIpAddress());
                        continue;
                    }
                    throw e;
                }
                break;
            }
            this.updateProgressReportInformation(150, 5, "Finished activating temporary IpSec tunnel", true);
        } else {
            this.updateProgressReportInformation(150, 2, "On trusted network - skipping activation of temporary tunnel", true);
            this.updateProgressReportInformation(200, 3, "Activating basic IP configuration", true);
            successfulConfiguration = ConfiguratorHelper.applyTrustedNetworkConfiguration(this.genericMaoContext, this.rbsConfigurationMao, doSetNodeInterfaceName);
            this.updateProgressReportInformation(200, 5, "Finished activating basic IP configuration", true);
        }
        logger.traceReturn(THIS_CLASS, "applyConfiguration()");
        return successfulConfiguration;
    }

    private List createLocalTsRanges(boolean autoDetect, boolean isIpv4) throws IOException {
        IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
        ArrayList<TrafficSelectorIpAddressRange> tsLocalIpAddressRangesDataList = new ArrayList<TrafficSelectorIpAddressRange>();
        if (autoDetect) {
            tsLocalIpAddressRangesDataList.add(new TrafficSelectorIpAddressRange(ipv6TsAllAddresses, "0"));
            tsLocalIpAddressRangesDataList.add(new TrafficSelectorIpAddressRange(ipv4TsAllAddresses, "0"));
        } else if (isIpv4) {
            tsLocalIpAddressRangesDataList.add(new TrafficSelectorIpAddressRange(ip.getInnerIpConfigurationData().getInnerIpAddress(), "32"));
        } else {
            tsLocalIpAddressRangesDataList.add(new TrafficSelectorIpAddressRange(ip.getInnerIpConfigurationData().getInnerIpAddress(), "128"));
        }
        return tsLocalIpAddressRangesDataList;
    }

    private List createRemoteTsRanges(boolean autoDetect, boolean isIpv4) throws IOException {
        ArrayList<TrafficSelectorIpAddressRange> tsRemoteIpAddressRangesDataList = new ArrayList<TrafficSelectorIpAddressRange>();
        if (autoDetect) {
            tsRemoteIpAddressRangesDataList.add(new TrafficSelectorIpAddressRange(ipv6TsAllAddresses, "0"));
            tsRemoteIpAddressRangesDataList.add(new TrafficSelectorIpAddressRange(ipv4TsAllAddresses, "0"));
        } else if (isIpv4) {
            tsRemoteIpAddressRangesDataList.add(new TrafficSelectorIpAddressRange(ipv4TsAllAddresses, "0"));
        } else {
            tsRemoteIpAddressRangesDataList.add(new TrafficSelectorIpAddressRange(ipv6TsAllAddresses, "0"));
        }
        return tsRemoteIpAddressRangesDataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyTemporaryIpSecConfiguration() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "applyTemporaryIpSecConfiguration()");
        IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
        try {
            TransactionHandler.run(new ReleaseDhcpIfTp(this.genericMaoContext));
        }
        catch (RbsConfigurationFailedException e) {
            logger.traceDebug(THIS_CLASS, "Unable to release DHCP: " + e.getMessage());
        }
        TransactionHandler.run(new SetFeatureActivateOnIpSecMoTp(1, this.genericMaoContext));
        TransactionHandler.run(new ConfigureIpMoTp(this.genericMaoContext, ip.getDnsServerAddress(), ip.getDefaultDomainName(), 0));
        boolean useDhcp = ip.getOuterIpConfigurationData().isOuterEmpty();
        IpAccessHostEtAddressSubscriber ipAccessHostEtSubscriber = new IpAccessHostEtAddressSubscriber(this.rbsConfigurationMao);
        ipAccessHostEtSubscriber.subscribe();
        TransactionHandler.run(new CreateIpInterfaceMoTp(this.genericMaoContext, ip, useDhcp));
        TransactionHandler.run(new CreateIpAccessHostEtMoTp(this.genericMaoContext, ip.getOuterIpConfigurationData().getOuterIpAddress(), "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1", useDhcp));
        TransactionHandler.run(new UnlockIpAccessHostEtMoTp(this.genericMaoContext));
        if (useDhcp && ipAccessHostEtSubscriber.getIpAddress().equals("")) {
            IpAccessHostEtAddressSubscriber ipAccessHostEtAddressSubscriber = ipAccessHostEtSubscriber;
            synchronized (ipAccessHostEtAddressSubscriber) {
                try {
                    ipAccessHostEtSubscriber.wait(this.isTestMode ? 2000L : 120000L);
                }
                catch (InterruptedException ie) {
                    logger.traceDebug(THIS_CLASS, "Interrupted while waiting. " + ie);
                }
            }
        }
        ipAccessHostEtSubscriber.unsubscribe();
        if (useDhcp && ipAccessHostEtSubscriber.getIpAddress().equals("")) {
            logger.traceAbnormal(THIS_CLASS, "Unable to get outer IPv4");
            throw new RbsConfigurationFailedException("Outer configuration failed - IPv4 address not set");
        }
        boolean autoDetect = Boolean.FALSE;
        boolean isIpv4 = Boolean.FALSE;
        Integer configurationMode = ip.getConfigurationModeVpnInterface();
        int preferredIpVersion = 2;
        if (configurationMode == RbsConfigurationDefinitions.VPN_INTERFACE_CONF_MODE_IKE) {
            autoDetect = Boolean.TRUE;
            if (ip.getIpVersionVpnInterface().equals(RbsConfigurationDefinitions.VPN_INTERFACE_IP_VERSION_V4)) {
                preferredIpVersion = 1;
                isIpv4 = Boolean.TRUE;
            }
        } else if (configurationMode.equals(RbsConfigurationDefinitions.VPN_INTERFACE_CONF_MODE_MANUAL) && ip.getInnerIpConfigurationData().getInnerIpAddress().indexOf(":") == -1) {
            isIpv4 = Boolean.TRUE;
        }
        if (!isIpv4 || autoDetect) {
            TransactionHandler.run(new CreateIpv6MoTp(this.genericMaoContext));
        }
        TransactionHandler.run(new CreateVpnInterfaceMoTp(this.genericMaoContext, configurationMode, ip.getIpVersionVpnInterface()));
        if (autoDetect) {
            TransactionHandler.run(new SetAutoDetectionOnVpnInterface(this.genericMaoContext, preferredIpVersion));
            TransactionHandler.run(new SetDnsAutoConfigInterfaceRefOnIpMoTp(this.genericMaoContext, "ManagedElement=1,IpSystem=1,VpnInterface=1"));
        }
        TransactionHandler.run(new CreateIpHostLinkMoVpnTp(this.genericMaoContext, ip.getInnerIpConfigurationData().getInnerIpAddress(), autoDetect));
        String[] peerIdType = new String[]{"AUTOMATIC", "IP_V4_ADDRESS", "AUTOMATIC"};
        if (!ip.isSecGwFqdnEmpty()) {
            peerIdType = new String[]{"AUTOMATIC", "FQDN", "IP_V4_ADDRESS", "AUTOMATIC"};
        }
        for (int i = 0; i < peerIdType.length; ++i) {
            try {
                String fqdn = peerIdType[i].equals("AUTOMATIC") ? "" : ip.getOuterIpConfigurationData().getInitialSecGwFqdn();
                String ipv4Address = peerIdType[i].equals("AUTOMATIC") ? "" : ip.getOuterIpConfigurationData().getInitialSecGwIpAdd();
                IkePeerData ikePeerData = new IkePeerData("CERTIFICATE", null, null, "1", null, null, fqdn, peerIdType[i], ipv4Address, ip.getOuterIpConfigurationData().getInitialSecGwIpAdd(), null, null, "Temporary-IkePeer", null, "", "ANY", "", true);
                TransactionHandler.run(new CreateIkePeerMoTp(this.genericMaoContext, ikePeerData));
            }
            catch (IOException e) {
                throw new RbsConfigurationFailedException("Unable to create IkePeer MO", e.getMessage());
            }
            try {
                IpSecTunnelData ipSecTunnelData = new IpSecTunnelData(null, null, this.createLocalTsRanges(autoDetect, isIpv4), "0", "1", "Temporary tunnel", null, null, this.createRemoteTsRanges(autoDetect, isIpv4), true);
                TransactionHandler.run(new CreateIpSecTunnelMoTp(this.genericMaoContext, ipSecTunnelData));
            }
            catch (IOException e) {
                throw new RbsConfigurationFailedException("Unable to create IpSecTunnel MO", e.getMessage());
            }
            IpHostLinkAddressSubscriber ipHostLinkSubscriber = new IpHostLinkAddressSubscriber(this.rbsConfigurationMao);
            ipHostLinkSubscriber.subscribe();
            try {
                TransactionHandler.run(new SetVendorCredentialsOnIpSecMoTp(1, this.genericMaoContext));
            }
            catch (RbsConfigurationFailedException e) {
                ipHostLinkSubscriber.unsubscribe();
                throw e;
            }
            if (autoDetect && ipHostLinkSubscriber.getIpAddress().equals("")) {
                IpHostLinkAddressSubscriber e = ipHostLinkSubscriber;
                synchronized (e) {
                    try {
                        ipHostLinkSubscriber.wait(this.isTestMode ? 2000L : 120000L);
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                }
            }
            ipHostLinkSubscriber.unsubscribe();
            if (autoDetect && ipHostLinkSubscriber.getIpAddress().equals("")) {
                if (i == peerIdType.length - 1) {
                    logger.traceAbnormal(THIS_CLASS, "Unable to get inner IPv4 or IPv6 address");
                    throw new RbsConfigurationFailedException("Inner configuration failed - IPv4 or IPv6 address not set");
                }
                logger.traceDebug(THIS_CLASS, "Failed to get inner address with " + peerIdType[i] + " peerIdType, will retry with different one");
                TransactionHandler.run(new RemoveTemporaryTunnelTp(this.genericMaoContext, false, true));
                continue;
            }
            if (autoDetect) break;
            logger.traceDebug(THIS_CLASS, "Static inner address is used in temp tunnel. Checking securityAssociations in ikePeerMo");
            boolean isSAReady = this.isSecurityAssociationsReady();
            if (!isSAReady && i == peerIdType.length - 1) {
                logger.traceAbnormal(THIS_CLASS, "Unable to fetch security association with any peer identity.");
                TransactionHandler.run(new RemoveTemporaryTunnelTp(this.genericMaoContext, false, true));
                throw new RbsConfigurationFailedException("IkePeer identity check failed - could not fetch security associations");
            }
            if (isSAReady) break;
            logger.traceDebug(THIS_CLASS, "Could not fetch SA. Failed to setup ikePeer with peerIdType " + peerIdType[i] + " , will retry with a different one");
            TransactionHandler.run(new RemoveTemporaryTunnelTp(this.genericMaoContext, false, true));
        }
        TransactionHandler.run(new SetNodeInterfaceNameTp(this.rbsConfigurationMao, this.genericMaoContext, "1", null, isIpv4));
        logger.traceReturn(THIS_CLASS, "applyTemporaryIpSecConfiguration()");
    }

    public boolean doSetupTemporaryTunnel() {
        boolean result2 = false;
        IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
        SecGwAddresses secAddress = SecGwAddresses.instance(this.rbsConfigurationMao);
        if (ip.existsAndNotEmptyTempIpsecTunnelParameters() || !secAddress.isEmpty()) {
            result2 = true;
        }
        return result2;
    }

    private boolean isSecurityAssociationsReady() {
        boolean isSAReady = false;
        IkePeerMo ikePeerMo = (IkePeerMo)this.moRepositoryWrapper.lookup("ManagedElement=1,IpSystem=1,IpSec=1,IkePeer=1");
        if (ikePeerMo == null) {
            logger.traceAbnormal(THIS_CLASS, "Unable to retrieve ikePeerMo");
        } else {
            for (int retryTimes = 0; retryTimes < 10; ++retryTimes) {
                block9: {
                    try {
                        if (ikePeerMo.getSecurityAssociations(null) == null) {
                            logger.traceDebug(THIS_CLASS, "securityAssociations is not created.");
                            break block9;
                        }
                        Struct[] sa = ikePeerMo.getSecurityAssociations(null);
                        if (sa.length == 0) {
                            logger.traceDebug(THIS_CLASS, "securityAssociations is created but empty.");
                            break block9;
                        }
                        isSAReady = true;
                        break;
                    }
                    catch (MoAccessException e) {
                        logger.traceAbnormal(THIS_CLASS, "Unable to get securityAssociations in ikePeerMo");
                    }
                }
                try {
                    logger.traceDebug(THIS_CLASS, "Retry in 1 second");
                    Thread.sleep(this.isTestMode ? 10L : 1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.traceAbnormal(THIS_CLASS, "Timer is interrupted");
                }
            }
        }
        return isSAReady;
    }
}

