/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.managedelement.NtpServerMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.ClientTimeSetter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.FqdnIpAddressPair;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.FqdnOrIpAddress;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecGwAddresses;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.WebServerAddresses;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.ReleaseDhcpIfTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.ConfiguratorHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse.EgisResponseParser;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse.EgisStateMonitor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse.FetchEgisResponseTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CleanIpConfigurationTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.FetchDhcpDataTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetDefaultNtpServerTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class EgisConfigurator {
    private static final Class THIS_CLASS = EgisConfigurator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private List aiws = null;
    private List secGws = null;
    private final RbsConfigurationMao rbsConfigurationMao;
    private final GenericMaoContext genericMaoContext;
    private final RbsConfigurationHelper helper;
    private final MoRepositoryWrapper moRepositoryWrapper;
    public static final int EGIS_OK_RESPONSE = 0;
    public static final int EGIS_INVALID_RESPONSE = 1;
    public static final int EGIS_NO_RESPONSE = 2;
    public static final String EGIS_OK_RESPONSE_NAME = "EGIS_OK_RESPONSE";
    public static final String EGIS_INVALID_RESPONSE_NAME = "EGIS_INVALID_RESPONSE";
    public static final String EGIS_NO_RESPONSE_NAME = "EGIS_NO_RESPONSE";
    public static final int DELAY = 3000;

    public EgisConfigurator(RbsConfigurationMao rbsConfigurationMaoIn, RbsConfigurationHelper helperIn, MoRepositoryWrapper moRepositoryWrapperIn) {
        this.rbsConfigurationMao = rbsConfigurationMaoIn;
        this.genericMaoContext = rbsConfigurationMaoIn.getRbsConfigurationContext().getGenericMaoContext();
        this.helper = helperIn;
        this.moRepositoryWrapper = moRepositoryWrapperIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void applyConfiguration() {
        block18: {
            logger.traceEnter(THIS_CLASS, "applyConfiguration()");
            int responseOk = 0;
            String responseName = EGIS_OK_RESPONSE_NAME;
            this.updateProgressReportInformation(95, 3, "Fetching data from the EGIS server", true);
            TransactionHandler.run(new CleanIpConfigurationTp(this.genericMaoContext, false, true));
            MoIterator moIter = this.moRepositoryWrapper.lookupType("GigaBitEthernet");
            if (moIter == null) {
                ConfiguratorHelper.createGigabitEthernetMo(this.genericMaoContext, ConfiguratorHelper.RETRY_SLEEP_TIME, this.helper);
            }
            ConfiguratorHelper.applyTemporaryIpConfiguration(this.genericMaoContext, this.rbsConfigurationMao);
            IpHostLinkMo ipHostLinkMo = (IpHostLinkMo)this.moRepositoryWrapper.lookup("ManagedElement=1,IpOam=1,Ip=1,IpHostLink=1");
            int i = 0;
            int IP_HOST_LINK_TRY_COUNT = 10;
            while (ipHostLinkMo.getOperationalState(null) == 0 && i < 10) {
                try {
                    Thread.sleep(250L);
                    logger.traceDebug(THIS_CLASS, "Waiting for IpHostLink to become available");
                    ++i;
                }
                catch (InterruptedException ie) {
                    logger.traceDebug(THIS_CLASS, "Thread interrupted while sleeping. " + ie);
                }
            }
            int[] dhcpOptions = new int[]{1, 3, 6, 42};
            TransactionHandler.run(new FetchDhcpDataTp(this.genericMaoContext, this.rbsConfigurationMao, dhcpOptions, false));
            TransactionHandler.run(new CleanIpConfigurationTp(this.genericMaoContext, false, false));
            ConfiguratorHelper.applyTrustedNetworkConfiguration(this.genericMaoContext, this.rbsConfigurationMao, true);
            if (!this.helper.isFirstNodeTimeReceivedFromNtp()) {
                logger.traceDebug(THIS_CLASS, "Node time not yet set. Starting NTP synchronization procedure.");
                this.getFirstNodeTimeFromNtp();
            } else {
                logger.traceDebug(THIS_CLASS, "Node time already set through NTP. Skipping new NTP synchronization procedure.");
            }
            responseOk = this.fetchAndParseEgisResponse();
            if (responseOk == 1) {
                responseName = EGIS_INVALID_RESPONSE_NAME;
            } else if (responseOk == 2) {
                responseName = EGIS_NO_RESPONSE_NAME;
            } else {
                EgisStateMonitor.getInstance().setIsEgisResponseFetched(true);
            }
            ConfigurationReportLoggerFactory.getLogger().logInformation("EGIS response received", responseName);
            Object var9_10 = null;
            this.updateProgressReportInformation(95, 5, "Finished fetching data from the EGIS server", true);
            try {
                TransactionHandler.run(new ReleaseDhcpIfTp(this.genericMaoContext));
                TransactionHandler.run(new CleanIpConfigurationTp(this.genericMaoContext, true, true));
                String initialSecGwIpAddress = IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().getInitialSecGwIpAdd();
                String initialSecGwIpFqdn = IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().getInitialSecGwFqdn();
                IpParameters.instance(this.rbsConfigurationMao).delete();
                IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().setInitialSecGwIpAdd(initialSecGwIpAddress);
                IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().setInitialSecGwFqdn(initialSecGwIpFqdn);
                FileParameters.instance(this.rbsConfigurationMao).delete(false);
            }
            catch (RbsConfigurationFailedException e2) {
                logger.traceDebug(THIS_CLASS, "Failure in EGIS step cleanup: " + e2.getMessage());
            }
            break block18;
            {
                catch (Exception e) {
                    logger.traceDebug(THIS_CLASS, e.toString());
                    ConfigurationReportLoggerFactory.getLogger().logInformation("Failure during fetching EGIS response", e.getMessage());
                    Object var9_11 = null;
                    this.updateProgressReportInformation(95, 5, "Finished fetching data from the EGIS server", true);
                    try {
                        TransactionHandler.run(new ReleaseDhcpIfTp(this.genericMaoContext));
                        TransactionHandler.run(new CleanIpConfigurationTp(this.genericMaoContext, true, true));
                        String initialSecGwIpAddress = IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().getInitialSecGwIpAdd();
                        String initialSecGwIpFqdn = IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().getInitialSecGwFqdn();
                        IpParameters.instance(this.rbsConfigurationMao).delete();
                        IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().setInitialSecGwIpAdd(initialSecGwIpAddress);
                        IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().setInitialSecGwFqdn(initialSecGwIpFqdn);
                        FileParameters.instance(this.rbsConfigurationMao).delete(false);
                    }
                    catch (RbsConfigurationFailedException e2) {
                        logger.traceDebug(THIS_CLASS, "Failure in EGIS step cleanup: " + e2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                this.updateProgressReportInformation(95, 5, "Finished fetching data from the EGIS server", true);
                try {
                    TransactionHandler.run(new ReleaseDhcpIfTp(this.genericMaoContext));
                    TransactionHandler.run(new CleanIpConfigurationTp(this.genericMaoContext, true, true));
                    String initialSecGwIpAddress = IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().getInitialSecGwIpAdd();
                    String initialSecGwIpFqdn = IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().getInitialSecGwFqdn();
                    IpParameters.instance(this.rbsConfigurationMao).delete();
                    IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().setInitialSecGwIpAdd(initialSecGwIpAddress);
                    IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().setInitialSecGwFqdn(initialSecGwIpFqdn);
                    FileParameters.instance(this.rbsConfigurationMao).delete(false);
                }
                catch (RbsConfigurationFailedException e2) {
                    logger.traceDebug(THIS_CLASS, "Failure in EGIS step cleanup: " + e2.getMessage());
                }
                throw throwable;
            }
        }
        logger.traceReturn(THIS_CLASS, "applyConfiguration()");
    }

    public void getFirstNodeTimeFromNtp() {
        block9: {
            logger.traceEnter(THIS_CLASS, "getFirstNodeTimeFromNtp()");
            try {
                TransactionHandler.run(new SetDefaultNtpServerTp(this.genericMaoContext, "pool.ntp.org", IpParameters.instance(this.rbsConfigurationMao).getNtpServerAddress()));
                NtpServerMo ntpServerMo = (NtpServerMo)this.genericMaoContext.getMoRepositoryWrapper().lookup("ManagedElement=1,SystemFunctions=1,TimeSetting=1,NtpServer=1");
                if (!ntpServerMo.getServerAddress(null).equals("169.254.0.10")) {
                    String initialRtcTime;
                    int totalSleepTimeUntilNtpReply = 0;
                    this.resetRtcTimeFileUpdateCycle();
                    String latestRtcTime = initialRtcTime = "";
                    try {
                        latestRtcTime = initialRtcTime = this.readRtcTimeFile();
                        logger.traceDebug(THIS_CLASS, "Initial time read from rtctime file before NTP sync: " + initialRtcTime);
                    }
                    catch (IOException e) {
                        logger.traceDebug(THIS_CLASS, "Initial time could not be read from rtctime file.");
                    }
                    int MAX_NTP_TRIES = 10;
                    for (int ntpTryCount = 0; ntpTryCount < 10 && latestRtcTime.equals(initialRtcTime); ++ntpTryCount) {
                        Thread.sleep(3000L);
                        totalSleepTimeUntilNtpReply += 3000;
                        try {
                            latestRtcTime = this.readRtcTimeFile();
                            if (!latestRtcTime.equals(initialRtcTime)) {
                                this.helper.setIsFirstNodeTimeReceivedFromNtp(true);
                                logger.traceDebug(THIS_CLASS, "NTP sync has updated time in rtctime file to " + latestRtcTime);
                                continue;
                            }
                            logger.traceDebug(THIS_CLASS, "Attempt " + ntpTryCount + ", still awaiting NTP reply, rtctime file unchanged. " + "Current NtpServerMo service status = " + this.getNtpServiceStatusValueDefinition(ntpServerMo.getServiceStatus(null)));
                            continue;
                        }
                        catch (IOException e) {
                            logger.traceDebug(THIS_CLASS, "Attempt " + ntpTryCount + ", still awaiting NTP reply, " + "rtctime file not yet created or is unreadable. Current NtpServerMo service status = " + this.getNtpServiceStatusValueDefinition(ntpServerMo.getServiceStatus(null)));
                        }
                    }
                    logger.traceDebug(THIS_CLASS, "NtpServerMo service status = " + this.getNtpServiceStatusValueDefinition(ntpServerMo.getServiceStatus(null)) + ", The wait for NTP server reply took in total " + totalSleepTimeUntilNtpReply + " milliseconds");
                    break block9;
                }
                logger.traceDebug(THIS_CLASS, "NTP sync not attempted due to NTP server IP address not set.");
            }
            catch (Exception e) {
                logger.traceDebug(THIS_CLASS, "Unable to find NTP Service. " + e.getMessage());
            }
        }
        logger.traceReturn(THIS_CLASS, "getFirstNodeTimeFromNtp()");
    }

    private void resetRtcTimeFileUpdateCycle() {
        logger.traceEnter(THIS_CLASS, "resetRtcTimeFileUpdateCycle()");
        ClientTimeSetter clientTimeSetter = new ClientTimeSetter(this.moRepositoryWrapper, this.helper);
        long currentTime = System.currentTimeMillis();
        try {
            clientTimeSetter.setTime(currentTime);
        }
        catch (MoAccessException e) {
            logger.traceAbnormal(THIS_CLASS, "Failed to set time on the node for resetting RTC time file update cycle: " + e.getMessage());
        }
        logger.traceReturn(THIS_CLASS, "resetRtcTimeFileUpdateCycle()");
    }

    /*
     * Loose catch block
     */
    private String readRtcTimeFile() throws IOException {
        String result2;
        block9: {
            logger.traceEnter(THIS_CLASS, "readRtcTimeFile()");
            result2 = "";
            String rtcFilePath = this.helper.getRtcDirPath() + "rtctime";
            BufferedReader bufReader = null;
            bufReader = new BufferedReader(new FileReader(rtcFilePath));
            result2 = bufReader.readLine();
            Object var6_4 = null;
            try {
                if (bufReader != null) {
                    bufReader.close();
                }
                break block9;
            }
            catch (IOException ex) {
                logger.traceDebug(THIS_CLASS, "I/O error when closing rtctime file.");
            }
            break block9;
            {
                catch (IOException e) {
                    logger.traceDebug(THIS_CLASS, rtcFilePath + " file not yet created or is unreadable.");
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    if (bufReader != null) {
                        bufReader.close();
                    }
                }
                catch (IOException ex) {
                    logger.traceDebug(THIS_CLASS, "I/O error when closing rtctime file.");
                }
                throw throwable;
            }
        }
        logger.traceReturn(THIS_CLASS, "readRtcTimeFile()");
        return result2;
    }

    private int fetchAndParseEgisResponse() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "fetchAndParseEgisResponse()");
        int responseOk = 2;
        FetchEgisResponseTp fetchEgisResponseTp = new FetchEgisResponseTp();
        TransactionHandler.runWithLoop(fetchEgisResponseTp);
        String egisResponse = fetchEgisResponseTp.getEgisResponse();
        if (egisResponse != null) {
            responseOk = 1;
            IpParameters.instance().getOuterIpConfigurationData().setInitialSecGwFqdn("");
            IpParameters.instance().getOuterIpConfigurationData().setInitialSecGwIpAdd("");
            SecGwAddresses secGwAddresses = SecGwAddresses.instance(this.rbsConfigurationMao);
            secGwAddresses.setSecGwAddresses((FqdnIpAddressPair[])null);
            WebServerAddresses webServerAddresses = WebServerAddresses.instance(this.rbsConfigurationMao);
            webServerAddresses.setWebServerAddresses((FqdnOrIpAddress[])null);
            EgisResponseParser parser = new EgisResponseParser(egisResponse);
            parser.parse();
            this.aiws = parser.getAiWebServers();
            this.secGws = parser.getSecurityGateWays();
            if (this.secGws.isEmpty() && this.aiws.isEmpty()) {
                logger.traceDebug(THIS_CLASS, "Empty response received from EGIS");
            } else if (this.secGws.isEmpty()) {
                logger.traceDebug(THIS_CLASS, "No security gateways in response from EGIS");
            } else if (this.aiws.isEmpty()) {
                logger.traceDebug(THIS_CLASS, "No AIWS in response from EGIS");
            } else {
                secGwAddresses.setSecGwAddresses(this.secGws.toArray(new FqdnIpAddressPair[this.secGws.size()]));
                secGwAddresses.setNextSecGwAddress(0);
                webServerAddresses.setWebServerAddresses(this.aiws.toArray(new FqdnOrIpAddress[this.aiws.size()]));
                responseOk = 0;
            }
        }
        logger.traceReturn(THIS_CLASS, "fetchAndParseEgisResponse()");
        return responseOk;
    }

    protected void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport) {
        ProgressReportHandler.getInstance().updateProgressReportInformation(integrationStepNumber, status, detailedInformation, updateProgressReport);
    }

    protected void traceNtpServiceStatus(int ntpServiceStatus) {
        switch (ntpServiceStatus) {
            case 9: {
                logger.traceDebug(THIS_CLASS, " ntpServiceStatus " + ntpServiceStatus + " is INACTIVE");
                break;
            }
            case 0: {
                logger.traceDebug(THIS_CLASS, " ntpServiceStatus " + ntpServiceStatus + " is REJECTED");
                break;
            }
            case 2: {
                logger.traceDebug(THIS_CLASS, " ntpServiceStatus " + ntpServiceStatus + " is EXCESS");
                break;
            }
            case 1: {
                logger.traceDebug(THIS_CLASS, " ntpServiceStatus " + ntpServiceStatus + " is FALSESTICK");
                break;
            }
            case 3: {
                logger.traceDebug(THIS_CLASS, " ntpServiceStatus " + ntpServiceStatus + " is OUTLYER");
                break;
            }
            case 7: {
                logger.traceDebug(THIS_CLASS, " ntpServiceStatus " + ntpServiceStatus + " is PROSPPEER");
                break;
            }
            case 5: {
                logger.traceDebug(THIS_CLASS, " ntpServiceStatus " + ntpServiceStatus + " is SELECTED");
                break;
            }
            case 4: {
                logger.traceDebug(THIS_CLASS, " ntpServiceStatus " + ntpServiceStatus + " is CANDIDATE");
                break;
            }
            case 8: {
                logger.traceDebug(THIS_CLASS, " ntpServiceStatus " + ntpServiceStatus + " is PENDING");
                break;
            }
            case 6: {
                logger.traceDebug(THIS_CLASS, " ntpServiceStatus " + ntpServiceStatus + " is SYSPEER");
                break;
            }
            default: {
                logger.traceDebug(THIS_CLASS, "ntpServiceStatus " + ntpServiceStatus + " is Status_Not_Available_Nothing_returned");
            }
        }
    }

    protected String getNtpServiceStatusValueDefinition(int ntpServiceStatus) {
        String result2 = null;
        switch (ntpServiceStatus) {
            case 9: {
                result2 = " is INACTIVE";
                break;
            }
            case 0: {
                result2 = " is REJECTED";
                break;
            }
            case 2: {
                result2 = " is EXCESS";
                break;
            }
            case 1: {
                result2 = " is FALSESTICK";
                break;
            }
            case 3: {
                result2 = " is OUTLYER";
                break;
            }
            case 7: {
                result2 = " is PROSPPEER";
                break;
            }
            case 5: {
                result2 = " is SELECTED";
                break;
            }
            case 4: {
                result2 = " is CANDIDATE";
                break;
            }
            case 8: {
                result2 = " is PENDING";
                break;
            }
            case 6: {
                result2 = " is SYSPEER";
                break;
            }
            default: {
                result2 = " Status Value Not Recognized ";
            }
        }
        return result2 != null ? result2 : "";
    }
}

