/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse;

import java.net.MalformedURLException;
import java.net.URL;
import se.ericsson.cello.cns.TransferClientException;
import se.ericsson.cello.cns.TransferClientMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.LoopableTransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class FetchEgisResponseTp
implements LoopableTransactionPackage {
    private static final Class THIS_CLASS = FetchEgisResponseTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final URL egisUrl;
    private static final String SLOGAN = "Get EGIS data";
    private static final String EXCEPTION_MESSAGE = "Failed to fetch EGIS response";
    private static final int DELAY_BETWEEN_RETRIES = 1000;
    private static final int NBR_OF_RETRIES = 20;
    private static final byte PERMANENT_ERROR_RETRIES = 3;
    private static short transactionErrorCode = (short)-1;
    private static byte countPermanentErrorsInTransactionErrorCode = 0;
    private static boolean isStopRetriesAfterPermanenErrorsSet = false;
    private static int delayBetweenRetries = 1000;
    private String egisResponseXml = null;
    private boolean successfull;
    private Exception exception;

    public FetchEgisResponseTp() throws RbsConfigurationFailedException {
        try {
            this.egisUrl = new URL("https", "egis.ericsson.net", 443, "/airequest");
        }
        catch (MalformedURLException e) {
            throw new RbsConfigurationFailedException(SLOGAN, "Failed to build EGIS URL", e);
        }
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute()");
        try {
            ConfigurationReportLoggerFactory.getLogger().logInformation("Sending HTTPS request to EGIS", this.egisUrl.toString());
            this.egisResponseXml = TransferClientMgr.getHttpsTransferClient().fetchFile(this.egisUrl);
        }
        catch (TransferClientException e) {
            FetchEgisResponseTp.setTransactionErrorCode((short)e.getErrorCode());
            throw new RbsConfigurationFailedException(SLOGAN, EXCEPTION_MESSAGE + this.getErrorCodeDefinition(e.getErrorCode()), (Exception)((Object)e));
        }
        this.successfull = true;
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public static byte getPermanentErrorRetries() {
        return 3;
    }

    public static short getTransactionErrorCode() {
        return transactionErrorCode;
    }

    public static void setTransactionErrorCode(short mTransactionErrorCode) {
        transactionErrorCode = mTransactionErrorCode;
    }

    public static byte getCountPermanentErrorsInTransactionErrorCode() {
        return countPermanentErrorsInTransactionErrorCode;
    }

    public boolean getSuccessful() {
        return this.successfull;
    }

    public String getEgisResponse() {
        return this.egisResponseXml;
    }

    public static void setDelayBetweenRetriesForBT(int delayBetweenRetriesIn) {
        delayBetweenRetries = delayBetweenRetriesIn;
    }

    public static void resetDelayBetweenRetriesForBT() {
        delayBetweenRetries = 1000;
    }

    public void handleExecutionException(Exception exceptionIn) {
        this.exception = exceptionIn;
        logger.traceDebug(THIS_CLASS, "Failed to fetch EGIS response, reason: " + exceptionIn);
    }

    public void handleTransactionException(Exception exceptionIn) {
        this.handleExecutionException(exceptionIn);
    }

    public boolean loop(int noOfLoops) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "loop() " + noOfLoops);
        if (!this.successfull) {
            logger.traceDebug(THIS_CLASS, "loop() started noOfLoops: " + noOfLoops + " , successful or not : " + this.successfull);
            if ((FetchEgisResponseTp.getTransactionErrorCode() == 13 || FetchEgisResponseTp.getTransactionErrorCode() == 4 || FetchEgisResponseTp.getTransactionErrorCode() == 5 || FetchEgisResponseTp.getTransactionErrorCode() == 12 || FetchEgisResponseTp.getTransactionErrorCode() == 15 || FetchEgisResponseTp.getTransactionErrorCode() == 10) && (countPermanentErrorsInTransactionErrorCode = (byte)(countPermanentErrorsInTransactionErrorCode + 1)) >= 3) {
                logger.traceDebug(THIS_CLASS, "Breaking out of loop() after following attempts for noOfLoops: " + noOfLoops + ", and permanent error retries: " + countPermanentErrorsInTransactionErrorCode);
                isStopRetriesAfterPermanenErrorsSet = true;
            }
            if (noOfLoops >= 20 || isStopRetriesAfterPermanenErrorsSet) {
                logger.traceDebug(THIS_CLASS, "Failed to fetch EGIS response, reason: " + this.exception + " after " + noOfLoops + " attempts");
                if (this.exception instanceof RbsConfigurationFailedException) {
                    throw (RbsConfigurationFailedException)((Object)this.exception);
                }
                throw new RbsConfigurationFailedException(SLOGAN, EXCEPTION_MESSAGE, this.exception);
            }
            try {
                Thread.sleep(delayBetweenRetries);
            }
            catch (InterruptedException willNotHappen) {
                logger.traceDebug(THIS_CLASS, "execute() Interrupted will sleeping before next attempt");
            }
            logger.traceDebug(THIS_CLASS, "loop() " + (noOfLoops + 1) * 1000 / 1000 + " seconds");
        }
        logger.traceReturn(THIS_CLASS, "loop() noOfLoops: " + noOfLoops + ", successfull: " + this.successfull);
        return !this.successfull;
    }

    protected String getErrorCodeDefinition(int transactionErrorCodeFromCPP) {
        String result2 = null;
        switch (transactionErrorCodeFromCPP) {
            case 1: {
                result2 = " CNS_TRANSFER_CLIENT_SOCKET_ERROR";
                break;
            }
            case 2: {
                result2 = " CNS_TRANSFER_CLIENT_SSL_SOCKET_ERROR ";
                break;
            }
            case 3: {
                result2 = " CNS_TRANSFER_CLIENT_BIO_ERROR ";
                break;
            }
            case 4: {
                result2 = " CNS_TRANSFER_CLIENT_VC_READ_ERROR ";
                break;
            }
            case 5: {
                result2 = " CNS_TRANSFER_CLIENT_VC_PARSE_ERROR ";
                break;
            }
            case 6: {
                result2 = " CNS_TRANSFER_CLIENT_SSL_CONNECT_ERROR ";
                break;
            }
            case 7: {
                result2 = " CNS_TRANSFER_CLIENT_TCP_CANNONT_CONNECT";
                break;
            }
            case 8: {
                result2 = " CNS_TRANSFER_CLIENT_NO_NAME_SERVER ";
                break;
            }
            case 9: {
                result2 = " CNS_TRANSFER_CLIENT_NO_MEMORY";
                break;
            }
            case 10: {
                result2 = " CNS_TRANSFER_CLIENT_FILE_NOT_FOUND";
                break;
            }
            case 11: {
                result2 = " CNS_TRANSFER_CLIENT_FILE_TOO_BIG";
                break;
            }
            case 12: {
                result2 = " CNS_TRANSFER_CLIENT_CERT_SIZE_ERR ";
                break;
            }
            case 13: {
                result2 = " CNS_TRANSFER_CLIENT_HOST_ERROR ";
                break;
            }
            case 14: {
                result2 = " CNS_TRANSFER_CLIENT_INTERNAL_ERR ";
                break;
            }
            case 15: {
                result2 = " CNS_URL_NOT_VALID";
                break;
            }
            case 16: {
                result2 = " CNS_NOT_ACCESSIBLE";
                break;
            }
            case 17: {
                result2 = " CNS_PROC_TERMINATED";
                break;
            }
            case 18: {
                result2 = " CNS_UNKNOWN_RESPONSE";
                break;
            }
            default: {
                result2 = " Error_code_value_not_recognized ";
            }
        }
        return result2 != null ? result2 : "";
    }
}

